



setTimeout(function(){
    var viewWidth= document.getElementById('viewport').clientWidth;
    var viewHeight=document.getElementById('viewport').clientHeight;

    var h_canvas = document.getElementById('h-ruler');
    var h_context = h_canvas.getContext('2d');

    h_canvas.width = (parseInt(viewWidth) - 16 );
    h_canvas.height = 16;

    var svgWidth = parseInt(viewWidth) * 0.95;
    var svgOffLeft =  (parseInt(viewWidth) - svgWidth)/2 -16;
    //  画矩形
    // h_context.beginPath();
    // h_context.fillStyle = "#f2f2f2";
    // h_context.fillRect(svgOffLeft,0,svgWidth,15);
    // h_context.beginPath();
    // ----------------------------------------------横尺----------------------------------------------------


   // 定义刻度线间距
    var AXIS_TICK_MARGIN = 10;

   // 定义刻度线高度
    var AXIS_TICK_LONG = 16;
    var AXIS_TICK_SHORT = 6;

    //  画刻度线
    for (var i = 0; i <= h_canvas.width; i++) {
        h_context.beginPath();

        h_context.moveTo( i * AXIS_TICK_MARGIN, 17);
        // 画线到刻度高度，10的位数就加高
        h_context.lineTo(i * AXIS_TICK_MARGIN, 17 - (i % AXIS_TICK_MARGIN == 0 ? AXIS_TICK_LONG : AXIS_TICK_SHORT));
        // 设置属性
        h_context.lineWidth=1;
        // 10的位数就加深
        h_context.strokeStyle=i % AXIS_TICK_MARGIN == 0 ? 'gray' : 'darkgray';
        // 描线
        h_context.stroke();
        // 描绘文本标签
        h_context.fillStyle='gray';
        if (i % AXIS_TICK_MARGIN == 0) {
            h_context.font='normal 10px Arial';
            // 为零补一个空格，让它看起来2位数，页面更整齐
            h_context.fillText(i == 0 ? ' ' + i : i*10, i * AXIS_TICK_MARGIN+2 , 9);
        }
        h_context.closePath();
    }


    jQuery(".h-container canvas").on("mouseenter", function(e) { // 动态创建指示器

        var left = e.clientX-16 -184;
        var str = "<div class='indicator'><span class='value'>"+left+"</span></div>";
        jQuery(str).css("left",left).appendTo(jQuery(".h-container"));
    });

    jQuery(".h-container canvas").on("mousemove", function(e) {
        var left = e.clientX-16 -184;

        jQuery(".indicator").css("left",left);
        jQuery(".indicator .value").text(left);
    });

    jQuery(".h-container canvas").on("mousedown", function(e) {
        var left = e.clientX-16 -184;

        jQuery(".indicator").remove();
        var str =' <div class="line" style="left: '+left+'px;"><div class="action"><span class="del">×</span><span class="value">'+left+'</span></div></div>';
        jQuery(str).appendTo(jQuery(".h-container .lines"));
    });
    jQuery(".h-container canvas").on("mouseleave", function(e) {
        jQuery(".indicator").remove();
    });

    jQuery(".h-container").on("click",".del" ,function(e) {
        e.preventDefault();
        e.stopPropagation();

        jQuery(this).parent().parent().remove();
    });
    jQuery(".h-container").on("mouseenter",".lines" ,function(e) {
        jQuery(".indicator").remove();
    });


// --------------------------------------------------竖尺-------------------------------------------------
    var v_canvas = document.getElementById('v-ruler');
    var v_context = v_canvas.getContext('2d');
    v_canvas.height =(parseInt(viewHeight) -16);
    v_canvas.width = 16;

    var svgHeight = parseInt(viewHeight) * 0.93;
    var svgOffTop =  (parseInt(viewHeight) - svgHeight)/2 -16;

    //  画矩形
    // v_context.beginPath();
    // v_context.fillStyle = "#f2f2f2";
    // v_context.fillRect(0,svgOffTop,15,svgHeight);
    // v_context.beginPath();


    //  画刻度线
    for (var j = 0; j <= v_canvas.height; j++) {
        v_context.beginPath();

        v_context.moveTo( 17,j * AXIS_TICK_MARGIN);
        // 画线到刻度高度，10的位数就加高
        v_context.lineTo(17 - (j % AXIS_TICK_MARGIN == 0 ? AXIS_TICK_LONG : AXIS_TICK_SHORT),j * AXIS_TICK_MARGIN);
        // 设置属性
        v_context.lineWidth=1;
        // 10的位数就加深
        v_context.strokeStyle=j % AXIS_TICK_MARGIN == 0 ? 'gray' : 'darkgray';
        // 描线
        v_context.stroke();
        // 描绘文本标签
        v_context.fillStyle='gray';

        if (j % AXIS_TICK_MARGIN == 0) {
            v_context.font='normal 10px Arial';
            v_context.save();
            v_context.rotate(-90*Math.PI/180);
            v_context.fillText(j == 0 ? ' ' + j : j*10, -j * AXIS_TICK_MARGIN+5 ,10);
            v_context.restore();
        }

        v_context.closePath();
    }


    jQuery(".v-container canvas").on("mouseenter", function(e) { // 动态创建指示器
        var top = e.clientY - 16 -54;
        var str = "<div class='indicator'><span class='value'>"+(top)+"</span></div>";
        jQuery(str).css("top",top-18).appendTo(jQuery(".v-container"));
    });

    jQuery(".v-container canvas").on("mousemove", function(e) {
        var top = e.clientY - 16 -54;

        jQuery(".indicator").css("top",top-18);
        jQuery(".indicator .value").text(top);
        // console.log("鼠标位置："+ e.clientY + ",指示器位置："+top);
    });

    jQuery(".v-container canvas").on("mousedown", function(e) {
        var top = e.clientY- 16 -54;

        jQuery(".indicator").remove();
        var str =' <div class="line" style="top: '+(top)+'px;"><div class="action"><span class="del">×</span><span class="value">'+(top)+'</span></div></div>';
        jQuery(str).appendTo(jQuery(".v-container .lines"));
    });
    jQuery(".v-container canvas").on("mouseleave", function(e) {
        jQuery(".indicator").remove();
    });

    jQuery(".v-container").on("click",".del" ,function(e) {
        e.preventDefault();
        e.stopPropagation();
        jQuery(this).parent().parent().remove();
    });
    jQuery(".v-container").on("mouseenter",".lines" ,function(e) {
        jQuery(".indicator").remove();
    });

},1000)
