/*
 * Activiti Modeler component part of the Activiti project
 * Copyright 2005-2014 Alfresco Software, Ltd. All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * Assignment
 */
var app = angular.module('myApp',[]);
var KisBpmAssignmentCtrl = ['$scope', '$modal', function ($scope, $modal) {

    // Config for the modal window
    var opts = {
        template: 'bpm/editor-app/configuration/properties/assignment-popup.html?version=' + Date.now(),
        scope: $scope
    };

    // Open the dialog
    $modal(opts);
    $scope.tab =1;
    $scope.selectTab = function (setTab) {
        this.tab = setTab;
    }
    $scope.isSelected = function (checkTab) {
      return  this.tab === checkTab;
    }
}];

var KisBpmAssignmentPopupCtrl = ['$scope', '$http', function ($scope, $http) {
    var countUser = 0;
    var countRole = 0;
    var countDept = 0;
    var arrUsers = [];
    var arrRoles = [];
    var arrDepts = [];
    $scope.setting = {
        async: {
            enable: true,
            type: "post",
            dataType: "text",
            url: ACTIVITI.CONFIG.baseRoot + "/assigneeChoose/lazyUserJson",
            autoParam: ["id"] //异步加载时需要自动提交父节点属性的参数
        },
        check: {
            enable: true
        },
        data: {
            simpleData: {
                enable: true,
                idKey : "id", //定义的节点属性名
                pIdKey : "pId", //定的义父节点属性名
                rootPId : 11 //根节点父id
            }
        },
        callback: {
            onCheck: function (event, treeId, treeNode) {//点击菜单时进行的处理
                // 获取到所有的节点
                // 选中的节点增加近中间变量，但是不可重复
                // 没有选中的节点从中间变量中删除

                var zTree = jQuery.fn.zTree.getZTreeObj("userTree");
                var node = zTree.getNodes();
                var nodes = zTree.transformToArray(node); //获取树所有节点转化为数组
                // 人员的中间变量
                var treeName = 'userTree';
                var users = $scope.users;
                // 遍历这个数组
                for (var i = 0;i < nodes.length;i ++) {
                    // 当前值
                    var temp = nodes[i];
                    if (temp.type === '用户' ) {
                        // 如果是被选中的节点,到中间变量中查找,找不到就添加
                        if (temp.checked && !checkArray(temp.id,users)) {
                            var obj1 = {
                                name: temp.name,
                                type: temp.type,
                                id: temp.id,
                                treeName:treeName
                            };
                            users.push(obj1);
                        }
                        // 如果是没有被选中的节点，也去找，找到了就删除
                        if (!temp.checked && checkArray(temp.id,users)) {
                            delFromArray(temp.id,users);
                        }
                    }
                }
                $scope.users = users;
                // 右侧的列表刷新
                $scope.$apply();
            },
            // 异步加载完成之后的回调
            onAsyncSuccess: function (event, treeId, treeNode, msg) {
                // 反选
                var zTree = jQuery.fn.zTree.getZTreeObj("userTree");
                //对已选择的值进行反选操作
                var candidateUsers = $scope.users;
                for (var i = 0; i < candidateUsers.length; i++) {
                    if (candidateUsers[i].id !== '' && candidateUsers[i].treeName === 'userTree') {
                        var n = zTree.getNodeByParam("id", candidateUsers[i].id, null);
                        if(n!= null && n !== "" && n != undefined && n !== "null"){
                            zTree.checkNode(zTree.getNodeByParam("id", candidateUsers[i].id, null), true, true, false);
                        }
                    }
                }
            },
            // 异步加载的异常
            onAsyncError: function (event, treeId, treeNode, XMLHttpRequest, textStatus, errorThrown) {
                console.error(errorThrown);
            }
        }
    };

    $scope.settingRole = {
        async: {
            enable: true,
            type: "post",
            dataType: "text",
            url: ACTIVITI.CONFIG.baseRoot + "/assigneeChoose/lazyRoleJson",
            autoParam: ["id"] //异步加载时需要自动提交父节点属性的参数
        },
        check: {
            enable: true
        },
        data: {
            simpleData: {
                enable: true,
                idKey : "id", //定义的节点属性名
                pIdKey : "pId" //定的义父节点属性名
            }
        },
        callback: {
            onCheck: function (event, treeId, treeNode) {//点击菜单时进行的处理
                // 获取到所有的节点
                // 选中的节点增加近中间变量，但是不可重复
                // 没有选中的节点从中间变量中删除

                var zTree = jQuery.fn.zTree.getZTreeObj("roleTree");
                var node = zTree.getNodes();
                var nodes = zTree.transformToArray(node); //获取树所有节点转化为数组
                // 角色的中间变量
                var treeName = 'roleTree';
                var users = $scope.roles;
                // 遍历这个数组
                for (var i = 0;i < nodes.length;i ++) {
                    // 当前值
                    var temp = nodes[i];
                    if (temp.type === '角色' ) {
                        // 如果是被选中的节点,到中间变量中查找,找不到就添加
                        if (temp.checked && !checkArray(temp.id,users)) {
                            var obj1 = {
                                name: temp.name,
                                type: temp.type,
                                id: temp.id,
                                treeName:treeName
                            };
                            users.push(obj1);
                        }
                        // 如果是没有被选中的节点，也去找，找到了就删除
                        if (!temp.checked && checkArray(temp.id,users)) {
                            delFromArray(temp.id,users);
                        }
                    }
                }
                $scope.roles = users;
                // 右侧的列表刷新
                $scope.$apply();
            },
            // 异步加载完成之后的回调
            onAsyncSuccess: function (event, treeId, treeNode, msg) {
                // 反选
                var zTree = jQuery.fn.zTree.getZTreeObj("roleTree");
                //对已选择的值进行反选操作
                var candidateUsers = $scope.roles;
                for (var i = 0; i < candidateUsers.length; i++) {
                    if (candidateUsers[i].id !== '' && candidateUsers[i].treeName === 'roleTree') {
                        var n = zTree.getNodeByParam("id", candidateUsers[i].id, null);
                        if(n!= null && n !== "" && n != undefined && n !== "null"){
                            zTree.checkNode(zTree.getNodeByParam("id", candidateUsers[i].id, null), true, true, false);
                        }
                    }
                }
            },
            // 异步加载的异常
            onAsyncError: function (event, treeId, treeNode, XMLHttpRequest, textStatus, errorThrown) {
                console.error(errorThrown);
            }
        }
    };

    $scope.settingDept = {
        async: {
            enable: true,
            type: "post",
            dataType: "text",
            url: ACTIVITI.CONFIG.baseRoot + "/assigneeChoose/lazyDeptJson",
            autoParam: ["id"] //异步加载时需要自动提交父节点属性的参数
        },
        check: {
            enable: true,
            chkboxType:{"Y":"","N":""}
        },
        data: {
            simpleData: {
                enable: true,
                idKey : "id", //定义的节点属性名
                pIdKey : "pId" //定的义父节点属性名
            }
        },
        callback: {
            onCheck: function (event, treeId, treeNode) {//点击菜单时进行的处理
                // 获取到所有的节点
                // 选中的节点增加近中间变量，但是不可重复
                // 没有选中的节点从中间变量中删除

                var zTree = jQuery.fn.zTree.getZTreeObj("deptTree");
                var node = zTree.getNodes();
                var nodes = zTree.transformToArray(node); //获取树所有节点转化为数组
                // 角色的中间变量
                var treeName = 'deptTree';
                var users = $scope.depts;
                // 遍历这个数组
                for (var i = 0;i < nodes.length;i ++) {
                    // 当前值
                    var temp = nodes[i];
                    if (temp.type === '部门' ) {
                        // 如果是被选中的节点,到中间变量中查找,找不到就添加
                        if (temp.checked && !checkArray(temp.id,users)) {
                            var obj1 = {
                                name: temp.name,
                                type: temp.type,
                                id: temp.id,
                                treeName:treeName
                            };
                            users.push(obj1);
                        }
                        // 如果是没有被选中的节点，也去找，找到了就删除
                        if (!temp.checked && checkArray(temp.id,users)) {
                            delFromArray(temp.id,users);
                        }
                    }
                }
                $scope.depts = users;
                // 右侧的列表刷新
                $scope.$apply();
            },
            // 异步加载完成之后的回调
            onAsyncSuccess: function (event, treeId, treeNode, msg) {
                // 反选
                var zTree = jQuery.fn.zTree.getZTreeObj("deptTree");
                //对已选择的值进行反选操作
                var candidateUsers = $scope.depts;
                for (var i = 0; i < candidateUsers.length; i++) {
                    if (candidateUsers[i].id !== '' && candidateUsers[i].treeName === 'deptTree') {
                        var n = zTree.getNodeByParam("id", candidateUsers[i].id, null);
                        if(n!= null && n !== "" && n != undefined && n !== "null"){
                            zTree.checkNode(zTree.getNodeByParam("id", candidateUsers[i].id, null), true, true, false);
                        }
                    }
                }
            },
            // 异步加载的异常
            onAsyncError: function (event, treeId, treeNode, XMLHttpRequest, textStatus, errorThrown) {
                console.error(errorThrown);
            }
        }
    };
    $scope.initUserTree = function () {
        // 先请求根节点
        $http({
            method: 'POST',
            url: ACTIVITI.CONFIG.baseRoot + "/assigneeChoose/lazyUserJson",
            params: {id:null}
        }).success(function (data, status, headers, config) {
            var personId = $scope.assignment.assignee;
            if(personId != "" && personId != undefined && personId != null){
                $scope.joinPerson = personId;
            }
            jQuery.noConflict();
            // 初始化树形菜单
            jQuery.fn.zTree.init(jQuery("#userTree"), $scope.setting,data);

            // 处理右侧表格的数据
            var treeName = "userTree";
            // 已经选择的用户数据
            var candidateUsers = $scope.assignment.candidateUsers;
            var users = [];
            // 循环遍历，得到数据,去查询数据库
            for (var i = 0; i < candidateUsers.length; i++) {
                if (candidateUsers[i].value !== '' && candidateUsers[i].type === 'userTree') {
                    users.push(candidateUsers[i].value);
                }
            }
            // 表格需要的数据
            var endUsers = [];
            // 查询数据库
            if (users.length > 0) {
                $http({
                    method: 'POST',
                    url: ACTIVITI.CONFIG.baseRoot + "/assigneeChoose/userList",
                    headers: {
                        'Accept': 'application/json',
                        'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
                    },
                    transformRequest: function (obj) {
                        var str = [];
                        for (var p in obj) {
                            str.push(encodeURIComponent(p) + "=" + encodeURIComponent(obj[p]));
                        }
                        return str.join("&");
                    },
                    data: {
                        ids: users
                    }
                }).success(function (data, status, headers, config) {
                    // 处理数据放入
                    for (var i = 0;i < data.length;i ++) {
                        var temp = data[i];
                        var obj = {
                            name: temp.name,
                            type: temp.type,
                            id: temp.id,
                            treeName:treeName
                        };
                        endUsers.push(obj);
                    }
                    endUsers = data;
                })
            }
            $scope.users = endUsers;
        }).error(function (data, status, headers, config) {
            alert("error");
        });
        $scope.initRoleTree();
    };

    $scope.initRoleTree = function () {
        // 先请求根节点
        $http({
            method: 'POST',
            url: ACTIVITI.CONFIG.baseRoot + "/assigneeChoose/lazyRoleJson",
            params: {id:null}
        }).success(function (data, status, headers, config) {
            jQuery.noConflict();
            // 初始化树形菜单
            jQuery.fn.zTree.init(jQuery("#roleTree"), $scope.settingRole,data);

            // 处理右侧表格的数据
            var treeName = "roleTree";
            // 已经选择的用户数据
            var candidateUsers = $scope.assignment.candidateRoles;
            var users = [];
            // 循环遍历，得到数据,去查询数据库
            for (var i = 0; i < candidateUsers.length; i++) {
                if (candidateUsers[i].value !== '' && candidateUsers[i].type === 'roleTree') {
                    users.push(candidateUsers[i].value);
                }
            }
            // 表格需要的数据
            var endUsers = [];
            // 查询数据库
            if (users.length > 0) {
                $http({
                    method: 'POST',
                    url: ACTIVITI.CONFIG.baseRoot + "/assigneeChoose/roleList",
                    headers: {
                        'Accept': 'application/json',
                        'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
                    },
                    transformRequest: function (obj) {
                        var str = [];
                        for (var p in obj) {
                            str.push(encodeURIComponent(p) + "=" + encodeURIComponent(obj[p]));
                        }
                        return str.join("&");
                    },
                    data: {
                        ids: users
                    }
                }).success(function (data, status, headers, config) {
                    // 处理数据放入
                    for (var i = 0;i < data.length;i ++) {
                        var temp = data[i];
                        var obj = {
                            name: temp.name,
                            type: temp.type,
                            id: temp.id,
                            treeName:treeName
                        };
                        endUsers.push(obj);
                    }
                    endUsers = data;
                })
            }
            $scope.roles = endUsers;
        }).error(function (data, status, headers, config) {
            alert("error");
        });
       $scope.initDeptTree();
    };

    $scope.initDeptTree = function () {
        // 先请求根节点
        $http({
            method: 'POST',
            url: ACTIVITI.CONFIG.baseRoot + "/assigneeChoose/lazyDeptJson",
            params: {id:null}
        }).success(function (data, status, headers, config) {
            jQuery.noConflict();
            // 初始化树形菜单
            jQuery.fn.zTree.init(jQuery("#deptTree"), $scope.settingDept,data);

            // 处理右侧表格的数据
            var treeName = "deptTree";
            // 已经选择的用户数据
            var candidateUsers = $scope.assignment.candidateDepts;
            var users = [];
            // 循环遍历，得到数据,去查询数据库
            for (var i = 0; i < candidateUsers.length; i++) {
                if (candidateUsers[i].value !== '' && candidateUsers[i].type === 'deptTree') {
                    users.push(candidateUsers[i].value);
                }
            }
            // 表格需要的数据
            var endUsers = [];
            // 查询数据库
            if (users.length > 0) {
                $http({
                    method: 'POST',
                    url: ACTIVITI.CONFIG.baseRoot + "/assigneeChoose/deptList",
                    headers: {
                        'Accept': 'application/json',
                        'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
                    },
                    transformRequest: function (obj) {
                        var str = [];
                        for (var p in obj) {
                            str.push(encodeURIComponent(p) + "=" + encodeURIComponent(obj[p]));
                        }
                        return str.join("&");
                    },
                    data: {
                        ids: users
                    }
                }).success(function (data, status, headers, config) {
                    // 处理数据放入
                    for (var i = 0;i < data.length;i ++) {
                        var temp = data[i];
                        var obj = {
                            name: temp.name,
                            type: temp.type,
                            id: temp.id,
                            treeName:treeName
                        };
                        endUsers.push(obj);
                    }
                    endUsers = data;
                })
            }
            $scope.depts = endUsers;
        }).error(function (data, status, headers, config) {
            alert("error");
        });
    };

    //用户列表删除操作
    $scope.unCheck = function (nodeId,treeName) {
        var zTree = jQuery.fn.zTree.getZTreeObj(treeName);
        // 获得节点
        var node = zTree.getNodeByParam("id", nodeId, null);
        if (null !== node && undefined !== node ) {
            zTree.checkNode(node, false, true, false);
        }
        var users;
        if(treeName == "roleTree"){
            users= $scope.roles;
        }else if(treeName == "deptTree"){
            users= $scope.depts;
        }else{
            users= $scope.users;
        }
        for (var i = 0; i < users.length; i++) {
            if(users[i].id == nodeId){
                users.splice(i,1);
            }
        }
        var userids = [];
        for(var i = 0; i < users.length; i++){
            userids[i] = users[i].id
        }
        if(treeName == "roleTree"){
            $scope.roles = users;
        }else if(treeName == "deptTree"){
            $scope.depts = users;
        }else{
            $scope.users = users;
        }
        // $scope.assignment.candidateUsers = userids.join(",")
    };

    // Put json representing assignment on scope
    if ($scope.property.value !== undefined && $scope.property.value !== null
        && $scope.property.value.assignment !== undefined
        && $scope.property.value.assignment !== null) {
        $scope.assignment = $scope.property.value.assignment;
    } else {
        $scope.assignment = {};
    }

    if ($scope.assignment.candidateUsers == undefined || $scope.assignment.candidateUsers.length == 0) {
        $scope.assignment.candidateUsers = [{value: ''}];
    }
    if ($scope.assignment.candidateRoles == undefined || $scope.assignment.candidateRoles.length == 0) {
        $scope.assignment.candidateRoles = [{value: ''}];
    }
    if ($scope.assignment.candidateDepts == undefined || $scope.assignment.candidateDepts.length == 0) {
        $scope.assignment.candidateDepts = [{value: ''}];
    }

    // Click handler for + button after enum value
    var userValueIndex = 1;
    $scope.addCandidateUserValue = function (index) {
        $scope.assignment.candidateUsers.splice(index + 1, 0, {value: 'value ' + userValueIndex++});
    };

    // Click handler for - button after enum value
    $scope.removeCandidateUserValue = function (index) {
        $scope.assignment.candidateUsers.splice(index, 1);
    };

    if ($scope.assignment.candidateGroups == undefined || $scope.assignment.candidateGroups.length == 0) {
        $scope.assignment.candidateGroups = [{value: ''}];
    }

    var groupValueIndex = 1;
    $scope.addCandidateGroupValue = function (index) {
        $scope.assignment.candidateGroups.splice(index + 1, 0, {value: 'value ' + groupValueIndex++});
    };

    // Click handler for - button after enum value
    $scope.removeCandidateGroupValue = function (index) {
        $scope.assignment.candidateGroups.splice(index, 1);
    };

    var roleValueIndex = 1;
    $scope.addCandidateRoleValue = function (index) {
        $scope.assignment.candidateRoles.splice(index + 1, 0, {value: 'value ' + roleValueIndex++});
    };

    // Click handler for - button after enum value
    $scope.removeCandidateRoleValue = function (index) {
        $scope.assignment.candidateRoles.splice(index, 1);
    };

    var deptValueIndex = 1;
    $scope.addCandidateDeptValue = function (index) {
        $scope.assignment.candidateDepts.splice(index + 1, 0, {value: 'value ' + deptValueIndex++});
    };

    // Click handler for - button after enum value
    $scope.removeCandidateDeptValue = function (index) {
        $scope.assignment.candidateDepts.splice(index, 1);
    };

    $scope.save = function () {
        //获取变量
        var joinPerson = $scope.joinPerson;
        //判断是否为空，如果不为空则使用的是变量的形式。
        if(joinPerson != "" && joinPerson != undefined && joinPerson != null){
            $scope.assignment.assignee = joinPerson;
            $scope.assignment.candidateUsers = [{value: ''}];
            $scope.assignment.candidateRoles = [{value: ''}];
            $scope.assignment.candidateDepts = [{value: ''}];
            $scope.property.value = {};
            handleAssignmentInput($scope);
            $scope.property.value.assignment = $scope.assignment;
            $scope.updatePropertyInModel($scope.property);
            $scope.close();
        }else{
            var arrayUsers = [];
            var arrayRoles = [];
            var arrayDepts = [];
            if ($scope.users.length > 0) {
                for (var i = 0; i < $scope.users.length; i++) {
                    arrayUsers.push({value: $scope.users[i].id ,type:"userTree"});
                }
            }
            if ($scope.roles.length > 0) {
                for (var i = 0; i < $scope.roles.length; i++) {
                    arrayRoles.push({value: $scope.roles[i].id,type:"roleTree"});
                }
            }
            if ($scope.depts.length > 0) {
                for (var i = 0; i < $scope.depts.length; i++) {
                    arrayDepts.push({value: $scope.depts[i].id, type: "deptTree"});
                }
            }
            $scope.assignment.assignee = "";
            $scope.assignment.candidateUsers = arrayUsers;
            $scope.assignment.candidateRoles = arrayRoles;
            $scope.assignment.candidateDepts = arrayDepts;
            $scope.property.value = {};
            handleAssignmentInput($scope);
            $scope.property.value.assignment = $scope.assignment;
            $scope.updatePropertyInModel($scope.property);
            $scope.close();
        }

    };

    // Close button handler
    $scope.close = function () {
        handleAssignmentInput($scope);
        $scope.property.mode = 'read';
        $scope.$hide();
    };

    var handleAssignmentInput = function ($scope) {
        if ($scope.assignment.candidateUsers) {
            var emptyUsers = true;
            var toRemoveIndexes = [];
            for (var i = 0; i < $scope.assignment.candidateUsers.length; i++) {
                if ($scope.assignment.candidateUsers[i].value != '') {
                    emptyUsers = false;
                }
                else {
                    toRemoveIndexes[toRemoveIndexes.length] = i;
                }
            }

            for (var i = 0; i < toRemoveIndexes.length; i++) {
                $scope.assignment.candidateUsers.splice(toRemoveIndexes[i], 1);
            }

            if (emptyUsers) {
                $scope.assignment.candidateUsers = undefined;
            }
        }

        if ($scope.assignment.candidateGroups) {
            var emptyGroups = true;
            var toRemoveIndexes = [];
            for (var i = 0; i < $scope.assignment.candidateGroups.length; i++) {
                if ($scope.assignment.candidateGroups[i].value != '') {
                    emptyGroups = false;
                }
                else {
                    toRemoveIndexes[toRemoveIndexes.length] = i;
                }
            }

            for (var i = 0; i < toRemoveIndexes.length; i++) {
                $scope.assignment.candidateGroups.splice(toRemoveIndexes[i], 1);
            }

            if (emptyGroups) {
                $scope.assignment.candidateGroups = undefined;
            }
        }
        if ($scope.assignment.candidateRoles) {
            var emptyRoles = true;
            var toRemoveIndexes = [];
            for (var i = 0; i < $scope.assignment.candidateRoles.length; i++) {
                if ($scope.assignment.candidateRoles[i].value != '') {
                    emptyRoles = false;
                }
                else {
                    toRemoveIndexes[toRemoveIndexes.length] = i;
                }
            }

            for (var i = 0; i < toRemoveIndexes.length; i++) {
                $scope.assignment.candidateRoles.splice(toRemoveIndexes[i], 1);
            }

            if (emptyRoles) {
                $scope.assignment.candidateRoles = undefined;
            }
        }
        if ($scope.assignment.candidateDepts) {
            var emptyDepts = true;
            var toRemoveIndexes = [];
            for (var i = 0; i < $scope.assignment.candidateDepts.length; i++) {
                if ($scope.assignment.candidateDepts[i].value != '') {
                    emptyDepts = false;
                }
                else {
                    toRemoveIndexes[toRemoveIndexes.length] = i;
                }
            }

            for (var i = 0; i < toRemoveIndexes.length; i++) {
                $scope.assignment.candidateDepts.splice(toRemoveIndexes[i], 1);
            }

            if (emptyDepts) {
                $scope.assignment.candidateDepts = undefined;
            }
        }
    };

    //[[初始化tree]]因为之前用的异步加载，用户初始化的回调会比较慢，现在改成方法内的异步，所以初始化树必须在数据初始化之后
    $scope.initUserTree();
}];
function wtConfigInfo($scope, $http) {
    //接受子控制器发送的消息
    // $scope.$on("menu",function(event,params){
    //     $http.get("/leave/userJson").success(function(data){
    //         //发送消息给子控制器
    //         $scope.$broadcast("menuData",data);
    //     });
    // });
}function wtConfigInfo1($scope, $http) {
    //接受子控制器发送的消息
    // $scope.$on("menu",function(event,params){
    //     $http.get("/leave/userJson").success(function(data){
    //         //发送消息给子控制器
    //         $scope.$broadcast("menuData",data);
    //     });
    // });
}function wtConfigInfo2($scope, $http) {
    $scope.joinPerson;
    //接受子控制器发送的消息
    // $scope.$on("menu",function(event,params){
    //     $http.get("/leave/userJson").success(function(data){
    //         //发送消息给子控制器
    //         $scope.$broadcast("menuData",data);
    //     });
    // });
}

/**
 * 查找一个对象的id，在一个数组中是否存在
 */
function checkArray(id,array) {
    for (var i = 0;i < array.length; i ++ ) {
        if (array[i].id === id) {
            return true;
        }
    }
    return false;
}

/**
 * 删除数组中对象id相同的元素
 */
function delFromArray(id,array) {
    for (var i = 0;i < array.length; i ++ ) {
        if (array[i].id === id) {
            array.splice(i,1);
        }
    }
}

