/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.properties;

import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="hussar")
public class HussarBpmProperties {
    public static final String PREFIX = "hussar";
    private String fileUploadPathWindows = "d:/tmp";
    private String fileUploadPathLinux = "/tmp/hussar";
    private Boolean fileDateSplit = true;
    private Boolean haveCreatePath = false;

    public String getFileUploadPath() {
        String fileUploadPath = "";
        boolean fileDateSplit = this.getFileDateSplit();
        Properties prop = System.getProperties();
        String os = prop.getProperty("os.name");
        if (os != null && os.toLowerCase().indexOf("linux") > -1) {
            fileUploadPath = this.fileUploadPathLinux;
        } else if (os != null && os.toLowerCase().indexOf("windows") > -1) {
            fileUploadPath = this.fileUploadPathWindows;
        } else if (os != null && os.toLowerCase().indexOf("mac") > -1) {
            fileUploadPath = this.fileUploadPathLinux;
        }
        if (fileDateSplit) {
            fileUploadPath = fileUploadPath + "/" + new SimpleDateFormat("yyyy/MM/dd").format(new Date());
        }
        if (ToolUtil.isEmpty((Object)fileUploadPath)) {
            return ToolUtil.getTempPath();
        }
        if (!fileUploadPath.endsWith(File.separator)) {
            fileUploadPath = fileUploadPath + File.separator;
        }
        if (!this.haveCreatePath.booleanValue()) {
            File file = new File(fileUploadPath);
            file.mkdirs();
            this.haveCreatePath = true;
        }
        return fileUploadPath;
    }

    public void setFileUploadPathWindows(String fileUploadPathWindows) {
        this.fileUploadPathWindows = fileUploadPathWindows;
    }

    public void setFileUploadPathLinux(String fileUploadPathLinux) {
        this.fileUploadPathLinux = fileUploadPathLinux;
    }

    public Boolean getFileDateSplit() {
        return this.fileDateSplit;
    }

    public void setFileDateSplit(Boolean fileDateSplit) {
        this.fileDateSplit = fileDateSplit;
    }

    public String getFileUploadPathWindows() {
        return this.fileUploadPathWindows;
    }

    public String getFileUploadPathLinux() {
        return this.fileUploadPathLinux;
    }

    public Boolean getHaveCreatePath() {
        return this.haveCreatePath;
    }

    public void setHaveCreatePath(Boolean haveCreatePath) {
        this.haveCreatePath = haveCreatePath;
    }
}

