/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.rest.service.impl;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.bpm.common.utils.ServiceResult;
import com.jxdinfo.hussar.bpm.process.model.ProcessDefinitionModel;
import com.jxdinfo.hussar.bpm.rest.service.ProcessDefinitionService;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.converter.util.InputStreamProvider;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.editor.language.json.converter.BpmnJsonConverter;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.impl.util.io.InputStreamSource;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ModelQuery;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.activiti.image.impl.DefaultProcessDiagramCanvas;
import org.activiti.image.impl.DefaultProcessDiagramGenerator;
import org.activiti.spring.ProcessEngineFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import sun.misc.BASE64Encoder;

@Service
public class ProcessDefinitionServiceImpl
implements ProcessDefinitionService {
    private static Logger LOGGER = LoggerFactory.getLogger(ProcessDefinitionServiceImpl.class);
    @Autowired
    private ProcessEngineFactoryBean processEngine;
    @Autowired
    private RepositoryService repositoryService;

    @Override
    public String queryProcessDefListOfHighVersion(String name) {
        try {
            List deployments = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionNameLike("%" + name + "%").latestVersion().orderByProcessDefinitionName().desc()).list();
            ArrayList<ProcessDefinitionModel> result = new ArrayList<ProcessDefinitionModel>(deployments.size());
            for (ProcessDefinition deployment : deployments) {
                ProcessDefinitionModel item = new ProcessDefinitionModel();
                item.setId(deployment.getId());
                item.setProcessName(deployment.getName());
                item.setVersion(Integer.toString(deployment.getVersion()));
                item.setIsSuspended(Boolean.toString(deployment.isSuspended()));
                item.setDescription(deployment.getDescription());
                item.setCategory(deployment.getCategory());
                item.setDeploymentId(deployment.getDeploymentId());
                if (deployment.getResourceName() != null) {
                    String[] sourceArr = deployment.getResourceName().split("/");
                    item.setResourceName(sourceArr[sourceArr.length - 1]);
                } else {
                    item.setResourceName("");
                }
                if (deployment.getDiagramResourceName() != null) {
                    String[] diagramArr = deployment.getDiagramResourceName().split("/");
                    item.setDiagramResourceName(diagramArr[diagramArr.length - 1]);
                } else {
                    item.setDiagramResourceName("");
                }
                Deployment deploymentTime = (Deployment)this.repositoryService.createDeploymentQuery().deploymentId(deployment.getDeploymentId()).singleResult();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String timeStr = sdf.format(deploymentTime.getDeploymentTime());
                item.setDeploymentTime(timeStr);
                result.add(item);
            }
            HashMap<String, Serializable> mapStr = new HashMap<String, Serializable>();
            mapStr.put("data", result);
            mapStr.put("count", Integer.valueOf(result.size()));
            return ServiceResult.getResult("1", "success", JSON.toJSONString(mapStr));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return ServiceResult.getResult("0", "error", "");
        }
    }

    @Override
    public String queryProcessDefList(String name) {
        try {
            List deployments = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionNameLike("%" + name + "%").orderByProcessDefinitionName().desc()).list();
            ArrayList<ProcessDefinitionModel> result = new ArrayList<ProcessDefinitionModel>(deployments.size());
            for (ProcessDefinition deployment : deployments) {
                ProcessDefinitionModel item = new ProcessDefinitionModel();
                item.setId(deployment.getId());
                item.setProcessName(deployment.getName());
                item.setVersion(Integer.toString(deployment.getVersion()));
                item.setIsSuspended(Boolean.toString(deployment.isSuspended()));
                item.setDescription(deployment.getDescription());
                item.setCategory(deployment.getCategory());
                item.setDeploymentId(deployment.getDeploymentId());
                if (deployment.getResourceName() != null) {
                    String[] sourceArr = deployment.getResourceName().split("/");
                    item.setResourceName(sourceArr[sourceArr.length - 1]);
                } else {
                    item.setResourceName("");
                }
                if (deployment.getDiagramResourceName() != null) {
                    String[] diagramArr = deployment.getDiagramResourceName().split("/");
                    item.setDiagramResourceName(diagramArr[diagramArr.length - 1]);
                } else {
                    item.setDiagramResourceName("");
                }
                Deployment deploymentTime = (Deployment)this.repositoryService.createDeploymentQuery().deploymentId(deployment.getDeploymentId()).singleResult();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String timeStr = sdf.format(deploymentTime.getDeploymentTime());
                item.setDeploymentTime(timeStr);
                result.add(item);
            }
            HashMap<String, ArrayList<ProcessDefinitionModel>> mapStr = new HashMap<String, ArrayList<ProcessDefinitionModel>>();
            mapStr.put("data", result);
            return ServiceResult.getResult("1", "success", JSON.toJSONString(mapStr));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return ServiceResult.getResult("0", "error", "");
        }
    }

    @Override
    public String updateProcessDefinitionState(String state, String processDefinitionId) {
        HashMap<String, String> mapStr = new HashMap<String, String>();
        try {
            if ("active".equals(state)) {
                this.repositoryService.activateProcessDefinitionById(processDefinitionId);
            }
            if ("suspend".equals(state)) {
                this.repositoryService.suspendProcessDefinitionById(processDefinitionId);
            }
            mapStr.put("flag", "true");
            return ServiceResult.getResult("1", "success", JSON.toJSONString(mapStr));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            mapStr.put("flag", "false");
            return ServiceResult.getResult("0", "error", JSON.toJSONString(mapStr));
        }
    }

    @Override
    public String deleteProcessDefinition(String processDefinitionId) {
        HashMap<String, String> mapStr = new HashMap<String, String>();
        try {
            this.repositoryService.deleteDeployment(processDefinitionId);
            mapStr.put("flag", "true");
            return ServiceResult.getResult("1", "success", JSON.toJSONString(mapStr));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            mapStr.put("flag", "false");
            return ServiceResult.getResult("0", "error", JSON.toJSONString(mapStr));
        }
    }

    @Override
    public String loadFlowResource(String processDefinitionId, String processDefinitionName, String resourceType) {
        HashMap<String, String> mapStr = new HashMap<String, String>();
        try {
            if ("xml".equals(resourceType)) {
                InputStream in = this.processEngine.getProcessEngineConfiguration().getRepositoryService().getResourceAsStream(processDefinitionId, processDefinitionName);
                BASE64Encoder encoder = new BASE64Encoder();
                byte[] data = null;
                data = new byte[in.available()];
                String xml = encoder.encode(data);
                mapStr.put("data", xml);
                return ServiceResult.getResult("1", "", JSON.toJSONString(mapStr));
            }
            if ("image".equals(resourceType)) {
                DefaultProcessDiagramGenerator defaultProcessDiagramGenerator = new DefaultProcessDiagramGenerator();
                BpmnModel bm = this.repositoryService.getBpmnModel(processDefinitionId);
                InputStream in = defaultProcessDiagramGenerator.generateDiagram(bm, "png", "\u5b8b\u4f53", "\u5b8b\u4f53", "\u5b8b\u4f53", null);
                BASE64Encoder encoder = new BASE64Encoder();
                byte[] data = null;
                data = new byte[in.available()];
                String image = encoder.encode(data);
                mapStr.put("data", image);
                return ServiceResult.getResult("1", "success", JSON.toJSONString(mapStr));
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return ServiceResult.getResult("0", "error", "");
    }

    @Override
    public String queryFlowConfigInfo(String processDefinitionId) {
        try {
            ArrayList activityInfos = new ArrayList();
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processDefinitionId);
            List activitiList = processDefinition.getActivities();
            InputStream xmlIs = this.repositoryService.getResourceAsStream(processDefinition.getDeploymentId(), processDefinition.getResourceName());
            BpmnModel bm = new BpmnXMLConverter().convertToBpmnModel((InputStreamProvider)new InputStreamSource(xmlIs), false, true);
            Class<?> clazz = Class.forName("org.activiti.image.impl.DefaultProcessDiagramGenerator");
            Method method = clazz.getDeclaredMethod("initProcessDiagramCanvas", BpmnModel.class, String.class, String.class, String.class, String.class, ClassLoader.class);
            method.setAccessible(true);
            DefaultProcessDiagramCanvas pdc = (DefaultProcessDiagramCanvas)method.invoke(clazz.newInstance(), bm, "png", "\u5b8b\u4f53", "\u5b8b\u4f53", "\u5b8b\u4f53", null);
            clazz = Class.forName("org.activiti.image.impl.DefaultProcessDiagramCanvas");
            Field minXField = clazz.getDeclaredField("minX");
            Field minYField = clazz.getDeclaredField("minY");
            minXField.setAccessible(true);
            minYField.setAccessible(true);
            int minX = minXField.getInt(pdc);
            int minY = minYField.getInt(pdc);
            minX = minX > 0 ? minX - 5 : 0;
            minY = minY > 0 ? minY - 5 : 0;
            for (ActivityImpl activity : activitiList) {
                HashMap<String, Object> activityInfo = new HashMap<String, Object>();
                activityInfo.put("width", activity.getWidth());
                activityInfo.put("height", activity.getHeight());
                activityInfo.put("x", activity.getX() + 10);
                activityInfo.put("y", activity.getY() + 10);
                activityInfo.put("actId", activity.getId());
                activityInfo.put("name", activity.getProperty("name"));
                if (activity.getProperty("name") == null || "".equals(activity.getProperty("name").toString())) {
                    activityInfo.put("name", "");
                } else {
                    activityInfo.put("name", activity.getProperty("name"));
                }
                activityInfo.put("type", activity.getProperty("type"));
                ActivityBehavior activityBehavior = activity.getActivityBehavior();
                if (activityBehavior instanceof UserTaskActivityBehavior) {
                    UserTaskActivityBehavior userTaskActivityBehavior = (UserTaskActivityBehavior)activityBehavior;
                    TaskDefinition taskDefinition = userTaskActivityBehavior.getTaskDefinition();
                    if (taskDefinition.getAssigneeExpression() == null || "".equals(taskDefinition.getAssigneeExpression().toString())) {
                        activityInfo.put("assignee", "\u672a\u8bbe\u7f6e");
                    } else {
                        activityInfo.put("assignee", taskDefinition.getAssigneeExpression().toString());
                    }
                }
                activityInfos.add(activityInfo);
            }
            HashMap mapStr = new HashMap();
            mapStr.put("data", activityInfos);
            return ServiceResult.getResult("1", "success", JSON.toJSONString(mapStr));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String queryProcess() {
        ArrayList list = new ArrayList();
        List models = ((ModelQuery)this.repositoryService.createModelQuery().deployed().orderByLastUpdateTime().desc()).list();
        if (models != null) {
            BpmnJsonConverter jsonConverter = new BpmnJsonConverter();
            for (Model model : models) {
                HashMap<String, String> map = new HashMap<String, String>();
                byte[] arg0 = this.repositoryService.getModelEditorSource(model.getId());
                String temp = null;
                try {
                    temp = new String(arg0, "utf-8").replace("undefined", "");
                    JsonNode editorNode = new ObjectMapper().readTree(temp.getBytes("utf-8"));
                    BpmnModel bpmnModel = jsonConverter.convertToBpmnModel(editorNode);
                    if (bpmnModel.getProcesses().size() <= 0) continue;
                    map.put("id", ((Process)bpmnModel.getProcesses().get(0)).getId());
                    map.put("name", ((Process)bpmnModel.getProcesses().get(0)).getName());
                    list.add(map);
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage());
                }
            }
        }
        return ServiceResult.getResult("1", "success", JSON.toJSONString(list));
    }

    @Override
    public String queryProcessLink(String processDefinitionKey) {
        ArrayList list = new ArrayList();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).latestVersion().singleResult();
        if (processDefinition == null) {
            return ServiceResult.getResult("0", "\u672a\u627e\u5230\u6d41\u7a0b\u5b9a\u4e49", "");
        }
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinition.getId());
        if (bpmnModel != null) {
            Collection flowElements = ((Process)bpmnModel.getProcesses().get(0)).getFlowElements();
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof UserTask)) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", flowElement.getId());
                map.put("name", flowElement.getName());
                list.add(map);
            }
            return ServiceResult.getResult("1", "success", JSON.toJSONString(list));
        }
        return ServiceResult.getResult("0", "\u6d41\u7a0b\u6a21\u578b\u4e3a\u7a7a", "");
    }

    @Override
    public String queryStartFormUrl(String processDefinitionKey) {
        String formUrl = "";
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).latestVersion().singleResult();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinition.getId());
        Collection flowElements = ((Process)bpmnModel.getProcesses().get(0)).getFlowElements();
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof StartEvent)) continue;
            formUrl = ((StartEvent)flowElement).getFormKey();
        }
        return ServiceResult.getResult("1", "success", formUrl);
    }
}

