/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.processimage.utils;

import com.jxdinfo.hussar.bpm.processimage.utils.ReflectUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.activiti.bpmn.model.AssociationDirection;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.image.impl.DefaultProcessDiagramCanvas;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HMProcessDiagramCanvas
extends DefaultProcessDiagramCanvas {
    private static Logger logger = LogManager.getLogger(HMProcessDiagramCanvas.class);
    private static List<String> taskType = new ArrayList<String>();
    private static List<String> eventType = new ArrayList<String>();
    private static List<String> gatewayType = new ArrayList<String>();
    private static List<String> subProcessType = new ArrayList<String>();
    private static Color START_COLOR = new Color(229, 246, 253);
    private static Color END_COLOR = new Color(229, 246, 253);
    private static Color GATEWAY_COLOR1 = new Color(50, 172, 255);
    private static Color GATEWAY_COLOR2 = new Color(207, 216, 221);
    private static Color TASK_BOX_COLOR1 = new Color(229, 246, 253);
    private static Color TASK_BOX_COLOR2 = new Color(255, 254, 230);
    private static Color TASK_BOX_COLOR3 = new Color(237, 239, 241);
    private static Color TASK_BORDER_COLOR1 = new Color(50, 172, 255);
    private static Color TASK_BORDER_COLOR2 = new Color(249, 200, 113);
    private static Color TASK_BORDER_COLOR3 = new Color(216, 223, 228);
    private static Color HIGHLIGHT_COLOR = new Color(50, 172, 255);
    private static Color LIGHT_COLOR = new Color(207, 216, 221);
    private static Color FONT_COLOR = new Color(66, 71, 91);
    private static Font TASK_FONT;
    private static String FONT_STYLE;
    private static Color LABAL_FONT_COLOR;
    private static List<String> highLightedActivitiesStatic;
    private static List<String> runningNodeStatic;
    private static BufferedImage USERTASK_PERSON_IMAGE1;
    private static BufferedImage USERTASK_PERSON_IMAGE2;
    private static BufferedImage USERTASK_PERSON_IMAGE3;
    private static BufferedImage START_IMAGE;
    private static BufferedImage END_IMAGE;
    private static Stroke HIGHLIGHT_FLOW_STROKE;
    private static Stroke BORDER_STROKE;

    public HMProcessDiagramCanvas(int width, int height, int minX, int minY, String imageType, String activityFontName, String labelFontName, String annotationFontName, ClassLoader customClassLoader, List<String> highLightedActivities, List<String> runningNode) {
        super(width, height, minX, minY, imageType, activityFontName, labelFontName, annotationFontName, customClassLoader);
        highLightedActivitiesStatic = highLightedActivities;
        runningNodeStatic = runningNode;
        HMProcessDiagramCanvas.init();
    }

    protected static void init() {
        taskType.add("manualTask");
        taskType.add("receiveTask");
        taskType.add("scriptTask");
        taskType.add("sendTask");
        taskType.add("serviceTask");
        taskType.add("userTask");
        gatewayType.add("exclusiveGateway");
        gatewayType.add("inclusiveGateway");
        gatewayType.add("eventBasedGateway");
        gatewayType.add("parallelGateway");
        eventType.add("intermediateTimer");
        eventType.add("intermediateMessageCatch");
        eventType.add("intermediateSignalCatch");
        eventType.add("intermediateSignalThrow");
        eventType.add("messageStartEvent");
        eventType.add("startTimerEvent");
        eventType.add("error");
        eventType.add("startEvent");
        eventType.add("errorEndEvent");
        eventType.add("endEvent");
        subProcessType.add("subProcess");
        subProcessType.add("callActivity");
    }

    public void initialize(String imageType) {
        this.processDiagram = "png".equalsIgnoreCase(imageType) ? new BufferedImage(this.canvasWidth, this.canvasHeight, 2) : new BufferedImage(this.canvasWidth, this.canvasHeight, 1);
        this.g = this.processDiagram.createGraphics();
        if (!"png".equalsIgnoreCase(imageType)) {
            this.g.setBackground(new Color(255, 255, 255, 0));
            this.g.clearRect(0, 0, this.canvasWidth, this.canvasHeight);
        }
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g.setPaint(Color.black);
        Font font = new Font(this.activityFontName, 1, 12);
        this.g.setFont(font);
        this.fontMetrics = this.g.getFontMetrics();
        LABEL_FONT = new Font(FONT_STYLE, 1, 10);
        ANNOTATION_FONT = new Font(this.annotationFontName, 1, 12);
        try {
            USERTASK_IMAGE = ImageIO.read(ReflectUtil.getResource("org/activiti/icons/userTask.png", this.customClassLoader));
            USERTASK_PERSON_IMAGE1 = ImageIO.read(ReflectUtil.getResource("org/activiti/icons/finish.png", this.customClassLoader));
            USERTASK_PERSON_IMAGE2 = ImageIO.read(ReflectUtil.getResource("org/activiti/icons/now.png", this.customClassLoader));
            USERTASK_PERSON_IMAGE3 = ImageIO.read(ReflectUtil.getResource("org/activiti/icons/next.png", this.customClassLoader));
            END_IMAGE = ImageIO.read(ReflectUtil.getResource("org/activiti/icons/end.png", this.customClassLoader));
            START_IMAGE = ImageIO.read(ReflectUtil.getResource("org/activiti/icons/start.png", this.customClassLoader));
            SCRIPTTASK_IMAGE = ImageIO.read(ReflectUtil.getResource("org/activiti/icons/scriptTask.png", this.customClassLoader));
            SERVICETASK_IMAGE = ImageIO.read(ReflectUtil.getResource("org/activiti/icons/serviceTask.png", this.customClassLoader));
            RECEIVETASK_IMAGE = ImageIO.read(ReflectUtil.getResource("org/activiti/icons/receiveTask.png", this.customClassLoader));
            SENDTASK_IMAGE = ImageIO.read(ReflectUtil.getResource("org/activiti/icons/sendTask.png", this.customClassLoader));
            MANUALTASK_IMAGE = ImageIO.read(ReflectUtil.getResource("org/activiti/icons/manualTask.png", this.customClassLoader));
            BUSINESS_RULE_TASK_IMAGE = ImageIO.read(ReflectUtil.getResource("org/activiti/icons/businessRuleTask.png", this.customClassLoader));
            SHELL_TASK_IMAGE = ImageIO.read(ReflectUtil.getResource("org/activiti/icons/shellTask.png", this.customClassLoader));
            CAMEL_TASK_IMAGE = ImageIO.read(ReflectUtil.getResource("org/activiti/icons/camelTask.png", this.customClassLoader));
            MULE_TASK_IMAGE = ImageIO.read(ReflectUtil.getResource("org/activiti/icons/muleTask.png", this.customClassLoader));
            TIMER_IMAGE = ImageIO.read(ReflectUtil.getResource("org/activiti/icons/timer.png", this.customClassLoader));
            COMPENSATE_THROW_IMAGE = ImageIO.read(ReflectUtil.getResource("org/activiti/icons/compensate-throw.png", this.customClassLoader));
            COMPENSATE_CATCH_IMAGE = ImageIO.read(ReflectUtil.getResource("org/activiti/icons/compensate.png", this.customClassLoader));
            ERROR_THROW_IMAGE = ImageIO.read(ReflectUtil.getResource("org/activiti/icons/error-throw.png", this.customClassLoader));
            ERROR_CATCH_IMAGE = ImageIO.read(ReflectUtil.getResource("org/activiti/icons/error.png", this.customClassLoader));
            MESSAGE_THROW_IMAGE = ImageIO.read(ReflectUtil.getResource("org/activiti/icons/message-throw.png", this.customClassLoader));
            MESSAGE_CATCH_IMAGE = ImageIO.read(ReflectUtil.getResource("org/activiti/icons/message.png", this.customClassLoader));
            SIGNAL_THROW_IMAGE = ImageIO.read(ReflectUtil.getResource("org/activiti/icons/signal-throw.png", this.customClassLoader));
            SIGNAL_CATCH_IMAGE = ImageIO.read(ReflectUtil.getResource("org/activiti/icons/signal.png", this.customClassLoader));
        }
        catch (IOException e) {
            logger.warn("Could not load image for process diagram creation: {}", (Object)e.getMessage());
        }
    }

    public void drawUserTask(String name, GraphicInfo graphicInfo, double scaleFactor, String id) {
        if (highLightedActivitiesStatic != null && highLightedActivitiesStatic.contains(id) && !runningNodeStatic.contains(id)) {
            this.drawTask(USERTASK_PERSON_IMAGE1, name, graphicInfo, scaleFactor, id);
        } else if (runningNodeStatic != null && runningNodeStatic.contains(id)) {
            this.drawTask(USERTASK_PERSON_IMAGE2, name, graphicInfo, scaleFactor, id);
        } else {
            this.drawTask(USERTASK_PERSON_IMAGE3, name, graphicInfo, scaleFactor, id);
        }
    }

    private void drawTask(BufferedImage icon, String name, GraphicInfo graphicInfo, double scaleFactor, String id) {
        this.drawTask(name, graphicInfo, id);
        this.g.drawImage(icon, (int)(graphicInfo.getX() + graphicInfo.getWidth() / 2.0 - (double)icon.getWidth() / 5.0), (int)(graphicInfo.getY() + graphicInfo.getHeight() / 2.0 - (double)icon.getHeight() / 1.3), (int)((double)icon.getWidth() / scaleFactor), (int)((double)icon.getHeight() / scaleFactor), null);
    }

    private void drawTask(String name, GraphicInfo graphicInfo, String id) {
        this.drawTask(name, graphicInfo, false, id);
    }

    private void drawTask(String name, GraphicInfo graphicInfo, boolean thickBorder, String id) {
        Paint originalPaint = this.g.getPaint();
        int x = (int)graphicInfo.getX();
        int y = (int)graphicInfo.getY();
        int width = (int)graphicInfo.getWidth();
        int height = (int)graphicInfo.getHeight();
        if (highLightedActivitiesStatic != null && highLightedActivitiesStatic.contains(id) && runningNodeStatic != null && !runningNodeStatic.contains(id)) {
            this.g.setPaint(TASK_BOX_COLOR1);
        } else if (runningNodeStatic != null && runningNodeStatic.contains(id)) {
            this.g.setPaint(TASK_BOX_COLOR2);
        } else {
            this.g.setPaint(TASK_BOX_COLOR3);
        }
        int arcR = 15;
        if (thickBorder) {
            arcR = 15;
        }
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(x, y, width, height, arcR, arcR);
        this.g.fill(rect);
        if (highLightedActivitiesStatic != null && highLightedActivitiesStatic.contains(id) && runningNodeStatic != null && !runningNodeStatic.contains(id)) {
            this.g.setPaint(TASK_BORDER_COLOR1);
        } else if (runningNodeStatic != null && runningNodeStatic.contains(id)) {
            this.g.setPaint(TASK_BORDER_COLOR2);
        } else {
            this.g.setPaint(TASK_BORDER_COLOR3);
        }
        Stroke originalStroke = this.g.getStroke();
        this.g.setStroke(BORDER_STROKE);
        this.g.draw(rect);
        this.g.setStroke(originalStroke);
        this.g.setPaint(originalPaint);
        if (name != null && name.length() > 0) {
            int boxWidth = width - 6;
            int boxHeight = height - 16 - ICON_PADDING - ICON_PADDING - 12 - 2 - 2;
            int boxX = x + width / 2 - boxWidth / 2;
            int boxY = y + height / 2 - boxHeight / 2 + ICON_PADDING + ICON_PADDING - 2 - 2 + 16;
            this.drawMultilineCentredText(name, boxX, boxY, boxWidth, boxHeight);
        }
    }

    public void drawSequenceflow(int srcX, int srcY, int targetX, int targetY, boolean conditional, boolean highLighted, double scaleFactor) {
        Paint originalPaint = this.g.getPaint();
        if (highLighted) {
            this.g.setPaint(HIGHLIGHT_COLOR);
        } else {
            this.g.setPaint(LIGHT_COLOR);
        }
        Line2D.Double line = new Line2D.Double(srcX, srcY, targetX, targetY);
        this.g.draw(line);
        this.drawArrowHead(line, scaleFactor);
        if (conditional) {
            this.drawConditionalSequenceFlowIndicator(line, scaleFactor);
        }
        if (highLighted) {
            this.g.setPaint(originalPaint);
        }
    }

    public void drawConnection(int[] xPoints, int[] yPoints, boolean conditional, boolean isDefault, String connectionType, AssociationDirection associationDirection, boolean highLighted, double scaleFactor) {
        Paint originalPaint = this.g.getPaint();
        Stroke originalStroke = this.g.getStroke();
        this.g.setPaint(LABAL_FONT_COLOR);
        if ("association".equals(connectionType)) {
            if (highLightedActivitiesStatic != null && highLightedActivitiesStatic.size() > 0) {
                this.g.setStroke(HIGHLIGHT_FLOW_STROKE);
            } else {
                this.g.setStroke(ASSOCIATION_STROKE);
            }
        } else if (highLighted) {
            this.g.setPaint(HIGHLIGHT_COLOR);
            this.g.setStroke(HIGHLIGHT_FLOW_STROKE);
        } else {
            this.g.setPaint(LIGHT_COLOR);
        }
        for (int i = 1; i < xPoints.length; ++i) {
            Integer sourceX = xPoints[i - 1];
            Integer sourceY = yPoints[i - 1];
            Integer targetX = xPoints[i];
            Integer targetY = yPoints[i];
            Line2D.Double line = new Line2D.Double(sourceX.intValue(), sourceY.intValue(), targetX.intValue(), targetY.intValue());
            this.g.draw(line);
        }
        if (isDefault) {
            Line2D.Double line = new Line2D.Double(xPoints[0], yPoints[0], xPoints[1], yPoints[1]);
            this.drawDefaultSequenceFlowIndicator(line, scaleFactor);
        }
        if (conditional) {
            Line2D.Double line = new Line2D.Double(xPoints[0], yPoints[0], xPoints[1], yPoints[1]);
            this.drawConditionalSequenceFlowIndicator(line, scaleFactor);
        }
        if (associationDirection.equals((Object)AssociationDirection.ONE) || associationDirection.equals((Object)AssociationDirection.BOTH)) {
            Line2D.Double line = new Line2D.Double(xPoints[xPoints.length - 2], yPoints[xPoints.length - 2], xPoints[xPoints.length - 1], yPoints[xPoints.length - 1]);
            this.drawArrowHead(line, scaleFactor);
        }
        if (associationDirection.equals((Object)AssociationDirection.BOTH)) {
            Line2D.Double line = new Line2D.Double(xPoints[1], yPoints[1], xPoints[0], yPoints[0]);
            this.drawArrowHead(line, scaleFactor);
        }
        this.g.setPaint(originalPaint);
        if (highLightedActivitiesStatic != null && highLightedActivitiesStatic.size() > 0) {
            this.g.setStroke(HIGHLIGHT_FLOW_STROKE);
        } else {
            this.g.setStroke(originalStroke);
        }
    }

    public void drawSequenceflowWithoutArrow(int srcX, int srcY, int targetX, int targetY, boolean conditional, boolean highLighted, double scaleFactor) {
        Paint originalPaint = this.g.getPaint();
        if (highLighted) {
            this.g.setPaint(HIGHLIGHT_COLOR);
        } else {
            this.g.setPaint(LIGHT_COLOR);
        }
        Line2D.Double line = new Line2D.Double(srcX, srcY, targetX, targetY);
        this.g.draw(line);
        if (conditional) {
            this.drawConditionalSequenceFlowIndicator(line, scaleFactor);
        }
        if (highLighted) {
            this.g.setPaint(originalPaint);
        }
    }

    public void drawHighLight(int x, int y, int width, int height, String activityType) {
        Paint originalPaint = this.g.getPaint();
        Stroke originalStroke = this.g.getStroke();
        this.g.setPaint(HIGHLIGHT_COLOR);
        BasicStroke stroke = new BasicStroke(1.0f);
        this.g.setStroke(stroke);
        if (gatewayType.contains(activityType)) {
            Polygon graphics = new Polygon();
            graphics.addPoint(x, y + height / 2);
            graphics.addPoint(x + width / 2, y + height);
            graphics.addPoint(x + width, y + height / 2);
            graphics.addPoint(x + width / 2, y);
            this.g.draw(graphics);
        } else if (eventType.contains(activityType)) {
            Ellipse2D.Double graphics = new Ellipse2D.Double(x, y, width, height);
            this.g.draw(graphics);
        } else if (subProcessType.contains(activityType)) {
            RoundRectangle2D.Double graphics = new RoundRectangle2D.Double(x + 1, y + 1, width - 2, height - 2, 20.0, 20.0);
            this.g.draw(graphics);
        }
        this.g.setPaint(originalPaint);
        this.g.setStroke(originalStroke);
    }

    public void drawNoneStartEvent(GraphicInfo graphicInfo) {
        this.drawStartEvent(graphicInfo, null, 1.0);
        this.g.drawImage(START_IMAGE, (int)(graphicInfo.getX() + graphicInfo.getWidth() / 2.0 - (double)START_IMAGE.getWidth() / 2.0 + 3.0), (int)(graphicInfo.getY() + graphicInfo.getHeight() / 2.0 - (double)START_IMAGE.getHeight() / 2.0 + 1.0), (int)((double)START_IMAGE.getWidth() / 1.0), (int)((double)START_IMAGE.getHeight() / 1.0), null);
    }

    public void drawStartEvent(GraphicInfo graphicInfo, BufferedImage image, double scaleFactor) {
        Paint originalPaint = this.g.getPaint();
        this.g.setPaint(START_COLOR);
        Ellipse2D.Double circle = new Ellipse2D.Double(graphicInfo.getX(), graphicInfo.getY(), graphicInfo.getWidth(), graphicInfo.getHeight());
        this.g.fill(circle);
        this.g.setPaint(START_COLOR);
        this.g.draw(circle);
        this.g.setPaint(originalPaint);
        if (image != null) {
            int imageX = (int)Math.round(graphicInfo.getX() + graphicInfo.getWidth() / 2.0 - (double)(image.getWidth() / 2) * scaleFactor);
            int imageY = (int)Math.round(graphicInfo.getY() + graphicInfo.getHeight() / 2.0 - (double)(image.getHeight() / 2) * scaleFactor);
            this.g.drawImage(image, imageX, imageY, (int)((double)image.getWidth() / scaleFactor), (int)((double)image.getHeight() / scaleFactor), null);
        }
    }

    public void drawNoneEndEvent(GraphicInfo graphicInfo, double scaleFactor) {
        Paint originalPaint = this.g.getPaint();
        Stroke originalStroke = this.g.getStroke();
        this.g.setPaint(END_COLOR);
        Ellipse2D.Double circle = new Ellipse2D.Double(graphicInfo.getX(), graphicInfo.getY(), graphicInfo.getWidth(), graphicInfo.getHeight());
        this.g.fill(circle);
        this.g.setPaint(END_COLOR);
        if (scaleFactor == 1.0) {
            this.g.setStroke(END_EVENT_STROKE);
        } else {
            this.g.setStroke(new BasicStroke(2.0f));
        }
        this.g.draw(circle);
        this.g.setStroke(originalStroke);
        this.g.setPaint(originalPaint);
        this.g.drawImage(END_IMAGE, (int)(graphicInfo.getX() + graphicInfo.getWidth() / 2.0 - (double)END_IMAGE.getWidth() / 2.0 + 1.0), (int)(graphicInfo.getY() + graphicInfo.getHeight() / 2.0 - (double)END_IMAGE.getHeight() / 2.0 + 1.0), (int)((double)END_IMAGE.getWidth() / 1.0), (int)((double)END_IMAGE.getHeight() / 1.0), null);
        Paint originalPaint1 = this.g.getPaint();
        Stroke originalStroke1 = this.g.getStroke();
        this.g.setPaint(LIGHT_COLOR);
        BasicStroke stroke = new BasicStroke(1.0f);
        this.g.setStroke(stroke);
        Ellipse2D.Double graphics = new Ellipse2D.Double(graphicInfo.getX(), graphicInfo.getY(), graphicInfo.getWidth(), graphicInfo.getHeight());
        this.g.draw(graphics);
        this.g.setPaint(originalPaint1);
        this.g.setStroke(originalStroke1);
    }

    public void drawActivityMarkers(int x, int y, int width, int height, boolean multiInstanceSequential, boolean multiInstanceParallel, boolean collapsed) {
        if (collapsed) {
            if (!multiInstanceSequential && !multiInstanceParallel) {
                this.drawCollapsedMarker(x, y, width, height);
            } else {
                this.drawCollapsedMarker(x - 6 - 2 + 36, y, width, height);
                if (multiInstanceSequential) {
                    this.drawMultiInstanceMarker(true, x + 6 + 2 + 36, y, width, height);
                } else {
                    this.drawMultiInstanceMarker(false, x + 6 + 2 + 36, y, width, height);
                }
            }
        } else if (multiInstanceSequential) {
            this.drawMultiInstanceMarker(true, x + 36, y, width, height);
        } else if (multiInstanceParallel) {
            this.drawMultiInstanceMarker(false, x + 36, y, width, height);
        }
    }

    protected void drawMultilineCentredText(String text, int x, int y, int boxWidth, int boxHeight) {
        this.drawMultilineText(text, x, y, boxWidth, boxHeight, true);
    }

    protected void drawMultilineText(String text, int x, int y, int boxWidth, int boxHeight, boolean centered) {
        int currentY;
        int currentHeight;
        int currentX;
        AttributedString attributedString = new AttributedString(text);
        TASK_FONT = new Font(FONT_STYLE, 1, 12);
        attributedString.addAttribute(TextAttribute.FONT, TASK_FONT);
        attributedString.addAttribute(TextAttribute.FOREGROUND, FONT_COLOR);
        AttributedCharacterIterator characterIterator = attributedString.getIterator();
        ArrayList<TextLayout> layouts = new ArrayList<TextLayout>();
        String lastLine = null;
        LineBreakMeasurer measurer = new LineBreakMeasurer(characterIterator, this.g.getFontRenderContext());
        TextLayout layout = null;
        for (currentHeight = 0; measurer.getPosition() < characterIterator.getEndIndex() && currentHeight <= boxHeight; currentHeight += currentX) {
            currentY = measurer.getPosition();
            layout = measurer.nextLayout(boxWidth);
            currentX = (int)(layout.getDescent() + layout.getAscent() + layout.getLeading());
            if (currentHeight + currentX > boxHeight) {
                if (layouts.isEmpty()) break;
                layouts.remove(layouts.size() - 1);
                if (lastLine != null && lastLine.length() >= 4) {
                    lastLine = lastLine.substring(0, lastLine.length() - 4) + "...";
                }
                layouts.add(new TextLayout(lastLine, this.g.getFont(), this.g.getFontRenderContext()));
                break;
            }
            layouts.add(layout);
            lastLine = text.substring(currentY, measurer.getPosition());
        }
        currentY = y + (centered ? (boxHeight - currentHeight) / 2 : 0);
        int currentX2 = 0;
        for (TextLayout textLayout : layouts) {
            currentY = (int)((float)currentY + textLayout.getAscent());
            currentX2 = x + (int)(centered ? ((double)boxWidth - textLayout.getBounds().getWidth()) / 2.0 : 0.0);
            textLayout.draw(this.g, currentX2, currentY);
            currentY = (int)((float)currentY + textLayout.getDescent() + textLayout.getLeading());
        }
    }

    public void drawLabel(String text, GraphicInfo graphicInfo) {
        this.drawLabel(text, graphicInfo, true);
    }

    public void drawLabel(String text, GraphicInfo graphicInfo, boolean centered) {
        float interline = 1.0f;
        if (text != null && text.length() > 0) {
            Paint originalPaint = this.g.getPaint();
            Font originalFont = this.g.getFont();
            this.g.setPaint(LABAL_FONT_COLOR);
            this.g.setFont(LABEL_FONT);
            int wrapWidth = 100;
            int textY = (int)graphicInfo.getY();
            AttributedString as = new AttributedString(text);
            as.addAttribute(TextAttribute.FOREGROUND, this.g.getPaint());
            as.addAttribute(TextAttribute.FONT, this.g.getFont());
            AttributedCharacterIterator aci = as.getIterator();
            FontRenderContext frc = new FontRenderContext((AffineTransform)null, true, false);
            LineBreakMeasurer lbm = new LineBreakMeasurer(aci, frc);
            while (lbm.getPosition() < text.length()) {
                TextLayout tl = lbm.nextLayout(wrapWidth);
                textY = (int)((float)textY + tl.getAscent());
                Rectangle2D bb = tl.getBounds();
                double tX = graphicInfo.getX();
                if (centered) {
                    tX += (double)((int)(graphicInfo.getWidth() / 2.0 - bb.getWidth() / 2.0));
                }
                tl.draw(this.g, (float)tX, textY);
                textY = (int)((float)textY + tl.getDescent() + tl.getLeading() + (interline - 1.0f) * tl.getAscent());
            }
            this.g.setFont(originalFont);
            this.g.setPaint(originalPaint);
        }
    }

    public void drawGateway(GraphicInfo graphicInfo, String id) {
        Polygon rhombus = new Polygon();
        int x = (int)graphicInfo.getX();
        int y = (int)graphicInfo.getY();
        int width = (int)graphicInfo.getWidth();
        int height = (int)graphicInfo.getHeight();
        rhombus.addPoint(x, y + height / 2);
        rhombus.addPoint(x + width / 2, y + height);
        rhombus.addPoint(x + width, y + height / 2);
        rhombus.addPoint(x + width / 2, y);
        if (highLightedActivitiesStatic != null && highLightedActivitiesStatic.contains(id)) {
            this.g.setPaint(GATEWAY_COLOR1);
        } else {
            this.g.setPaint(GATEWAY_COLOR2);
        }
        this.g.draw(rhombus);
    }

    public void drawParallelGateway(GraphicInfo graphicInfo, double scaleFactor, String id) {
        this.drawGateway(graphicInfo, id);
        int x = (int)graphicInfo.getX();
        int y = (int)graphicInfo.getY();
        int width = (int)graphicInfo.getWidth();
        int height = (int)graphicInfo.getHeight();
        if (scaleFactor == 1.0) {
            Stroke orginalStroke = this.g.getStroke();
            if (highLightedActivitiesStatic != null && highLightedActivitiesStatic.contains(id)) {
                this.g.setPaint(GATEWAY_COLOR1);
            } else {
                this.g.setPaint(GATEWAY_COLOR2);
            }
            this.g.setStroke(GATEWAY_TYPE_STROKE);
            Line2D.Double line = new Line2D.Double(x + 10, y + height / 2, x + width - 10, y + height / 2);
            this.g.draw(line);
            line = new Line2D.Double(x + width / 2, y + height - 10, x + width / 2, y + 10);
            if (highLightedActivitiesStatic != null && highLightedActivitiesStatic.contains(id)) {
                this.g.setPaint(GATEWAY_COLOR1);
            } else {
                this.g.setPaint(GATEWAY_COLOR2);
            }
            this.g.draw(line);
            this.g.setStroke(orginalStroke);
        }
    }

    public void drawExclusiveGateway(GraphicInfo graphicInfo, double scaleFactor, String id) {
        this.drawGateway(graphicInfo, id);
        int x = (int)graphicInfo.getX();
        int y = (int)graphicInfo.getY();
        int width = (int)graphicInfo.getWidth();
        int height = (int)graphicInfo.getHeight();
        int quarterWidth = width / 4;
        int quarterHeight = height / 4;
        if (scaleFactor == 1.0) {
            Stroke orginalStroke = this.g.getStroke();
            this.g.setStroke(GATEWAY_TYPE_STROKE);
            if (highLightedActivitiesStatic != null && highLightedActivitiesStatic.contains(id)) {
                this.g.setPaint(GATEWAY_COLOR1);
            } else {
                this.g.setPaint(GATEWAY_COLOR2);
            }
            Line2D.Double line = new Line2D.Double(x + quarterWidth + 3, y + quarterHeight + 3, x + 3 * quarterWidth - 3, y + 3 * quarterHeight - 3);
            this.g.draw(line);
            line = new Line2D.Double(x + quarterWidth + 3, y + 3 * quarterHeight - 3, x + 3 * quarterWidth - 3, y + quarterHeight + 3);
            if (highLightedActivitiesStatic != null && highLightedActivitiesStatic.contains(id)) {
                this.g.setPaint(GATEWAY_COLOR1);
            } else {
                this.g.setPaint(GATEWAY_COLOR2);
            }
            this.g.draw(line);
            this.g.setStroke(orginalStroke);
        }
    }

    public void drawInclusiveGateway(GraphicInfo graphicInfo, double scaleFactor, String id) {
        this.drawGateway(graphicInfo, id);
        int x = (int)graphicInfo.getX();
        int y = (int)graphicInfo.getY();
        int width = (int)graphicInfo.getWidth();
        int height = (int)graphicInfo.getHeight();
        int diameter = width / 2;
        if (scaleFactor == 1.0) {
            Stroke orginalStroke = this.g.getStroke();
            this.g.setStroke(GATEWAY_TYPE_STROKE);
            Ellipse2D.Double circle = new Ellipse2D.Double((width - diameter) / 2 + x, (height - diameter) / 2 + y, diameter, diameter);
            if (highLightedActivitiesStatic != null && highLightedActivitiesStatic.contains(id)) {
                this.g.setPaint(GATEWAY_COLOR1);
            } else {
                this.g.setPaint(GATEWAY_COLOR2);
            }
            this.g.draw(circle);
            this.g.setStroke(orginalStroke);
        }
    }

    static {
        FONT_STYLE = "\u5fae\u8f6f\u96c5\u9ed1";
        LABAL_FONT_COLOR = new Color(66, 71, 90);
        HIGHLIGHT_FLOW_STROKE = new BasicStroke(1.0f);
        BORDER_STROKE = new BasicStroke(1.0f);
    }
}

