/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.engine.controller;

import com.jxdinfo.hussar.bpm.engine.model.Result;
import com.jxdinfo.hussar.bpm.engine.service.TaskEngineService;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/task"})
public class TaskEngineController {
    private final TaskEngineService taskEngineService;

    @Autowired
    public TaskEngineController(TaskEngineService taskEngineService) {
        this.taskEngineService = taskEngineService;
    }

    @RequestMapping(value={"/queryToDoTaskList1"})
    public Result queryToDoTaskList(String userId) {
        return this.taskEngineService.queryToDoTaskList(userId);
    }

    @RequestMapping(value={"/queryToDoTaskList2"})
    public Result queryToDoTaskListByProcess(String userId, String processDefinitionKey) {
        return this.taskEngineService.queryToDoTaskListByProcess(userId, processDefinitionKey);
    }

    @RequestMapping(value={"/queryToDoTaskList3"})
    public Result queryToDoTaskList(String userId, Integer page, Integer rows) {
        return this.taskEngineService.queryToDoTaskList(userId, page, rows);
    }

    @RequestMapping(value={"/queryToDoTaskList4"})
    public Result queryToDoByDefinitionKey(String processDefinitionKey) {
        return this.taskEngineService.queryToDoTaskList(processDefinitionKey);
    }

    @RequestMapping(value={"/queryToDoTaskList5"})
    public Result queryToDoTaskListByPageAndProcess(String userId, String processDefinitionKey, Integer page, Integer rows) {
        return this.taskEngineService.queryToDoTaskListByPageAndProcess(userId, processDefinitionKey, page, rows);
    }

    @RequestMapping(value={"/queryToDoTaskList6"})
    public Result queryToDoTaskListByDefinitionKey(String userId, String processDefinitionKey, String definitionKey, Integer page, Integer rows) {
        return this.taskEngineService.queryToDoTaskListByDefinitionKey(userId, processDefinitionKey, definitionKey, page, rows);
    }

    @RequestMapping(value={"/queryFinishedTaskList1"})
    public Result queryFinishedTaskList(String userId) {
        return this.taskEngineService.queryFinishedTaskList(userId);
    }

    @RequestMapping(value={"/queryFinishedTaskList2"})
    public Result queryFinishedTaskListByProcess(String userId, String processDefinitionKey) {
        return this.taskEngineService.queryFinishedTaskListByProcess(userId, processDefinitionKey);
    }

    @RequestMapping(value={"/queryFinishedTaskList3"})
    public Result queryFinishedTaskList(String userId, Integer page, Integer rows) {
        return this.taskEngineService.queryFinishedTaskList(userId, page, rows);
    }

    @RequestMapping(value={"/queryFinishedTaskList4"})
    public Result queryFinishedTaskListByPageAndProcess(String userId, String processDefinitionKey, Integer page, Integer rows) {
        return this.taskEngineService.queryFinishedTaskListByPageAndProcess(userId, processDefinitionKey, page, rows);
    }

    @RequestMapping(value={"/queryFinishedTaskList5"})
    public Result queryFinishedTaskListByDefinitionKey(String userId, String processDefinitionKey, String definitionKey, Integer page, Integer rows) {
        return this.taskEngineService.queryFinishedTaskListByDefinitionKey(userId, processDefinitionKey, definitionKey, page, rows);
    }

    @RequestMapping(value={"/queryUserTaskCount"})
    public Result queryUserTaskCount(String userId) {
        return this.taskEngineService.queryUserTaskCount(userId);
    }

    @RequestMapping(value={"/queryUserTaskCountByNode"})
    public Result queryUserTaskCountByNode(String userId) {
        return this.taskEngineService.queryUserTaskCountByNode(userId);
    }

    @RequestMapping(value={"/claimTask"})
    public Result claimTask(String taskId, String userId) {
        return this.taskEngineService.claimTask(taskId, userId);
    }

    @RequestMapping(value={"/completeTask1"})
    public Result completeTask(String taskId) {
        return this.taskEngineService.completeTask(taskId);
    }

    @RequestMapping(value={"/completeTask2"})
    public Result completeTask(String taskId, String userId) {
        return this.taskEngineService.completeTask(taskId, userId);
    }

    @RequestMapping(value={"/completeTask3"})
    public Result completeTask(String taskId, Map<String, Object> map) {
        return this.taskEngineService.completeTask(taskId, map);
    }

    @RequestMapping(value={"/completeTask4"})
    public Result completeTask(String taskId, String userId, Map<String, Object> map) {
        return this.taskEngineService.completeTask(taskId, userId, map);
    }

    @RequestMapping(value={"/completeTask5"})
    public Result completeTask(String taskId, String userId, Map<String, String> assigneeMap, Map<String, Object> map) {
        return this.taskEngineService.completeTask(taskId, userId, assigneeMap, map);
    }

    @RequestMapping(value={"/completeTask6"})
    public Result completeTask(String taskId, String userId, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        return this.taskEngineService.completeTask(taskId, userId, assigneeMap, comment, map);
    }

    @RequestMapping(value={"/completeTask7"})
    public Result completeTask(String taskId, String userId, String comment, Map<String, Object> map) {
        return this.taskEngineService.completeTask(taskId, userId, comment, map);
    }

    @RequestMapping(value={"/unClaimTask"})
    public Result unClaimTask(String taskId) {
        return this.taskEngineService.unClaimTask(taskId);
    }

    @RequestMapping(value={"/rejectToPreTask1"})
    public Result rejectToPreTask(String taskId, String comment, Map<String, Object> map) {
        return this.taskEngineService.rejectToPreTask(taskId, comment, map);
    }

    @RequestMapping(value={"/rejectToPreTask2"})
    public Result rejectToPreTask(String taskId, String userId, String comment, Map<String, Object> map) {
        return this.taskEngineService.rejectToPreTask(taskId, userId, comment, map);
    }

    @RequestMapping(value={"/rejectToPreTask3"})
    public Result rejectToPreTask(String taskId, String userId, String assignees, String comment, Map<String, Object> map) {
        return this.taskEngineService.rejectToPreTask(taskId, userId, assignees, comment, map);
    }

    @RequestMapping(value={"/rejectToLastTask"})
    public Result rejectToLastTask(String taskId, String userId, String comment, Map<String, Object> map) {
        return this.taskEngineService.rejectToLastTask(taskId, userId, comment, map);
    }

    @RequestMapping(value={"/rejectToFristTask1"})
    public Result rejectToFristTask(String taskId, String comment, Map<String, Object> map) {
        return this.taskEngineService.rejectToFristTask(taskId, comment, map);
    }

    @RequestMapping(value={"/rejectToFristTask2"})
    public Result rejectToFristTask(String taskId, String userId, String comment, Map<String, Object> map) {
        return this.taskEngineService.rejectToFristTask(taskId, userId, comment, map);
    }

    @RequestMapping(value={"/rejectToFristTask3"})
    public Result rejectToFristTask(String taskId, String userId, String comment, boolean isSubmit, Map<String, Object> map) {
        return this.taskEngineService.rejectToFristTask(taskId, userId, comment, isSubmit, map);
    }

    @RequestMapping(value={"/rejectToAnyTask1"})
    public Result rejectToAnyTask(String taskId, String userId, String backActivityId, String comment, Map<String, Object> map) {
        return this.taskEngineService.rejectToAnyTask(taskId, userId, backActivityId, comment, map);
    }

    @RequestMapping(value={"/rejectToAnyTask2"})
    public Result rejectToAnyTask(String taskId, String userId, String backActivityId, String comment, boolean isSubmit, Map<String, Object> map) {
        return this.taskEngineService.rejectToAnyTask(taskId, userId, backActivityId, comment, isSubmit, map);
    }

    @RequestMapping(value={"/delegateTask"})
    public Result delegateTask(String taskId, String userId) {
        return this.taskEngineService.delegateTask(taskId, userId);
    }

    @RequestMapping(value={"/freeJump"})
    public Result freeJump(String taskId, String activitiId) {
        return this.taskEngineService.freeJump(taskId, activitiId);
    }

    @RequestMapping(value={"/getCurrNodeInfoByTaskId"})
    public Result getCurrNodeInfoByTaskId(String taskId) {
        return this.taskEngineService.getCurrNodeInfoByTaskId(taskId);
    }

    @RequestMapping(value={"/lastUserTask"})
    public Result lastUserTask(String taskId) {
        return this.taskEngineService.lastUserTask(taskId);
    }

    @RequestMapping(value={"/queryAssigneeByTaskId"})
    public Result queryAssigneeByTaskId(String taskId) {
        return this.taskEngineService.queryAssigneeByTaskId(taskId);
    }

    @RequestMapping(value={"/queryNextAssigneeByTaskId"})
    public Result queryNextAssigneeByTaskId(String taskId, Map<String, String> formData) {
        return this.taskEngineService.queryNextAssigneeByTaskId(taskId, formData);
    }

    @RequestMapping(value={"/queryHistoryActByTaskId"})
    public Result queryHistoryActByTaskId(String taskId) {
        return this.taskEngineService.queryHistoryActByTaskId(taskId);
    }

    @RequestMapping(value={"/queryTaskIdByBusinessKey"})
    public Result queryTaskIdByBusinessKey(String businessId) {
        return this.taskEngineService.queryTaskIdByBusinessKey(businessId);
    }

    @RequestMapping(value={"/withdrawState"})
    public Result withdrawState(String historicTaskId) {
        return this.taskEngineService.withdrawState(historicTaskId);
    }

    @RequestMapping(value={"/revokeTask1"})
    public Result revokeTask(String bussinessId, String userId, String comment, Map<String, Object> map) {
        return this.taskEngineService.revokeTask(bussinessId, userId, comment, map);
    }

    @RequestMapping(value={"/revokeTask2"})
    public Result revokeTask(String bussinessId, String userId, String comment, boolean isSubmit, Map<String, Object> map) {
        return this.taskEngineService.revokeTask(bussinessId, userId, comment, isSubmit, map);
    }
}

