/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.engine.controller;

import com.jxdinfo.hussar.bpm.engine.model.Result;
import com.jxdinfo.hussar.bpm.engine.service.InstanceEngineService;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/instance"})
public class InstanceEngineController {
    private final InstanceEngineService instanceEngineService;

    @Autowired
    public InstanceEngineController(InstanceEngineService instanceEngineService) {
        this.instanceEngineService = instanceEngineService;
    }

    @RequestMapping(value={"/startProcessInstanceById1"})
    public Result startProcessInstanceById(String processDefinitionId, String userId, String businessKey, Map<String, Object> variablesMap) {
        return this.instanceEngineService.startProcessInstanceById(processDefinitionId, userId, businessKey, variablesMap);
    }

    @RequestMapping(value={"/startProcessInstanceByKey1"})
    public Result startProcessInstanceByKey(String processDefinitionKey, String userId, String businessKey, Map<String, Object> variablesMap) {
        return this.instanceEngineService.startProcessInstanceByKey(processDefinitionKey, userId, businessKey, variablesMap);
    }

    @RequestMapping(value={"/startProcessInstanceById2"})
    public Result startProcessInstanceById(String processDefinitionId, String userId, String businessKey) {
        return this.instanceEngineService.startProcessInstanceById(processDefinitionId, userId, businessKey);
    }

    @RequestMapping(value={"/startProcessInstanceByKey2"})
    public Result startProcessInstanceByKey(String processDefinitionKey, String userId, String businessKey) {
        return this.instanceEngineService.startProcessInstanceByKey(processDefinitionKey, userId, businessKey);
    }

    @RequestMapping(value={"/queryProcessInstanceList"})
    public Result queryProcessInstanceList(int page, int rows) {
        return this.instanceEngineService.queryProcessInstanceList(page, rows);
    }

    @RequestMapping(value={"/queryProcessInstanceByKey"})
    public Result queryProcessInstanceByKey(String processDefinitionKey, String businessKey, int page, int rows) {
        return this.instanceEngineService.queryProcessInstanceByKey(processDefinitionKey, businessKey, page, rows);
    }

    @RequestMapping(value={"/updateProcessInstanceState"})
    public Result updateProcessInstanceState(String operation, String processInstanceId) {
        return this.instanceEngineService.updateProcessInstanceState(operation, processInstanceId);
    }

    @RequestMapping(value={"/deleteProcessInstance"})
    public Result deleteProcessInstance(String processInstanceId, String reason) {
        return this.instanceEngineService.deleteProcessInstance(processInstanceId, reason);
    }

    @RequestMapping(value={"/deleteFinishedProcessInstance"})
    public Result deleteFinishedProcessInstance(String processInstanceId) {
        return this.instanceEngineService.deleteFinishedProcessInstance(processInstanceId);
    }

    @RequestMapping(value={"/endProcessInstance"})
    public Result endProcessInstance(String taskId) {
        return this.instanceEngineService.endProcessInstance(taskId);
    }

    @RequestMapping(value={"/queryFinishedProcessInstance"})
    public Result queryFinishedProcessInstance(String processDefinitionId, String businessKey, int page, int rows) {
        return this.instanceEngineService.queryFinishedProcessInstance(processDefinitionId, businessKey, page, rows);
    }

    @RequestMapping(value={"/queryProcessInstanceCompleteState"})
    public Result queryProcessInstanceCompleteState(String processInstanceId) {
        return this.instanceEngineService.queryProcessInstanceCompleteState(processInstanceId);
    }

    @RequestMapping(value={"/queryProcessInstancePicture"})
    public void queryProcessInstancePicture(String processInstanceId, HttpServletResponse response) {
        this.instanceEngineService.queryProcessInstancePicture(processInstanceId, response);
    }

    @RequestMapping(value={"/getProcessTrace"})
    public Result getProcessTrace(String processInstanceId) {
        return this.instanceEngineService.getProcessTrace(processInstanceId);
    }

    @RequestMapping(value={"/getAllProcessTrace"})
    public Result getAllProcessTrace(String processInstanceId) {
        return this.instanceEngineService.getAllProcessTrace(processInstanceId);
    }

    @RequestMapping(value={"/queryProcessDefinitionByInstanceId"})
    public Result queryProcessDefinitionByInstanceId(String processInstanceId) {
        return this.instanceEngineService.queryProcessDefinitionByInstanceId(processInstanceId);
    }

    @RequestMapping(value={"/queryVariable"})
    public Result queryVariable(String processInstId) {
        return this.instanceEngineService.queryVariable(processInstId);
    }

    @RequestMapping(value={"/editVariable"})
    public Result editVariable(String taskId, HashMap map) {
        return this.instanceEngineService.editVariable(taskId, map);
    }
}

