/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.assignee.service.impl;

import com.jxdinfo.hussar.bpm.assignee.dao.AssigneeChooseMapper;
import com.jxdinfo.hussar.bpm.assignee.model.TreeModel;
import com.jxdinfo.hussar.bpm.assignee.model.TreeStrModel;
import com.jxdinfo.hussar.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AssigneeChooseServiceImpl
implements IAssigneeChooseService {
    @Resource
    private AssigneeChooseMapper assigneeChooseMapper;

    @Override
    public List<TreeModel> queryUser(String userName) {
        return this.assigneeChooseMapper.getUserListByName(userName);
    }

    @Override
    public List<TreeStrModel> queryLazyUser(String nodeId) {
        return this.assigneeChooseMapper.queryLazyUser(nodeId);
    }

    @Override
    public List<TreeStrModel> queryUserList(List<String> list) {
        return this.assigneeChooseMapper.queryUserList(list);
    }

    @Override
    public List<TreeStrModel> queryRoleList(List<String> list) {
        return this.assigneeChooseMapper.queryRoleList(list);
    }

    @Override
    public List<TreeModel> queryUserByRole(String userName) {
        return this.assigneeChooseMapper.getRoleTree(userName);
    }

    @Override
    public List<TreeStrModel> queryLazyRoleTree(String nodeId) {
        List<Object> jsTreeModels = new ArrayList();
        jsTreeModels = null == nodeId ? this.assigneeChooseMapper.getFirstRoleTree() : this.assigneeChooseMapper.getLazyRoleTree(nodeId);
        return jsTreeModels;
    }

    @Override
    public List<TreeStrModel> queryUserByDept(String userName) {
        return this.assigneeChooseMapper.getRestUserTree();
    }

    @Override
    public List<TreeStrModel> getLazyDeptTree(String nodeId) {
        return this.assigneeChooseMapper.getLazyDeptTree(nodeId);
    }

    @Override
    public List<TreeStrModel> queryDeptTree(List<String> list) {
        return this.assigneeChooseMapper.queryDeptTree(list);
    }

    @Override
    public List<String> getUserList(List deptList, List roleList) {
        return this.assigneeChooseMapper.getUserList(deptList, roleList);
    }

    @Override
    public List<String> getFlowStarterDept(String userId) {
        return this.assigneeChooseMapper.getFlowStarterDept(userId);
    }

    @Override
    public String getUsers(List list) {
        StringBuilder result = new StringBuilder();
        List<Map> userList = this.assigneeChooseMapper.getUsers(list);
        if (userList != null && userList.size() > 0) {
            for (Map map : userList) {
                result.append(map.get("USER_NAME")).append(",");
            }
            result = new StringBuilder(result.substring(0, result.length() - 1));
        }
        return result.toString();
    }

    @Override
    public Map<String, String> getUserListByUserId(List<String> userList) {
        List<Map> users = this.assigneeChooseMapper.getUserListByUserId(userList);
        HashMap<String, String> result = new HashMap<String, String>();
        if (users != null && users.size() > 0) {
            for (Map map : users) {
                result.put(map.get("USER_ID").toString(), map.get("USER_NAME").toString());
            }
        }
        return result;
    }

    @Override
    public List<String> getUserList(List<String> deptsList, List<String> rolesList, List<String> humanList, boolean currentdept) {
        List<Object> list = new ArrayList();
        if (ToolUtil.isNotEmpty(deptsList) || ToolUtil.isNotEmpty(rolesList)) {
            list = this.assigneeChooseMapper.getUserList(deptsList, rolesList);
        }
        List<String> userlist = currentdept && ToolUtil.isNotEmpty(humanList) ? this.assigneeChooseMapper.getUserListByDeptAndUserId(deptsList, humanList) : humanList;
        list.addAll(userlist);
        return list;
    }
}

