/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.assignee.controller;

import com.jxdinfo.hussar.bpm.assignee.model.TreeStrModel;
import com.jxdinfo.hussar.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/assigneeChoose"})
public class AssigneeChooseController {
    @Resource
    private IAssigneeChooseService sysInterfaceService;

    @RequestMapping(value={"/userJson"})
    @ResponseBody
    public Object getUser(@RequestParam(required=false) String userName) {
        return this.sysInterfaceService.queryUser(userName);
    }

    @RequestMapping(value={"/lazyUserJson"})
    @ResponseBody
    public List<TreeStrModel> getLazyUser(@RequestParam(required=false) String id) {
        if (null == id) {
            id = "11";
        }
        return this.sysInterfaceService.queryLazyUser(id);
    }

    @RequestMapping(value={"/userList"})
    @ResponseBody
    public List<TreeStrModel> getUserList(@RequestBody MultiValueMap<String, String> values) {
        List<TreeStrModel> arrList = new ArrayList<TreeStrModel>();
        String ids = (String)values.getFirst((Object)"ids");
        if (ToolUtil.isNotEmpty((Object)ids)) {
            List<String> list = Arrays.asList(ids.split(","));
            arrList = this.sysInterfaceService.queryUserList(list);
        }
        return arrList;
    }

    @RequestMapping(value={"/roleJson"})
    @ResponseBody
    public Object getRole() {
        return this.sysInterfaceService.queryUserByRole(null);
    }

    @RequestMapping(value={"/lazyRoleJson"})
    @ResponseBody
    public List<TreeStrModel> getLazyRole(@RequestParam(required=false) String id) {
        return this.sysInterfaceService.queryLazyRoleTree(id);
    }

    @RequestMapping(value={"/roleList"})
    @ResponseBody
    public List<TreeStrModel> getRoleList(@RequestBody MultiValueMap<String, String> values) {
        List<TreeStrModel> arrList = new ArrayList<TreeStrModel>();
        String ids = (String)values.getFirst((Object)"ids");
        if (ToolUtil.isNotEmpty((Object)ids)) {
            List<String> list = Arrays.asList(ids.split(","));
            arrList = this.sysInterfaceService.queryRoleList(list);
        }
        return arrList;
    }

    @RequestMapping(value={"/deptJson"})
    @ResponseBody
    public Object getDept() {
        return this.sysInterfaceService.queryUserByDept(null);
    }

    @RequestMapping(value={"/lazyDeptJson"})
    @ResponseBody
    public List<TreeStrModel> getLazyDept(@RequestParam(required=false) String id) {
        if (null == id) {
            id = "11";
        }
        return this.sysInterfaceService.getLazyDeptTree(id);
    }

    @RequestMapping(value={"/deptList"})
    @ResponseBody
    public List<TreeStrModel> getDeptList(@RequestBody MultiValueMap<String, String> values) {
        List<TreeStrModel> arrList = new ArrayList<TreeStrModel>();
        String ids = (String)values.getFirst((Object)"ids");
        if (ToolUtil.isNotEmpty((Object)ids)) {
            List<String> list = Arrays.asList(ids.split(","));
            arrList = this.sysInterfaceService.queryDeptTree(list);
        }
        return arrList;
    }
}

