var ProcessDefinition = {};
layui.use(['jquery', 'layer', 'Hussar', 'jstree', 'HussarAjax', 'table'], function () {
    var Hussar = layui.Hussar;
    var $ = layui.jquery;
    var layer = layui.layer;
    var $ax = layui.HussarAjax;
    var table = layui.table;
    table.render({
        elem: '#processDefinitionTable',
        url: Hussar.ctxPath + "/ProcessDefinitionsController/queryProcessDefinitionsList",
        cols: [[
            {type: 'checkbox'},
            {type: 'numbers', width: 46, title: '序号'},
            {
                field: 'key', title: '流程定义KEY', align: 'center', templet: function (params) {
                    if (params.key == null || params.key == "") {
                        return "";
                    } else {
                        return '<div title ="' + params.key + '">' + params.key + '</div>';
                    }
                }
            },
            {field: 'processName', title: '流程定义名称', align: 'center'},
            {field: 'version', width: 58, title: '版本', align: 'center'},
            {
                field: 'resourceName',
                title: 'xml文件',
                align: 'center',
                event: 'downloadXml',
                style: 'cursor: pointer;color:#00a4ff'
            },
            {field: 'deploymentTime', title: '部署时间', align: 'center'},
            {field: 'isSuspended', width: 60, title: '状态', align: 'center', templet: Format},
            {
                field: 'diagramResourceName',
                title: '流程图片',
                align: 'center',
                event: 'openPic',
                style: 'cursor: pointer;color:#00a4ff'
            }
        ]],
        where: {
            definitionName: encodeURI(encodeURI($('#processDefinitionName').val())),
        }
        , page: true
        , height: $("body").height() - $(".toolbar").outerHeight(true) - 70
        , loading: true
        , text: {
            none: '暂无相关数据' //默认：无数据。注：该属性为 layui 2.2.5 开始新增
        }
        , even: true
    });

    /**
     * @return {string}
     */
    function Format(params) {
        if (params.isSuspended == "false") {
            return "激活";
        } else if (params.isSuspended == "true") {
            return "挂起";
        }
    }

    table.on('tool(clickEvent)', function (obj) {
        var data = obj.data;
        if (obj.event === 'openPic') {
            layui.use('layer', function () {
                var layer = layui.layer;
                layer.open({
                    type: 1,
                    title: data.processName,
                    maxmin: true,
                    content: $('#picWindow'), //这里content是一个DOM，注意：最好该元素要存放在body最外层，否则可能被其它的相对元素所影响
                    area: ["100%", "100%"],
                    success: function () {
                    },
                    end: function () {
                        $('#picWindow').hide();
                    }
                });
            });
            //var flowImageAndRect = $('#flowImageAndRect');
            //flowImageAndRect.empty();
            // 加载流程图片
            loadProcessImage(data.key);
        } else if (obj.event === 'downloadXml') {
            var depId = encodeURI(encodeURI(data.deploymentId));
            var resourceName = encodeURI(encodeURI(data.resourceName));
            window.location.href = Hussar.ctxPath + "/ProcessDefinitionsController/getXML?deploymentId=" + depId + "&resourceName=" + resourceName + "";
        }
    });
    /*查询*/
    $("#search").click(function searcha() {
        reloadTable();
    });

    /*删除*/
    $("#deleteBtn").click(function () {
        var ids = [];
        var table = layui.table;
        var checkStatus = table.checkStatus("processDefinitionTable");
        var data = checkStatus.data;
        for (var i = 0; i < data.length; i++) {    //循环筛选出id
            ids.push(data[i].deploymentId);
        }
        if (data.length == 0) {
            Hussar.info("请选择要删除的记录");
        } else {
            var eId = ids.join(',');
            var operation = function () {
                var ajax = new $ax(Hussar.ctxPath + "/ProcessDefinitionsController/deleteData",
                    function (data) {
                        if (data == "success") {
                            reloadTable();
                            Hussar.success("删除成功");
                        } else if (data == "active") {
                            Hussar.info("存在运行中的流程实例，无法删除");
                        } else {
                            Hussar.error("删除失败");
                        }
                    }, function (data) {
                        Hussar.error("删除失败！");
                    });
                ajax.set("deploymentId", eId);
                ajax.start();
            };
            Hussar.confirm("确定要删除吗 ?", operation);
        }
    });

    /*挂起*/
    $('#suspendBtn').click(function () {
        var table = layui.table;
        var checkStatus = table.checkStatus("processDefinitionTable");
        var data = checkStatus.data;
        if (data.length == 0) {
            Hussar.info("请选择一条挂起的记录！");
            return;
        } else if (data.length > 1) {
            Hussar.info("请选择一条挂起的记录！");
            return;
        }
        if (data[0].isSuspended == "true") {
            Hussar.info("此流程已挂起！");
            return;
        }
        var id = encodeURI(encodeURI(data[0].id));
        $.ajax({
            type: "post",
            url: Hussar.ctxPath + "/ProcessDefinitionsController/suspendProcess?id=" + id + "",
            success: function (data) {
                if (data == "success") {
                    reloadTable();
                    Hussar.success("挂起成功");
                } else {
                    Hussar.error("挂起失败");
                }
            },
            error: function () {
                Hussar.error("挂起失败");
            }
        });
    });

    /*激活*/
    $('#activeBtn').click(function () {
        var table = layui.table;
        var checkStatus = table.checkStatus("processDefinitionTable");
        var data = checkStatus.data;
        if (data.length == 0) {
            Hussar.info("请选择一条激活的记录！");
            return;
        } else if (data.length > 1) {
            Hussar.info("请选择一条激活的记录！");
            return;
        }
        if (data[0].isSuspended == "false") {
            Hussar.info("此流程已激活！");
            return;
        }
        var id = encodeURI(encodeURI(data[0].id));
        $.ajax({
            type: "post",
            url: Hussar.ctxPath + "/ProcessDefinitionsController/activatedProcess?id=" + id + "",
            success: function (data) {
                if (data == "success") {
                    reloadTable();
                    Hussar.success("激活成功");
                } else {
                    Hussar.error("激活失败");
                }
            },
            error: function () {
                Hussar.error("激活失败");
            }
        });
    });

    /*重置*/
    $("#reset").click(function () {
        //流程定义名称
        $('#processDefinitionName').val('');
        //重新加载表格
        reloadTable();
    });

    function reloadTable() {
        var table = layui.table;
        table.reload("processDefinitionTable", {
            where: {
                definitionName: encodeURI(encodeURI($('#processDefinitionName').val())),
            }
        });
    }

    function loadProcessImage(key) {
        layui.use(['jquery', 'Hussar', 'HussarAjax'], function () {
            var Hussar = layui.Hussar;
            var $ = layui.jquery;
            var $ax = layui.HussarAjax;
            $(function () {
                //1.获取canvas元素
                var cnv = document.getElementById("canvas");
                cnv.width = $(window).width() - 50;
                cnv.height = $(window).height() - 50;
                //获取上下文环境对象
                var cxt = cnv.getContext("2d");
                var canvasDiv = document.getElementById("canvasDiv");
                createImg(cxt);
                var flag_1 = 0;

                function createImg(cxt) {
                    $.ajax({
                        type: "POST",
                        url: Hussar.ctxPath+"/processDiagram/getProcessInfoByDefKey",
                        dataType: "json",
                        data: {
                            processDefinitonKey: key
                        },
                        success: function (data) {
                            window.tools.createImg(cnv,data,null);
                        }
                    });
                }
            });

            function nodeTaskList(key) {
                table.render({
                    elem: '#nodetask',
                    url: Hussar.ctxPath + "/processCount/nodeTaskList",
                    cols: [[
                        {type: 'numbers', title: '序号'},
                        {field: 'processName', title: '流程定义名称', align: 'center'},
                        {field: 'nodeName', title: '节点名称', align: 'center'},
                        {field: 'taskId', title: '任务ID', align: 'center'},
                        {field: 'businessKey', title: '业务ID', align: 'center'},
                        {field: 'userName', title: '任务接收人', align: 'center'},
                        {
                            field: 'createTime', title: '任务开始时间', align: 'center', templet: function (params) {
                            if (params.createTime == null || params.createTime === "") {
                                return "";
                            } else {
                                return new Date(params.createTime).format("yyyy-MM-dd hh:mm:ss");
                            }
                        }
                        }
                    ]],
                    where: {
                        definitionKey: key,
                        userId: $('#userId').val()
                    }
                    , page: true
                    , height: $("body").height() - $(".toolbar").outerHeight(true) - 170
                    , loading: true
                    , text: {
                        none: '暂无相关数据' //默认：无数据。注：该属性为 layui 2.2.5 开始新增
                    }
                    , even: true
                });
            }

            Date.prototype.format = function (fmt) {
                var o = {
                    "M+": this.getMonth() + 1,                 //月份
                    "d+": this.getDate(),                    //日
                    "h+": this.getHours(),                   //小时
                    "m+": this.getMinutes(),                 //分
                    "s+": this.getSeconds(),                 //秒
                    "q+": Math.floor((this.getMonth() + 3) / 3), //季度
                    "S": this.getMilliseconds()             //毫秒
                };
                if (/(y+)/.test(fmt)) {
                    fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
                }
                for (var k in o) {
                    if (new RegExp("(" + k + ")").test(fmt)) {
                        fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
                    }
                }
                return fmt;
            }
        });
    }
})