/**
 * Created by ChenXin on 2018/8/13.
 */

layui.define(['jquery','Hussar','HussarAjax'], function(exports) {
    var $ = layui.jquery
        ,Hussar=layui.Hussar
        , $ax = layui.HussarAjax;
    var HussarBpm = {

        //加载流程图信息，processId——流程id，title——标题，callback——success后的回调
        processPic:function (processId,title,callback) {
            layer.open({
                type: 2,
                title:title,
                maxmin : true,
                content: hussar_path+"/ProcessPicController/processPic?processId="+processId,
                area: ["100%", "100%"],
                success: function(){
                    callback.call(this);
                },
                end: function () {
                    $('#picWindow').hide();
                }
            });
        },
        //加载流程图实例信息(包含节点信息)，processId——流程实例id，title——标题，callback——success后的回调
        processPicInfo:function (processId,title,callback) {
            layer.open({
                type: 2,
                title:title,
                maxmin : true,
                content: hussar_path+"/ProcessPicController/processPicInfo?processId="+processId,
                area: ["100%", "100%"],
                success: function(){
                    callback.call(this);
                },
                end: function () {
                    $('#picWindow').hide();
                }
            });
        },
        //加载流程图实例信息(包含节点信息)，processId——流程实例id，title——标题，callback——success后的回调
        processpicTab:function (processId,title,callback) {
            layer.open({
                type: 2,
                title:title,
                maxmin : true,
                content: hussar_path+"/ProcessPicController/processpicTab?processId="+processId,
                area: ["100%", "100%"],
                success: function(){
                    callback.call(this);

                },
                end: function () {
                    $('#picWindow').hide();
                }
            });
        },
        //根据流程实例ID获取流程定义信息，processInstanceId——流程实例id
        processDefinition:function (processInstanceId,callback) {
            var ajax = new $ax(hussar_path+"/queryProcessDefinitionByInstanceId",
                function(result) {
                    callback.call(this,result);
                }, function(result) {
                    callback.call(this,result);
                });
            ajax.set("processInstanceId", processInstanceId);
            ajax.start();
        },
        //查询当前流程是否完成，processInstanceId——流程实例id，callback——ajax回调函数
        ProcessInstanceCompleteState:function (processInstanceId,callback) {
            var ajax = new $ax(hussar_path+"/queryProcessInstanceCompleteState",
                function(result) {
                    callback.call(this,result); //成功回调
                }, function(result) {
                    callback.call(this,result); //失败回调
                });
            ajax.set("processInstanceId", processInstanceId);
            ajax.start();
        },
        //代办列表（用户id）
        toDoTaskList:function (userId,callback) {
            var ajax = new $ax(hussar_path+"/queryToDoTaskList",
                function(result) {
                    callback.call(this,result); //成功回调
                }, function(result) {
                    callback.call(this,result); //失败回调
                });
            ajax.set("userId", userId);
            ajax.start();
        },
        //代办列表（用户id，流程定义key）
        toDoTaskListByProcess:function (userId,processDefinitionKey,callback) {
            var ajax = new $ax(hussar_path+"/queryToDoTaskListByProcess",
                function(result) {
                    callback.call(this,result); //成功回调
                }, function(result) {
                    callback.call(this,result); //失败回调
                });
            ajax.set("userId", userId);
            ajax.set("processDefinitionKey", processDefinitionKey);
            ajax.start();
        },
        //代办列表（流程定义key）
        toDoTaskListByDefinitionKey:function (processDefinitionKey,callback) {
            var ajax = new $ax(hussar_path+"/queryToDoByDefinitionKey",
                function(result) {
                    callback.call(this,result); //成功回调
                }, function(result) {
                    callback.call(this,result); //失败回调
                });
            ajax.set("processDefinitionKey", processDefinitionKey);
            ajax.start();
        },
        //已办列表（用户id）
        finishedTaskList:function (userId,callback) {
            var ajax = new $ax(hussar_path+"/queryFinishedTaskList",
                function(result) {
                    callback.call(this,result); //成功回调
                }, function(result) {
                    callback.call(this,result); //失败回调
                });
            ajax.set("userId", userId);
            ajax.start();
        },
        //已办列表（用户id，流程定义）
        finishedTaskListByProcess:function (userId,processDefinitionKey,callback) {
            var ajax = new $ax(hussar_path+"/queryFinishedTaskListByProcess",
                function(result) {
                    callback.call(this,result); //成功回调
                }, function(result) {
                    callback.call(this,result); //失败回调
                });
            ajax.set("userId", userId);
            ajax.set("processDefinitionKey", processDefinitionKey);
            ajax.start();
        },
        //签收任务（任务ID，用户ID）
        claimTask:function (taskId,userId,callback) {
            var ajax = new $ax(hussar_path+"/claimTask",
                function(result) {
                    callback.call(this,result); //成功回调
                }, function(result) {
                    callback.call(this,result); //失败回调
                });
            ajax.set("taskId", taskId);
            ajax.set("userId", userId);
            ajax.start();
        },
        //任务办理（任务id）
        completeTask:function (taskId,callback) {
            var ajax = new $ax(hussar_path+"/completeTask",
                function(result) {
                    callback.call(this,result); //成功回调
                }, function(result) {
                    callback.call(this,result); //失败回调
                });
            ajax.set("taskId", taskId);
            ajax.start();
        },
        //任务办理（任务id，人员id）
        completeTaskByUser:function (taskId,userId,callback) {
            var ajax = new $ax(hussar_path+"/completeTaskByUser",
                function(result) {
                    callback.call(this,result); //成功回调
                }, function(result) {
                    callback.call(this,result); //失败回调
                });
            ajax.set("taskId", taskId);
            ajax.set("userId", userId);
            ajax.start();
        },
        //任务办理（任务id，Map）
        completeTaskByMap:function (taskId,map,callback) {
            var ajax = new $ax(hussar_path+"/completeTaskByMap",
                function(result) {
                    callback.call(this,result); //成功回调
                }, function(result) {
                    callback.call(this,result); //失败回调
                });
            ajax.set("taskId", taskId);
            ajax.set("map", map);
            ajax.start();
        },
        //任务办理（任务id，用户id，Map）
        completeTaskByUserAndMap:function (taskId,userId,map,callback) {
            var ajax = new $ax(hussar_path+"/completeTaskByUserAndMap ",
                function(result) {
                    callback.call(this,result); //成功回调
                }, function(result) {
                    callback.call(this,result); //失败回调
                });
            ajax.set("taskId", taskId);
            jax.set("userId", userId);
            ajax.set("map", map);
            ajax.start();
        },
        //取消签收
        unClaimTask:function (taskId,callback) {
            var ajax = new $ax(hussar_path+"/unClaimTask",
                function(result) {
                    callback.call(this,result); //成功回调
                }, function(result) {
                    callback.call(this,result); //失败回调
                });
            ajax.set("taskId", taskId);
            ajax.start();
        },
        //任务驳回上一节点
        rejectToPreTask:function (taskId,comment,callback) {
            var ajax = new $ax(hussar_path+"/rejectToPreTask",
                function(result) {
                    callback.call(this,result); //成功回调
                }, function(result) {
                    callback.call(this,result); //失败回调
                });
            ajax.set("taskId", taskId);
            ajax.set("comment", comment);
            ajax.start();
        },
        //任务驳回上一节点
        rejectToPreTaskByUser:function (taskId,userId,comment,callback) {
            var ajax = new $ax(hussar_path+"/rejectToPreTaskByUser",
                function(result) {
                    callback.call(this,result); //成功回调
                }, function(result) {
                    callback.call(this,result); //失败回调
                });
            ajax.set("taskId", taskId);
            ajax.set("userId", userId);
            ajax.set("comment", comment);
            ajax.start();
        },
        //任务驳回第一节点
        rejectToFristTask:function (taskId,comment,callback) {
            var ajax = new $ax(hussar_path+"/rejectToFristTask",
                function(result) {
                    callback.call(this,result); //成功回调
                }, function(result) {
                    callback.call(this,result); //失败回调
                });
            ajax.set("taskId", taskId);
            ajax.set("comment", comment);
            ajax.start();
        },
        //任务驳回第一节点
        rejectToFristTaskByUser:function (taskId,userId,comment,callback) {
            var ajax = new $ax(hussar_path+"/rejectToFristTaskByUser",
                function(result) {
                    callback.call(this,result); //成功回调
                }, function(result) {
                    callback.call(this,result); //失败回调
                });
            ajax.set("taskId", taskId);
            ajax.set("userId", userId);
            ajax.set("comment", comment);
            ajax.start();
        },
        //委托
        delegateTask:function (taskId,userId,callback) {
            var ajax = new $ax(hussar_path+"/delegateTask",
                function(result) {
                    callback.call(this,result); //成功回调
                }, function(result) {
                    callback.call(this,result); //失败回调
                });
            ajax.set("taskId", taskId);
            ajax.set("userId", userId);
            ajax.start();
        },
        //自由跳转某一节点，activitiId——活动节点id
        freeJump:function (taskId,activitiId,callback) {
            var ajax = new $ax(hussar_path+"/freeJump",
                function(result) {
                    callback.call(this,result); //成功回调
                }, function(result) {
                    callback.call(this,result); //失败回调
                });
            ajax.set("taskId", taskId);
            ajax.set("activitiId", activitiId);
            ajax.start();
        },
        //根据任务ID进行获取当前环节信息
        getCurrNodeInfoByTaskId:function (taskId,callback) {
            var ajax = new $ax(hussar_path+"/getCurrNodeInfoByTaskId",
                function(result) {
                    callback.call(this,result); //成功回调
                }, function(result) {
                    callback.call(this,result); //失败回调
                });
            ajax.set("taskId", taskId);
            ajax.start();
        },
        //判断下一环节是否结束
        lastUserTask:function (taskId,callback) {
            var ajax = new $ax(hussar_path+"/lastUserTask",
                function(result) {
                    callback.call(this,result); //成功回调
                }, function(result) {
                    callback.call(this,result); //失败回调
                });
            ajax.set("taskId", taskId);
            ajax.start();
        },
        //获取历史环节信息
        queryHistoryActByTaskId:function (taskId,callback) {
            var ajax = new $ax(hussar_path+"/queryHistoryActByTaskId",
                function(result) {
                    callback.call(this,result); //成功回调
                }, function(result) {
                    callback.call(this,result); //失败回调
                });
            ajax.set("taskId", taskId);
            ajax.start();
        },
        //获取当前环节参与者
        queryAssigneeByTaskId:function (taskId,callback) {
            var ajax = new $ax(hussar_path+"/queryAssigneeByTaskId",
                function(result) {
                    callback.call(this,result); //成功回调
                }, function(result) {
                    callback.call(this,result); //失败回调
                });
            ajax.set("taskId", taskId);
            ajax.start();
        },
        //获取当前节点下一人工环节
        nextActListByTaskId:function (taskId,callback) {
            var ajax = new $ax(hussar_path+"/queryNextActivitiListByTaskId",
                function(result) {
                    callback.call(this,result); //成功回调
                }, function(result) {
                    callback.call(this,result); //失败回调
                });
            ajax.set("taskId", taskId);
            ajax.start();
        },
        //查询任务id（业务主键）
        queryTaskIdByBusinessKey:function (businessId,callback) {
            var ajax = new $ax(hussar_path+"/queryTaskIdByBusinessKey",
                function(result) {
                    callback.call(this,result); //成功回调
                }, function(result) {
                    callback.call(this,result); //失败回调
                });
            ajax.set("businessId", businessId);
            ajax.start();
        },
        //能否撤回(historicTaskId 历史任务ID)
        withdrawState:function (historicTaskId,callback) {
            var ajax = new $ax(hussar_path+"/withdrawState",
                function(result) {
                    callback.call(this,result); //成功回调
                }, function(result) {
                    callback.call(this,result); //失败回调
                });
            ajax.set("historicTaskId", historicTaskId);
            ajax.start();
        },
        //撤回（业务id，人员id）
        revokeTask:function (historicTaskId,bussinessId,userId,callback) {
            this.withdrawState(historicTaskId,function (data) {
                if(data.result=="false"){
                    Hussar.info("下一节点已办理，不能撤回！");
                    return ;
                }else {
                    var ajax = new $ax(hussar_path+"/revokeTask",
                        function(result) {
                            callback.call(this,result); //成功回调
                        }, function(result) {
                            callback.call(this,result); //失败回调
                        });
                    ajax.set("bussinessId", bussinessId);
                    ajax.set("userId", userId);
                    ajax.start();
                }
            })
        }
    };
    exports('HussarBpm', HussarBpm);
});
