/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.processimage.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.bpm.hisline.model.SysActHiLine;
import com.jxdinfo.hussar.bpm.hisline.service.ISysActHiLineService;
import com.jxdinfo.hussar.bpm.processimage.service.ProcessDiagramService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ErrorEventDefinition;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.InclusiveGateway;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProcessDiagramServiceImpl
implements ProcessDiagramService {
    @Autowired
    private HistoryService historyService;
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private TaskService taskService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private ISysActHiLineService iSysActHiLineService;
    private static final String FINISH_STATE = "finish";
    private static final String NOW_STATE = "now";
    private static final String NEXT_STATE = "next";
    private static final String SUSPENDED_STATE = "suspend";
    private static final String REJECT_STATE = "reject";

    @Override
    public JSONArray getProcessInfo(String processInstanceId) {
        Map<Object, Object> map = new HashMap();
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        String processDefinitonId = processInstance.getProcessDefinitionId();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitonId);
        this.prepareBpmnModel(bpmnModel);
        boolean suspended = false;
        List taskList = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).includeTaskLocalVariables()).includeProcessVariables()).list();
        if (taskList.size() == 0) {
            map = this.queryPreActivitiesByTaskIdFinished(processInstanceId);
        } else {
            ProcessInstance instance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            suspended = instance.isSuspended();
            map = this.queryPreActivitiesByTaskId(taskList, processInstanceId, processDefinitonId);
        }
        ArrayList<String> runningNode = new ArrayList<String>();
        for (Task task : taskList) {
            runningNode.add(task.getTaskDefinitionKey());
        }
        List idList = new ArrayList();
        List<Object> lineList = new ArrayList();
        List<SysActHiLine> sysActHiLines = this.iSysActHiLineService.getSysActHiLineByProcessinsId(processInstanceId);
        if (map != null) {
            idList = (List)map.get("idList");
            lineList = (List)map.get("lineList");
        }
        if (sysActHiLines != null && sysActHiLines.size() > 0) {
            lineList = sysActHiLines.stream().map(sysActHiLine -> sysActHiLine.getLineId()).collect(Collectors.toList());
        }
        JSONArray jsonArray = new JSONArray();
        for (Process process : bpmnModel.getProcesses()) {
            for (FlowNode flowNode : process.findFlowElementsOfType(FlowNode.class)) {
                JSONObject object = new JSONObject();
                String flowNodeId = flowNode.getId();
                object.put("id", (Object)flowNodeId);
                object.put("name", (Object)flowNode.getName());
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
                object.put("x", (Object)graphicInfo.getX());
                object.put("y", (Object)graphicInfo.getY());
                object.put("width", (Object)graphicInfo.getWidth());
                object.put("height", (Object)graphicInfo.getHeight());
                object.put("type", (Object)this.getNodeType(flowNode));
                if (runningNode.contains(flowNodeId)) {
                    if (suspended) {
                        object.put("state", (Object)SUSPENDED_STATE);
                    } else {
                        object.put("state", (Object)NOW_STATE);
                    }
                } else if (idList.contains(flowNodeId)) {
                    object.put("state", (Object)FINISH_STATE);
                } else {
                    object.put("state", (Object)NEXT_STATE);
                }
                jsonArray.add((Object)object);
                for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                    JSONObject obj = new JSONObject();
                    obj.put("id", (Object)sequenceFlow.getId());
                    obj.put("name", (Object)sequenceFlow.getName());
                    obj.put("type", (Object)"sequenceFlow");
                    List graphicInfoList = bpmnModel.getFlowLocationGraphicInfo(sequenceFlow.getId());
                    if (graphicInfoList != null && graphicInfoList.size() > 0) {
                        int[] xPoints = new int[graphicInfoList.size()];
                        int[] yPoints = new int[graphicInfoList.size()];
                        for (int i = 1; i < graphicInfoList.size(); ++i) {
                            GraphicInfo gi = (GraphicInfo)graphicInfoList.get(i);
                            GraphicInfo previousGraphicInfo = (GraphicInfo)graphicInfoList.get(i - 1);
                            if (i == 1) {
                                xPoints[0] = (int)previousGraphicInfo.getX();
                                yPoints[0] = (int)previousGraphicInfo.getY();
                            }
                            xPoints[i] = (int)gi.getX();
                            yPoints[i] = (int)gi.getY();
                        }
                        obj.put("xPoints", (Object)xPoints);
                        obj.put("yPoints", (Object)yPoints);
                    }
                    if (lineList.contains(sequenceFlow.getId())) {
                        obj.put("state", (Object)FINISH_STATE);
                    } else {
                        obj.put("state", (Object)NEXT_STATE);
                    }
                    jsonArray.add((Object)obj);
                }
            }
        }
        return jsonArray;
    }

    @Override
    public JSONArray getProcessCompleteInfo(String processInstanceId) {
        JSONArray jsonArray = new JSONArray();
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processInstance.getProcessDefinitionId());
        List activitiList = processDefinition.getActivities();
        List hisList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).activityType("userTask").orderByHistoricActivityInstanceStartTime().desc()).finished().list();
        List<String> userList = new ArrayList<String>();
        if (hisList != null && hisList.size() > 0) {
            userList = hisList.stream().map(HistoricActivityInstance::getAssignee).filter(x -> x != null).collect(Collectors.toList());
        }
        Map<String, String> finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList);
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
        for (ActivityImpl activity : activitiList) {
            JSONObject object = new JSONObject();
            object.put("width", (Object)activity.getWidth());
            object.put("height", (Object)activity.getHeight());
            object.put("x", (Object)activity.getX());
            object.put("y", (Object)activity.getY());
            object.put("id", (Object)activity.getId());
            List taskList = null;
            if (tasks != null && tasks.size() > 0) {
                taskList = tasks.stream().filter(t -> t.getTaskDefinitionKey().equals(activity.getId())).collect(Collectors.toList());
            }
            if (taskList != null && taskList.size() > 0) {
                Set<String> user = this.getAssigneeByTaskId(((Task)taskList.get(0)).getId());
                object.put("startTime", (Object)((Task)taskList.get(0)).getCreateTime());
                if (user != null && user.size() > 0) {
                    String assignee = this.iAssigneeChooseService.getUsers(Arrays.asList(user.toArray()));
                    object.put("assignee", (Object)assignee);
                } else {
                    object.put("assignee", (Object)"\u65e0\u4efb\u52a1\u63a5\u6536\u4eba");
                }
                object.put("state", (Object)NOW_STATE);
            } else {
                object.put("state", (Object)FINISH_STATE);
                List hisActivitList = null;
                if (hisList != null && hisList.size() > 0) {
                    hisActivitList = hisList.stream().filter(hai -> hai.getActivityId().equals(activity.getId())).collect(Collectors.toList());
                }
                if (hisActivitList == null || hisActivitList.size() <= 0) continue;
                hisActivitList.sort((m1, m2) -> m1.getStartTime().compareTo(m2.getStartTime()));
                JSONArray json = new JSONArray();
                for (HistoricActivityInstance historicActivityInstance : hisActivitList) {
                    List comments;
                    JSONObject o = new JSONObject();
                    String user = "";
                    if (historicActivityInstance.getAssignee() != null) {
                        user = finalUsersMap.get(historicActivityInstance.getAssignee());
                    }
                    if (StringUtils.isEmpty((CharSequence)user)) {
                        user = "\u81ea\u52a8\u8df3\u8fc7\u8282\u70b9";
                    }
                    if ((comments = this.taskService.getTaskComments(historicActivityInstance.getTaskId(), "complete")) != null && comments.size() > 0) {
                        o.put("comments", (Object)(((Comment)comments.get(0)).getFullMessage() == null ? "\u65e0\u5ba1\u6279\u610f\u89c1" : ((Comment)comments.get(0)).getFullMessage()));
                    } else {
                        o.put("comments", (Object)"\u65e0\u5ba1\u6279\u610f\u89c1");
                    }
                    o.put("assignee", (Object)user);
                    o.put("endTime", (Object)historicActivityInstance.getEndTime());
                    o.put("startTime", (Object)historicActivityInstance.getStartTime());
                    json.add((Object)o);
                }
                object.put("completeInfo", (Object)json);
            }
            jsonArray.add((Object)object);
        }
        return jsonArray;
    }

    @Override
    public JSONArray getProcessInfoByDefKey(String processDefinitonKey) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitonKey).latestVersion().singleResult();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinition.getId());
        this.prepareBpmnModel(bpmnModel);
        JSONArray jsonArray = new JSONArray();
        for (Process process : bpmnModel.getProcesses()) {
            for (FlowNode flowNode : process.findFlowElementsOfType(FlowNode.class)) {
                JSONObject object = new JSONObject();
                String flowNodeId = flowNode.getId();
                object.put("id", (Object)flowNodeId);
                object.put("name", (Object)flowNode.getName());
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
                object.put("x", (Object)graphicInfo.getX());
                object.put("y", (Object)graphicInfo.getY());
                object.put("width", (Object)graphicInfo.getWidth());
                object.put("height", (Object)graphicInfo.getHeight());
                object.put("type", (Object)this.getNodeType(flowNode));
                object.put("state", (Object)FINISH_STATE);
                jsonArray.add((Object)object);
                for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                    JSONObject obj = new JSONObject();
                    obj.put("id", (Object)sequenceFlow.getId());
                    obj.put("name", (Object)sequenceFlow.getName());
                    obj.put("type", (Object)"sequenceFlow");
                    List graphicInfoList = bpmnModel.getFlowLocationGraphicInfo(sequenceFlow.getId());
                    if (graphicInfoList != null && graphicInfoList.size() > 0) {
                        int[] xPoints = new int[graphicInfoList.size()];
                        int[] yPoints = new int[graphicInfoList.size()];
                        for (int i = 1; i < graphicInfoList.size(); ++i) {
                            GraphicInfo gi = (GraphicInfo)graphicInfoList.get(i);
                            GraphicInfo previousGraphicInfo = (GraphicInfo)graphicInfoList.get(i - 1);
                            if (i == 1) {
                                xPoints[0] = (int)previousGraphicInfo.getX();
                                yPoints[0] = (int)previousGraphicInfo.getY();
                            }
                            xPoints[i] = (int)gi.getX();
                            yPoints[i] = (int)gi.getY();
                        }
                        obj.put("xPoints", (Object)xPoints);
                        obj.put("yPoints", (Object)yPoints);
                    }
                    jsonArray.add((Object)obj);
                }
            }
        }
        return jsonArray;
    }

    private void prepareBpmnModel(BpmnModel bpmnModel) {
        ArrayList allGraphicInfos = new ArrayList();
        if (bpmnModel.getLocationMap() != null) {
            allGraphicInfos.addAll(bpmnModel.getLocationMap().values());
        }
        if (bpmnModel.getLabelLocationMap() != null) {
            allGraphicInfos.addAll(bpmnModel.getLabelLocationMap().values());
        }
        if (bpmnModel.getFlowLocationMap() != null) {
            for (List flowGraphicInfos : bpmnModel.getFlowLocationMap().values()) {
                allGraphicInfos.addAll(flowGraphicInfos);
            }
        }
        if (allGraphicInfos.size() > 0) {
            boolean needsTranslationX = false;
            boolean needsTranslationY = false;
            double lowestX = 0.0;
            double lowestY = 0.0;
            for (GraphicInfo graphicInfo : allGraphicInfos) {
                double x = graphicInfo.getX();
                double y = graphicInfo.getY();
                if (x < lowestX) {
                    needsTranslationX = true;
                    lowestX = x;
                }
                if (!(y < lowestY)) continue;
                needsTranslationY = true;
                lowestY = y;
            }
            if (needsTranslationX || needsTranslationY) {
                double translationX = Math.abs(lowestX);
                double translationY = Math.abs(lowestY);
                for (GraphicInfo graphicInfo : allGraphicInfos) {
                    if (needsTranslationX) {
                        graphicInfo.setX(graphicInfo.getX() + translationX);
                    }
                    if (!needsTranslationY) continue;
                    graphicInfo.setY(graphicInfo.getY() + translationY);
                }
            }
        }
    }

    private String getNodeType(FlowNode flowNode) {
        String type = "";
        if (flowNode instanceof UserTask) {
            type = "userTask";
        } else if (flowNode instanceof StartEvent) {
            EventDefinition eventDefinition;
            StartEvent startEvent = (StartEvent)flowNode;
            type = startEvent.getEventDefinitions() != null && !startEvent.getEventDefinitions().isEmpty() ? ((eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0)) instanceof TimerEventDefinition ? "startTimerEvent" : (eventDefinition instanceof ErrorEventDefinition ? "errorEvent" : (eventDefinition instanceof SignalEventDefinition ? "signalEvent" : (eventDefinition instanceof MessageEventDefinition ? "messageEvent" : "noneEvent")))) : "startEvent";
        } else if (flowNode instanceof EndEvent) {
            type = "endEvent";
        } else if (flowNode instanceof ParallelGateway) {
            type = "parallelGateway";
        } else if (flowNode instanceof InclusiveGateway) {
            type = "inclusiveGateway";
        } else if (flowNode instanceof ExclusiveGateway) {
            type = "exclusiveGateway";
        } else if (flowNode instanceof SubProcess) {
            type = "subProcess";
        } else if (flowNode instanceof BoundaryEvent) {
            type = "boundaryEvent";
        } else if (flowNode instanceof CallActivity) {
            type = "callActivity";
        }
        return type;
    }

    private Map<String, Object> queryPreActivitiesByTaskIdFinished(String processInstanceId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List historicTaskInstanceList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).orderByHistoricTaskInstanceEndTime().desc()).list();
        HistoricTaskInstance task = (HistoricTaskInstance)historicTaskInstanceList.get(0);
        if (task != null) {
            ActivityImpl activityImpl;
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
            ArrayList<String> idList = new ArrayList<String>();
            ArrayList<String> lineList = new ArrayList<String>();
            ArrayList<String> outLineList = new ArrayList<String>();
            HashMap<String, String> typeMap = new HashMap<String, String>();
            List list = ((HistoricActivityInstanceQuery)this.processEngine.getHistoryService().createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().finished().asc()).list();
            for (HistoricActivityInstance his : list) {
                idList.add(his.getActivityId());
                typeMap.put(his.getActivityId(), his.getActivityType());
                activityImpl = processDefinition.findActivity(his.getActivityId());
                List outgoing = activityImpl.getOutgoingTransitions();
                for (PvmTransition pv : outgoing) {
                    outLineList.add(pv.getId());
                }
            }
            for (HistoricActivityInstance his : list) {
                activityImpl = processDefinition.findActivity(his.getActivityId());
                List incoming = activityImpl.getIncomingTransitions();
                for (PvmTransition pv : incoming) {
                    if (!outLineList.contains(pv.getId())) continue;
                    lineList.add(pv.getId());
                }
            }
            map.put("idList", idList);
            map.put("lineList", lineList);
            map.put("typeMap", typeMap);
        }
        return map;
    }

    private Map<String, Object> queryPreActivitiesByTaskId(List taskList, String processInstanceId, String processDefinitonId) {
        List in;
        ActivityImpl activity;
        HashMap<String, Object> map = new HashMap<String, Object>();
        ProcessDefinitionEntity def = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processDefinitonId);
        ArrayList list = new ArrayList();
        ArrayList<String> idList = new ArrayList<String>();
        ArrayList<String> lineList = new ArrayList<String>();
        HashMap<String, Object> typeMap = new HashMap<String, Object>();
        ArrayList<String> executionList = new ArrayList<String>();
        for (int i = 0; i < taskList.size(); ++i) {
            Task task = (Task)taskList.get(i);
            if (task == null) continue;
            executionList.add(task.getExecutionId());
            String activitiId = task.getTaskDefinitionKey();
            activity = def.findActivity(activitiId);
            in = activity.getIncomingTransitions();
            this.getPreActivities(processInstanceId, in, idList, lineList, typeMap);
        }
        List endEventActivitList = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).activityType("endEvent").finished().list();
        if (endEventActivitList != null && endEventActivitList.size() > 0) {
            for (int i = 0; i < endEventActivitList.size(); ++i) {
                HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)endEventActivitList.get(i);
                activity = def.findActivity(historicActivityInstance.getActivityId());
                in = activity.getIncomingTransitions();
                this.getPreActivities(processInstanceId, in, idList, lineList, typeMap);
                idList.add(activity.getId());
                typeMap.put(activity.getId(), activity.getProperty("type"));
            }
        }
        for (int i = 0; i < list.size(); ++i) {
            ActivityImpl activity2 = (ActivityImpl)list.get(i);
            List in2 = activity2.getIncomingTransitions();
            this.getParallelGatewayPreActivities(in2, idList, lineList, typeMap, executionList, processInstanceId);
        }
        map.put("idList", idList);
        map.put("lineList", lineList);
        map.put("typeMap", typeMap);
        return map;
    }

    private void getParallelGatewayPreActivities(List<PvmTransition> in, List<String> idList, List<String> lineList, HashMap<String, Object> typeMap, List<String> executionList, String processInstanceId) {
        for (PvmTransition pv : in) {
            PvmActivity source = pv.getSource();
            List highLightedActivitList = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).activityId(source.getId()).list();
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)highLightedActivitList.get(0);
            if (executionList.indexOf(historicActivityInstance.getExecutionId()) != -1) continue;
            lineList.add(pv.getId());
            idList.add(source.getId());
            typeMap.put(source.getId(), source.getProperty("type"));
            List incoming = source.getIncomingTransitions();
            this.getPreActivities(processInstanceId, incoming, idList, lineList, typeMap);
        }
    }

    private void getPreActivities(String processInstanceId, List<PvmTransition> in, List<String> idList, List<String> lineList, HashMap<String, Object> typeMap) {
        List list = ((HistoricActivityInstanceQuery)this.processEngine.getHistoryService().createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().finished().desc()).list();
        ArrayList<String> actList = new ArrayList<String>();
        for (HistoricActivityInstance hai : list) {
            actList.add(hai.getActivityId());
        }
        for (PvmTransition pv : in) {
            if (lineList.contains(pv.getId()) || !actList.contains(pv.getSource().getId())) continue;
            lineList.add(pv.getId());
            PvmActivity source = pv.getSource();
            idList.add(source.getId());
            typeMap.put(source.getId(), source.getProperty("type"));
            List incoming = source.getIncomingTransitions();
            if (incoming == null || incoming.size() <= 0) continue;
            this.getPreActivities(processInstanceId, incoming, idList, lineList, typeMap);
        }
    }

    private Set<String> getAssigneeByTaskId(String taskId) {
        HashSet<String> users = new HashSet<String>();
        List identityLinkList = this.taskService.getIdentityLinksForTask(taskId);
        if (identityLinkList != null && identityLinkList.size() > 0) {
            for (IdentityLink identityLink : identityLinkList) {
                users.add(identityLink.getUserId());
            }
        }
        return users;
    }
}

