/**
 * Created by xb on 2018/4/19.
 */
layui.use(['jquery','layer','Hussar','jstree','HussarAjax','table','jqForm'], function(){
	var Hussar = layui.Hussar;
	var $ = layui.jquery;
	var layer=layui.layer;
	var $ax=layui.HussarAjax;
	var table = layui.table;
	var jqForm=layui.jqForm;
            table.render({
                where:{
                    attachId: $('#attachId').val(),
                },
                elem: '#impModleTable',
                url:Hussar.ctxPath+'/impModle/queryImpModle',
                cols: [[
                    {type:'numbers', title: '序号'},
                    {field: 'impModleId', title: '模型ID', align:'center'},
                    {field: 'impModleName', title: '模型名称', align:'center',},
                    {field: 'impTime', title: '模型导入时间', align:'center'},
                    {field: 'impUser', title: '流程导入用户', align:'center'}
                ]],
                page: true,
                height:$("body").height() - $(".toolbar").outerHeight(true) -70,
                loading:true,
                text: {
                    none: '暂无相关数据' //默认：无数据。注：该属性为 layui 2.2.5 开始新增
                }
                ,even: true
            });
       
/*查询*/
$("#search").click(function () {
    reloadTable();
});
function reloadTable() {
    var table = layui.table;
    table.reload("impModleTable", {
        page : {
            curr : 1
            // 重新从第 1 页开始
        },
        where: {
            impModleName: $('#impModleName').val(),
            attachId: $('#attachId').val(),
        }
    });
}
/*重置*/
$("#reset").click(function () {
    //模型名称
    $('#impModleName').val('');
    reloadTable();
});

/*导入*/
$("#import").click(function(){
    $("#importFlag").val("import");
    importForm();
});
/*导入保存*/
$("#importSave").click(function () {
    importSave();
});
/*批量导入*/
$("#batchImport").click(function(){
    $("#importFlag").val("batchImport");
    importForm();
});
/*导入*/
function importForm() {
    var that = this;
    infoWin = $("#importEvent").createLayerWindow({
        type: 1,
        title : "导入模型",
        shadeClose: false,
        shade: true,
        maxmin: false, //开启最大化最小化按钮
        area: ['440px', '160px'],
        success:function(){
            //重置form
            $("#importForm").formReset();
        }
    });
}
/*导入保存*/
function importSave() {
    var that = this;
    if($("#importFileInput").val()==""){
        Hussar.info("流程模型文件不能为空");
        return;
    }
    var url;
    if ($("#importFlag").val() == "batchImport") {
        url = Hussar.ctxPath+"/model/batchImport";
    }
    if($("#importFlag").val() == "import"){
        url = Hussar.ctxPath+"/model/modelImport";
    }
    $("#importForm").ajaxSubmit({
        url:url,
        type:"post",
        success:function (data) {
            var jsObject = JSON.parse(data);
            var result= jsObject.result;
            var flags = JSON.parse(result);
            var re = flags.flag;
            if(re=="true"){
                layer.closeAll();
                layer.close(layer.index);
                reloadTable();
                Hussar.success("导入成功")
            }
            if(re=="false"){
                Hussar.error("导入失败");
            }
        },
        error:function(){
        }
    })
}
function FormatTime(params) {
    var p = new Date(parseInt(params)).format("yyyy-MM-dd hh:mm:ss")
    return p;
}
Date.prototype.format = function(fmt) {
    var o = {
        "M+" : this.getMonth()+1,                 //月份
        "d+" : this.getDate(),                    //日
        "h+" : this.getHours(),                   //小时
        "m+" : this.getMinutes(),                 //分
        "s+" : this.getSeconds(),                 //秒
        "q+" : Math.floor((this.getMonth()+3)/3), //季度
        "S"  : this.getMilliseconds()             //毫秒
    };
    if(/(y+)/.test(fmt)) {
        fmt=fmt.replace(RegExp.$1, (this.getFullYear()+"").substr(4 - RegExp.$1.length));
    }
    for(var k in o) {
        if(new RegExp("("+ k +")").test(fmt)){
            fmt = fmt.replace(RegExp.$1, (RegExp.$1.length==1) ? (o[k]) : (("00"+ o[k]).substr((""+ o[k]).length)));
        }
    }
    return fmt;
}
});