/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.rest.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.toolkit.IdWorker;
import com.jxdinfo.hussar.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.bpm.common.utils.ServiceResult;
import com.jxdinfo.hussar.bpm.hisline.model.SysActHiLine;
import com.jxdinfo.hussar.bpm.hisline.service.ISysActHiLineService;
import com.jxdinfo.hussar.bpm.rest.dao.TaskWebMapper;
import com.jxdinfo.hussar.bpm.rest.service.TaskWebService;
import com.jxdinfo.hussar.bpm.rest.util.ActivitiJumpCommand;
import com.jxdinfo.hussar.bpm.rest.util.CommonJumpTaskCmd;
import com.jxdinfo.hussar.bpm.rest.util.MultiInstanceJumpTaskCmd;
import com.jxdinfo.hussar.bpm.rest.util.ParallelJumpTaskCmd;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.converter.util.InputStreamProvider;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.ActivitiTaskAlreadyClaimedException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.TaskServiceImpl;
import org.activiti.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.activiti.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.ValueExpression;
import org.activiti.engine.impl.juel.ExpressionFactoryImpl;
import org.activiti.engine.impl.juel.SimpleContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.ReadOnlyProcessDefinition;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.impl.util.io.InputStreamSource;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class TaskWebServiceImpl
implements TaskWebService {
    private static Logger LOGGER = LoggerFactory.getLogger(TaskWebServiceImpl.class);
    @Autowired
    private TaskService taskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private ISysActHiLineService iSysActHiLineService;
    @Resource
    private TaskWebMapper taskWebMapper;
    private String userTask = "userTask";
    private String subProcess = "subProcess";
    private String startAct = "startEvent";
    private String endAct = "endEvent";

    @Override
    public String queryToDoTaskList(String userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskCandidateOrAssigned(userId).includeProcessVariables()).includeTaskLocalVariables()).orderByTaskCreateTime()).desc()).list();
            if (tasks != null) {
                List<Map<String, Object>> list = this.tasksToMap(tasks);
                map.put("data", JSONArray.toJSONString(list));
                map.put("count", tasks.size());
            }
            return ServiceResult.getResult("1", "success", JSON.toJSONString(map));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5f85\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String queryToDoTaskListByProcess(String userId, String processDefinitionKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskCandidateOrAssigned(userId).processDefinitionKey(processDefinitionKey)).includeProcessVariables()).includeTaskLocalVariables()).orderByTaskCreateTime()).desc()).list();
            if (tasks != null) {
                List<Map<String, Object>> list = this.tasksToMap(tasks);
                map.put("data", JSONArray.toJSONString(list));
                map.put("count", tasks.size());
            }
            return ServiceResult.getResult("1", "success", JSON.toJSONString(map));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5f85\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String queryToDoTaskList(String userId, Integer page, Integer rows) {
        Long countTasks = 0L;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            countTasks = this.taskService.createTaskQuery().taskCandidateOrAssigned(userId).count();
            List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskCandidateOrAssigned(userId).includeProcessVariables()).includeTaskLocalVariables()).orderByTaskCreateTime()).desc()).listPage((page - 1) * rows, rows.intValue());
            List<Map<String, Object>> list = this.tasksToMap(tasks);
            map.put("data", JSONArray.toJSONString(list));
            map.put("count", countTasks);
            return ServiceResult.getResult("1", "success", JSON.toJSONString(map));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5f85\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String queryToDoByDefinitionKey(String processDefinitionKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey(processDefinitionKey)).includeProcessVariables()).includeTaskLocalVariables()).orderByTaskCreateTime()).desc()).list();
            if (tasks != null) {
                List<Map<String, Object>> list = this.tasksToMap(tasks);
                map.put("data", JSONArray.toJSONString(list));
                map.put("count", tasks.size());
            }
            return ServiceResult.getResult("1", "success", JSON.toJSONString(map));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5f85\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String queryToDoTaskListByPageAndProcess(String userId, String processDefinitionKey, Integer page, Integer rows) {
        Long countTasks = 0L;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            countTasks = ((TaskQuery)this.taskService.createTaskQuery().taskCandidateOrAssigned(userId).processDefinitionKey(processDefinitionKey)).count();
            List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskCandidateOrAssigned(userId).processDefinitionKey(processDefinitionKey)).includeProcessVariables()).includeTaskLocalVariables()).orderByTaskCreateTime()).desc()).listPage((page - 1) * rows, rows.intValue());
            List<Map<String, Object>> list = this.tasksToMap(tasks);
            map.put("data", JSONArray.toJSONString(list));
            map.put("count", countTasks);
            return ServiceResult.getResult("1", "success", JSON.toJSONString(map));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5f85\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String queryToDoTaskListByDefinitionKey(String userId, String processDefinitionKey, String definitionKey, Integer page, Integer rows) {
        Long countTasks = 0L;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            countTasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskCandidateOrAssigned(userId).processDefinitionKey(processDefinitionKey)).taskDefinitionKey(definitionKey)).count();
            List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskCandidateOrAssigned(userId).processDefinitionKey(processDefinitionKey)).taskDefinitionKey(definitionKey)).includeProcessVariables()).includeTaskLocalVariables()).orderByTaskCreateTime()).desc()).listPage((page - 1) * rows, rows.intValue());
            List<Map<String, Object>> list = this.tasksToMap(tasks);
            map.put("data", JSONArray.toJSONString(list));
            map.put("count", countTasks);
            return ServiceResult.getResult("1", "success", JSON.toJSONString(map));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5f85\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String queryFinishedTaskList(String userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskAssignee(userId)).orderByHistoricTaskInstanceEndTime().includeProcessVariables()).includeTaskLocalVariables()).finished().desc()).list();
            if (hisTaskList != null) {
                List<Map<String, Object>> list = this.hisTasksToMap(hisTaskList);
                map.put("data", JSONArray.toJSONString(list));
                map.put("count", hisTaskList.size());
            }
            return ServiceResult.getResult("1", "success", JSON.toJSONString(map));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5df2\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String queryFinishedTaskListByProcess(String userId, String processDefinitionKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processDefinitionKey(processDefinitionKey)).taskAssignee(userId)).includeProcessVariables()).includeTaskLocalVariables()).orderByHistoricTaskInstanceEndTime().finished().desc()).list();
            if (hisTaskList != null) {
                List<Map<String, Object>> list = this.hisTasksToMap(hisTaskList);
                map.put("data", JSONArray.toJSONString(list));
                map.put("count", hisTaskList.size());
            }
            return ServiceResult.getResult("1", "success", JSON.toJSONString(map));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5df2\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String queryFinishedTaskList(String userId, Integer page, Integer rows) {
        Long counthisList = 0L;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            counthisList = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskAssignee(userId)).finished().count();
            List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskAssignee(userId)).includeProcessVariables()).includeTaskLocalVariables()).orderByHistoricTaskInstanceEndTime().finished().desc()).listPage((page - 1) * rows, rows.intValue());
            List<Map<String, Object>> list = this.hisTasksToMap(hisTaskList);
            map.put("data", JSONArray.toJSONString(list));
            map.put("count", counthisList);
            return ServiceResult.getResult("1", "success", JSON.toJSONString(map));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5df2\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String queryFinishedTaskListByPageAndProcess(String userId, String processDefinitionKey, Integer page, Integer rows) {
        Long counthisList = 0L;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            counthisList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskAssignee(userId)).processDefinitionKey(processDefinitionKey)).finished().count();
            List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processDefinitionKey(processDefinitionKey)).taskAssignee(userId)).includeProcessVariables()).includeTaskLocalVariables()).finished().orderByHistoricTaskInstanceEndTime().desc()).listPage((page - 1) * rows, rows.intValue());
            List<Map<String, Object>> list = this.hisTasksToMap(hisTaskList);
            map.put("data", JSONArray.toJSONString(list));
            map.put("count", counthisList);
            return ServiceResult.getResult("1", "success", JSON.toJSONString(map));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5df2\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String queryFinishedTaskListByDefinitionKey(String userId, String processDefinitionKey, String definitionKey, Integer page, Integer rows) {
        Long counthisList = 0L;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            counthisList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskAssignee(userId)).processDefinitionKey(processDefinitionKey)).taskDefinitionKey(definitionKey)).finished().count();
            List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskAssignee(userId)).processDefinitionKey(processDefinitionKey)).taskDefinitionKey(definitionKey)).includeProcessVariables()).includeTaskLocalVariables()).finished().orderByHistoricTaskInstanceEndTime().desc()).listPage((page - 1) * rows, rows.intValue());
            List<Map<String, Object>> list = this.hisTasksToMap(hisTaskList);
            map.put("data", JSONArray.toJSONString(list));
            map.put("count", counthisList);
            return ServiceResult.getResult("1", "success", JSON.toJSONString(map));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5df2\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String queryUserTaskCount(String userId) {
        List<Map> list = this.taskWebMapper.getUserTask(userId);
        return ServiceResult.getResult("1", "success", JSON.toJSONString(list));
    }

    @Override
    public String queryUserTaskCountByNode(String userId) {
        List<Map> list = this.taskWebMapper.getUserTaskByNode(userId);
        return ServiceResult.getResult("1", "success", JSON.toJSONString(list));
    }

    @Override
    public String claimTask(String taskId, String userId) {
        try {
            this.taskService.claim(taskId, userId);
            return ServiceResult.getResult("1", "success", "\u7b7e\u6536\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("\u7b7e\u6536\u4efb\u52a1\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "\u4efb\u52a1\u5df2\u88ab\u5176\u4ed6\u4eba\u5458\u7b7e\u6536");
        }
    }

    @Override
    public String completeTask(String taskId) {
        try {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            String processInstanceId = task.getProcessInstanceId();
            List oldList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().asc()).list();
            this.complete(task, "", null);
            List newList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().asc()).list();
            this.saveLineHis(processInstanceId, newList, oldList, "", task.getTaskDefinitionKey());
            return this.installReturnValue(task.getProcessInstanceId());
        }
        catch (ActivitiObjectNotFoundException a) {
            LOGGER.error(a.getMessage());
            return ServiceResult.getResult("0", a.getMessage(), "\u4efb\u52a1\u5df2\u88ab\u529e\u7406\u3002");
        }
        catch (Exception e) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String completeTask(String taskId, String userId) {
        try {
            this.taskService.claim(taskId, userId);
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            String processInstanceId = task.getProcessInstanceId();
            List oldList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().asc()).list();
            this.complete(task, userId, null);
            List newList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().asc()).list();
            this.saveLineHis(processInstanceId, newList, oldList, userId, task.getTaskDefinitionKey());
            return this.installReturnValue(task.getProcessInstanceId());
        }
        catch (ActivitiTaskAlreadyClaimedException atac) {
            LOGGER.error(atac.getMessage());
            return ServiceResult.getResult("0", atac.getMessage(), "\u4efb\u52a1\u5df2\u88ab\u7b7e\u6536\u3002");
        }
        catch (ActivitiObjectNotFoundException a) {
            LOGGER.error(a.getMessage());
            return ServiceResult.getResult("0", a.getMessage(), "\u4efb\u52a1\u5df2\u88ab\u529e\u7406\u3002");
        }
        catch (Exception e) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String completeTask(String taskId, Map<String, Object> map) {
        try {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            String processInstanceId = task.getProcessInstanceId();
            List oldList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().asc()).list();
            this.complete(task, "", map);
            List newList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().asc()).list();
            this.saveLineHis(processInstanceId, newList, oldList, "", task.getTaskDefinitionKey());
            return this.installReturnValue(task.getProcessInstanceId());
        }
        catch (ActivitiObjectNotFoundException a) {
            LOGGER.error(a.getMessage());
            return ServiceResult.getResult("0", a.getMessage(), "\u4efb\u52a1\u5df2\u88ab\u529e\u7406\u3002");
        }
        catch (Exception e) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String completeCountersignTask(String taskId, String comment, Map<String, Object> map) {
        try {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            String processInstanceId = task.getProcessInstanceId();
            if (StringUtils.isNotEmpty((CharSequence)comment)) {
                this.taskService.addComment(taskId, null, "complete", comment);
            }
            List oldList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().asc()).list();
            this.complete(task, "", map);
            List newList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().asc()).list();
            this.saveLineHis(processInstanceId, newList, oldList, "", task.getTaskDefinitionKey());
            return this.installReturnValue(task.getProcessInstanceId());
        }
        catch (ActivitiObjectNotFoundException a) {
            LOGGER.error(a.getMessage());
            return ServiceResult.getResult("0", a.getMessage(), "\u4efb\u52a1\u5df2\u88ab\u529e\u7406\u3002");
        }
        catch (Exception e) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String completeTask(String taskId, String userId, Map<String, Object> map) {
        try {
            this.taskService.claim(taskId, userId);
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            String processInstanceId = task.getProcessInstanceId();
            List oldList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().asc()).list();
            this.complete(task, userId, map);
            List newList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().asc()).list();
            this.saveLineHis(processInstanceId, newList, oldList, userId, task.getTaskDefinitionKey());
            return this.installReturnValue(task.getProcessInstanceId());
        }
        catch (ActivitiTaskAlreadyClaimedException atac) {
            LOGGER.error(atac.getMessage());
            return ServiceResult.getResult("0", atac.getMessage(), "\u4efb\u52a1\u5df2\u88ab\u7b7e\u6536\u3002");
        }
        catch (ActivitiObjectNotFoundException a) {
            LOGGER.error(a.getMessage());
            return ServiceResult.getResult("0", a.getMessage(), "\u4efb\u52a1\u5df2\u88ab\u529e\u7406\u3002");
        }
        catch (Exception e) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String completeTask(String taskId, String userId, Map<String, String> assigneeMap, Map<String, Object> map) {
        try {
            this.taskService.claim(taskId, userId);
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            String processInstanceId = task.getProcessInstanceId();
            List oldList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().asc()).list();
            this.complete(task, userId, map);
            List newList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().asc()).list();
            this.saveLineHis(processInstanceId, newList, oldList, userId, task.getTaskDefinitionKey());
            this.setAssignee(task.getProcessInstanceId(), assigneeMap);
            return this.installReturnValue(task.getProcessInstanceId());
        }
        catch (ActivitiTaskAlreadyClaimedException atac) {
            LOGGER.error(atac.getMessage());
            return ServiceResult.getResult("0", atac.getMessage(), "\u4efb\u52a1\u5df2\u88ab\u7b7e\u6536\u3002");
        }
        catch (ActivitiObjectNotFoundException a) {
            LOGGER.error(a.getMessage());
            return ServiceResult.getResult("0", a.getMessage(), "\u4efb\u52a1\u5df2\u88ab\u529e\u7406\u3002");
        }
        catch (Exception e) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String completeTask(String taskId, String userId, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        try {
            this.taskService.claim(taskId, userId);
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            String processInstanceId = task.getProcessInstanceId();
            if (StringUtils.isNotEmpty((CharSequence)comment)) {
                this.taskService.addComment(taskId, null, "complete", comment);
            }
            List oldList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().asc()).list();
            this.complete(task, userId, map);
            List newList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().asc()).list();
            this.saveLineHis(processInstanceId, newList, oldList, userId, task.getTaskDefinitionKey());
            this.setAssignee(processInstanceId, assigneeMap);
            return this.installReturnValue(processInstanceId);
        }
        catch (ActivitiTaskAlreadyClaimedException atac) {
            LOGGER.error(atac.getMessage());
            return ServiceResult.getResult("0", atac.getMessage(), "\u4efb\u52a1\u5df2\u88ab\u7b7e\u6536\u3002");
        }
        catch (ActivitiObjectNotFoundException a) {
            LOGGER.error(a.getMessage());
            return ServiceResult.getResult("0", a.getMessage(), "\u4efb\u52a1\u5df2\u88ab\u529e\u7406\u3002");
        }
        catch (Exception e) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    private void saveLineHis(String processInstanceId, List<HistoricActivityInstance> newList, List<HistoricActivityInstance> oldList, String userId, String activityId) {
        List<SysActHiLine> sysActHiLines = new ArrayList<SysActHiLine>();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        ProcessDefinitionEntity def = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(newList.get(0).getProcessDefinitionId());
        List oldIds = oldList.stream().map(historicActivityInstance -> historicActivityInstance.getId()).collect(Collectors.toList());
        newList.removeIf(item -> oldIds.contains(item.getId()));
        List<String> ids = newList.stream().map(HistoricActivityInstance::getActivityId).collect(Collectors.toList());
        ActivityImpl activity = def.findActivity(activityId);
        if (processInstance != null) {
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
            Set taskIds = tasks.stream().map(task -> task.getTaskDefinitionKey()).collect(Collectors.toSet());
            if (taskIds != null && taskIds.size() == 1 && taskIds.contains(activityId)) {
                return;
            }
            if (taskIds != null && taskIds.size() >= 1) {
                sysActHiLines = this.installHiLine(activity, processInstance, sysActHiLines, ids, userId, 0);
            }
        } else {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            sysActHiLines = this.installHiLine(activity, historicProcessInstance, sysActHiLines, ids, userId);
        }
        if (sysActHiLines != null && sysActHiLines.size() > 0) {
            this.iSysActHiLineService.insertBatch(sysActHiLines);
        }
    }

    private List<SysActHiLine> installHiLine(ActivityImpl activity, ProcessInstance processInstance, List<SysActHiLine> sysActHiLines, List<String> ids, String userId, int num) {
        List outgoingTransitions = activity.getOutgoingTransitions();
        if (outgoingTransitions != null && outgoingTransitions.size() > 0) {
            for (PvmTransition p : outgoingTransitions) {
                if (!ids.contains(p.getDestination().getId())) continue;
                ActivityImpl acti = (ActivityImpl)p.getDestination();
                SysActHiLine sysActHiLine = new SysActHiLine();
                sysActHiLine.setId(IdWorker.get32UUID());
                sysActHiLine.setProcInstId(processInstance.getProcessInstanceId());
                sysActHiLine.setProcDefId(processInstance.getProcessDefinitionId());
                sysActHiLine.setProcDefKey(processInstance.getProcessDefinitionKey());
                sysActHiLine.setLineId(p.getId());
                sysActHiLine.setLineName(p.getProperty("name") == null ? "" : (String)p.getProperty("name"));
                sysActHiLine.setCompleteTime(new Timestamp(System.currentTimeMillis()));
                sysActHiLine.setCompleteUser(userId);
                sysActHiLine.setInNode(acti.getId());
                sysActHiLine.setInNodeName(acti.getProperty("name") == null ? "" : acti.getProperty("name").toString());
                sysActHiLine.setOutNode(activity.getId());
                sysActHiLine.setOutNodeName(activity.getProperty("name") == null ? "" : activity.getProperty("name").toString());
                sysActHiLines.add(sysActHiLine);
                if (ids.size() <= num) continue;
                this.installHiLine(acti, processInstance, sysActHiLines, ids, userId, ++num);
            }
        }
        return sysActHiLines;
    }

    private List<SysActHiLine> installHiLine(ActivityImpl activity, HistoricProcessInstance historicProcessInstance, List<SysActHiLine> sysActHiLines, List<String> ids, String userId) {
        List outgoingTransitions = activity.getOutgoingTransitions();
        if (outgoingTransitions != null && outgoingTransitions.size() > 0) {
            for (PvmTransition p : outgoingTransitions) {
                if (!ids.contains(p.getDestination().getId())) continue;
                ActivityImpl acti = (ActivityImpl)p.getDestination();
                SysActHiLine sysActHiLine = new SysActHiLine();
                sysActHiLine.setId(IdWorker.get32UUID());
                sysActHiLine.setProcInstId(historicProcessInstance.getId());
                sysActHiLine.setProcDefId(historicProcessInstance.getProcessDefinitionId());
                sysActHiLine.setProcDefKey(historicProcessInstance.getProcessDefinitionKey());
                sysActHiLine.setLineId(p.getId());
                sysActHiLine.setLineName(p.getProperty("name") == null ? "" : (String)p.getProperty("name"));
                sysActHiLine.setCompleteTime(new Timestamp(System.currentTimeMillis()));
                sysActHiLine.setCompleteUser(userId);
                sysActHiLine.setInNode(acti.getId());
                sysActHiLine.setInNodeName(acti.getProperty("name") == null ? "" : acti.getProperty("name").toString());
                sysActHiLine.setOutNode(activity.getId());
                sysActHiLine.setOutNodeName(activity.getProperty("name") == null ? "" : activity.getProperty("name").toString());
                sysActHiLines.add(sysActHiLine);
                if (acti.getId().equals(historicProcessInstance.getEndActivityId())) continue;
                this.installHiLine(acti, historicProcessInstance, sysActHiLines, ids, userId);
            }
        }
        return sysActHiLines;
    }

    @Override
    public String completeTask(String taskId, String userId, String comment, Map<String, Object> map) {
        try {
            this.taskService.claim(taskId, userId);
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            if (StringUtils.isNotEmpty((CharSequence)comment)) {
                this.taskService.addComment(taskId, null, "complete", comment);
            }
            this.complete(task, userId, map);
            return this.installReturnValue(task.getProcessInstanceId());
        }
        catch (ActivitiTaskAlreadyClaimedException atac) {
            LOGGER.error(atac.getMessage());
            return ServiceResult.getResult("0", atac.getMessage(), "\u4efb\u52a1\u5df2\u88ab\u7b7e\u6536\u3002");
        }
        catch (ActivitiObjectNotFoundException a) {
            LOGGER.error(a.getMessage());
            return ServiceResult.getResult("0", a.getMessage(), "\u4efb\u52a1\u5df2\u88ab\u529e\u7406\u3002");
        }
        catch (Exception e) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    private void complete(Task task, String userId, Map<String, Object> map) {
        String taskId = task.getId();
        this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"complete");
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        Map<Object, Object> skipMap = new HashMap();
        if (StringUtils.isNotEmpty((CharSequence)userId)) {
            skipMap = this.checkIsAssigneeRepeat(task, userId, map);
        }
        if (skipMap != null) {
            map.putAll(skipMap);
        }
        if (task.getDelegationState() == null) {
            this.taskService.complete(taskId, map);
        } else {
            this.taskService.resolveTask(taskId);
            this.taskService.complete(taskId, map);
        }
    }

    private Map<String, Object> checkIsAssigneeRepeat(Task task, String userId, Map<String, Object> map) {
        Map<String, Object> skipMap = new HashMap<String, Object>();
        BpmnModel bm = this.getBpmnModel(task.getProcessDefinitionId());
        skipMap = this.collectionSkipMap(task, bm, skipMap, userId, task.getTaskDefinitionKey(), map);
        return skipMap;
    }

    private Map<String, Object> collectionSkipMap(Task task, BpmnModel bm, Map<String, Object> skipMap, String userId, String activityId, Map<String, Object> formData) {
        UserTask u;
        UserTask userTask = (UserTask)((Process)bm.getProcesses().get(0)).getFlowElement(activityId);
        List sequenceFlows = userTask.getOutgoingFlows();
        if (sequenceFlows.size() > 1) {
            return skipMap;
        }
        String seqTarRef = ((SequenceFlow)sequenceFlows.get(0)).getTargetRef();
        if (((Process)bm.getProcesses().get(0)).getFlowElement(seqTarRef) instanceof ExclusiveGateway) {
            if (formData == null) {
                return skipMap;
            }
            ExclusiveGateway exclusiveGateway = (ExclusiveGateway)((Process)bm.getProcesses().get(0)).getFlowElement(seqTarRef);
            List sf = exclusiveGateway.getOutgoingFlows();
            for (SequenceFlow s : sf) {
                String ce = s.getConditionExpression();
                if (!this.getResultByELAndFormData(ce, formData)) continue;
                if (!(((Process)bm.getProcesses().get(0)).getFlowElement(s.getTargetRef()) instanceof UserTask)) {
                    return skipMap;
                }
                UserTask u2 = (UserTask)((Process)bm.getProcesses().get(0)).getFlowElement(s.getTargetRef());
                if (u2.getSkipExpression() == null) {
                    return skipMap;
                }
                ArrayList<String> nextNodeList = new ArrayList<String>();
                nextNodeList.add(u2.getId());
                List<Object> list = this.getCandidateUserList(task, bm, nextNodeList);
                Map map = (Map)list.get(0);
                List userList = (List)map.get("list");
                String nodeId = u2.getId();
                nodeId = nodeId.replaceAll("-", "");
                if (userList.contains(userId)) {
                    skipMap.put(nodeId, true);
                } else {
                    skipMap.put(nodeId, false);
                }
                this.collectionSkipMap(task, bm, skipMap, userId, s.getTargetRef(), formData);
                break;
            }
        }
        if (((Process)bm.getProcesses().get(0)).getFlowElement(seqTarRef) instanceof UserTask) {
            u = (UserTask)((Process)bm.getProcesses().get(0)).getFlowElement(seqTarRef);
            if (u.getSkipExpression() == null) {
                return skipMap;
            }
            ArrayList<String> nextNodeList = new ArrayList<String>();
            nextNodeList.add(u.getId());
            List<Object> list = this.getCandidateUserList(task, bm, nextNodeList);
            Map map = (Map)list.get(0);
            List userList = (List)map.get("list");
            String nodeId = u.getId();
            nodeId = nodeId.replaceAll("-", "");
            if (userList.contains(userId)) {
                skipMap.put(nodeId, true);
            } else {
                skipMap.put(nodeId, false);
            }
        } else {
            return skipMap;
        }
        this.collectionSkipMap(task, bm, skipMap, userId, u.getId(), formData);
        return skipMap;
    }

    private void setAssignee(String processInstanceId, Map<String, String> assigneeMap) {
        List taskNow;
        if (assigneeMap != null && (taskNow = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).active().list()) != null && taskNow.size() > 0) {
            for (Task t : taskNow) {
                String tId = t.getId();
                String nodeId = t.getTaskDefinitionKey();
                String assignee = assigneeMap.get(nodeId);
                if (!StringUtils.isNotEmpty((CharSequence)assignee)) continue;
                Set<String> userSet = this.getAssigneeByTaskId(tId);
                for (String user : userSet) {
                    this.taskService.deleteCandidateUser(tId, user);
                }
                List<String> assigneeList = Arrays.asList(assignee.split(","));
                for (String id : assigneeList) {
                    this.taskService.addCandidateUser(tId, id);
                }
            }
        }
    }

    private String installReturnValue(String processInstanceId) {
        ArrayList list = new ArrayList();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
        if (tasks != null && tasks.size() > 0) {
            for (Task t : tasks) {
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                resultMap.put("taskId", t.getId());
                resultMap.put("definitionKey", t.getTaskDefinitionKey());
                resultMap.put("definitionName", t.getName());
                resultMap.put("userId", this.getAssigneeByTaskId(t.getId()));
                list.add(resultMap);
            }
        }
        return ServiceResult.getResult("1", "success", JSON.toJSONString(list));
    }

    @Override
    public String unClaimTask(String taskId) {
        try {
            this.taskService.unclaim(taskId);
            return ServiceResult.getResult("1", "success", "");
        }
        catch (Exception e) {
            LOGGER.error("\u53d6\u6d88\u7b7e\u6536\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    private List<PvmTransition> getPvmTransition(ActivityImpl currActivity, List<PvmTransition> pt) {
        String activityType = "";
        List incomingTransitions = currActivity.getIncomingTransitions();
        for (PvmTransition pv : incomingTransitions) {
            ActivityImpl ai = (ActivityImpl)pv.getSource();
            Map map = ai.getProperties();
            String string = activityType = map.get("type") == null ? "" : map.get("type").toString();
            if (activityType.contains("Gateway")) {
                pt = this.getPvmTransition(ai, pt);
                continue;
            }
            pt.add(pv);
        }
        return pt;
    }

    @Override
    public String rejectToPreTask(String taskId, String comment, Map<String, Object> map) {
        boolean isFirst = false;
        String starterUserId = "";
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String backActivityId = this.getLastActivityId(taskId);
        if (backActivityId != null && backActivityId.equals(this.getFristActivityId(taskId))) {
            starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
            isFirst = true;
        }
        this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"reject");
        this.rejectTask("", taskId, backActivityId, comment, map);
        this.deleteSysActHis(task.getProcessInstanceId(), backActivityId, task.getTaskDefinitionKey());
        return this.installRejectReturnValue(task.getProcessInstanceId(), isFirst, starterUserId);
    }

    @Override
    public String rejectToPreTask(String taskId, String userId, String comment, Map<String, Object> map) {
        boolean isFirst = false;
        String starterUserId = "";
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String backActivityId = this.getLastActivityId(taskId);
        if (backActivityId != null && backActivityId.equals(this.getFristActivityId(taskId))) {
            starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
            isFirst = true;
        }
        this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"reject");
        this.rejectTask(userId, taskId, backActivityId, comment, map);
        this.deleteSysActHis(task.getProcessInstanceId(), backActivityId, task.getTaskDefinitionKey());
        return this.installRejectReturnValue(task.getProcessInstanceId(), isFirst, starterUserId);
    }

    @Override
    public String rejectToPreTask(String taskId, String userId, String comment, String users, Map<String, Object> map) {
        boolean isFirst = false;
        String starterUserId = "";
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String backActivityId = this.getLastActivityId(taskId);
        if (backActivityId != null && backActivityId.equals(this.getFristActivityId(taskId))) {
            starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
            isFirst = true;
        }
        this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"reject");
        this.rejectTask(userId, taskId, backActivityId, comment, map);
        this.deleteSysActHis(task.getProcessInstanceId(), backActivityId, task.getTaskDefinitionKey());
        HashMap<String, String> assigneeMap = new HashMap<String, String>();
        assigneeMap.put(backActivityId, users);
        this.setAssignee(task.getProcessInstanceId(), assigneeMap);
        return this.installRejectReturnValue(task.getProcessInstanceId(), isFirst, starterUserId);
    }

    @Override
    public String rejectToLastTask(String taskId, String userId, String comment, Map<String, Object> map) {
        List tasks;
        String assignee = "";
        ArrayList list = new ArrayList();
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String backActivityId = this.getLastActivityId(taskId);
        this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"reject");
        this.rejectTask(userId, taskId, backActivityId, comment, map);
        this.deleteSysActHis(task.getProcessInstanceId(), backActivityId, task.getTaskDefinitionKey());
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).taskDefinitionKey(backActivityId)).finished().orderByHistoricTaskInstanceEndTime().desc()).list();
        if (hisTaskList != null && hisTaskList.size() > 0) {
            assignee = ((HistoricTaskInstance)hisTaskList.get(0)).getAssignee();
        }
        if (StringUtils.isNotEmpty((CharSequence)assignee) && (tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(task.getProcessInstanceId())).active().taskDefinitionKey(backActivityId)).list()) != null && tasks.size() > 0) {
            for (Task t : tasks) {
                Set<String> userSet = this.getAssigneeByTaskId(t.getId());
                for (String user : userSet) {
                    this.taskService.deleteCandidateUser(t.getId(), user);
                }
                this.taskService.addCandidateUser(t.getId(), assignee);
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                resultMap.put("taskId", t.getId());
                resultMap.put("definitionKey", t.getTaskDefinitionKey());
                resultMap.put("definitionName", t.getName());
                resultMap.put("userId", this.getAssigneeByTaskId(t.getId()));
                list.add(resultMap);
            }
        }
        return ServiceResult.getResult("1", "success", JSON.toJSONString(list));
    }

    @Override
    public String rejectToFristTask(String taskId, String comment, Map<String, Object> map) {
        String starterUserId = "";
        ArrayList list = new ArrayList();
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String firstTaskId = this.getFristActivityId(taskId);
        starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
        this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"reject");
        this.rejectTask("", taskId, firstTaskId, comment, map);
        this.deleteSysActHis(task.getProcessInstanceId(), firstTaskId, task.getTaskDefinitionKey());
        return this.installRejectReturnValue(task.getProcessInstanceId(), true, starterUserId);
    }

    @Override
    public String rejectToFristTask(String taskId, String userId, String comment, Map<String, Object> map) {
        this.claimTask(taskId, userId);
        ArrayList list = new ArrayList();
        String starterUserId = "";
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String firstTaskId = this.getFristActivityId(taskId);
        starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
        this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"reject");
        this.rejectTask(userId, taskId, firstTaskId, comment, map);
        this.deleteSysActHis(task.getProcessInstanceId(), firstTaskId, task.getTaskDefinitionKey());
        return this.installRejectReturnValue(task.getProcessInstanceId(), true, starterUserId);
    }

    @Override
    public String rejectToAnyTask(String taskId, String userId, String backActivityId, String comment, Map<String, Object> map) {
        boolean isFirst = false;
        String starterUserId = "";
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (backActivityId != null && backActivityId.equals(this.getFristActivityId(taskId))) {
            starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
            isFirst = true;
        }
        this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"reject");
        this.rejectTask(userId, taskId, backActivityId, comment, map);
        this.deleteSysActHis(task.getProcessInstanceId(), backActivityId, task.getTaskDefinitionKey());
        return this.installRejectReturnValue(task.getProcessInstanceId(), isFirst, starterUserId);
    }

    @Override
    public String rejectToAnyTask(String taskId, String userId, String backActivityId, String comment, boolean isSubmit, Map<String, Object> map) {
        boolean isFirst = false;
        String starterUserId = "";
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (backActivityId != null && backActivityId.equals(this.getFristActivityId(taskId))) {
            starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
            isFirst = true;
        }
        this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"reject");
        this.rejectTask(userId, taskId, backActivityId, comment, map);
        this.deleteSysActHis(task.getProcessInstanceId(), backActivityId, task.getTaskDefinitionKey());
        if (!isSubmit) {
            return this.installRejectReturnValue(task.getProcessInstanceId(), isFirst, starterUserId);
        }
        return this.installRejectReturnValue(task.getProcessInstanceId(), backActivityId);
    }

    private String installRejectReturnValue(String processInstanceId, boolean isFirst, String starterUserId) {
        ArrayList list = new ArrayList();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).active().list();
        if (tasks != null && tasks.size() > 0) {
            for (Task t : tasks) {
                List identityLinkList = this.taskService.getIdentityLinksForTask(t.getId());
                if (isFirst && t.getAssignee() == null && StringUtils.isNotEmpty((CharSequence)starterUserId) && (identityLinkList == null || identityLinkList.size() == 0)) {
                    this.taskService.setAssignee(t.getId(), starterUserId);
                }
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                resultMap.put("taskId", t.getId());
                resultMap.put("definitionKey", t.getTaskDefinitionKey());
                resultMap.put("definitionName", t.getName());
                resultMap.put("userId", this.getAssigneeByTaskId(t.getId()));
                list.add(resultMap);
            }
        }
        return ServiceResult.getResult("1", "success", JSON.toJSONString(list));
    }

    private String installRejectReturnValue(String processInstanceId, String backActivityId) {
        String assignee = "";
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).taskDefinitionKey(backActivityId)).finished().orderByHistoricTaskInstanceEndTime().desc()).list();
        if (hisTaskList != null && hisTaskList.size() > 0) {
            assignee = ((HistoricTaskInstance)hisTaskList.get(0)).getAssignee();
        }
        ArrayList list = new ArrayList();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).active().list();
        if (tasks != null && tasks.size() > 0) {
            for (Task t : tasks) {
                if (t.getTaskDefinitionKey().equals(backActivityId)) {
                    Set<String> userSet = this.getAssigneeByTaskId(t.getId());
                    for (String user : userSet) {
                        this.taskService.deleteCandidateUser(t.getId(), user);
                    }
                    this.taskService.addCandidateUser(t.getId(), assignee);
                }
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                resultMap.put("taskId", t.getId());
                resultMap.put("definitionKey", t.getTaskDefinitionKey());
                resultMap.put("definitionName", t.getName());
                resultMap.put("userId", this.getAssigneeByTaskId(t.getId()));
                list.add(resultMap);
            }
        }
        return ServiceResult.getResult("1", "success", JSON.toJSONString(list));
    }

    private void deleteSysActHis(String processInstanceId, String startId, String endId) {
        List<SysActHiLine> sysActHiLines = this.iSysActHiLineService.getSysActHiLineByProcessinsId(processInstanceId);
        ArrayList<SysActHiLine> result = new ArrayList<SysActHiLine>();
        TaskWebServiceImpl.getResult(sysActHiLines, result, startId, endId);
        if (result.size() > 0) {
            this.iSysActHiLineService.deleteSysActHis(result);
        }
    }

    public static List<SysActHiLine> getResult(List<SysActHiLine> list, List<SysActHiLine> result, String startId, String endId) {
        List l1 = list.stream().filter(lineHis -> startId.equals(lineHis.getOutNode())).collect(Collectors.toList());
        if (l1.size() > 0) {
            if (endId.equals(((SysActHiLine)((Object)l1.get(0))).getInNode())) {
                result.add((SysActHiLine)((Object)l1.get(0)));
                return result;
            }
            result.add((SysActHiLine)((Object)l1.get(0)));
            TaskWebServiceImpl.getResult(list, result, ((SysActHiLine)((Object)l1.get(0))).getInNode(), endId);
        }
        return result;
    }

    private void rejectTask(String userId, String taskId, String backActivityId, String comment, Map<String, Object> map) {
        int backType = this.backType(taskId);
        if (StringUtils.isNotEmpty((CharSequence)comment)) {
            this.taskService.addComment(taskId, null, "complete", comment);
        }
        switch (backType) {
            case 1: {
                this.commonReject(userId, taskId, backActivityId, map);
                break;
            }
            case 2: {
                this.multiInstanceReject(userId, taskId, backActivityId, map);
                break;
            }
            case 3: {
                this.parallelReject(userId, taskId, backActivityId, map);
                break;
            }
            default: {
                this.commonReject(userId, taskId, backActivityId, map);
            }
        }
    }

    private void parallelReject(String userId, String taskId, String backActivityId, Map<String, Object> map) {
        if (StringUtils.isNotEmpty((CharSequence)userId)) {
            this.claimTask(taskId, userId);
        }
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String processDefinition = task.getProcessDefinitionId();
        ReadOnlyProcessDefinition processDefinitionEntity = (ReadOnlyProcessDefinition)this.repositoryService.getProcessDefinition(processDefinition);
        ActivityImpl destinationActivity = (ActivityImpl)processDefinitionEntity.findActivity(backActivityId);
        String executionId = task.getExecutionId();
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId(task.getTaskDefinitionKey()).singleResult();
        String parentId = execution.getParentId();
        ActivityImpl currentActivity = (ActivityImpl)processDefinitionEntity.findActivity(task.getTaskDefinitionKey());
        this.processEngine.getManagementService().executeCommand((Command)new ParallelJumpTaskCmd(userId, executionId, parentId, destinationActivity, map, currentActivity));
    }

    private void commonReject(String userId, String taskId, String backActivityId, Map<String, Object> map) {
        if (StringUtils.isNotEmpty((CharSequence)userId)) {
            this.claimTask(taskId, userId);
        }
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String processDefinition = task.getProcessDefinitionId();
        ReadOnlyProcessDefinition processDefinitionEntity = (ReadOnlyProcessDefinition)this.repositoryService.getProcessDefinition(processDefinition);
        ActivityImpl destinationActivity = (ActivityImpl)processDefinitionEntity.findActivity(backActivityId);
        String executionId = task.getExecutionId();
        String parentId = task.getExecutionId();
        ActivityImpl currentActivity = (ActivityImpl)processDefinitionEntity.findActivity(task.getTaskDefinitionKey());
        this.processEngine.getManagementService().executeCommand((Command)new CommonJumpTaskCmd(executionId, parentId, destinationActivity, map, currentActivity));
    }

    private void multiInstanceReject(String userId, String taskId, String backActivityId, Map<String, Object> map) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String processDefinition = task.getProcessDefinitionId();
        ReadOnlyProcessDefinition processDefinitionEntity = (ReadOnlyProcessDefinition)this.repositoryService.getProcessDefinition(processDefinition);
        ActivityImpl destinationActivity = (ActivityImpl)processDefinitionEntity.findActivity(backActivityId);
        String executionId = task.getExecutionId();
        List execution = this.runtimeService.createExecutionQuery().activityId(task.getTaskDefinitionKey()).list();
        String parentId = ((Execution)execution.get(0)).getParentId();
        ActivityImpl currentActivity = (ActivityImpl)processDefinitionEntity.findActivity(task.getTaskDefinitionKey());
        this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceJumpTaskCmd(userId, executionId, parentId, destinationActivity, map, currentActivity));
    }

    private String getLastActivityId(String taskId) {
        ArrayList<PvmTransition> pt;
        String backActivityId = "";
        HistoricTaskInstance currTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
        List list = ((HistoricActivityInstanceQuery)this.processEngine.getHistoryService().createHistoricActivityInstanceQuery().processInstanceId(currTask.getProcessInstanceId()).orderByHistoricActivityInstanceEndTime().activityType(this.userTask).finished().desc()).list();
        ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(currTask.getProcessDefinitionId());
        ActivityImpl currActivity = definition.findActivity(currTask.getTaskDefinitionKey());
        List<PvmTransition> incomingTransitions = this.getPvmTransition(currActivity, pt = new ArrayList<PvmTransition>());
        if (incomingTransitions != null && incomingTransitions.size() > 0) {
            for (HistoricActivityInstance his : list) {
                for (int i = 0; i < incomingTransitions.size(); ++i) {
                    String id = incomingTransitions.get(i).getSource().getId();
                    if (!id.equals(his.getActivityId())) continue;
                    backActivityId = id;
                    return backActivityId;
                }
            }
        }
        return null;
    }

    private String getFristActivityId(String taskId) {
        String allNodeInfo = this.queryHistoryActByTaskId(taskId);
        JSONObject object = JSONObject.parseObject((String)allNodeInfo);
        String resultStr = object.get((Object)"result") == null ? "" : object.get((Object)"result").toString();
        JSONArray jsonArray = JSONArray.parseArray((String)JSONObject.parseObject((String)resultStr).get((Object)"data").toString());
        JSONObject jsonObject = new JSONObject();
        if (jsonArray != null && jsonArray.size() > 0) {
            jsonObject = jsonArray.getJSONObject(jsonArray.size() - 1);
        }
        return jsonObject.getString("nodeId") == null ? "" : jsonObject.getString("nodeId");
    }

    @Override
    public String delegateTask(String taskId, String userId) {
        try {
            this.taskService.delegateTask(taskId, userId);
            return ServiceResult.getResult("1", "success", "");
        }
        catch (Exception e) {
            LOGGER.error("\u4efb\u52a1\u59d4\u6258\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String freeJump(String taskId, String activitiId) {
        try {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            if (task != null) {
                String excId = task.getExecutionId();
                TaskServiceImpl taskServiceImpl = (TaskServiceImpl)this.taskService;
                taskServiceImpl.getCommandExecutor().execute((Command)new ActivitiJumpCommand(excId, activitiId));
            }
            return ServiceResult.getResult("1", "success", "");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String getCurrNodeInfoByTaskId(String taskId) {
        try {
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).list();
            String re = JSONArray.toJSONString(this.tasksToMap(tasks));
            return ServiceResult.getResult("1", "success", re);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String lastUserTask(String taskId) {
        boolean flag = false;
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        try {
            if (task != null) {
                String excId = task.getExecutionId();
                ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(excId).singleResult();
                String activitiId = execution.getActivityId();
                ProcessDefinitionEntity def = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
                ActivityImpl activity = def.findActivity(activitiId);
                List outTransitions = activity.getOutgoingTransitions();
                for (PvmTransition pt : outTransitions) {
                    PvmActivity pa = pt.getDestination();
                    if (pa.getParent() != null) {
                        if (pa.getParent().getProperty("type") != null) {
                            List subOutTransitions;
                            String parentType = String.valueOf(pa.getParent().getProperty("type"));
                            if (!this.subProcess.equals(parentType) || (subOutTransitions = ((ActivityImpl)pa.getParent()).getOutgoingTransitions()).size() <= 0) continue;
                            for (PvmTransition tr : subOutTransitions) {
                                PvmActivity p = tr.getDestination();
                                if (!"endEvent".equals(p.getProperty("type"))) continue;
                                flag = true;
                            }
                            continue;
                        }
                        if (!"endEvent".equals(pa.getProperty("type"))) continue;
                        flag = true;
                        continue;
                    }
                    if (!"endEvent".equals(pa.getProperty("type"))) continue;
                    flag = true;
                }
            }
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put("flag", flag);
            return ServiceResult.getResult("1", "success", JSON.toJSONString(map));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String queryNextActivitiListByTaskId(String taskId) {
        JSONArray list = new JSONArray();
        JSONObject json = new JSONObject();
        JSONObject curJson = new JSONObject();
        try {
            if (StringUtils.isNotBlank((CharSequence)taskId)) {
                String formKeyExpression;
                Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
                String excId = task.getExecutionId();
                ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(excId).singleResult();
                String activitiId = execution.getActivityId();
                ProcessDefinitionEntity def = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
                ActivityImpl activity = def.findActivity(activitiId);
                TaskDefinition curtask = (TaskDefinition)activity.getProperty("taskDefinition");
                Expression curProp = curtask.getFormKeyExpression();
                StringBuilder curUserProp = new StringBuilder();
                if (curProp != null && StringUtils.isNotBlank((CharSequence)(formKeyExpression = curProp.getExpressionText()))) {
                    String[] keys = formKeyExpression.split(",");
                    for (int i = 0; i < keys.length; ++i) {
                        String key = keys[i];
                        curUserProp.append(key.substring(key.indexOf("[") + 1, key.indexOf("]"))).append(",");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)curUserProp.toString())) {
                    if (curUserProp.toString().contains("6")) {
                        curJson.put("firstUser", (Object)this.getStartPersionId(excId, def));
                    }
                    curUserProp = new StringBuilder(curUserProp.substring(0, curUserProp.length() - 1));
                }
                curJson.put("nextUserProp", (Object)curUserProp.toString());
                List outTransitions = activity.getOutgoingTransitions();
                for (PvmTransition pt : outTransitions) {
                    String formKeyExpression2;
                    PvmActivity pa = pt.getDestination();
                    String actype = String.valueOf(pa.getProperty("type"));
                    if (!this.userTask.equals(actype)) {
                        List<JSONObject> jsonlist = this.userActivityImpl(pa, "");
                        list.addAll(jsonlist);
                        continue;
                    }
                    JSONObject jsonStr = new JSONObject();
                    jsonStr.put("nodeType", (Object)actype);
                    jsonStr.put("nodeId", (Object)pa.getId());
                    jsonStr.put("gateway", (Object)"");
                    jsonStr.put("nodeName", (Object)String.valueOf(pa.getProperty("name")));
                    jsonStr.put("condition", (Object)"");
                    TaskDefinition t = (TaskDefinition)pa.getProperty("taskDefinition");
                    Expression duedate = t.getDueDateExpression();
                    if (duedate != null) {
                        jsonStr.put("duedate", (Object)duedate.getExpressionText());
                    } else {
                        jsonStr.put("duedate", (Object)"");
                    }
                    String users = "";
                    users = t.getCandidateUserIdExpressions().toString();
                    if (StringUtils.isNotBlank((CharSequence)users)) {
                        json.put("users", (Object)users);
                    }
                    jsonStr.put("users", (Object)users);
                    Expression nextProp = t.getFormKeyExpression();
                    StringBuilder nextUserProp = new StringBuilder();
                    if (nextProp != null && StringUtils.isNotBlank((CharSequence)(formKeyExpression2 = nextProp.getExpressionText()))) {
                        String[] keys = formKeyExpression2.split(",");
                        for (int j = 0; j < keys.length; ++j) {
                            String key = keys[j];
                            nextUserProp.append(key.substring(key.indexOf("[") + 1, key.indexOf("]"))).append(",");
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)nextUserProp.toString())) {
                        if (nextUserProp.toString().contains("6")) {
                            jsonStr.put("firstUser", (Object)this.getStartPersionId(excId, def));
                        }
                        nextUserProp = new StringBuilder(nextUserProp.substring(0, nextUserProp.length() - 1));
                    }
                    jsonStr.put("nextUserProp", (Object)nextUserProp.toString());
                    list.add((Object)jsonStr);
                }
            }
            json.put("array", (Object)list);
            json.put("current", (Object)curJson);
            return ServiceResult.getResult("1", "success", JSON.toJSONString((Object)json));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5f53\u524d\u8282\u70b9\u4e0b\u4e00\u4eba\u5de5\u73af\u8282\u51fa\u9519" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    private String getStartPersionId(String excId, ProcessDefinitionEntity def) {
        String startUser = "";
        HistoricActivityInstance hisBean = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityType(this.startAct).processInstanceId(excId).singleResult();
        startUser = hisBean.getAssignee();
        if (startUser == null || "".equals(startUser)) {
            String actId = hisBean.getActivityId();
            ActivityImpl activity = def.findActivity(actId);
            PvmTransition outTransitions = (PvmTransition)activity.getOutgoingTransitions().get(0);
            PvmActivity p = outTransitions.getDestination();
            String firstActId = p.getId();
            hisBean = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId(firstActId).processInstanceId(excId).singleResult();
            startUser = hisBean.getAssignee();
        }
        return startUser;
    }

    private List<JSONObject> userActivityImpl(PvmActivity pa, String conditionText) {
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        String actype = String.valueOf(pa.getProperty("type"));
        if (!this.userTask.equals(actype)) {
            if (this.subProcess.equals(actype)) {
                List subProcessActivitis = pa.getActivities();
                for (ActivityImpl act : subProcessActivitis) {
                    if (!this.startAct.equals(act.getProperty("type"))) continue;
                    List outTransitions = act.getOutgoingTransitions();
                    if (outTransitions.size() > 0) {
                        for (PvmTransition tr : outTransitions) {
                            StringBuffer condition = new StringBuffer("");
                            if (!"".equals(conditionText)) {
                                condition.append(conditionText);
                            }
                            if (tr.getProperty("conditionText") != null) {
                                if (condition.length() > 0) {
                                    condition.append(";");
                                }
                                condition.append(tr.getProperty("conditionText"));
                            }
                            PvmActivity ac = tr.getDestination();
                            List<JSONObject> temp = this.userActivityImpl(ac, condition.toString());
                            list.addAll(temp);
                        }
                    }
                    break;
                }
            } else if (this.endAct.equals(actype)) {
                if (pa.getParent() != null) {
                    if (pa.getParent().getProperty("type") != null) {
                        List outTransitions;
                        String parentType = String.valueOf(pa.getParent().getProperty("type"));
                        if (this.subProcess.equals(parentType) && (outTransitions = ((ActivityImpl)pa.getParent()).getOutgoingTransitions()).size() > 0) {
                            outTransitions = (List)((Object)outTransitions.iterator());
                            while (((Iterator)((Object)outTransitions)).hasNext()) {
                                Object tr = ((Iterator)((Object)outTransitions)).next();
                                StringBuffer condition = new StringBuffer("");
                                if (!"".equals(conditionText)) {
                                    condition.append(conditionText);
                                }
                                if (((PvmTransition)tr).getProperty("conditionText") != null) {
                                    if (condition.length() > 0) {
                                        condition.append(";");
                                    }
                                    condition.append(((PvmTransition)tr).getProperty("conditionText"));
                                }
                                PvmActivity ac = ((PvmTransition)tr).getDestination();
                                List<JSONObject> temp = this.userActivityImpl(ac, condition.toString());
                                list.addAll(temp);
                            }
                        }
                    } else if ("ParallelGateway".equals(actype)) {
                        JSONObject json = new JSONObject();
                        json.put("nodeType", (Object)actype);
                        json.put("nodeId", (Object)pa.getId());
                        json.put("nodeName", (Object)String.valueOf(pa.getProperty("name")));
                        json.put("condition", (Object)conditionText);
                        list.add(json);
                    } else {
                        JSONObject json = new JSONObject();
                        json.put("nodeType", (Object)actype);
                        json.put("nodeId", (Object)pa.getId());
                        json.put("nodeName", (Object)(pa.getProperty("name") == null ? "\u7ed3\u675f" : String.valueOf(pa.getProperty("name"))));
                        json.put("condition", (Object)conditionText);
                        list.add(json);
                    }
                }
            } else {
                List outTransitions = pa.getOutgoingTransitions();
                if (outTransitions.size() > 0) {
                    for (PvmTransition pv : outTransitions) {
                        StringBuffer condition = new StringBuffer("");
                        if (StringUtils.isNotBlank((CharSequence)conditionText)) {
                            condition.append(conditionText);
                        }
                        if (pv.getProperty("conditionText") != null) {
                            String judge = pv.getProperty("conditionText").toString();
                            if ((judge = judge.substring(judge.indexOf("==") + 2, judge.length() - 1)).equals(conditionText)) continue;
                            if (condition.length() > 0) {
                                condition.append(";");
                            }
                            condition.append(pv.getProperty("conditionText"));
                        }
                        PvmActivity ac = pv.getDestination();
                        List<JSONObject> temp = this.userActivityImpl(ac, condition.toString());
                        list.addAll(temp);
                    }
                }
            }
        } else {
            String formKeyExpression;
            TaskDefinition t;
            Expression duedate;
            String parentType;
            JSONObject json = new JSONObject();
            json.put("nodeType", (Object)actype);
            json.put("nodeId", (Object)pa.getId());
            json.put("nodeName", (Object)String.valueOf(pa.getProperty("name")));
            json.put("condition", (Object)conditionText);
            List incoming = pa.getIncomingTransitions();
            if (pa.getParent() != null && pa.getParent().getProperty("type") != null && this.subProcess.equals(parentType = String.valueOf(pa.getParent().getProperty("type")))) {
                incoming = ((ActivityImpl)pa.getParent()).getIncomingTransitions();
            }
            if (incoming != null && !incoming.isEmpty()) {
                String type = String.valueOf(((PvmTransition)incoming.get(0)).getSource().getProperty("type"));
                if (StringUtils.isNotBlank((CharSequence)conditionText)) {
                    for (PvmTransition inc : incoming) {
                        Object condi = inc.getProperty("conditionText");
                        if (condi == null || !String.valueOf(condi).equalsIgnoreCase(conditionText)) continue;
                        type = String.valueOf(inc.getSource().getProperty("type"));
                        break;
                    }
                }
                if ("ParallelGateway".equalsIgnoreCase(type)) {
                    json.put("gateway", (Object)"parallel");
                } else if ("ExclusiveGateway".equalsIgnoreCase(type)) {
                    json.put("gateway", (Object)"exclusive");
                } else if ("InclusiveGateway".equalsIgnoreCase(type)) {
                    json.put("gateway", (Object)"inclusive");
                } else {
                    json.put("gateway", (Object)"");
                }
            }
            if ((duedate = (t = (TaskDefinition)pa.getProperty("taskDefinition")).getDueDateExpression()) != null) {
                json.put("duedate", (Object)duedate.getExpressionText());
            } else {
                json.put("duedate", (Object)"");
            }
            String users = "";
            users = t.getCandidateUserIdExpressions().toString();
            if (StringUtils.isNotBlank((CharSequence)users)) {
                json.put("users", (Object)users);
            }
            Expression nextProp = t.getFormKeyExpression();
            StringBuilder nextUserProp = new StringBuilder();
            if (nextProp != null && StringUtils.isNotBlank((CharSequence)(formKeyExpression = nextProp.getExpressionText()))) {
                String[] keys = formKeyExpression.split(",");
                for (int i = 0; i < keys.length; ++i) {
                    String key = keys[i];
                    nextUserProp.append(key.substring(key.indexOf("[") + 1, key.indexOf("]"))).append(",");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)nextUserProp.toString())) {
                nextUserProp = new StringBuilder(nextUserProp.substring(0, nextUserProp.length() - 1));
            }
            json.put("nextUserProp", (Object)nextUserProp.toString());
            list.add(json);
        }
        return list;
    }

    @Override
    public String queryAssigneeByTaskId(String taskId) {
        Set<String> users = null;
        try {
            users = this.getAssigneeByTaskId(taskId);
            return ServiceResult.getResult("1", "success", JSON.toJSONString(users));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String queryNextAssigneeByTaskId(String taskId, Map<String, String> formData) {
        try {
            List sf;
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            BpmnModel bm = this.getBpmnModel(task.getProcessDefinitionId());
            ArrayList<String> nextNodeList = new ArrayList<String>();
            UserTask userTask = (UserTask)((Process)bm.getProcesses().get(0)).getFlowElement(task.getTaskDefinitionKey());
            List sequenceFlows = userTask.getOutgoingFlows();
            String seqTarRef = ((SequenceFlow)sequenceFlows.get(0)).getTargetRef();
            if (((Process)bm.getProcesses().get(0)).getFlowElement(seqTarRef) instanceof ExclusiveGateway) {
                if (formData == null) {
                    return ServiceResult.getResult("0", "error", "\u53c2\u6570\u53d8\u91cf\u548c\u53c2\u6570\u503c\u4e0d\u80fd\u4e3a\u7a7a!");
                }
                ExclusiveGateway exclusiveGateway = (ExclusiveGateway)((Process)bm.getProcesses().get(0)).getFlowElement(seqTarRef);
                sf = exclusiveGateway.getOutgoingFlows();
                for (SequenceFlow s : sf) {
                    String ce = s.getConditionExpression();
                    if (!this.getResultByELAndFormData(ce, formData)) continue;
                    nextNodeList.add(s.getTargetRef());
                    break;
                }
            }
            if (((Process)bm.getProcesses().get(0)).getFlowElement(seqTarRef) instanceof ParallelGateway) {
                ParallelGateway parallelGateway = (ParallelGateway)((Process)bm.getProcesses().get(0)).getFlowElement(seqTarRef);
                sf = parallelGateway.getOutgoingFlows();
                for (SequenceFlow s : sf) {
                    nextNodeList.add(s.getTargetRef());
                }
            }
            if (((Process)bm.getProcesses().get(0)).getFlowElement(seqTarRef) instanceof UserTask) {
                UserTask u = (UserTask)((Process)bm.getProcesses().get(0)).getFlowElement(seqTarRef);
                nextNodeList.add(u.getId());
            }
            List<Object> list = this.getCandidateUserList(task, bm, nextNodeList);
            return ServiceResult.getResult("1", "success", JSON.toJSONString(list));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u8282\u70b9\u53c2\u4e0e\u8005\u51fa\u9519\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    private BpmnModel getBpmnModel(String processDefinitionId) {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processDefinitionId);
        InputStream xmlIs = this.repositoryService.getResourceAsStream(processDefinition.getDeploymentId(), processDefinition.getResourceName());
        return new BpmnXMLConverter().convertToBpmnModel((InputStreamProvider)new InputStreamSource(xmlIs), false, true);
    }

    private boolean getResultByELAndFormData(String el, Map formData) {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = new SimpleContext();
        for (Object k : formData.keySet()) {
            if (formData.get(k) == null) continue;
            context.setVariable(k.toString(), factory.createValueExpression(formData.get(k), formData.get(k).getClass()));
        }
        ValueExpression e = factory.createValueExpression((ELContext)context, el, Boolean.TYPE);
        return (Boolean)e.getValue((ELContext)context);
    }

    private List<Object> getCandidateUserList(Task task, BpmnModel bm, List<String> nextNodeList) {
        String userId = "";
        List<Object> userList = new ArrayList();
        List<String> deptsList = null;
        List<String> rolesList = null;
        ArrayList<Object> finList = new ArrayList<Object>();
        if (nextNodeList != null && nextNodeList.size() > 0) {
            for (String nodeId : nextNodeList) {
                Map extensionElements;
                Boolean currentdept;
                if (!(((Process)bm.getProcesses().get(0)).getFlowElement(nodeId) instanceof UserTask)) {
                    return finList;
                }
                UserTask userTask = (UserTask)((Process)bm.getProcesses().get(0)).getFlowElement(nodeId);
                Map extensionAttribute = userTask.getAttributes();
                List deptAttribute = (List)extensionAttribute.get("candidateDepts");
                List roleAttribute = (List)extensionAttribute.get("candidateRoles");
                if (deptAttribute != null && deptAttribute.size() > 0) {
                    String candidateDepts = ((ExtensionAttribute)deptAttribute.get(0)).getValue();
                    deptsList = Arrays.asList(candidateDepts.split(","));
                }
                if (roleAttribute != null && roleAttribute.size() > 0) {
                    String candidateRoles = ((ExtensionAttribute)roleAttribute.get(0)).getValue();
                    rolesList = Arrays.asList(candidateRoles.split(","));
                }
                if ((currentdept = Boolean.valueOf(Boolean.parseBoolean(String.valueOf((extensionElements = ((Process)bm.getProcesses().get(0)).getFlowElement(nodeId).getExtensionElements()).get("currentdept"))))).booleanValue()) {
                    userId = this.getTaskStarterUserId(task.getProcessInstanceId());
                    deptsList = this.iAssigneeChooseService.getFlowStarterDept(userId);
                }
                userList = deptsList == null && rolesList == null ? new ArrayList() : this.iAssigneeChooseService.getUserList(deptsList, rolesList);
                List candidateList = userTask.getCandidateUsers();
                if (candidateList != null && candidateList.size() > 0) {
                    userList.addAll(candidateList);
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("nodeId", nodeId);
                map.put("nodeName", userTask.getName());
                map.put("list", userList);
                finList.add(map);
            }
        }
        return finList;
    }

    private Set<String> getAssigneeByTaskId(String taskId) {
        HashSet<String> users = new HashSet<String>();
        List identityLinkList = this.taskService.getIdentityLinksForTask(taskId);
        if (identityLinkList != null && identityLinkList.size() > 0) {
            for (IdentityLink identityLink : identityLinkList) {
                users.add(identityLink.getUserId());
            }
        }
        return users;
    }

    @Override
    public String queryHistoryActByTaskId(String taskId) {
        ArrayList hisList = new ArrayList();
        HashMap<String, Object> mapResult = new HashMap<String, Object>();
        try {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            if (task != null) {
                String processInstanceId = task.getProcessInstanceId();
                List list = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().activityType(this.userTask).processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().desc()).list();
                if (list != null && list.size() > 0) {
                    for (HistoricActivityInstance historyIns : list) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        String tId = historyIns.getTaskId();
                        if (tId.equals(taskId)) continue;
                        map.put("nodeId", historyIns.getActivityId());
                        map.put("nodeName", historyIns.getActivityName());
                        map.put("taskId", tId);
                        map.put("endTime", historyIns.getEndTime() == null ? null : Long.valueOf(historyIns.getEndTime().getTime()));
                        hisList.add(map);
                    }
                }
            }
            mapResult.put("data", JSONArray.toJSONString(hisList));
            mapResult.put("count", hisList.size());
            return ServiceResult.getResult("1", "success", JSON.toJSONString(mapResult));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5386\u53f2\u73af\u8282\u4fe1\u606f\u63a5\u53e3\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    private List<Map<String, Object>> tasksToMap(List<Task> tasks) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        HashSet<String> processInstanceIds = new HashSet<String>();
        ArrayList<ProcessInstance> pis = new ArrayList();
        if (tasks != null && tasks.size() > 0) {
            for (Task t : tasks) {
                processInstanceIds.add(t.getProcessInstanceId());
            }
            pis = this.runtimeService.createProcessInstanceQuery().processInstanceIds(processInstanceIds).list();
        }
        if (tasks != null && tasks.size() > 0) {
            for (int i = 0; i < tasks.size(); ++i) {
                HashMap<String, Object> taskMap = new HashMap<String, Object>();
                Task task = tasks.get(i);
                Map variables = task.getProcessVariables();
                Map taskVariables = task.getTaskLocalVariables();
                ProcessInstance pi = this.getProcessInstance(pis, task.getProcessInstanceId());
                taskMap.put("taskId", task.getId());
                taskMap.put("name", task.getName());
                taskMap.put("assignee", task.getAssignee());
                taskMap.put("definitionKey", pi.getProcessDefinitionKey());
                taskMap.put("definitionId", task.getProcessDefinitionId());
                taskMap.put("definitionName", pi.getProcessDefinitionName());
                taskMap.put("taskDefinitionKey", task.getTaskDefinitionKey());
                taskMap.put("processInsId", task.getProcessInstanceId());
                taskMap.put("createTime", task.getCreateTime());
                taskMap.put("bussinessId", pi.getBusinessKey());
                taskMap.put("variables", variables);
                taskMap.put("taskVariables", taskVariables);
                taskMap.put("taskSourceFlag", taskVariables.get("taskSourceFlag"));
                taskMap.put("formKey", task.getFormKey());
                list.add(taskMap);
            }
        }
        return list;
    }

    private ProcessInstance getProcessInstance(List<ProcessInstance> pis, String processInstanceId) {
        if (pis != null && pis.size() > 0) {
            for (ProcessInstance p : pis) {
                if (!p.getId().equals(processInstanceId)) continue;
                return p;
            }
        }
        return null;
    }

    private List<Map<String, Object>> hisTasksToMap(List<HistoricTaskInstance> hs) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        HashSet<String> processInstanceIds = new HashSet<String>();
        ArrayList<HistoricProcessInstance> pis = new ArrayList();
        if (hs != null && hs.size() > 0) {
            for (HistoricTaskInstance h : hs) {
                processInstanceIds.add(h.getProcessInstanceId());
            }
            pis = this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(processInstanceIds).list();
        }
        if (hs != null && hs.size() > 0) {
            for (HistoricTaskInstance hsi : hs) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                HistoricProcessInstance hpi = this.getHistoricProcessInstance(pis, hsi.getProcessInstanceId());
                Map variables = hsi.getProcessVariables();
                Map taskVariables = hsi.getTaskLocalVariables();
                map.put("taskId", hsi.getId());
                map.put("name", hsi.getName());
                map.put("assignee", hsi.getAssignee());
                map.put("definitionId", hsi.getProcessDefinitionId());
                map.put("definitionKey", hpi.getProcessDefinitionKey());
                map.put("definitionName", hpi.getProcessDefinitionName());
                map.put("taskDefinitionKey", hsi.getTaskDefinitionKey());
                map.put("processInsId", hsi.getProcessInstanceId());
                map.put("claimTime", hsi.getClaimTime());
                map.put("startTime", hsi.getStartTime());
                map.put("bussinessId", hpi.getBusinessKey());
                map.put("variables", variables);
                map.put("taskVariables", taskVariables);
                map.put("taskSourceFlag", taskVariables.get("taskSourceFlag"));
                map.put("endTime", hsi.getEndTime());
                map.put("formKey", hsi.getFormKey());
                list.add(map);
            }
        }
        return list;
    }

    private HistoricProcessInstance getHistoricProcessInstance(List<HistoricProcessInstance> pis, String processInstanceId) {
        if (pis != null && pis.size() > 0) {
            for (HistoricProcessInstance p : pis) {
                if (!p.getId().equals(processInstanceId)) continue;
                return p;
            }
        }
        return null;
    }

    @Override
    public String queryTaskIdByBusinessKey(String businessId) {
        try {
            List task = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(businessId)).list();
            ArrayList<String> list = new ArrayList<String>();
            if (task != null) {
                for (int i = 0; i < task.size(); ++i) {
                    list.add(((Task)task.get(i)).getId());
                }
            }
            return ServiceResult.getResult("1", "success", JSONArray.toJSONString(list));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5f85\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String withdrawState(String historicTaskId) {
        String result = "false";
        try {
            HistoricTaskInstance currTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(historicTaskId)).singleResult();
            ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(currTask.getProcessInstanceId()).singleResult();
            if (instance == null) {
                LOGGER.error("\u51fa\u9519\u5566\uff01\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f");
                return ServiceResult.getResult("0", "\u51fa\u9519\u5566\uff01\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f", "");
            }
            ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(currTask.getProcessDefinitionId());
            if (definition == null) {
                return ServiceResult.getResult("0", "\u51fa\u9519\u5566\uff01\u6d41\u7a0b\u5b9a\u4e49\u672a\u627e\u5230", "");
            }
            ActivityImpl currActivity = definition.findActivity(currTask.getTaskDefinitionKey());
            List nextTransitionList = currActivity.getOutgoingTransitions();
            for (PvmTransition nextTransition : nextTransitionList) {
                List nextTransitionLists;
                PvmActivity nextActivity = nextTransition.getDestination();
                if ("parallelGateway".equals(nextActivity.getProperty("type"))) {
                    nextTransitionLists = nextActivity.getOutgoingTransitions();
                    boolean flag = false;
                    for (PvmTransition nextTransitions : nextTransitionLists) {
                        PvmActivity nextActivitys = nextTransitions.getDestination();
                        List hisList = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(instance.getId()).activityId(nextActivitys.getId()).unfinished().list();
                        if (hisList == null || hisList.size() <= 0) continue;
                        flag = true;
                    }
                    if (!flag) continue;
                    result = "true";
                    continue;
                }
                if ("exclusiveGateway".equals(nextActivity.getProperty("type"))) {
                    nextTransitionLists = nextActivity.getOutgoingTransitions();
                    for (PvmTransition nextTransitions : nextTransitionLists) {
                        PvmActivity nextActivitys = nextTransitions.getDestination();
                        List hisList = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(instance.getId()).activityId(nextActivitys.getId()).unfinished().list();
                        if (hisList == null || hisList.size() <= 0) continue;
                        result = "true";
                    }
                    continue;
                }
                List hisList = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(instance.getId()).activityId(nextActivity.getId()).unfinished().list();
                if (hisList != null && hisList.size() > 0) {
                    result = "true";
                    continue;
                }
                result = "false";
            }
            return ServiceResult.getResult("1", "success", result);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u80fd\u5426\u9a73\u56de\u51fa\u9519\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), result);
        }
    }

    @Override
    public String revokeTask(String bussinessId, String userId, String comment, Map<String, Object> map) {
        ArrayList list = new ArrayList();
        List taskList = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(bussinessId)).list();
        if (taskList != null && taskList.size() > 0) {
            Task task = (Task)taskList.get(0);
            String taskId = task.getId();
            task.setAssignee(userId);
            boolean isFirst = false;
            String starterUserId = "";
            String backActivityId = this.getLastActivityId(taskId);
            if (backActivityId != null && backActivityId.equals(this.getFristActivityId(taskId))) {
                starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
                isFirst = true;
            }
            this.deleteSysActHis(task.getProcessInstanceId(), backActivityId, task.getTaskDefinitionKey());
            this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"revoke");
            this.rejectTask(userId, taskId, backActivityId, comment, map);
            return this.installRejectReturnValue(task.getProcessInstanceId(), isFirst, starterUserId);
        }
        return ServiceResult.getResult("0", "error", null);
    }

    @Override
    public String revokeTask(String bussinessId, String userId, String comment, boolean isSubmit, Map<String, Object> map) {
        ArrayList list = new ArrayList();
        List taskList = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(bussinessId)).list();
        if (taskList != null && taskList.size() > 0) {
            Task task = (Task)taskList.get(0);
            String taskId = task.getId();
            task.setAssignee(userId);
            boolean isFirst = false;
            String starterUserId = "";
            String backActivityId = this.getLastActivityId(taskId);
            if (backActivityId != null && backActivityId.equals(this.getFristActivityId(taskId))) {
                starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
                isFirst = true;
            }
            this.deleteSysActHis(task.getProcessInstanceId(), backActivityId, task.getTaskDefinitionKey());
            this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"revoke");
            this.rejectTask(userId, taskId, backActivityId, comment, map);
            if (!isSubmit) {
                return this.installRejectReturnValue(task.getProcessInstanceId(), isFirst, starterUserId);
            }
            return this.installRejectReturnValue(task.getProcessInstanceId(), backActivityId);
        }
        return ServiceResult.getResult("0", "error", null);
    }

    private String getTaskStarterUserId(String processInstanceId) {
        String starterUserId = "";
        HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (hpi != null) {
            starterUserId = hpi.getStartUserId();
        }
        return starterUserId;
    }

    private int backType(String taskId) {
        int num = 1;
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).active().singleResult();
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        if (instance == null) {
            LOGGER.error("\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f");
            return 0;
        }
        ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
        if (definition == null) {
            LOGGER.error("\u6d41\u7a0b\u5b9a\u4e49\u672a\u627e\u5230");
            return 0;
        }
        ActivityImpl currActivity = definition.findActivity(task.getTaskDefinitionKey());
        ActivityBehavior activityBehavior = currActivity.getActivityBehavior();
        if (activityBehavior instanceof ParallelMultiInstanceBehavior || activityBehavior instanceof SequentialMultiInstanceBehavior) {
            num = 2;
            return num;
        }
        List incomingTransitions = currActivity.getIncomingTransitions();
        for (PvmTransition pvmTransition : incomingTransitions) {
            PvmActivity pvmActivity = pvmTransition.getSource();
            if ("parallelGateway".equals(pvmActivity.getProperty("type"))) {
                num = 3;
                continue;
            }
            num = 1;
        }
        return num;
    }
}

