/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.processinst.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.bpm.common.utils.ServiceResult;
import com.jxdinfo.hussar.bpm.processinst.dao.ProcessInMapper;
import com.jxdinfo.hussar.bpm.processinst.service.ProcessInstService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RuntimeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class ProcessInstServiceImpl
implements ProcessInstService {
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private ProcessInMapper processInstDao;
    @Autowired
    private Environment env;
    public static final String MYSQL_DRIVER = "com.mysql.jdbc.Driver";

    @Override
    public Map<String, Object> getRunningProcessList(HashMap map) {
        String dbDriver = this.env.getProperty("spring.datasource.driverClassName");
        List<Object> instList = new ArrayList();
        instList = MYSQL_DRIVER.equals(dbDriver) ? this.processInstDao.runningList(map) : this.processInstDao.runningListOracle(map);
        Integer page = Integer.parseInt(map.get("page").toString());
        Integer limit = Integer.parseInt(map.get("limit").toString());
        List<Object> pageList = new ArrayList();
        pageList = instList.size() > limit * page ? instList.subList((page - 1) * limit, limit * page) : instList.subList((page - 1) * limit, instList.size());
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("count", instList.size());
        dataMap.put("code", 0);
        dataMap.put("msg", "success");
        dataMap.put("data", pageList);
        return dataMap;
    }

    @Override
    public Map<String, Object> getSuspendProcessList(HashMap map) {
        String dbDriver = this.env.getProperty("spring.datasource.driverClassName");
        List<Object> instList = new ArrayList();
        instList = MYSQL_DRIVER.equals(dbDriver) ? this.processInstDao.suppendList(map) : this.processInstDao.suppendListOracle(map);
        Integer page = Integer.parseInt(map.get("page").toString());
        Integer limit = Integer.parseInt(map.get("limit").toString());
        List<Object> pageList = new ArrayList();
        pageList = instList.size() > limit * page ? instList.subList((page - 1) * limit, limit * page) : instList.subList((page - 1) * limit, instList.size());
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("count", instList.size());
        dataMap.put("code", 0);
        dataMap.put("msg", "success");
        dataMap.put("data", pageList);
        return dataMap;
    }

    @Override
    public Map<String, Object> getFinishedProcessList(HashMap map) {
        String dbDriver = this.env.getProperty("spring.datasource.driverClassName");
        List<Object> instList = new ArrayList();
        instList = MYSQL_DRIVER.equals(dbDriver) ? this.processInstDao.finishedList(map) : this.processInstDao.finishedListOracle(map);
        Integer page = Integer.parseInt(map.get("page").toString());
        Integer limit = Integer.parseInt(map.get("limit").toString());
        List<Object> pageList = new ArrayList();
        pageList = instList.size() > limit * page ? instList.subList((page - 1) * limit, limit * page) : instList.subList((page - 1) * limit, instList.size());
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("count", instList.size());
        dataMap.put("code", 0);
        dataMap.put("msg", "success");
        dataMap.put("data", pageList);
        return dataMap;
    }

    @Override
    public String suspendProcessInstanceById(String processInstCode) {
        HashMap<String, String> mapStr = new HashMap<String, String>();
        try {
            this.runtimeService.suspendProcessInstanceById(processInstCode);
            mapStr.put("flag", "true");
            return ServiceResult.getResult("1", "", JSON.toJSONString(mapStr));
        }
        catch (Exception e) {
            mapStr.put("flag", "false");
            return ServiceResult.getResult("0", "", JSON.toJSONString(mapStr));
        }
    }

    @Override
    public String activateProcessById(String processInstCode) {
        HashMap<String, String> mapStr = new HashMap<String, String>();
        try {
            this.runtimeService.activateProcessInstanceById(processInstCode);
            mapStr.put("flag", "true");
            return ServiceResult.getResult("1", "", JSON.toJSONString(mapStr));
        }
        catch (Exception e) {
            mapStr.put("flag", "false");
            return ServiceResult.getResult("0", "", JSON.toJSONString(mapStr));
        }
    }

    @Override
    public String deleteProcessInstance(String processInstCode) {
        HashMap<String, String> mapStr = new HashMap<String, String>();
        try {
            this.runtimeService.deleteProcessInstance(processInstCode, "");
            mapStr.put("flag", "true");
            return ServiceResult.getResult("1", "", JSON.toJSONString(mapStr));
        }
        catch (Exception e) {
            mapStr.put("flag", "false");
            return ServiceResult.getResult("0", "", JSON.toJSONString(mapStr));
        }
    }

    @Override
    public String deleteFinishedProcessInstance(String processInstCode) {
        HashMap<String, String> mapStr = new HashMap<String, String>();
        try {
            this.historyService.deleteHistoricProcessInstance(processInstCode);
            mapStr.put("flag", "true");
            return ServiceResult.getResult("1", "", JSON.toJSONString(mapStr));
        }
        catch (Exception e) {
            mapStr.put("flag", "false");
            return ServiceResult.getResult("0", "", JSON.toJSONString(mapStr));
        }
    }

    @Override
    public List<Map<String, String>> getFinishAmount(String type) {
        return this.processInstDao.finishedAnalysis(type);
    }
}

