/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.processinst.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bpm.processinst.service.ProcessInstService;
import com.jxdinfo.hussar.bpm.rest.service.ProcessInstanceService;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import java.util.HashMap;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/processInst"})
public class ProcessInstController
extends BaseController {
    @Autowired
    private ProcessInstService processInstService;
    @Autowired
    private ProcessInstanceService processInstanceService;

    @RequestMapping(value={"/goViewRun"})
    @RequiresPermissions(value={"processInst:goViewRun"})
    public ModelAndView goViewRun() {
        return new ModelAndView("/bpm/processinst/running/runningProcess.html");
    }

    @RequestMapping(value={"/goViewSup"})
    @RequiresPermissions(value={"processInst:goViewSup"})
    public ModelAndView goViewSup() {
        return new ModelAndView("/bpm/processinst/suspend/suspendProcess.html");
    }

    @RequestMapping(value={"/goViewFinished"})
    @RequiresPermissions(value={"processInst:goViewFinished"})
    public ModelAndView goViewFinished() {
        return new ModelAndView("/bpm/processinst/finished/finishedProcess.html");
    }

    @RequestMapping(value={"/getRunningProcessList"})
    public Map<String, Object> getRunningProcessList(@RequestParam(required=false) String processDefName, @RequestParam(required=false) String processInstCode, @RequestParam(required=false) String businessKey, @RequestParam(required=false) String startTime, @RequestParam(required=false) String startTimeEnd, @RequestParam(required=false) Integer page, @RequestParam(required=false) Integer limit) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processDefName", processDefName);
        map.put("processInstCode", processInstCode);
        map.put("businessKey", businessKey);
        map.put("startTime", startTime);
        map.put("startTimeEnd", startTimeEnd);
        map.put("page", page);
        map.put("limit", limit);
        return this.processInstService.getRunningProcessList(map);
    }

    @RequestMapping(value={"/getSuspendProcessList"})
    public Map<String, Object> getSuspendProcessList(@RequestParam(required=false) String processDefName, @RequestParam(required=false) String processInstCode, @RequestParam(required=false) String businessKey, @RequestParam(required=false) String startTime, @RequestParam(required=false) String startTimeEnd, @RequestParam(required=false) Integer page, @RequestParam(required=false) Integer limit) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processDefName", processDefName);
        map.put("processInstCode", processInstCode);
        map.put("businessKey", businessKey);
        map.put("startTime", startTime);
        map.put("startTimeEnd", startTimeEnd);
        map.put("page", page);
        map.put("limit", limit);
        return this.processInstService.getSuspendProcessList(map);
    }

    @RequestMapping(value={"/getFinishedProcessList"})
    public Map<String, Object> getFinishedProcessList(@RequestParam(required=false) String processDefName, @RequestParam(required=false) String processInstCode, @RequestParam(required=false) String businessKey, @RequestParam(required=false) String endTime, @RequestParam(required=false) String endTimeEnd, @RequestParam(required=false) Integer page, @RequestParam(required=false) Integer limit) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processDefName", processDefName);
        map.put("processInstCode", processInstCode);
        map.put("businessKey", businessKey);
        map.put("endTime", endTime);
        map.put("endTimeEnd", endTimeEnd);
        map.put("page", page);
        map.put("limit", limit);
        return this.processInstService.getFinishedProcessList(map);
    }

    @RequestMapping(value={"/deleteProcessById"})
    @RequiresPermissions(value={"processInst:deleteProcessById"})
    public String deleteProcessById(@RequestParam(value="instId") String instId) {
        String delete = "";
        String[] processInstanceId = instId.split(",");
        for (int i = 0; i < processInstanceId.length; ++i) {
            delete = this.processInstService.deleteProcessInstance(processInstanceId[i]);
        }
        return delete;
    }

    @RequestMapping(value={"/deleteFinishedProcessById"})
    @RequiresPermissions(value={"processInst:deleteFinishedProcessById"})
    public String deleteFinishedProcessById(@RequestParam(value="instId") String instId) {
        String delete = "";
        String[] processInstanceId = instId.split(",");
        for (int i = 0; i < processInstanceId.length; ++i) {
            delete = this.processInstService.deleteFinishedProcessInstance(processInstanceId[i]);
        }
        return delete;
    }

    @RequestMapping(value={"/suspendProcessById"})
    @RequiresPermissions(value={"processInst:suspendProcessById"})
    public String suspendProcessById(@RequestParam(value="instId") String instId) {
        String suspend = "";
        String[] processInstanceId = instId.split(",");
        for (int i = 0; i < processInstanceId.length; ++i) {
            suspend = this.processInstService.suspendProcessInstanceById(processInstanceId[i]);
        }
        return suspend;
    }

    @RequestMapping(value={"/activateProcessById"})
    @RequiresPermissions(value={"processInst:activateProcessById"})
    public String activateProcessById(@RequestParam(value="instId") String instId) {
        String activate = "";
        String[] processInstanceId = instId.split(",");
        for (int i = 0; i < processInstanceId.length; ++i) {
            activate = this.processInstService.activateProcessById(processInstanceId[i]);
        }
        return activate;
    }

    @RequestMapping(value={"/getLocalProcessTrace"})
    @ResponseBody
    public JSONArray getLocalProcessTrace(String processInstanceId) {
        try {
            String trace = this.processInstanceService.getProcessTrace(processInstanceId);
            JSONObject object = JSONObject.parseObject((String)trace);
            String resultStr = object.get((Object)"result") == null ? "" : object.get((Object)"result").toString();
            return JSONArray.parseArray((String)resultStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

