/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.processentrust.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.jxdinfo.hussar.bpm.processentrust.model.TEntrust;
import com.jxdinfo.hussar.bpm.processentrust.service.ITEntrustService;
import com.jxdinfo.hussar.bpm.rest.service.ProcessDefinitionService;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/tEntrust"})
public class TEntrustController
extends BaseController {
    private String PREFIX = "/bpm/processentrust/";
    @Autowired
    private ITEntrustService tEntrustService;
    @Autowired
    private ProcessDefinitionService processDefinitionService;

    @RequestMapping(value={"/view"})
    public String index() {
        return this.PREFIX + "tEntrust.html";
    }

    @RequestMapping(value={"/tEntrust_add"})
    public String tEntrustAdd(Model model, HttpSession httpSession) {
        Object obj = httpSession.getAttribute("shiroUser");
        model.addAttribute("user", obj);
        model.addAttribute("list", this.select());
        return this.PREFIX + "tEntrust_add.html";
    }

    @RequestMapping(value={"/tEntrust_update/{tEntrustId}"})
    public String tEntrustUpdate(@PathVariable String tEntrustId, Model model, HttpSession httpSession) {
        TEntrust tEntrust = (TEntrust)((Object)this.tEntrustService.selectById((Serializable)((Object)tEntrustId)));
        model.addAttribute("item", (Object)tEntrust);
        Object obj = httpSession.getAttribute("shiroUser");
        model.addAttribute("user", obj);
        model.addAttribute("list", this.select());
        return this.PREFIX + "tEntrust_edit.html";
    }

    @RequestMapping(value={"/choose"})
    public String choose() {
        return this.PREFIX + "choose.html";
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    public Object list(String condition) {
        Page page1 = new Page(Integer.parseInt(super.getPara("page")), Integer.parseInt(super.getPara("limit")));
        EntityWrapper ew = new EntityWrapper();
        ew.like(ToolUtil.isNotEmpty((Object)condition), "PROCESSNAME", condition);
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        List list = this.tEntrustService.selectPage(page1, (Wrapper)ew).getRecords();
        result.put("count", page1.getTotal());
        result.put("code", "0");
        result.put("data", list);
        result.put("msg", "success");
        return result;
    }

    @RequestMapping(value={"/add"})
    @ResponseBody
    public Object add(TEntrust tEntrust) {
        EntityWrapper ew = new EntityWrapper();
        ew.eq("ENPEOPLE", (Object)tEntrust.getEnpeople()).eq("PROCESSID", (Object)tEntrust.getProcessid());
        List list = this.tEntrustService.selectList((Wrapper)ew);
        if (list.size() >= 1) {
            return new ErrorTip(500, "\u6b64\u6d41\u7a0b\u5df2\u6709\u59d4\u6258\u4eba\uff01");
        }
        this.tEntrustService.insert((Object)tEntrust);
        return SUCCESS_TIP;
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public Object delete(@RequestParam String tEntrustId) {
        this.tEntrustService.deleteBatchIds(JSON.parseArray((String)tEntrustId, String.class));
        return SUCCESS_TIP;
    }

    @RequestMapping(value={"/update"})
    @ResponseBody
    public Object update(TEntrust tEntrust) {
        EntityWrapper ew = new EntityWrapper();
        ew.eq("ENPEOPLE", (Object)tEntrust.getEnpeople()).eq("PROCESSID", (Object)tEntrust.getProcessid());
        TEntrust tEntrust1 = (TEntrust)((Object)this.tEntrustService.selectOne((Wrapper)ew));
        if (tEntrust1 == null || tEntrust1.getId().equals(tEntrust.getId())) {
            this.tEntrustService.updateById((Object)tEntrust);
            return SUCCESS_TIP;
        }
        return new ErrorTip(500, "\u6b64\u6d41\u7a0b\u5df2\u6709\u59d4\u6258\u4eba\uff01");
    }

    @RequestMapping(value={"/detail/{tEntrustId}"})
    @ResponseBody
    public Object detail(@PathVariable(value="tEntrustId") String tEntrustId) {
        return this.tEntrustService.selectById((Serializable)((Object)tEntrustId));
    }

    @RequestMapping(value={"/editState"})
    @ResponseBody
    public Object editState(@RequestParam String tEntrusts) {
        List list = JSON.parseArray((String)tEntrusts, TEntrust.class);
        for (TEntrust t : list) {
            if ("1".equals(t.getState())) {
                t.setState("0");
                continue;
            }
            t.setState("1");
        }
        if (this.tEntrustService.updateBatchById(list, list.size())) {
            return SUCCESS_TIP;
        }
        return new ErrorTip(500, "\u542f\u7528/\u7981\u7528\u5931\u8d25\uff01");
    }

    private List<Map<String, String>> select() {
        String allProcess = this.processDefinitionService.queryProcess();
        List list = JSONArray.parseArray((String)JSON.parseObject((String)allProcess).get((Object)"result").toString(), String.class);
        ArrayList<Map<String, String>> li = new ArrayList<Map<String, String>>();
        if (ToolUtil.isNotEmpty((Object)list)) {
            for (String s : list) {
                JSONObject obj = JSONObject.parseObject((String)s);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", obj.get((Object)"name").toString());
                map.put("id", obj.get((Object)"id").toString());
                li.add(map);
            }
        }
        return li;
    }
}

