/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.processcount.controller;

import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.bpm.processcount.service.ProcessCountService;
import com.jxdinfo.hussar.bpm.processinst.service.ProcessInstService;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/processCount"})
public class ProcessCountController
extends BaseController {
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private ProcessInstService processInstService;
    @Autowired
    private ProcessCountService processCountService;
    @Autowired
    private Environment env;
    private static final String MYSQL_DRIVER = "com.mysql.jdbc.Driver";

    @RequestMapping(value={"/getPic"})
    public List getProcessDefinitions() {
        ArrayList<Serializable> result = new ArrayList<Serializable>();
        String dbDriver = this.env.getProperty("spring.datasource.driverClassName");
        try {
            int definition = (int)this.repositoryService.createProcessDefinitionQuery().latestVersion().count();
            int model = (int)this.repositoryService.createModelQuery().latestVersion().count();
            int wait = (int)this.taskService.createTaskQuery().count();
            int instance = (int)this.runtimeService.createProcessInstanceQuery().count();
            int finished = (int)this.historyService.createHistoricProcessInstanceQuery().finished().count();
            int suspend = (int)this.runtimeService.createProcessInstanceQuery().suspended().count();
            int active = (int)this.runtimeService.createProcessInstanceQuery().active().count();
            List<Map<String, String>> list = null;
            list = MYSQL_DRIVER.equals(dbDriver) ? this.processInstService.getFinishAmount("mysql") : this.processInstService.getFinishAmount("oracle");
            HashMap map = new HashMap();
            if (list != null && list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    HashMap mapResult = (HashMap)list.get(i);
                    map.put(((String)mapResult.get("TIME")).trim(), mapResult.get("AMOUNT"));
                }
            }
            result.add(Integer.valueOf(definition));
            result.add(Integer.valueOf(model));
            result.add(Integer.valueOf(wait));
            result.add(Integer.valueOf(instance));
            result.add(Integer.valueOf(finished));
            result.add(Integer.valueOf(suspend));
            result.add(Integer.valueOf(active));
            result.add(map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @RequestMapping(value={"/instanceCount"})
    @RequiresPermissions(value={"processCount:instanceCount"})
    public ModelAndView instanceCount() {
        return new ModelAndView("/bpm/processcount/instancecount.html");
    }

    @RequestMapping(value={"/processPandect"})
    @RequiresPermissions(value={"processCount:processPandect"})
    public ModelAndView processPandect() {
        return new ModelAndView("/bpm/processcount/processpandect.html");
    }

    @RequestMapping(value={"/finishedProcess"})
    @RequiresPermissions(value={"processCount:finishedProcess"})
    public ModelAndView finishedProcess() {
        return new ModelAndView("/bpm/processcount/finishedprocess.html");
    }

    @RequestMapping(value={"/allTask"})
    public ModelAndView allTask() {
        return new ModelAndView("/bpm/processcount/taskcount_all.html");
    }

    @RequestMapping(value={"/getAllTackCout"})
    public List<Map> getAllTackCout() {
        String userId = super.getPara("userId");
        return this.processCountService.getAllTackCout(userId);
    }

    @RequestMapping(value={"/loadProcessImage"})
    public void loadProcessImage(@RequestParam(value="definitionKey") String definitionKey, HttpServletResponse response) {
        this.processCountService.loadProcessImage(definitionKey, response);
    }

    @RequestMapping(value={"/loadNodeCount"})
    @ResponseBody
    public JSONArray loadNodeCount(String definitionKey) {
        return this.processCountService.loadNodeCount(definitionKey);
    }

    @RequestMapping(value={"/nodeTaskList"})
    public Map<String, Object> nodeTaskList(String userId, String definitionKey) {
        return this.processCountService.nodeTaskList(userId, definitionKey);
    }
}

