/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.listener;

import com.jxdinfo.hussar.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.bpm.common.utils.BpmConstant;
import com.jxdinfo.hussar.bpm.processentrust.service.ITEntrustService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.converter.util.InputStreamProvider;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.impl.ActivitiEntityEventImpl;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricIdentityLink;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.util.io.InputStreamSource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HussarBpmListener
implements ActivitiEventListener {
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private ITEntrustService itEntrustService;

    public void onEvent(ActivitiEvent activitiEvent) {
        ProcessDefinitionEntity processDefinition;
        InputStream xmlIs;
        BpmnModel bm;
        ActivitiEntityEventImpl activitiEntityEvent = (ActivitiEntityEventImpl)activitiEvent;
        TaskEntity task = (TaskEntity)activitiEntityEvent.getEntity();
        String taskId = "";
        String processDefinitionId = "";
        if (task != null) {
            taskId = task.getId();
            processDefinitionId = task.getProcessDefinitionId();
        }
        if ((bm = new BpmnXMLConverter().convertToBpmnModel((InputStreamProvider)new InputStreamSource(xmlIs = BpmConstant.repositoryService.getResourceAsStream((processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)BpmConstant.repositoryService).getDeployedProcessDefinition(processDefinitionId)).getDeploymentId(), processDefinition.getResourceName())), false, true)) != null) {
            List<String> list = this.getCandidateUser(bm, task);
            Map<String, String> map = this.itEntrustService.queryByUsers(list, processDefinition.getProcessDefinition().getKey());
            if (list != null && list.size() > 0) {
                for (String id : list) {
                    if (ToolUtil.isNotEmpty((Object)map.get(id))) {
                        BpmConstant.taskService.addCandidateUser(taskId, map.get(id));
                        continue;
                    }
                    BpmConstant.taskService.addCandidateUser(taskId, id);
                }
            }
        }
    }

    private List<String> getCandidateUser(BpmnModel bm, TaskEntity task) {
        Boolean currentdept;
        boolean skipUserTask;
        String userId = "";
        List<String> deptsList = null;
        List<String> rolesList = null;
        List<String> userList = new ArrayList<String>();
        String nodeId = "";
        String processInstanceId = "";
        Expression expression = null;
        ExecutionEntity execution = null;
        List hisActivitList = null;
        if (task != null) {
            execution = task.getExecution();
            expression = task.getTaskDefinition().getSkipExpression();
            nodeId = task.getTaskDefinitionKey();
            processInstanceId = task.getProcessInstanceId();
        }
        Map extensionElementsNode = ((Process)bm.getProcesses().get(0)).getFlowElement(nodeId).getExtensionElements();
        boolean bl = skipUserTask = SkipExpressionUtil.isSkipExpressionEnabled((ActivityExecution)execution, (Expression)expression) && SkipExpressionUtil.shouldSkipFlowElement((ActivityExecution)execution, (Expression)expression);
        if (skipUserTask) {
            return null;
        }
        String assignmentnode = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("assignmentnode")).get(0)).getAttributes().get("assignmentnode")).get(0)).getValue();
        if (StringUtils.isNotEmpty((String)assignmentnode) && (hisActivitList = ((HistoricActivityInstanceQuery)BpmConstant.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).activityId(assignmentnode).orderByHistoricActivityInstanceStartTime().desc()).list()) != null && hisActivitList.size() > 0 && StringUtils.isNotEmpty((String)((HistoricActivityInstance)hisActivitList.get(0)).getAssignee())) {
            userList.add(((HistoricActivityInstance)hisActivitList.get(0)).getAssignee());
            return userList;
        }
        Map extensionAttribute = ((Process)bm.getProcesses().get(0)).getFlowElement(nodeId).getAttributes();
        List deptAttribute = (List)extensionAttribute.get("candidateDepts");
        List roleAttribute = (List)extensionAttribute.get("candidateRoles");
        if (deptAttribute != null && deptAttribute.size() > 0) {
            String candidateDepts = ((ExtensionAttribute)deptAttribute.get(0)).getValue();
            deptsList = Arrays.asList(candidateDepts.split(","));
        }
        if (roleAttribute != null && roleAttribute.size() > 0) {
            String candidateRoles = ((ExtensionAttribute)roleAttribute.get(0)).getValue();
            rolesList = Arrays.asList(candidateRoles.split(","));
        }
        if ((currentdept = Boolean.valueOf(Boolean.parseBoolean(((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("currentdept")).get(0)).getAttributes().get("currentdept")).get(0)).getValue()))).booleanValue() && rolesList != null) {
            List identityLink = BpmConstant.processEngine.getHistoryService().getHistoricIdentityLinksForProcessInstance(processInstanceId);
            for (HistoricIdentityLink il : identityLink) {
                if (!"starter".equals(il.getType())) continue;
                userId = il.getUserId() == null ? "" : il.getUserId();
                break;
            }
            deptsList = this.iAssigneeChooseService.getFlowStarterDept(userId);
        }
        userList = deptsList == null && rolesList == null ? null : this.iAssigneeChooseService.getUserList(deptsList, rolesList);
        return userList;
    }

    public boolean isFailOnException() {
        return false;
    }
}

