/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.engine.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.toolkit.IdWorker;
import com.jxdinfo.hussar.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.bpm.engine.model.Result;
import com.jxdinfo.hussar.bpm.engine.service.TaskEngineService;
import com.jxdinfo.hussar.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.bpm.hisline.model.SysActHiLine;
import com.jxdinfo.hussar.bpm.hisline.service.ISysActHiLineService;
import com.jxdinfo.hussar.bpm.rest.dao.TaskWebMapper;
import com.jxdinfo.hussar.bpm.rest.util.ActivitiJumpCommand;
import com.jxdinfo.hussar.bpm.rest.util.CommonJumpTaskCmd;
import com.jxdinfo.hussar.bpm.rest.util.MultiInstanceJumpTaskCmd;
import com.jxdinfo.hussar.bpm.rest.util.ParallelJumpTaskCmd;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.converter.util.InputStreamProvider;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.ActivitiTaskAlreadyClaimedException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.TaskServiceImpl;
import org.activiti.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.activiti.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.ValueExpression;
import org.activiti.engine.impl.juel.ExpressionFactoryImpl;
import org.activiti.engine.impl.juel.SimpleContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.ReadOnlyProcessDefinition;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.util.io.InputStreamSource;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class TaskEngineServiceImpl
implements TaskEngineService {
    private static Logger LOGGER = LoggerFactory.getLogger(TaskEngineServiceImpl.class);
    @Autowired
    private TaskService taskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private ISysActHiLineService iSysActHiLineService;
    @Resource
    private TaskWebMapper taskWebMapper;
    private String userTask = "userTask";
    private String subProcess = "subProcess";
    private String startAct = "startEvent";
    private String endAct = "endEvent";

    @Override
    public Result queryToDoTaskList(String userId) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        try {
            List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskCandidateOrAssigned(userId).includeProcessVariables()).includeTaskLocalVariables()).orderByTaskCreateTime()).desc()).list();
            if (tasks != null) {
                List<Map<String, Object>> list = this.tasksToMap(tasks);
                object.put("data", list);
                object.put("count", (Object)tasks.size());
                json.add((Object)object);
            }
            return InstallResult.getResult("1", "success", json);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5f85\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    @Override
    public Result queryToDoTaskListByProcess(String userId, String processDefinitionKey) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        try {
            List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskCandidateOrAssigned(userId).processDefinitionKey(processDefinitionKey)).includeProcessVariables()).includeTaskLocalVariables()).orderByTaskCreateTime()).desc()).list();
            if (tasks != null) {
                List<Map<String, Object>> list = this.tasksToMap(tasks);
                object.put("data", list);
                object.put("count", (Object)tasks.size());
                json.add((Object)object);
            }
            return InstallResult.getResult("1", "success", json);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5f85\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    @Override
    public Result queryToDoTaskList(String userId, Integer page, Integer rows) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        Long countTasks = 0L;
        try {
            countTasks = this.taskService.createTaskQuery().taskCandidateOrAssigned(userId).count();
            List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskCandidateOrAssigned(userId).includeProcessVariables()).includeTaskLocalVariables()).orderByTaskCreateTime()).desc()).listPage((page - 1) * rows, rows.intValue());
            List<Map<String, Object>> list = this.tasksToMap(tasks);
            object.put("data", list);
            object.put("count", (Object)countTasks);
            json.add((Object)object);
            return InstallResult.getResult("1", "success", json);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5f85\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    @Override
    public Result queryToDoByDefinitionKey(String processDefinitionKey) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        try {
            List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey(processDefinitionKey)).includeProcessVariables()).includeTaskLocalVariables()).orderByTaskCreateTime()).desc()).list();
            if (tasks != null) {
                List<Map<String, Object>> list = this.tasksToMap(tasks);
                object.put("data", list);
                object.put("count", (Object)tasks.size());
                json.add((Object)object);
            }
            return InstallResult.getResult("1", "success", json);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5f85\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    @Override
    public Result queryToDoTaskListByPageAndProcess(String userId, String processDefinitionKey, Integer page, Integer rows) {
        Long countTasks = 0L;
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        try {
            countTasks = ((TaskQuery)this.taskService.createTaskQuery().taskCandidateOrAssigned(userId).processDefinitionKey(processDefinitionKey)).count();
            List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskCandidateOrAssigned(userId).processDefinitionKey(processDefinitionKey)).includeProcessVariables()).includeTaskLocalVariables()).orderByTaskCreateTime()).desc()).listPage((page - 1) * rows, rows.intValue());
            List<Map<String, Object>> list = this.tasksToMap(tasks);
            object.put("data", list);
            object.put("count", (Object)countTasks);
            json.add((Object)object);
            return InstallResult.getResult("1", "success", json);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5f85\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    @Override
    public Result queryToDoTaskListByDefinitionKey(String userId, String processDefinitionKey, String definitionKey, Integer page, Integer rows) {
        Long countTasks = 0L;
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        try {
            countTasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskCandidateOrAssigned(userId).processDefinitionKey(processDefinitionKey)).taskDefinitionKey(definitionKey)).count();
            List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskCandidateOrAssigned(userId).processDefinitionKey(processDefinitionKey)).taskDefinitionKey(definitionKey)).includeProcessVariables()).includeTaskLocalVariables()).orderByTaskCreateTime()).desc()).listPage((page - 1) * rows, rows.intValue());
            List<Map<String, Object>> list = this.tasksToMap(tasks);
            object.put("data", list);
            object.put("count", (Object)countTasks);
            json.add((Object)object);
            return InstallResult.getResult("1", "success", json);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5f85\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    @Override
    public Result queryFinishedTaskList(String userId) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        try {
            List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskAssignee(userId)).orderByHistoricTaskInstanceEndTime().includeProcessVariables()).includeTaskLocalVariables()).finished().desc()).list();
            if (hisTaskList != null) {
                List<Map<String, Object>> list = this.hisTasksToMap(hisTaskList);
                object.put("data", list);
                object.put("count", (Object)hisTaskList.size());
                json.add((Object)object);
            }
            return InstallResult.getResult("1", "success", json);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5df2\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    @Override
    public Result queryFinishedTaskListByProcess(String userId, String processDefinitionKey) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        try {
            List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processDefinitionKey(processDefinitionKey)).taskAssignee(userId)).includeProcessVariables()).includeTaskLocalVariables()).orderByHistoricTaskInstanceEndTime().finished().desc()).list();
            if (hisTaskList != null) {
                List<Map<String, Object>> list = this.hisTasksToMap(hisTaskList);
                object.put("data", list);
                object.put("count", (Object)hisTaskList.size());
                json.add((Object)object);
            }
            return InstallResult.getResult("1", "success", json);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5df2\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    @Override
    public Result queryFinishedTaskList(String userId, Integer page, Integer rows) {
        Long counthisList = 0L;
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        try {
            counthisList = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskAssignee(userId)).finished().count();
            List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskAssignee(userId)).includeProcessVariables()).includeTaskLocalVariables()).orderByHistoricTaskInstanceEndTime().finished().desc()).listPage((page - 1) * rows, rows.intValue());
            List<Map<String, Object>> list = this.hisTasksToMap(hisTaskList);
            object.put("data", list);
            object.put("count", (Object)counthisList);
            json.add((Object)object);
            return InstallResult.getResult("1", "success", json);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5df2\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    @Override
    public Result queryFinishedTaskListByPageAndProcess(String userId, String processDefinitionKey, Integer page, Integer rows) {
        Long counthisList = 0L;
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        try {
            counthisList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskAssignee(userId)).processDefinitionKey(processDefinitionKey)).finished().count();
            List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processDefinitionKey(processDefinitionKey)).taskAssignee(userId)).includeProcessVariables()).includeTaskLocalVariables()).finished().orderByHistoricTaskInstanceEndTime().desc()).listPage((page - 1) * rows, rows.intValue());
            List<Map<String, Object>> list = this.hisTasksToMap(hisTaskList);
            object.put("data", list);
            object.put("count", (Object)counthisList);
            json.add((Object)object);
            return InstallResult.getResult("1", "success", json);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5df2\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    @Override
    public Result queryFinishedTaskListByDefinitionKey(String userId, String processDefinitionKey, String definitionKey, Integer page, Integer rows) {
        Long counthisList = 0L;
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        try {
            counthisList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskAssignee(userId)).processDefinitionKey(processDefinitionKey)).taskDefinitionKey(definitionKey)).finished().count();
            List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskAssignee(userId)).processDefinitionKey(processDefinitionKey)).taskDefinitionKey(definitionKey)).includeProcessVariables()).includeTaskLocalVariables()).finished().orderByHistoricTaskInstanceEndTime().desc()).listPage((page - 1) * rows, rows.intValue());
            List<Map<String, Object>> list = this.hisTasksToMap(hisTaskList);
            object.put("data", (Object)JSONArray.toJSONString(list));
            object.put("count", (Object)counthisList);
            json.add((Object)object);
            return InstallResult.getResult("1", "success", json);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5df2\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    @Override
    public Result queryUserTaskCount(String userId) {
        List<Map> list = this.taskWebMapper.getUserTask(userId);
        JSONArray json = new JSONArray();
        JSONObject object = new JSONObject();
        object.put("list", list);
        json.add((Object)object);
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public Result queryUserTaskCountByNode(String userId) {
        List<Map> list = this.taskWebMapper.getUserTaskByNode(userId);
        JSONArray json = new JSONArray();
        JSONObject object = new JSONObject();
        object.put("list", list);
        json.add((Object)object);
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public Result claimTask(String taskId, String userId) {
        try {
            this.taskService.claim(taskId, userId);
            return InstallResult.getResult("1", "\u7b7e\u6536\u6210\u529f", null);
        }
        catch (Exception e) {
            LOGGER.error("\u7b7e\u6536\u4efb\u52a1\u51fa\u932f\uff1a" + e.getMessage());
            return InstallResult.getResult("0", "\u4efb\u52a1\u5df2\u88ab\u5176\u4ed6\u4eba\u7b7e\u6536", null);
        }
    }

    @Override
    public Result completeTask(String taskId) {
        try {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            String processInstanceId = task.getProcessInstanceId();
            List oldList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().asc()).list();
            this.complete(task, "", null);
            List newList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().asc()).list();
            this.saveLineHis(processInstanceId, newList, oldList, "", task.getTaskDefinitionKey());
            return this.installReturnValue(processInstanceId);
        }
        catch (ActivitiTaskAlreadyClaimedException atac) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + atac.getMessage());
            return InstallResult.getResult("0", "\u4efb\u52a1\u5df2\u88ab\u7b7e\u6536\u3002", null);
        }
        catch (ActivitiObjectNotFoundException a) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + a.getMessage());
            return InstallResult.getResult("0", "\u4efb\u52a1\u5df2\u88ab\u529e\u7406\u3002", null);
        }
        catch (Exception e) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    @Override
    public Result completeTask(String taskId, String userId) {
        try {
            this.taskService.claim(taskId, userId);
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            String processInstanceId = task.getProcessInstanceId();
            List oldList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().asc()).list();
            this.complete(task, userId, null);
            List newList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().asc()).list();
            this.saveLineHis(processInstanceId, newList, oldList, "", task.getTaskDefinitionKey());
            return this.installReturnValue(processInstanceId);
        }
        catch (ActivitiTaskAlreadyClaimedException atac) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + atac.getMessage());
            return InstallResult.getResult("0", "\u4efb\u52a1\u5df2\u88ab\u7b7e\u6536\u3002", null);
        }
        catch (ActivitiObjectNotFoundException a) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + a.getMessage());
            return InstallResult.getResult("0", "\u4efb\u52a1\u5df2\u88ab\u529e\u7406\u3002", null);
        }
        catch (Exception e) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    @Override
    public Result completeTask(String taskId, Map<String, Object> map) {
        try {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            String processInstanceId = task.getProcessInstanceId();
            List oldList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().asc()).list();
            this.complete(task, "", map);
            List newList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().asc()).list();
            this.saveLineHis(processInstanceId, newList, oldList, "", task.getTaskDefinitionKey());
            return this.installReturnValue(processInstanceId);
        }
        catch (ActivitiTaskAlreadyClaimedException atac) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + atac.getMessage());
            return InstallResult.getResult("0", "\u4efb\u52a1\u5df2\u88ab\u7b7e\u6536\u3002", null);
        }
        catch (ActivitiObjectNotFoundException a) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + a.getMessage());
            return InstallResult.getResult("0", "\u4efb\u52a1\u5df2\u88ab\u529e\u7406\u3002", null);
        }
        catch (Exception e) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    @Override
    public Result completeTask(String taskId, String userId, Map<String, Object> map) {
        try {
            this.taskService.claim(taskId, userId);
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            String processInstanceId = task.getProcessInstanceId();
            List oldList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().asc()).list();
            this.complete(task, userId, map);
            List newList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().asc()).list();
            this.saveLineHis(processInstanceId, newList, oldList, "", task.getTaskDefinitionKey());
            return this.installReturnValue(processInstanceId);
        }
        catch (ActivitiTaskAlreadyClaimedException atac) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + atac.getMessage());
            return InstallResult.getResult("0", "\u4efb\u52a1\u5df2\u88ab\u7b7e\u6536\u3002", null);
        }
        catch (ActivitiObjectNotFoundException a) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + a.getMessage());
            return InstallResult.getResult("0", "\u4efb\u52a1\u5df2\u88ab\u529e\u7406\u3002", null);
        }
        catch (Exception e) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    @Override
    public Result completeTask(String taskId, String userId, Map<String, String> assigneeMap, Map<String, Object> map) {
        try {
            this.taskService.claim(taskId, userId);
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            String processInstanceId = task.getProcessInstanceId();
            List oldList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().asc()).list();
            this.complete(task, userId, map);
            List newList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().asc()).list();
            this.saveLineHis(processInstanceId, newList, oldList, "", task.getTaskDefinitionKey());
            this.setAssignee(processInstanceId, assigneeMap);
            return this.installReturnValue(processInstanceId);
        }
        catch (ActivitiTaskAlreadyClaimedException atac) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + atac.getMessage());
            return InstallResult.getResult("0", "\u4efb\u52a1\u5df2\u88ab\u7b7e\u6536\u3002", null);
        }
        catch (ActivitiObjectNotFoundException a) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + a.getMessage());
            return InstallResult.getResult("0", "\u4efb\u52a1\u5df2\u88ab\u529e\u7406\u3002", null);
        }
        catch (Exception e) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    @Override
    public Result completeTask(String taskId, String userId, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        try {
            this.taskService.claim(taskId, userId);
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            String processInstanceId = task.getProcessInstanceId();
            this.addComment(taskId, comment);
            List oldList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().asc()).list();
            this.complete(task, userId, map);
            List newList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().asc()).list();
            this.saveLineHis(processInstanceId, newList, oldList, "", task.getTaskDefinitionKey());
            this.setAssignee(processInstanceId, assigneeMap);
            return this.installReturnValue(processInstanceId);
        }
        catch (ActivitiTaskAlreadyClaimedException atac) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + atac.getMessage());
            return InstallResult.getResult("0", "\u4efb\u52a1\u5df2\u88ab\u7b7e\u6536\u3002", null);
        }
        catch (ActivitiObjectNotFoundException a) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + a.getMessage());
            return InstallResult.getResult("0", "\u4efb\u52a1\u5df2\u88ab\u529e\u7406\u3002", null);
        }
        catch (Exception e) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    @Override
    public Result completeTask(String taskId, String userId, String comment, Map<String, Object> map) {
        try {
            this.taskService.claim(taskId, userId);
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            String processInstanceId = task.getProcessInstanceId();
            this.addComment(taskId, comment);
            List oldList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().asc()).list();
            this.complete(task, userId, map);
            List newList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().asc()).list();
            this.saveLineHis(processInstanceId, newList, oldList, "", task.getTaskDefinitionKey());
            return this.installReturnValue(processInstanceId);
        }
        catch (ActivitiTaskAlreadyClaimedException atac) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + atac.getMessage());
            return InstallResult.getResult("0", "\u4efb\u52a1\u5df2\u88ab\u7b7e\u6536\u3002", null);
        }
        catch (ActivitiObjectNotFoundException a) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + a.getMessage());
            return InstallResult.getResult("0", "\u4efb\u52a1\u5df2\u88ab\u529e\u7406\u3002", null);
        }
        catch (Exception e) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    private void complete(Task task, String userId, Map<String, Object> map) {
        String taskId = task.getId();
        this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"complete");
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        Map<Object, Object> skipMap = new HashMap();
        if (StringUtils.isNotEmpty((CharSequence)userId)) {
            skipMap = this.checkIsAssigneeRepeat(task, userId, map);
        }
        if (skipMap != null) {
            map.putAll(skipMap);
        }
        if (task.getDelegationState() == null) {
            this.taskService.complete(taskId, map);
        } else {
            this.taskService.resolveTask(taskId);
            this.taskService.complete(taskId, map);
        }
    }

    private Map<String, Object> checkIsAssigneeRepeat(Task task, String userId, Map<String, Object> map) {
        Map<String, Object> skipMap = new HashMap<String, Object>();
        BpmnModel bm = this.getBpmnModel(task.getProcessDefinitionId());
        skipMap = this.collectionSkipMap(task, bm, skipMap, userId, task.getTaskDefinitionKey(), map);
        return skipMap;
    }

    private Map<String, Object> collectionSkipMap(Task task, BpmnModel bm, Map<String, Object> skipMap, String userId, String activityId, Map<String, Object> formData) {
        UserTask u;
        UserTask userTask = (UserTask)((Process)bm.getProcesses().get(0)).getFlowElement(activityId);
        List sequenceFlows = userTask.getOutgoingFlows();
        if (sequenceFlows.size() > 1) {
            return skipMap;
        }
        String seqTarRef = ((SequenceFlow)sequenceFlows.get(0)).getTargetRef();
        if (((Process)bm.getProcesses().get(0)).getFlowElement(seqTarRef) instanceof ExclusiveGateway) {
            if (formData == null) {
                return skipMap;
            }
            ExclusiveGateway exclusiveGateway = (ExclusiveGateway)((Process)bm.getProcesses().get(0)).getFlowElement(seqTarRef);
            List sf = exclusiveGateway.getOutgoingFlows();
            for (SequenceFlow s : sf) {
                String ce = s.getConditionExpression();
                if (!this.getResultByELAndFormData(ce, formData)) continue;
                UserTask u2 = (UserTask)((Process)bm.getProcesses().get(0)).getFlowElement(s.getTargetRef());
                if (u2.getSkipExpression() == null) {
                    return skipMap;
                }
                ArrayList<String> nextNodeList = new ArrayList<String>();
                nextNodeList.add(u2.getId());
                JSONArray list = this.getCandidateUserList(task, bm, nextNodeList);
                Map map = (Map)list.get(0);
                List userList = (List)map.get("list");
                String nodeId = u2.getId();
                nodeId = nodeId.replaceAll("-", "");
                if (userList.contains(userId)) {
                    skipMap.put(nodeId, true);
                } else {
                    skipMap.put(nodeId, false);
                }
                this.collectionSkipMap(task, bm, skipMap, userId, s.getTargetRef(), formData);
                break;
            }
        }
        if (((Process)bm.getProcesses().get(0)).getFlowElement(seqTarRef) instanceof UserTask) {
            u = (UserTask)((Process)bm.getProcesses().get(0)).getFlowElement(seqTarRef);
            if (u.getSkipExpression() == null) {
                return skipMap;
            }
            ArrayList<String> nextNodeList = new ArrayList<String>();
            nextNodeList.add(u.getId());
            JSONArray list = this.getCandidateUserList(task, bm, nextNodeList);
            Map map = (Map)list.get(0);
            List userList = (List)map.get("list");
            String nodeId = u.getId();
            nodeId = nodeId.replaceAll("-", "");
            if (userList.contains(userId)) {
                skipMap.put(nodeId, true);
            } else {
                skipMap.put(nodeId, false);
            }
        } else {
            return skipMap;
        }
        this.collectionSkipMap(task, bm, skipMap, userId, u.getId(), formData);
        return skipMap;
    }

    private void addComment(String taskId, String comment) {
        if (StringUtils.isNotEmpty((CharSequence)comment)) {
            this.taskService.addComment(taskId, null, "complete", comment);
        }
    }

    private void setAssignee(String processInstanceId, Map<String, String> assigneeMap) {
        List taskNow;
        if (assigneeMap != null && (taskNow = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).active().list()) != null && taskNow.size() > 0) {
            for (Task t : taskNow) {
                String tId = t.getId();
                String nodeId = t.getTaskDefinitionKey();
                String assignee = assigneeMap.get(nodeId);
                if (!StringUtils.isNotEmpty((CharSequence)assignee)) continue;
                Set<String> userSet = this.getAssigneeByTaskId(tId);
                for (String user : userSet) {
                    this.taskService.deleteCandidateUser(tId, user);
                }
                List<String> assigneeList = Arrays.asList(assignee.split(","));
                for (String id : assigneeList) {
                    this.taskService.addCandidateUser(tId, id);
                }
            }
        }
    }

    private Result installReturnValue(String processInstanceId) {
        JSONArray json = new JSONArray();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
        if (tasks != null && tasks.size() > 0) {
            for (Task t : tasks) {
                JSONObject object = new JSONObject();
                object.put("taskId", (Object)t.getId());
                object.put("definitionKey", (Object)t.getTaskDefinitionKey());
                object.put("definitionName", (Object)t.getName());
                object.put("userId", this.getAssigneeByTaskId(t.getId()));
                json.add((Object)object);
            }
        }
        return InstallResult.getResult("1", "success", json);
    }

    private void saveLineHis(String processInstanceId, List<HistoricActivityInstance> newList, List<HistoricActivityInstance> oldList, String userId, String activityId) {
        List<SysActHiLine> sysActHiLines = new ArrayList<SysActHiLine>();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        ProcessDefinitionEntity def = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(newList.get(0).getProcessDefinitionId());
        List oldIds = oldList.stream().map(historicActivityInstance -> historicActivityInstance.getId()).collect(Collectors.toList());
        newList.removeIf(item -> oldIds.contains(item.getId()));
        List<String> ids = newList.stream().map(HistoricActivityInstance::getActivityId).collect(Collectors.toList());
        ActivityImpl activity = def.findActivity(activityId);
        if (processInstance != null) {
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
            Set taskIds = tasks.stream().map(task -> task.getTaskDefinitionKey()).collect(Collectors.toSet());
            if (taskIds != null && taskIds.size() == 1 && taskIds.contains(activityId)) {
                return;
            }
            if (taskIds != null && taskIds.size() >= 1) {
                sysActHiLines = this.installHiLine(activity, processInstance, sysActHiLines, ids, userId, 0);
            }
        } else {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            sysActHiLines = this.installHiLine(activity, historicProcessInstance, sysActHiLines, ids, userId);
        }
        if (sysActHiLines != null && sysActHiLines.size() > 0) {
            this.iSysActHiLineService.insertBatch(sysActHiLines);
        }
    }

    private List<SysActHiLine> installHiLine(ActivityImpl activity, ProcessInstance processInstance, List<SysActHiLine> sysActHiLines, List<String> ids, String userId, int num) {
        List outgoingTransitions = activity.getOutgoingTransitions();
        if (outgoingTransitions != null && outgoingTransitions.size() > 0) {
            for (PvmTransition p : outgoingTransitions) {
                if (!ids.contains(p.getDestination().getId())) continue;
                ActivityImpl acti = (ActivityImpl)p.getDestination();
                SysActHiLine sysActHiLine = new SysActHiLine();
                sysActHiLine.setId(IdWorker.get32UUID());
                sysActHiLine.setProcInstId(processInstance.getProcessInstanceId());
                sysActHiLine.setProcDefId(processInstance.getProcessDefinitionId());
                sysActHiLine.setProcDefKey(processInstance.getProcessDefinitionKey());
                sysActHiLine.setLineId(p.getId());
                sysActHiLine.setLineName(p.getProperty("name") == null ? "" : (String)p.getProperty("name"));
                sysActHiLine.setCompleteTime(new Timestamp(System.currentTimeMillis()));
                sysActHiLine.setCompleteUser(userId);
                sysActHiLine.setInNode(acti.getId());
                sysActHiLine.setInNodeName(acti.getProperty("name") == null ? "" : acti.getProperty("name").toString());
                sysActHiLine.setOutNode(activity.getId());
                sysActHiLine.setOutNodeName(activity.getProperty("name") == null ? "" : activity.getProperty("name").toString());
                sysActHiLines.add(sysActHiLine);
                if (ids.size() <= num) continue;
                this.installHiLine(acti, processInstance, sysActHiLines, ids, userId, ++num);
            }
        }
        return sysActHiLines;
    }

    private List<SysActHiLine> installHiLine(ActivityImpl activity, HistoricProcessInstance historicProcessInstance, List<SysActHiLine> sysActHiLines, List<String> ids, String userId) {
        List outgoingTransitions = activity.getOutgoingTransitions();
        if (outgoingTransitions != null && outgoingTransitions.size() > 0) {
            for (PvmTransition p : outgoingTransitions) {
                if (!ids.contains(p.getDestination().getId())) continue;
                ActivityImpl acti = (ActivityImpl)p.getDestination();
                SysActHiLine sysActHiLine = new SysActHiLine();
                sysActHiLine.setId(IdWorker.get32UUID());
                sysActHiLine.setProcInstId(historicProcessInstance.getId());
                sysActHiLine.setProcDefId(historicProcessInstance.getProcessDefinitionId());
                sysActHiLine.setProcDefKey(historicProcessInstance.getProcessDefinitionKey());
                sysActHiLine.setLineId(p.getId());
                sysActHiLine.setLineName(p.getProperty("name") == null ? "" : (String)p.getProperty("name"));
                sysActHiLine.setCompleteTime(new Timestamp(System.currentTimeMillis()));
                sysActHiLine.setCompleteUser(userId);
                sysActHiLine.setInNode(acti.getId());
                sysActHiLine.setInNodeName(acti.getProperty("name") == null ? "" : acti.getProperty("name").toString());
                sysActHiLine.setOutNode(activity.getId());
                sysActHiLine.setOutNodeName(activity.getProperty("name") == null ? "" : activity.getProperty("name").toString());
                sysActHiLines.add(sysActHiLine);
                if (acti.getId().equals(historicProcessInstance.getEndActivityId())) continue;
                this.installHiLine(acti, historicProcessInstance, sysActHiLines, ids, userId);
            }
        }
        return sysActHiLines;
    }

    @Override
    public Result unClaimTask(String taskId) {
        try {
            this.taskService.unclaim(taskId);
            return InstallResult.getResult("1", "success", null);
        }
        catch (Exception e) {
            LOGGER.error("\u53d6\u6d88\u7b7e\u6536\u51fa\u932f\uff1a" + e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    private List<PvmTransition> getPvmTransition(ActivityImpl currActivity, List<PvmTransition> pt) {
        String activityType = "";
        List incomingTransitions = currActivity.getIncomingTransitions();
        for (PvmTransition pv : incomingTransitions) {
            ActivityImpl ai = (ActivityImpl)pv.getSource();
            Map map = ai.getProperties();
            String string = activityType = map.get("type") == null ? "" : map.get("type").toString();
            if (activityType.contains("Gateway")) {
                pt = this.getPvmTransition(ai, pt);
                continue;
            }
            pt.add(pv);
        }
        return pt;
    }

    @Override
    public Result rejectToPreTask(String taskId, String comment, Map<String, Object> map) {
        boolean isFirst = false;
        String starterUserId = "";
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String backActivityId = this.getLastActivityId(taskId);
        if (backActivityId != null && backActivityId.equals(this.getFristActivityId(taskId))) {
            starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
            isFirst = true;
        }
        this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"reject");
        this.rejectTask("", taskId, backActivityId, comment, map);
        this.deleteSysActHis(task.getProcessInstanceId(), backActivityId, task.getTaskDefinitionKey());
        return this.installRejectReturnValue(task.getProcessInstanceId(), isFirst, starterUserId);
    }

    @Override
    public Result rejectToPreTask(String taskId, String userId, String comment, Map<String, Object> map) {
        boolean isFirst = false;
        String starterUserId = "";
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String backActivityId = this.getLastActivityId(taskId);
        if (backActivityId != null && backActivityId.equals(this.getFristActivityId(taskId))) {
            starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
            isFirst = true;
        }
        this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"reject");
        this.rejectTask(userId, taskId, backActivityId, comment, map);
        this.deleteSysActHis(task.getProcessInstanceId(), backActivityId, task.getTaskDefinitionKey());
        return this.installRejectReturnValue(task.getProcessInstanceId(), isFirst, starterUserId);
    }

    @Override
    public Result rejectToLastTask(String taskId, String userId, String comment, Map<String, Object> map) {
        List tasks;
        String assignee = "";
        JSONArray json = new JSONArray();
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String backActivityId = this.getLastActivityId(taskId);
        this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"reject");
        this.rejectTask(userId, taskId, backActivityId, comment, map);
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).taskDefinitionKey(backActivityId)).finished().orderByHistoricTaskInstanceEndTime().desc()).list();
        if (hisTaskList != null && hisTaskList.size() > 0) {
            assignee = ((HistoricTaskInstance)hisTaskList.get(0)).getAssignee();
        }
        if (StringUtils.isNotEmpty((CharSequence)assignee) && (tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(task.getProcessInstanceId())).active().taskDefinitionKey(backActivityId)).list()) != null && tasks.size() > 0) {
            for (Task t : tasks) {
                Set<String> userSet = this.getAssigneeByTaskId(t.getId());
                for (String user : userSet) {
                    this.taskService.deleteCandidateUser(t.getId(), user);
                }
                this.taskService.addCandidateUser(t.getId(), assignee);
                JSONObject object = new JSONObject();
                object.put("taskId", (Object)t.getId());
                object.put("definitionKey", (Object)t.getTaskDefinitionKey());
                object.put("definitionName", (Object)t.getName());
                object.put("userId", this.getAssigneeByTaskId(t.getId()));
                json.add((Object)object);
            }
        }
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public Result rejectToFristTask(String taskId, String comment, Map<String, Object> map) {
        String starterUserId = "";
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String firstTaskId = this.getFristActivityId(taskId);
        starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
        this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"reject");
        this.rejectTask("", taskId, firstTaskId, comment, map);
        this.deleteSysActHis(task.getProcessInstanceId(), firstTaskId, task.getTaskDefinitionKey());
        return this.installRejectReturnValue(task.getProcessInstanceId(), true, starterUserId);
    }

    @Override
    public Result rejectToFristTask(String taskId, String userId, String comment, Map<String, Object> map) {
        this.claimTask(taskId, userId);
        String starterUserId = "";
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String firstTaskId = this.getFristActivityId(taskId);
        starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
        this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"reject");
        this.rejectTask(userId, taskId, firstTaskId, comment, map);
        this.deleteSysActHis(task.getProcessInstanceId(), firstTaskId, task.getTaskDefinitionKey());
        return this.installRejectReturnValue(task.getProcessInstanceId(), true, starterUserId);
    }

    @Override
    public Result rejectToAnyTask(String taskId, String userId, String backActivityId, String comment, Map<String, Object> map) {
        boolean isFirst = false;
        String starterUserId = "";
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (backActivityId != null && backActivityId.equals(this.getFristActivityId(taskId))) {
            starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
            isFirst = true;
        }
        this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"reject");
        this.rejectTask(userId, taskId, backActivityId, comment, map);
        this.deleteSysActHis(task.getProcessInstanceId(), backActivityId, task.getTaskDefinitionKey());
        return this.installRejectReturnValue(task.getProcessInstanceId(), isFirst, starterUserId);
    }

    @Override
    public Result rejectToAnyTask(String taskId, String userId, String backActivityId, String comment, boolean isSubmit, Map<String, Object> map) {
        boolean isFirst = false;
        String starterUserId = "";
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (backActivityId != null && backActivityId.equals(this.getFristActivityId(taskId))) {
            starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
            isFirst = true;
        }
        this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"reject");
        this.rejectTask(userId, taskId, backActivityId, comment, map);
        this.deleteSysActHis(task.getProcessInstanceId(), backActivityId, task.getTaskDefinitionKey());
        if (!isSubmit) {
            return this.installRejectReturnValue(task.getProcessInstanceId(), isFirst, starterUserId);
        }
        return this.installRejectReturnValue(task.getProcessInstanceId(), backActivityId);
    }

    private void deleteSysActHis(String processInstanceId, String startId, String endId) {
        List<SysActHiLine> sysActHiLines = this.iSysActHiLineService.getSysActHiLineByProcessinsId(processInstanceId);
        ArrayList<SysActHiLine> result = new ArrayList<SysActHiLine>();
        TaskEngineServiceImpl.getResult(sysActHiLines, result, startId, endId);
        if (result.size() > 0) {
            this.iSysActHiLineService.deleteSysActHis(result);
        }
    }

    private Result installRejectReturnValue(String processInstanceId, boolean isFirst, String starterUserId) {
        JSONArray json = new JSONArray();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).active().list();
        if (tasks != null && tasks.size() > 0) {
            for (Task t : tasks) {
                List identityLinkList = this.taskService.getIdentityLinksForTask(t.getId());
                if (isFirst && t.getAssignee() == null && StringUtils.isNotEmpty((CharSequence)starterUserId) && (identityLinkList == null || identityLinkList.size() == 0)) {
                    this.taskService.setAssignee(t.getId(), starterUserId);
                }
                JSONObject object = new JSONObject();
                object.put("taskId", (Object)t.getId());
                object.put("definitionKey", (Object)t.getTaskDefinitionKey());
                object.put("definitionName", (Object)t.getName());
                object.put("userId", this.getAssigneeByTaskId(t.getId()));
                json.add((Object)object);
            }
        }
        return InstallResult.getResult("1", "success", json);
    }

    private Result installRejectReturnValue(String processInstanceId, String backActivityId) {
        String assignee = "";
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).taskDefinitionKey(backActivityId)).finished().orderByHistoricTaskInstanceEndTime().desc()).list();
        if (hisTaskList != null && hisTaskList.size() > 0) {
            assignee = ((HistoricTaskInstance)hisTaskList.get(0)).getAssignee();
        }
        JSONArray json = new JSONArray();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).active().list();
        if (tasks != null && tasks.size() > 0) {
            for (Task t : tasks) {
                if (t.getTaskDefinitionKey().equals(backActivityId)) {
                    Set<String> userSet = this.getAssigneeByTaskId(t.getId());
                    for (String user : userSet) {
                        this.taskService.deleteCandidateUser(t.getId(), user);
                    }
                    this.taskService.addCandidateUser(t.getId(), assignee);
                }
                JSONObject object = new JSONObject();
                object.put("taskId", (Object)t.getId());
                object.put("definitionKey", (Object)t.getTaskDefinitionKey());
                object.put("definitionName", (Object)t.getName());
                object.put("userId", this.getAssigneeByTaskId(t.getId()));
                json.add((Object)object);
            }
        }
        return InstallResult.getResult("1", "success", json);
    }

    public static List<SysActHiLine> getResult(List<SysActHiLine> list, List<SysActHiLine> result, String startId, String endId) {
        List l1 = list.stream().filter(lineHis -> startId.equals(lineHis.getOutNode())).collect(Collectors.toList());
        if (l1.size() > 0) {
            if (endId.equals(((SysActHiLine)((Object)l1.get(0))).getInNode())) {
                result.add((SysActHiLine)((Object)l1.get(0)));
                return result;
            }
            result.add((SysActHiLine)((Object)l1.get(0)));
            TaskEngineServiceImpl.getResult(list, result, ((SysActHiLine)((Object)l1.get(0))).getInNode(), endId);
        }
        return result;
    }

    private void rejectTask(String userId, String taskId, String backActivityId, String comment, Map<String, Object> map) {
        int backType = this.backType(taskId);
        if (StringUtils.isNotEmpty((CharSequence)comment)) {
            this.taskService.addComment(taskId, null, "complete", comment);
        }
        switch (backType) {
            case 1: {
                this.commonReject(userId, taskId, backActivityId, map);
                break;
            }
            case 2: {
                this.multiInstanceReject(userId, taskId, backActivityId, map);
                break;
            }
            case 3: {
                this.parallelReject(userId, taskId, backActivityId, map);
                break;
            }
            default: {
                this.commonReject(userId, taskId, backActivityId, map);
            }
        }
    }

    private void parallelReject(String userId, String taskId, String backActivityId, Map<String, Object> map) {
        if (StringUtils.isNotEmpty((CharSequence)userId)) {
            this.claimTask(taskId, userId);
        }
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String processDefinition = task.getProcessDefinitionId();
        ReadOnlyProcessDefinition processDefinitionEntity = (ReadOnlyProcessDefinition)this.repositoryService.getProcessDefinition(processDefinition);
        ActivityImpl destinationActivity = (ActivityImpl)processDefinitionEntity.findActivity(backActivityId);
        String executionId = task.getExecutionId();
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId(task.getTaskDefinitionKey()).singleResult();
        String parentId = execution.getParentId();
        ActivityImpl currentActivity = (ActivityImpl)processDefinitionEntity.findActivity(task.getTaskDefinitionKey());
        this.processEngine.getManagementService().executeCommand((Command)new ParallelJumpTaskCmd(userId, executionId, parentId, destinationActivity, map, currentActivity));
    }

    private void commonReject(String userId, String taskId, String backActivityId, Map<String, Object> map) {
        if (StringUtils.isNotEmpty((CharSequence)userId)) {
            this.claimTask(taskId, userId);
        }
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String processDefinition = task.getProcessDefinitionId();
        ReadOnlyProcessDefinition processDefinitionEntity = (ReadOnlyProcessDefinition)this.repositoryService.getProcessDefinition(processDefinition);
        ActivityImpl destinationActivity = (ActivityImpl)processDefinitionEntity.findActivity(backActivityId);
        String executionId = task.getExecutionId();
        String parentId = task.getExecutionId();
        ActivityImpl currentActivity = (ActivityImpl)processDefinitionEntity.findActivity(task.getTaskDefinitionKey());
        this.processEngine.getManagementService().executeCommand((Command)new CommonJumpTaskCmd(executionId, parentId, destinationActivity, map, currentActivity));
    }

    private void multiInstanceReject(String userId, String taskId, String backActivityId, Map<String, Object> map) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String processDefinition = task.getProcessDefinitionId();
        ReadOnlyProcessDefinition processDefinitionEntity = (ReadOnlyProcessDefinition)this.repositoryService.getProcessDefinition(processDefinition);
        ActivityImpl destinationActivity = (ActivityImpl)processDefinitionEntity.findActivity(backActivityId);
        String executionId = task.getExecutionId();
        List execution = this.runtimeService.createExecutionQuery().activityId(task.getTaskDefinitionKey()).list();
        String parentId = ((Execution)execution.get(0)).getParentId();
        ActivityImpl currentActivity = (ActivityImpl)processDefinitionEntity.findActivity(task.getTaskDefinitionKey());
        this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceJumpTaskCmd(userId, executionId, parentId, destinationActivity, map, currentActivity));
    }

    private String getLastActivityId(String taskId) {
        ArrayList<PvmTransition> pt;
        String backActivityId = "";
        HashMap map = new HashMap();
        HistoricTaskInstance currTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
        List list = ((HistoricActivityInstanceQuery)this.processEngine.getHistoryService().createHistoricActivityInstanceQuery().processInstanceId(currTask.getProcessInstanceId()).orderByHistoricActivityInstanceEndTime().activityType(this.userTask).finished().desc()).list();
        ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(currTask.getProcessDefinitionId());
        ActivityImpl currActivity = definition.findActivity(currTask.getTaskDefinitionKey());
        List<PvmTransition> incomingTransitions = this.getPvmTransition(currActivity, pt = new ArrayList<PvmTransition>());
        if (incomingTransitions != null && incomingTransitions.size() > 0) {
            for (HistoricActivityInstance his : list) {
                for (int i = 0; i < incomingTransitions.size(); ++i) {
                    String id = incomingTransitions.get(i).getSource().getId();
                    if (!id.equals(his.getActivityId())) continue;
                    backActivityId = id;
                    return backActivityId;
                }
            }
        }
        return null;
    }

    private String getFristActivityId(String taskId) {
        Result allNodeInfo = this.queryHistoryActByTaskId(taskId);
        JSONArray jsonArray = allNodeInfo.getResult();
        JSONObject jsonObject = new JSONObject();
        if (jsonArray != null && jsonArray.size() > 0) {
            jsonObject = jsonArray.getJSONObject(jsonArray.size() - 1);
        }
        return jsonObject.getString("nodeId") == null ? "" : jsonObject.getString("nodeId");
    }

    @Override
    public Result delegateTask(String taskId, String userId) {
        try {
            this.taskService.delegateTask(taskId, userId);
            return InstallResult.getResult("1", "success", null);
        }
        catch (Exception e) {
            LOGGER.error("\u4efb\u52a1\u59d4\u6258\u51fa\u932f\uff1a" + e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    @Override
    public Result freeJump(String taskId, String activitiId) {
        try {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            if (task != null) {
                String excId = task.getExecutionId();
                TaskServiceImpl taskServiceImpl = (TaskServiceImpl)this.taskService;
                taskServiceImpl.getCommandExecutor().execute((Command)new ActivitiJumpCommand(excId, activitiId));
            }
            return InstallResult.getResult("1", "success", null);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    @Override
    public Result getCurrNodeInfoByTaskId(String taskId) {
        JSONArray json = new JSONArray();
        try {
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).list();
            List<Map<String, Object>> list = this.tasksToMap(tasks);
            json.add(list);
            return InstallResult.getResult("1", "success", json);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    @Override
    public Result lastUserTask(String taskId) {
        boolean flag = false;
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        JSONArray json = new JSONArray();
        try {
            if (task != null) {
                String excId = task.getExecutionId();
                ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(excId).singleResult();
                String activitiId = execution.getActivityId();
                ProcessDefinitionEntity def = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
                ActivityImpl activity = def.findActivity(activitiId);
                List outTransitions = activity.getOutgoingTransitions();
                for (PvmTransition pt : outTransitions) {
                    PvmActivity pa = pt.getDestination();
                    if (pa.getParent() != null) {
                        if (pa.getParent().getProperty("type") != null) {
                            List subOutTransitions;
                            String parentType = String.valueOf(pa.getParent().getProperty("type"));
                            if (!this.subProcess.equals(parentType) || (subOutTransitions = ((ActivityImpl)pa.getParent()).getOutgoingTransitions()).size() <= 0) continue;
                            for (PvmTransition tr : subOutTransitions) {
                                PvmActivity p = tr.getDestination();
                                if (!"endEvent".equals(p.getProperty("type"))) continue;
                                flag = true;
                            }
                            continue;
                        }
                        if (!"endEvent".equals(pa.getProperty("type"))) continue;
                        flag = true;
                        continue;
                    }
                    if (!"endEvent".equals(pa.getProperty("type"))) continue;
                    flag = true;
                }
            }
            JSONObject object = new JSONObject();
            object.put("flag", (Object)flag);
            json.add((Object)object);
            return InstallResult.getResult("1", "success", json);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    @Override
    public Result queryAssigneeByTaskId(String taskId) {
        Set<String> users = null;
        JSONArray json = new JSONArray();
        try {
            users = this.getAssigneeByTaskId(taskId);
            json.add(users);
            return InstallResult.getResult("1", "success", json);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    @Override
    public Result queryNextAssigneeByTaskId(String taskId, Map<String, String> formData) {
        try {
            List sf;
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            BpmnModel bm = this.getBpmnModel(task.getProcessDefinitionId());
            ArrayList<String> nextNodeList = new ArrayList<String>();
            UserTask userTask = (UserTask)((Process)bm.getProcesses().get(0)).getFlowElement(task.getTaskDefinitionKey());
            List sequenceFlows = userTask.getOutgoingFlows();
            String seqTarRef = ((SequenceFlow)sequenceFlows.get(0)).getTargetRef();
            if (((Process)bm.getProcesses().get(0)).getFlowElement(seqTarRef) instanceof ExclusiveGateway) {
                if (formData == null) {
                    return InstallResult.getResult("0", "\u53c2\u6570\u53d8\u91cf\u548c\u53c2\u6570\u503c\u4e0d\u80fd\u4e3a\u7a7a!", null);
                }
                ExclusiveGateway exclusiveGateway = (ExclusiveGateway)((Process)bm.getProcesses().get(0)).getFlowElement(seqTarRef);
                sf = exclusiveGateway.getOutgoingFlows();
                for (SequenceFlow s : sf) {
                    String ce = s.getConditionExpression();
                    if (!this.getResultByELAndFormData(ce, formData)) continue;
                    nextNodeList.add(s.getTargetRef());
                    break;
                }
            }
            if (((Process)bm.getProcesses().get(0)).getFlowElement(seqTarRef) instanceof ParallelGateway) {
                ParallelGateway parallelGateway = (ParallelGateway)((Process)bm.getProcesses().get(0)).getFlowElement(seqTarRef);
                sf = parallelGateway.getOutgoingFlows();
                for (SequenceFlow s : sf) {
                    nextNodeList.add(s.getTargetRef());
                }
            }
            if (((Process)bm.getProcesses().get(0)).getFlowElement(seqTarRef) instanceof UserTask) {
                UserTask u = (UserTask)((Process)bm.getProcesses().get(0)).getFlowElement(seqTarRef);
                nextNodeList.add(u.getId());
            }
            JSONArray json = this.getCandidateUserList(task, bm, nextNodeList);
            return InstallResult.getResult("1", "success", json);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u8282\u70b9\u53c2\u4e0e\u8005\u51fa\u9519\uff1a" + e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    private BpmnModel getBpmnModel(String processDefinitionId) {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processDefinitionId);
        InputStream xmlIs = this.repositoryService.getResourceAsStream(processDefinition.getDeploymentId(), processDefinition.getResourceName());
        return new BpmnXMLConverter().convertToBpmnModel((InputStreamProvider)new InputStreamSource(xmlIs), false, true);
    }

    private boolean getResultByELAndFormData(String el, Map formData) {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = new SimpleContext();
        for (Object k : formData.keySet()) {
            if (formData.get(k) == null) continue;
            context.setVariable(k.toString(), factory.createValueExpression(formData.get(k), formData.get(k).getClass()));
        }
        ValueExpression e = factory.createValueExpression((ELContext)context, el, Boolean.TYPE);
        return (Boolean)e.getValue((ELContext)context);
    }

    private JSONArray getCandidateUserList(Task task, BpmnModel bm, List<String> nextNodeList) {
        String userId = "";
        List<Object> userList = new ArrayList();
        List<String> deptsList = null;
        List<String> rolesList = null;
        JSONArray json = new JSONArray();
        if (nextNodeList != null && nextNodeList.size() > 0) {
            for (String nodeId : nextNodeList) {
                Map extensionElements;
                Boolean currentdept;
                UserTask userTask = (UserTask)((Process)bm.getProcesses().get(0)).getFlowElement(nodeId);
                Map extensionAttribute = userTask.getAttributes();
                List deptAttribute = (List)extensionAttribute.get("candidateDepts");
                List roleAttribute = (List)extensionAttribute.get("candidateRoles");
                if (deptAttribute != null && deptAttribute.size() > 0) {
                    String candidateDepts = ((ExtensionAttribute)deptAttribute.get(0)).getValue();
                    deptsList = Arrays.asList(candidateDepts.split(","));
                }
                if (roleAttribute != null && roleAttribute.size() > 0) {
                    String candidateRoles = ((ExtensionAttribute)roleAttribute.get(0)).getValue();
                    rolesList = Arrays.asList(candidateRoles.split(","));
                }
                if ((currentdept = Boolean.valueOf(Boolean.parseBoolean(String.valueOf((extensionElements = ((Process)bm.getProcesses().get(0)).getFlowElement(nodeId).getExtensionElements()).get("currentdept"))))).booleanValue()) {
                    userId = this.getTaskStarterUserId(task.getProcessInstanceId());
                    deptsList = this.iAssigneeChooseService.getFlowStarterDept(userId);
                }
                userList = deptsList == null && rolesList == null ? new ArrayList() : this.iAssigneeChooseService.getUserList(deptsList, rolesList);
                List candidateList = userTask.getCandidateUsers();
                if (candidateList != null && candidateList.size() > 0) {
                    userList.addAll(candidateList);
                }
                JSONObject object = new JSONObject();
                object.put("nodeId", (Object)nodeId);
                object.put("nodeName", (Object)userTask.getName());
                object.put("list", userList);
                json.add((Object)object);
            }
        }
        return json;
    }

    private Set<String> getAssigneeByTaskId(String taskId) {
        HashSet<String> users = new HashSet<String>();
        List identityLinkList = this.taskService.getIdentityLinksForTask(taskId);
        if (identityLinkList != null && identityLinkList.size() > 0) {
            for (IdentityLink identityLink : identityLinkList) {
                users.add(identityLink.getUserId());
            }
        }
        return users;
    }

    @Override
    public Result queryHistoryActByTaskId(String taskId) {
        JSONArray json = new JSONArray();
        try {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            if (task != null) {
                String processInstanceId = task.getProcessInstanceId();
                List list = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().activityType(this.userTask).processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().desc()).list();
                if (list != null && list.size() > 0) {
                    for (HistoricActivityInstance historyIns : list) {
                        JSONObject object = new JSONObject();
                        String tId = historyIns.getTaskId();
                        if (tId.equals(taskId)) continue;
                        object.put("nodeId", (Object)historyIns.getActivityId());
                        object.put("nodeName", (Object)historyIns.getActivityName());
                        object.put("taskId", (Object)tId);
                        object.put("count", (Object)list.size());
                        object.put("endTime", historyIns.getEndTime() == null ? null : Long.valueOf(historyIns.getEndTime().getTime()));
                        json.add((Object)object);
                    }
                }
            }
            return InstallResult.getResult("1", "success", json);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5386\u53f2\u73af\u8282\u4fe1\u606f\u63a5\u53e3\u51fa\u932f\uff1a" + e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    private List<Map<String, Object>> tasksToMap(List<Task> tasks) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        HashSet<String> processInstanceIds = new HashSet<String>();
        ArrayList<ProcessInstance> pis = new ArrayList();
        if (tasks != null && tasks.size() > 0) {
            for (Task t : tasks) {
                processInstanceIds.add(t.getProcessInstanceId());
            }
            pis = this.runtimeService.createProcessInstanceQuery().processInstanceIds(processInstanceIds).list();
        }
        if (tasks != null && tasks.size() > 0) {
            for (int i = 0; i < tasks.size(); ++i) {
                HashMap<String, Object> taskMap = new HashMap<String, Object>();
                Task task = tasks.get(i);
                Map variables = task.getProcessVariables();
                Map taskVariables = task.getTaskLocalVariables();
                ProcessInstance pi = this.getProcessInstance(pis, task.getProcessInstanceId());
                taskMap.put("taskId", task.getId());
                taskMap.put("name", task.getName());
                taskMap.put("assignee", task.getAssignee());
                taskMap.put("definitionKey", pi.getProcessDefinitionKey());
                taskMap.put("definitionId", task.getProcessDefinitionId());
                taskMap.put("definitionName", pi.getProcessDefinitionName());
                taskMap.put("taskDefinitionKey", task.getTaskDefinitionKey());
                taskMap.put("processInsId", task.getProcessInstanceId());
                taskMap.put("createTime", task.getCreateTime());
                taskMap.put("bussinessId", pi.getBusinessKey());
                taskMap.put("variables", variables);
                taskMap.put("taskVariables", taskVariables);
                taskMap.put("taskSourceFlag", taskVariables.get("taskSourceFlag"));
                taskMap.put("formKey", task.getFormKey());
                list.add(taskMap);
            }
        }
        return list;
    }

    private ProcessInstance getProcessInstance(List<ProcessInstance> pis, String processInstanceId) {
        if (pis != null && pis.size() > 0) {
            for (ProcessInstance p : pis) {
                if (!p.getId().equals(processInstanceId)) continue;
                return p;
            }
        }
        return null;
    }

    private List<Map<String, Object>> hisTasksToMap(List<HistoricTaskInstance> hs) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        HashSet<String> processInstanceIds = new HashSet<String>();
        ArrayList<HistoricProcessInstance> pis = new ArrayList();
        if (hs != null && hs.size() > 0) {
            for (HistoricTaskInstance h : hs) {
                processInstanceIds.add(h.getProcessInstanceId());
            }
            pis = this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(processInstanceIds).list();
        }
        if (hs != null && hs.size() > 0) {
            for (HistoricTaskInstance hsi : hs) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                HistoricProcessInstance hpi = this.getHistoricProcessInstance(pis, hsi.getProcessInstanceId());
                Map variables = hsi.getProcessVariables();
                Map taskVariables = hsi.getTaskLocalVariables();
                map.put("taskId", hsi.getId());
                map.put("name", hsi.getName());
                map.put("assignee", hsi.getAssignee());
                map.put("definitionId", hsi.getProcessDefinitionId());
                map.put("definitionKey", hpi.getProcessDefinitionKey());
                map.put("definitionName", hpi.getProcessDefinitionName());
                map.put("taskDefinitionKey", hsi.getTaskDefinitionKey());
                map.put("processInsId", hsi.getProcessInstanceId());
                map.put("claimTime", hsi.getClaimTime());
                map.put("startTime", hsi.getStartTime());
                map.put("bussinessId", hpi.getBusinessKey());
                map.put("variables", variables);
                map.put("taskVariables", taskVariables);
                map.put("taskSourceFlag", taskVariables.get("taskSourceFlag"));
                map.put("endTime", hsi.getEndTime());
                map.put("formKey", hsi.getFormKey());
                list.add(map);
            }
        }
        return list;
    }

    private HistoricProcessInstance getHistoricProcessInstance(List<HistoricProcessInstance> pis, String processInstanceId) {
        if (pis != null && pis.size() > 0) {
            for (HistoricProcessInstance p : pis) {
                if (!p.getId().equals(processInstanceId)) continue;
                return p;
            }
        }
        return null;
    }

    @Override
    public Result queryTaskIdByBusinessKey(String businessId) {
        JSONArray json = new JSONArray();
        try {
            List task = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(businessId)).list();
            if (task != null) {
                for (int i = 0; i < task.size(); ++i) {
                    json.add((Object)((Task)task.get(i)).getId());
                }
            }
            return InstallResult.getResult("1", "success", json);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5f85\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    @Override
    public Result withdrawState(String historicTaskId) {
        JSONArray json = new JSONArray();
        boolean result = false;
        try {
            HistoricTaskInstance currTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(historicTaskId)).singleResult();
            ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(currTask.getProcessInstanceId()).singleResult();
            if (instance == null) {
                LOGGER.error("\u51fa\u9519\u5566\uff01\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f");
                return InstallResult.getResult("0", "\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f\u3002", null);
            }
            ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(currTask.getProcessDefinitionId());
            if (definition == null) {
                return InstallResult.getResult("0", "\u6d41\u7a0b\u5b9a\u4e49\u672a\u627e\u5230\u3002", null);
            }
            ActivityImpl currActivity = definition.findActivity(currTask.getTaskDefinitionKey());
            List nextTransitionList = currActivity.getOutgoingTransitions();
            for (PvmTransition nextTransition : nextTransitionList) {
                List nextTransitionLists;
                PvmActivity nextActivity = nextTransition.getDestination();
                if ("parallelGateway".equals(nextActivity.getProperty("type"))) {
                    nextTransitionLists = nextActivity.getOutgoingTransitions();
                    boolean flag = false;
                    for (PvmTransition nextTransitions : nextTransitionLists) {
                        PvmActivity nextActivitys = nextTransitions.getDestination();
                        List hisList = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(instance.getId()).activityId(nextActivitys.getId()).unfinished().list();
                        if (hisList == null || hisList.size() <= 0) continue;
                        flag = true;
                    }
                    if (!flag) continue;
                    result = true;
                    continue;
                }
                if ("exclusiveGateway".equals(nextActivity.getProperty("type"))) {
                    nextTransitionLists = nextActivity.getOutgoingTransitions();
                    for (PvmTransition nextTransitions : nextTransitionLists) {
                        PvmActivity nextActivitys = nextTransitions.getDestination();
                        List hisList = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(instance.getId()).activityId(nextActivitys.getId()).unfinished().list();
                        if (hisList == null || hisList.size() <= 0) continue;
                        result = true;
                    }
                    continue;
                }
                List hisList = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(instance.getId()).activityId(nextActivity.getId()).unfinished().list();
                if (hisList != null && hisList.size() > 0) {
                    result = true;
                    continue;
                }
                result = false;
            }
            json.add((Object)result);
            return InstallResult.getResult("1", "success", json);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u80fd\u5426\u9a73\u56de\u51fa\u932f\uff1a" + e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    @Override
    public Result revokeTask(String bussinessId, String userId, String comment, Map<String, Object> map) {
        ArrayList list = new ArrayList();
        List taskList = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(bussinessId)).list();
        if (taskList != null && taskList.size() > 0) {
            Task task = (Task)taskList.get(0);
            String taskId = task.getId();
            task.setAssignee(userId);
            boolean isFirst = false;
            String starterUserId = "";
            String backActivityId = this.getLastActivityId(taskId);
            if (backActivityId != null && backActivityId.equals(this.getFristActivityId(taskId))) {
                starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
                isFirst = true;
            }
            this.deleteSysActHis(task.getProcessInstanceId(), backActivityId, task.getTaskDefinitionKey());
            this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"revoke");
            this.rejectTask(userId, taskId, backActivityId, comment, map);
            return this.installRejectReturnValue(task.getProcessInstanceId(), isFirst, starterUserId);
        }
        return InstallResult.getResult("0", "error", null);
    }

    @Override
    public Result revokeTask(String bussinessId, String userId, String comment, boolean isSubmit, Map<String, Object> map) {
        ArrayList list = new ArrayList();
        List taskList = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(bussinessId)).list();
        if (taskList != null && taskList.size() > 0) {
            Task task = (Task)taskList.get(0);
            String taskId = task.getId();
            task.setAssignee(userId);
            boolean isFirst = false;
            String starterUserId = "";
            String backActivityId = this.getLastActivityId(taskId);
            if (backActivityId != null && backActivityId.equals(this.getFristActivityId(taskId))) {
                starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
                isFirst = true;
            }
            this.deleteSysActHis(task.getProcessInstanceId(), backActivityId, task.getTaskDefinitionKey());
            this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"revoke");
            this.rejectTask(userId, taskId, backActivityId, comment, map);
            if (!isSubmit) {
                return this.installRejectReturnValue(task.getProcessInstanceId(), isFirst, starterUserId);
            }
            return this.installRejectReturnValue(task.getProcessInstanceId(), backActivityId);
        }
        return InstallResult.getResult("0", "error", null);
    }

    private String getTaskStarterUserId(String processInstanceId) {
        String starterUserId = "";
        HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (hpi != null) {
            starterUserId = hpi.getStartUserId();
        }
        return starterUserId;
    }

    private int backType(String taskId) {
        int num = 1;
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).active().singleResult();
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        if (instance == null) {
            LOGGER.error("\u51fa\u9519\u5566\uff01\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f");
            return 0;
        }
        ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
        if (definition == null) {
            LOGGER.error("\u51fa\u9519\u5566\uff01\u6d41\u7a0b\u5b9a\u4e49\u672a\u627e\u5230");
            return 0;
        }
        ActivityImpl currActivity = definition.findActivity(task.getTaskDefinitionKey());
        ActivityBehavior activityBehavior = currActivity.getActivityBehavior();
        if (activityBehavior instanceof ParallelMultiInstanceBehavior || activityBehavior instanceof SequentialMultiInstanceBehavior) {
            num = 2;
            return num;
        }
        List incomingTransitions = currActivity.getIncomingTransitions();
        for (PvmTransition pvmTransition : incomingTransitions) {
            PvmActivity pvmActivity = pvmTransition.getSource();
            if ("parallelGateway".equals(pvmActivity.getProperty("type"))) {
                num = 3;
                continue;
            }
            num = 1;
        }
        return num;
    }
}

