/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.model.controller;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.bpm.impmodle.model.ImpAttachment;
import com.jxdinfo.hussar.bpm.impmodle.model.ImpModle;
import com.jxdinfo.hussar.bpm.impmodle.service.ImpModleService;
import com.jxdinfo.hussar.bpm.rest.service.ProcessModelService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.config.properties.HussarProperties;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"model"})
public class ModelController
extends BaseController {
    @Resource
    private ProcessModelService processModelService;
    @Resource
    private ImpModleService impModleService;
    public static String status = "1";
    @Resource
    private HussarProperties hussarProperties;

    @RequestMapping(value={"/goView"})
    @RequiresPermissions(value={"model:goView"})
    @BussinessLog(key="/model/goView", type="04", value="\u6d41\u7a0b\u6a21\u578b\u5217\u8868\u9875\u9762")
    public ModelAndView goView() {
        ModelAndView mv = new ModelAndView("/bpm/model/modelquery/modelQuery.html");
        return mv;
    }

    @RequestMapping(value={"/modelQuery"})
    public Map<String, Object> queryModelList(@RequestParam(required=false) String name, @RequestParam(required=false) Integer page, @RequestParam(required=false) Integer limit) {
        try {
            Map<String, Object> result = this.processModelService.queryModelList(name, page, limit);
            return result;
        }
        catch (Exception e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/modelDelete"})
    @RequiresPermissions(value={"model:modelDelete"})
    @BussinessLog(key="/model/modelDelete", type="02", value="\u5220\u9664\u6d41\u7a0b\u6a21\u578b")
    public String deleteModel(@RequestParam(value="modelId") String modelId) {
        try {
            String[] id = modelId.split(",");
            String result = "";
            for (int i = 0; i < id.length; ++i) {
                result = this.processModelService.deleteModel(id[i]);
            }
            return result;
        }
        catch (Exception e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/modelCreate"})
    @RequiresPermissions(value={"model:modelCreate"})
    @BussinessLog(key="/model/modelCreate", type="01", value="\u65b0\u589e\u6d41\u7a0b\u6a21\u578b")
    public void createModel(HttpServletRequest request, HttpServletResponse response) {
        try {
            String str = this.processModelService.createModel();
            com.alibaba.fastjson.JSONObject jsonobject = JSON.parseObject((String)str);
            String result = jsonobject.get((Object)"result").toString();
            com.alibaba.fastjson.JSONObject job = JSON.parseObject((String)result);
            String modelId = job.get((Object)"modelId").toString();
            response.sendRedirect(request.getContextPath() + "/static/modeler.html?modelId=" + modelId);
        }
        catch (Exception e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/modelEdit"})
    @RequiresPermissions(value={"model:modelEdit"})
    public void modelEdit(@RequestParam(value="modelId") String modelId, HttpServletRequest request, HttpServletResponse response) {
        try {
            response.sendRedirect(request.getContextPath() + "/static/modeler.html?modelId=" + modelId);
        }
        catch (Exception e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/modelDeploy"})
    @RequiresPermissions(value={"model:modelDeploy"})
    @BussinessLog(key="/model/modelDeploy", type="03", value="\u90e8\u7f72\u6d41\u7a0b")
    public String deployModel(@RequestParam(value="modelId") String modelId) {
        try {
            String result = this.processModelService.deployModel(modelId);
            return result;
        }
        catch (Exception e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/modelImport"})
    @RequiresPermissions(value={"model:modelImport"})
    @BussinessLog(key="/model/modelImport", type="09", value="\u5bfc\u5165\u6a21\u578b")
    public String importModel(@RequestParam(value="file") MultipartFile file) {
        try {
            InputStream in = null;
            FileOutputStream fos = null;
            String fileName = System.currentTimeMillis() + ".xml";
            String attachRealName = file.getOriginalFilename();
            in = file.getInputStream();
            File file1 = new File(this.hussarProperties.getFileUploadPath());
            if (!file1.exists()) {
                file1.mkdirs();
            }
            fos = new FileOutputStream(this.hussarProperties.getFileUploadPath() + File.separator + fileName);
            byte[] b = new byte[1024];
            while (in.read(b) != -1) {
                fos.write(b);
            }
            in.close();
            fos.close();
            Date day = new Date();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String impTime = df.format(day);
            ImpAttachment impAttachment = new ImpAttachment();
            String attachId = UUID.randomUUID().toString();
            impAttachment.setAttachId(attachId);
            impAttachment.setAttachName(fileName);
            impAttachment.setAttachRealName(attachRealName);
            impAttachment.setAttachPath(this.hussarProperties.getFileUploadPath() + File.separator + fileName);
            impAttachment.setAttachType("xml");
            impAttachment.setImpAttachTime(impTime);
            impAttachment.setImpAttachUser(ShiroKit.getUser().getId());
            this.impModleService.saveAttachmentInfo(impAttachment);
            String result = this.processModelService.importModel(file);
            JSONObject jsonObject = JSONObject.fromObject((Object)result);
            if (ToolUtil.equals((Object)status, (Object)jsonObject.get("code"))) {
                String data = jsonObject.get("result") == null ? "" : jsonObject.get("result").toString();
                JSONObject json = JSONObject.fromObject((Object)data);
                String impModleId = json.get("modelKey") == null ? "" : json.get("modelKey").toString();
                String impModleName = json.get("modelName") == null ? "" : json.get("modelName").toString();
                String impUser = ShiroKit.getUser().getId();
                ImpModle impModle = new ImpModle();
                impModle.setAttachId(attachId);
                impModle.setImpId(UUID.randomUUID().toString());
                impModle.setImpModleId(impModleId);
                impModle.setImpModleName(impModleName);
                impModle.setImpUser(impUser);
                impModle.setImpTime(impTime);
                this.impModleService.saveImpInfo(impModle);
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/export"})
    @RequiresPermissions(value={"model:export"})
    @BussinessLog(key="/model/export", type="08", value="\u5bfc\u51fa\u6a21\u578b")
    public void export(@RequestParam(value="modelId") String modelId, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        String[] ids = modelId.split(",");
        if (ids.length > 1) {
            ZipOutputStream zipOutputStream = null;
            ByteArrayInputStream in = null;
            try {
                response.setContentType(MediaType.APPLICATION_OCTET_STREAM.toString());
                response.setHeader("Content-Disposition", "attachment; filename=\"model.zip\"");
                zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
                for (int i = 0; i < ids.length; ++i) {
                    String id = ids[i];
                    String export = this.processModelService.exportModel(id);
                    com.alibaba.fastjson.JSONObject map = com.alibaba.fastjson.JSONObject.parseObject((String)export);
                    String result = map.get("result").toString();
                    com.alibaba.fastjson.JSONObject map1 = com.alibaba.fastjson.JSONObject.parseObject((String)result);
                    String filename = map1.get("filename").toString();
                    byte[] bpmnBytes = map1.get("bpmnBytes").toString().getBytes("UTF8");
                    in = new ByteArrayInputStream(bpmnBytes);
                    ZipEntry zipEntry = new ZipEntry(filename);
                    zipOutputStream.putNextEntry((java.util.zip.ZipEntry)zipEntry);
                    IOUtils.copy((InputStream)in, (OutputStream)zipOutputStream);
                    in.close();
                }
                zipOutputStream.flush();
                zipOutputStream.closeEntry();
                zipOutputStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (zipOutputStream != null) {
                        zipOutputStream.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            ByteArrayInputStream in = null;
            OutputStream out1 = null;
            try {
                String export = this.processModelService.exportModel(modelId);
                com.alibaba.fastjson.JSONObject map = com.alibaba.fastjson.JSONObject.parseObject((String)export);
                String result = map.get("result").toString();
                com.alibaba.fastjson.JSONObject map1 = com.alibaba.fastjson.JSONObject.parseObject((String)result);
                String filename = map1.get("filename").toString();
                byte[] bpmnBytes = map1.get("bpmnBytes").toString().getBytes("UTF8");
                in = new ByteArrayInputStream(bpmnBytes);
                byte[] b = new byte[1024];
                int len = -1;
                out1 = response.getOutputStream();
                response.addHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(filename, "UTF-8"));
                response.setContentType("application/octet-stream");
                while ((len = in.read(b, 0, 1024)) != -1) {
                    out1.write(b, 0, len);
                }
                out1.flush();
            }
            catch (Exception e) {
                PrintWriter out = null;
                try {
                    out = response.getWriter();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                out.write("\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
                e.printStackTrace();
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out1 != null) {
                        out1.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @RequestMapping(value={"/batchImport"})
    @RequiresPermissions(value={"model:batchImport"})
    @BussinessLog(key="/model/batchImport", type="09", value="\u6279\u91cf\u5bfc\u5165\u6a21\u578b\u6587\u4ef6")
    public String batchImport(@RequestParam(value="file") MultipartFile file, HttpServletRequest request) {
        String result = "";
        InputStream in = null;
        FileOutputStream fos = null;
        String fileName = System.currentTimeMillis() + ".zip";
        String attachRealName = file.getOriginalFilename();
        try {
            in = file.getInputStream();
            fos = new FileOutputStream(this.hussarProperties.getFileUploadPath() + File.separator + fileName);
            byte[] b = new byte[1024];
            while (in.read(b) != -1) {
                fos.write(b);
            }
            in.close();
            fos.close();
            List<String> fileList = this.unZipFile(this.hussarProperties.getFileUploadPath() + File.separator + fileName, this.hussarProperties.getFileUploadPath(), request);
            Date day = new Date();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String impTime = df.format(day);
            ImpAttachment impAttachment = new ImpAttachment();
            String attachId = UUID.randomUUID().toString();
            impAttachment.setAttachId(attachId);
            impAttachment.setAttachName(fileName);
            impAttachment.setAttachRealName(attachRealName);
            impAttachment.setAttachPath(this.hussarProperties.getFileUploadPath() + File.separator + fileName);
            impAttachment.setAttachType("zip");
            impAttachment.setImpAttachTime(impTime);
            impAttachment.setImpAttachUser(ShiroKit.getUser().getId());
            this.impModleService.saveAttachmentInfo(impAttachment);
            for (int i = 0; i < fileList.size(); ++i) {
                FileInputStream fis = new FileInputStream(fileList.get(i));
                result = this.processModelService.batchImportModel(fis);
                JSONObject jsonObject = JSONObject.fromObject((Object)result);
                if (!"1".equals(jsonObject.get("code"))) continue;
                String data = jsonObject.get("result") == null ? "" : jsonObject.get("result").toString();
                JSONObject json = JSONObject.fromObject((Object)data);
                String impModleId = json.get("modelKey") == null ? "" : json.get("modelKey").toString();
                String impModleName = json.get("modelName") == null ? "" : json.get("modelName").toString();
                String impUser = ShiroKit.getUser().getId();
                ImpModle impModle = new ImpModle();
                impModle.setImpId(UUID.randomUUID().toString());
                impModle.setAttachId(attachId);
                impModle.setImpModleId(impModleId);
                impModle.setImpModleName(impModleName);
                impModle.setImpUser(impUser);
                impModle.setImpTime(impTime);
                this.impModleService.saveImpInfo(impModle);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return result;
        }
        return result;
    }

    public List<String> unZipFile(String zipFile, String filePath, HttpServletRequest request) {
        String clientChartSet = request.getCharacterEncoding();
        ArrayList<String> resultList = new ArrayList<String>();
        try {
            File pathFile = new File(filePath);
            if (!pathFile.exists()) {
                pathFile.mkdirs();
            }
            ZipFile zip = new ZipFile(zipFile, "UTF-8");
            Enumeration entries = zip.getEntries();
            while (entries.hasMoreElements()) {
                int len;
                ZipEntry entry = (ZipEntry)entries.nextElement();
                String zipEntryName = entry.getName();
                InputStream in = zip.getInputStream(entry);
                String outPath = (filePath + new String(zipEntryName.getBytes(clientChartSet))).replaceAll("\\*", File.separator);
                int lastIndex = 0;
                lastIndex = outPath.lastIndexOf(File.separator) != -1 ? outPath.lastIndexOf(File.separator) : outPath.lastIndexOf("/");
                File file = new File(outPath.substring(0, lastIndex));
                if (!file.exists()) {
                    file.mkdirs();
                }
                if (new File(outPath).isDirectory()) continue;
                resultList.add(outPath);
                FileOutputStream out = new FileOutputStream(outPath);
                byte[] buf1 = new byte[1024];
                while ((len = in.read(buf1)) > 0) {
                    ((OutputStream)out).write(buf1, 0, len);
                }
                in.close();
                ((OutputStream)out).close();
            }
            zip.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resultList;
    }
}

