/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.process.controller;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bpm.process.model.ProcessDefinitionModel;
import com.jxdinfo.hussar.bpm.processimage.utils.HMProcessDiagramGenerator;
import com.jxdinfo.hussar.bpm.rest.service.ProcessInstanceService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.activiti.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.activiti.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.activiti.engine.task.TaskQuery;
import org.activiti.spring.ProcessEngineFactoryBean;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/ProcessDefinitionsController"})
public class ProcessDefinitionsController
extends BaseController {
    @Autowired
    private ProcessEngineFactoryBean processEngine;
    @Autowired
    private TaskService taskService;
    @Autowired
    private RepositoryService repositoryService;
    @Resource
    private ProcessInstanceService service;

    @RequestMapping(value={"/queryProcessDefinitionsList"})
    public Map<String, Object> getProcessDefinitions(@RequestParam(value="definitionName", required=false) String definitionName, @RequestParam(required=false) Integer page, @RequestParam(required=false) Integer limit) {
        try {
            definitionName = URLDecoder.decode(URLDecoder.decode(definitionName, "UTF-8"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        JSONObject json = new JSONObject();
        List processDefinitionList = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionNameLike("%" + definitionName + "%").latestVersion().orderByProcessDefinitionName().desc()).listPage((page - 1) * limit, limit.intValue());
        ArrayList<ProcessDefinitionModel> result = new ArrayList<ProcessDefinitionModel>(processDefinitionList.size());
        for (ProcessDefinition processDefinition : processDefinitionList) {
            ProcessDefinitionModel item = new ProcessDefinitionModel();
            item.setId(processDefinition.getId());
            item.setKey(processDefinition.getKey());
            item.setProcessName(processDefinition.getName());
            item.setVersion(Integer.toString(processDefinition.getVersion()));
            item.setIsSuspended(Boolean.toString(processDefinition.isSuspended()));
            item.setDescription(processDefinition.getDescription());
            item.setCategory(processDefinition.getCategory());
            item.setDeploymentId(processDefinition.getDeploymentId());
            if (processDefinition.getResourceName() != null) {
                item.setResourceName(processDefinition.getResourceName());
            } else {
                item.setResourceName("");
            }
            if (processDefinition.getDiagramResourceName() != null) {
                String name = processDefinition.getDiagramResourceName();
                String diagramResourceName = name.substring(0, name.indexOf("."));
                item.setDiagramResourceName(diagramResourceName);
            } else {
                item.setDiagramResourceName("");
            }
            Deployment deploymentTime = (Deployment)this.repositoryService.createDeploymentQuery().deploymentId(processDefinition.getDeploymentId()).singleResult();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String timeStr = sdf.format(deploymentTime.getDeploymentTime());
            item.setDeploymentTime(timeStr);
            result.add(item);
        }
        int total = (int)this.repositoryService.createProcessDefinitionQuery().processDefinitionNameLike("%" + definitionName + "%").latestVersion().count();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("count", total);
        map.put("code", 0);
        map.put("msg", "success");
        map.put("data", result);
        return map;
    }

    @RequestMapping(value={"/suspendProcess"})
    @ResponseBody
    @RequiresPermissions(value={"ProcessDefinitionsController:suspendProcess"})
    @BussinessLog(key="/ProcessDefinitionsController/suspendProcess", type="03", value="\u6302\u8d77\u6d41\u7a0b\u5b9a\u4e49")
    public String suspendProcessDefinitionById(@RequestParam(value="id", required=false) String definitionId) {
        String result = "fail";
        try {
            definitionId = URLDecoder.decode(URLDecoder.decode(definitionId, "UTF-8"), "UTF-8");
            this.repositoryService.suspendProcessDefinitionById(definitionId);
            result = "success";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @RequestMapping(value={"/activatedProcess"})
    @ResponseBody
    @RequiresPermissions(value={"ProcessDefinitionsController:activatedProcess"})
    @BussinessLog(key="/ProcessDefinitionsController/activatedProcess", type="03", value="\u6fc0\u6d3b\u6d41\u7a0b\u5b9a\u4e49")
    public String activatedProcessDefinitionById(@RequestParam(value="id", required=false) String definitionId) {
        String result = "fail";
        try {
            definitionId = URLDecoder.decode(URLDecoder.decode(definitionId, "UTF-8"), "UTF-8");
            this.repositoryService.activateProcessDefinitionById(definitionId);
            result = "success";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @RequestMapping(value={"/processDefinitionsView"})
    @RequiresPermissions(value={"ProcessDefinitionsController:processDefinitionsView"})
    @BussinessLog(key="/ProcessDefinitionsController/processDefinitionsView", type="04", value="\u6d41\u7a0b\u5b9a\u4e49\u9875\u9762")
    public ModelAndView processDefinitionsView() {
        ModelAndView mv = new ModelAndView("/bpm/process/mainPage/processDefinitions.html");
        return mv;
    }

    @RequestMapping(value={"/deleteData"})
    @ResponseBody
    @RequiresPermissions(value={"ProcessDefinitionsController:deleteData"})
    @BussinessLog(key="/ProcessDefinitionsController/deleteData", type="02", value="\u5220\u9664\u6d41\u7a0b\u5b9a\u4e49")
    public String deleteDeployment(@RequestParam(value="deploymentId", required=false) String deploymentIds) {
        String result = "fail";
        String[] idArr = deploymentIds.split(",");
        try {
            int i;
            for (i = 0; i < idArr.length; ++i) {
                List tasks = ((TaskQuery)this.taskService.createTaskQuery().deploymentId(idArr[i])).list();
                if (tasks.size() <= 0) continue;
                return "active";
            }
            for (i = 0; i < idArr.length; ++i) {
                this.repositoryService.deleteDeployment(idArr[i]);
            }
            result = "success";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/getXML"})
    public void getXML(@RequestParam(value="deploymentId", required=false) String deploymentId, @RequestParam(value="resourceName", required=false) String resourceName, HttpServletResponse response) {
        OutputStream out = null;
        InputStream in = null;
        try {
            deploymentId = URLDecoder.decode(URLDecoder.decode(deploymentId, "UTF-8"), "UTF-8");
            resourceName = URLDecoder.decode(URLDecoder.decode(resourceName, "UTF-8"), "UTF-8");
            in = this.processEngine.getProcessEngineConfiguration().getRepositoryService().getResourceAsStream(deploymentId, resourceName);
            byte[] b = new byte[1024];
            int len = -1;
            out = response.getOutputStream();
            response.addHeader("Content-Disposition", "attachment;filename=" + new String(resourceName.getBytes("GBK"), "ISO-8859-1"));
            response.setContentType("application/octet-stream");
            while ((len = in.read(b, 0, 1024)) != -1) {
                out.write(b, 0, len);
            }
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/getpic"})
    public void getpic(@RequestParam(value="definitionId") String definitionId, HttpServletResponse response) {
        try {
            definitionId = URLDecoder.decode(URLDecoder.decode(definitionId, "UTF-8"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        HMProcessDiagramGenerator hmProcessDiagramGenerator = new HMProcessDiagramGenerator();
        BpmnModel bm = this.repositoryService.getBpmnModel(definitionId);
        OutputStream os = null;
        try {
            InputStream is = hmProcessDiagramGenerator.generateDiagram(bm, "png", new ArrayList(), new ArrayList(), "\u96c5\u9ed1", "\u96c5\u9ed1", "\u96c5\u9ed1", null, 1.0, new ArrayList<String>(), new HashMap());
            int size = is.available();
            byte[] data = new byte[size];
            is.read(data);
            response.setContentType("image/png");
            os = response.getOutputStream();
            os.write(data);
            os.flush();
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @RequestMapping(value={"getProcessTrace"})
    @ResponseBody
    public List<Map<String, Object>> getProcessTrace(@RequestParam(value="definitionId") String definitionId, HttpServletResponse response) throws Exception {
        try {
            definitionId = URLDecoder.decode(URLDecoder.decode(definitionId, "UTF-8"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ArrayList<Map<String, Object>> activityInfos = new ArrayList<Map<String, Object>>();
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(definitionId);
        List activitiList = processDefinition.getActivities();
        for (ActivityImpl activity : activitiList) {
            TaskDefinition taskDefinition;
            UserTaskActivityBehavior userTaskActivityBehavior;
            HashMap<String, Object> activityInfo = new HashMap<String, Object>();
            activityInfo.put("width", activity.getWidth());
            activityInfo.put("height", activity.getHeight());
            activityInfo.put("x", activity.getX());
            activityInfo.put("y", activity.getY());
            activityInfo.put("actId", activity.getId());
            if (activity.getProperty("name") == null || "".equals(activity.getProperty("name").toString())) {
                activityInfo.put("name", "\u672a\u8bbe\u7f6e");
            } else {
                activityInfo.put("name", activity.getProperty("name"));
            }
            activityInfo.put("type", activity.getProperty("type"));
            ActivityBehavior activityBehavior = activity.getActivityBehavior();
            if (activityBehavior instanceof ParallelMultiInstanceBehavior) {
                ParallelMultiInstanceBehavior parallelMultiInstanceBehavior = (ParallelMultiInstanceBehavior)activityBehavior;
                userTaskActivityBehavior = (UserTaskActivityBehavior)parallelMultiInstanceBehavior.getInnerActivityBehavior();
                taskDefinition = userTaskActivityBehavior.getTaskDefinition();
                if (taskDefinition.getCandidateUserIdExpressions() == null || "".equals(taskDefinition.getCandidateUserIdExpressions().toString())) {
                    activityInfo.put("assignee", "\u672a\u8bbe\u7f6e");
                } else {
                    activityInfo.put("assignee", taskDefinition.getCandidateUserIdExpressions().toString());
                }
            } else if (activityBehavior instanceof UserTaskActivityBehavior) {
                UserTaskActivityBehavior userTaskActivityBehavior2 = (UserTaskActivityBehavior)activityBehavior;
                TaskDefinition taskDefinition2 = userTaskActivityBehavior2.getTaskDefinition();
                if (taskDefinition2.getCandidateUserIdExpressions() == null || "".equals(taskDefinition2.getCandidateUserIdExpressions().toString())) {
                    activityInfo.put("assignee", "\u672a\u8bbe\u7f6e");
                } else {
                    activityInfo.put("assignee", taskDefinition2.getCandidateUserIdExpressions().toString());
                }
            } else if (activityBehavior instanceof SequentialMultiInstanceBehavior) {
                SequentialMultiInstanceBehavior sequentialMultiInstanceBehavior = (SequentialMultiInstanceBehavior)activityBehavior;
                userTaskActivityBehavior = (UserTaskActivityBehavior)sequentialMultiInstanceBehavior.getInnerActivityBehavior();
                taskDefinition = userTaskActivityBehavior.getTaskDefinition();
                if (taskDefinition.getCandidateUserIdExpressions() == null || "".equals(taskDefinition.getCandidateUserIdExpressions().toString())) {
                    activityInfo.put("assignee", "\u672a\u8bbe\u7f6e");
                } else {
                    activityInfo.put("assignee", taskDefinition.getCandidateUserIdExpressions().toString());
                }
            }
            activityInfos.add(activityInfo);
        }
        return activityInfos;
    }
}

