/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.impmodle.controller;

import com.jxdinfo.hussar.bpm.impmodle.model.ImpAttachment;
import com.jxdinfo.hussar.bpm.impmodle.service.ImpModleService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"impModle"})
public class ImpModleController
extends BaseController {
    @Autowired
    private ImpModleService impModleService;

    @RequestMapping(value={"/impModleView"})
    public ModelAndView goViewRun(HttpServletRequest request) {
        String attachId = request.getParameter("attachId");
        ModelAndView mv = new ModelAndView("/bpm/impmodle/impModle.html");
        mv.addObject("attachId", (Object)attachId);
        return mv;
    }

    @RequestMapping(value={"/impAttachmentView"})
    @RequiresPermissions(value={"impModle:impAttachmentView"})
    @BussinessLog(key="/impModle/impAttachmentView", type="04", value="\u6a21\u578b\u5bfc\u5165\u9875\u9762")
    public ModelAndView impAttachmentView() {
        ModelAndView mv = new ModelAndView("/bpm/impmodle/impAttachmentView.html");
        return mv;
    }

    @RequestMapping(value={"/queryImpModle"})
    public Map<String, Object> queryImpModle(@RequestParam(required=false) String impModleName, @RequestParam(required=false) String attachId, @RequestParam(required=false) Integer page, @RequestParam(required=false) Integer limit, HttpServletResponse response, HttpServletRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("impModleName", impModleName);
        map.put("attachId", attachId);
        map.put("page", page);
        map.put("limit", limit);
        Map<String, Object> result = this.impModleService.queryImpModle(map);
        return result;
    }

    @RequestMapping(value={"/queryAttachment"})
    public Map<String, Object> queryAttachment(@RequestParam(required=false) String attachName, @RequestParam(required=false) Integer page, @RequestParam(required=false) Integer limit) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("attachName", attachName);
        map.put("page", page);
        map.put("limit", limit);
        Map<String, Object> result = this.impModleService.queryAttachemnt(map);
        return result;
    }

    @RequestMapping(value={"/deleteAttach"})
    @RequiresPermissions(value={"impModle:deleteAttach"})
    @BussinessLog(key="/impModle/deleteAttach", type="02", value="\u5220\u9664\u5bfc\u5165\u4fe1\u606f")
    public String deleteAttach(@RequestParam(value="attachId") String attachId) {
        try {
            return this.impModleService.deleteAttach(attachId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/downloadFile"})
    public void downloadFile(@RequestParam(value="attachId") String attachId, HttpServletResponse response) {
        OutputStream out = null;
        InputStream in = null;
        try {
            ImpAttachment impAttachment = this.impModleService.queryAttachemntById(attachId);
            String attachRealName = impAttachment.getAttachRealName();
            String attachPath = impAttachment.getAttachPath();
            in = new FileInputStream(attachPath);
            byte[] b = new byte[1024];
            int len = -1;
            out = response.getOutputStream();
            response.addHeader("Content-Disposition", "attachment;filename=" + new String(attachRealName.getBytes("GBK"), "ISO-8859-1"));
            response.setContentType("application/octet-stream");
            while ((len = in.read(b, 0, 1024)) != -1) {
                out.write(b, 0, len);
            }
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

