var ProcessDefinition = {};
layui.use(['jquery','layer','Hussar','jstree','HussarAjax','table'], function(){
	var Hussar = layui.Hussar;
	var $ = layui.jquery;
	var layer=layui.layer;
	var $ax=layui.HussarAjax;
	var table = layui.table;
            table.render({
                elem: '#processDefinitionTable',
                url: Hussar.ctxPath+"/ProcessDefinitionsController/queryProcessDefinitionsList",
                cols: [[
                    {type:'checkbox'},
                    {type:'numbers',width:46, title: '序号'},
                    {field: 'key', title: '流程定义编码', align:'center',templet:function (params) {
                        if (params.key == null || params.key== "") {
                            return "";
                        } else {
                            return '<div title ="' + params.key + '">' + params.key + '</div>';
                        }
                    }},
                    {field: 'processName', title: '流程定义名称', align:'center'},
                    {field: 'version',width:58, title: '版本', align:'center'},
                    {field: 'resourceName', title: 'xml文件', align:'center',event: 'downloadXml',style:'cursor: pointer;color:#00a4ff'},
                    {field: 'deploymentTime', title: '部署时间', align:'center'},
                    {field: 'isSuspended',width:60, title: '状态', align:'center',templet:Format},
                    {field: 'diagramResourceName', title: '流程图片', align:'center',event: 'openPic', style:'cursor: pointer;color:#00a4ff'}
                ]],
                where: {
                    definitionName: encodeURI(encodeURI($('#processDefinitionName').val())),
                }
                ,page: true
                ,height:$("body").height() - $(".toolbar").outerHeight(true) -70
                ,loading:true
                ,text: {
                    none: '暂无相关数据' //默认：无数据。注：该属性为 layui 2.2.5 开始新增
                }
                ,even: true
            });
            function Format(params) {
                if(params.isSuspended=="false"){
                    return "激活";
                }else if(params.isSuspended=="true"){
                    return "挂起";
                }
            }
            table.on('tool(clickEvent)', function(obj){
                var data = obj.data;
                if(obj.event === 'openPic'){
                    layui.use('layer', function(){
                        var layer = layui.layer;
                        layer.open({
                            type: 1,
                            title:data.processName,
                            maxmin : true,
                            content: $('#picWindow'), //这里content是一个DOM，注意：最好该元素要存放在body最外层，否则可能被其它的相对元素所影响
                            area: ["866px", "450px"],
                            success: function(){
                            },
                            end: function () {
                                $('#picWindow').hide();
                            }
                        });
                    });
                    var flowImageAndRect = $('#flowImageAndRect');
                    flowImageAndRect.empty();
                    // 加载流程图片
                    loadProcessImage(data.id);
                    // 加载各节点信息
                    //setTimeout(function(){
                    //    loadProcessTrace(data.id);
                    //},200);
                }else if(obj.event === 'downloadXml'){
                    var depId=encodeURI(encodeURI(data.deploymentId));
                    var resourceName=encodeURI(encodeURI(data.resourceName));
                    window.location.href=Hussar.ctxPath+"/ProcessDefinitionsController/getXML?deploymentId="+depId+"&resourceName="+resourceName+"";
                }
            });
            /*查询*/
            $("#search").click(function searcha() {
                reloadTable();
            });

            /*删除*/
            $("#deleteBtn").click(function(){
                var ids = [];
                var table = layui.table;
                var checkStatus = table.checkStatus("processDefinitionTable");
                var data = checkStatus.data;
                for(var i=0;i<data.length;i++){    //循环筛选出id
                    ids.push(data[i].deploymentId);
                }
                if(data.length == 0){
                    Hussar.info("请选择要删除的记录");
                }else{
                    var eId = ids.join(',');
                    var operation =function(){
                        var ajax = new $ax(Hussar.ctxPath+"/ProcessDefinitionsController/deleteData",
                            function(data) {
                                if(data == "success"){
                                    reloadTable();
                                    Hussar.success("删除成功");
                                }else if(data == "active"){
                                    Hussar.info("存在运行中的流程实例，无法删除");
                                }else{
                                    Hussar.error("删除失败");
                                }
                            }, function(data) {
                                Hussar.error("删除失败！");
                            });
                        ajax.set("deploymentId", eId);
                        ajax.start();
                    };
                    Hussar.confirm("确定要删除吗 ?", operation);
                }
            });

            /*挂起*/
            $('#suspendBtn').click(function(){
                var table = layui.table;
                var checkStatus = table.checkStatus("processDefinitionTable");
                var data = checkStatus.data;
                if(data.length == 0){
                    Hussar.info("请选择一条挂起的记录！");
                    return;
                }else if (data.length > 1){
                    Hussar.info("请选择一条挂起的记录！");
                    return;
                }
                if(data[0].isSuspended=="true"){
                    Hussar.info("此流程已挂起！");
                    return;
                }
                var id=encodeURI(encodeURI(data[0].id));
                $.ajax({
                    type: "post",
                    url: Hussar.ctxPath+"/ProcessDefinitionsController/suspendProcess?id="+id+"",
                    success: function (data) {
                        if(data == "success"){
                            reloadTable();
                            Hussar.success("挂起成功");
                        }else{
                            Hussar.error("挂起失败");
                        }
                    },
                    error: function () {
                        Hussar.error("挂起失败");
                    }
                });
            });

            /*激活*/
            $('#activeBtn').click(function(){
                var table = layui.table;
                var checkStatus = table.checkStatus("processDefinitionTable");
                var data = checkStatus.data;
                if(data.length == 0){
                    Hussar.info("请选择一条激活的记录！");
                    return;
                }else if (data.length > 1){
                    Hussar.info("请选择一条激活的记录！");
                    return;
                }
                if(data[0].isSuspended=="false"){
                    Hussar.info("此流程已激活！");
                    return;
                }
                var id=encodeURI(encodeURI(data[0].id));
                $.ajax({
                    type: "post",
                    url: Hussar.ctxPath+"/ProcessDefinitionsController/activatedProcess?id="+id+"",
                    success: function (data) {
                        if(data == "success"){
                            reloadTable();
                            Hussar.success("激活成功");
                        }else{
                            Hussar.error("激活失败");
                        }
                    },
                    error: function () {
                        Hussar.error("激活失败");
                    }
                });
            });

            /*重置*/
            $("#reset").click(function () {
                //流程定义名称
                $('#processDefinitionName').val('');
                //重新加载表格
                reloadTable();
            });

            /**
             * 加载图片
             */
            function loadProcessImage(id){
                var imageUrl = Hussar.ctxPath+"/ProcessDefinitionsController/getpic?definitionId="+encodeURI(encodeURI(id))+"";
                // 加载图片
                $('<img />',{
                    "src" : imageUrl,
                    "alt" : '',
                    "class":"imgLeft",
                }).appendTo($('#flowImageAndRect'));

            }
            /**
             * 加载流程中各节点的信息
             * @param id : 流程定义的id
             */
            function loadProcessTrace(id) {
                var traceUrl = Hussar.ctxPath+"/ProcessDefinitionsController/getProcessTrace?definitionId=" + encodeURI(encodeURI(id)) + "";
                var html = "";
                $.ajax({
                    type: "get",
                    url: traceUrl,
                    traditional: true,
                    success: function (infos) {
                        $.each(infos, function (i, v) {
                            // 矩形的div
                            var $div = $('<div/>', {
                                'class': 'activity-attr',
                                'onmouseover' : 'ProcessDefinition.over("'+v.actId+'")',
                                'onmouseout' : 'ProcessDefinition.out("'+v.actId+'")',
                            }).css({
                                position: 'absolute',
                                left: v.x,
                                top: v.y,
                                width: v.width,
                                height: v.height,
                                opacity: 0,
                                zIndex: 100,
                            }).attr({'actId': v.actId, 'name': v.name});
                            html += $div.prop("outerHTML");
                        });

                        $.each(infos, function (i, v) {
                            // 矩形的div
                            var assignee='';
                            if(v.type=='userTask'){
                                assignee='    <tr>\n' +
                                    '        <td ><span>处理人</span></td>\n' +
                                    '        <td ><span id="numZJ">'+v.assignee+'</span></td>\n' +
                                    '    </tr>\n'
                            }
                            var $div = $('<div id="'+v.actId+'" class="hideDiv"><table class="activityTable">\n' +
                                '    <tbody>\n' +
                                '    <tr>\n' +
                                '        <td ><span>节点名称</span></td>\n' +
                                '        <td ><span id="numHQ">'+v.name+'</span></td>\n' +
                                '    </tr>\n' +
                                '    <tr>\n' +
                                '        <td ><span>节点类型</span></td>\n' +
                                '        <td ><span id="numHZ">'+v.type+'</span></td>\n' +
                                '    </tr>\n' +
                                assignee+
                                '    </tbody>\n' +
                                '</table></div>', {
                                'class': ''
                            }).css({
                                position: 'absolute',
                                left: v.x+v.width+3,
                                top: v.y,
                                width: 300,
                                height: v.height ,
                                opacity: 999,
                                zIndex: 10000000,
                            }).attr({'actId': v.actId, 'name': v.name});
                            html += $div.prop("outerHTML");
                        });
                        $('<div />', {'id': 'processRect'}).html(html).appendTo($('#flowImageAndRect'));
                    }
                })
            }
            /*鼠标悬停*/
            ProcessDefinition.over=function(id){
                $('#'+id).show();
            }
            /*鼠标移出*/
            ProcessDefinition.out=function(id){
                $('#'+id).hide();
            }

            function reloadTable() {
                var table = layui.table;
                table.reload("processDefinitionTable", {
                    where: {
                        definitionName: encodeURI(encodeURI($('#processDefinitionName').val())),
                    }
                });
            }
        });
