/**
 * Created by lenovo on 2018/2/28.
 */
layui.use(['jquery','layer','Hussar','jstree','HussarAjax','table'], function(){
	var Hussar = layui.Hussar;
	var $ = layui.jquery;
	var layer=layui.layer;
	var $ax=layui.HussarAjax;
	var table = layui.table;
        //初始化表格
            table.render({
                elem: '#modelTable',
                url:Hussar.ctxPath+'/model/modelQuery',
                where:{
                    name: $('#modelName').val()
                },
                cols: [[
                    {type:'checkbox'},
                    {type:'numbers', title: '序号'},
                    {field: 'processDefinitionId', title: '流程定义ID', align:'center',width:250},
                    {field: 'modelKey', title: '流程定义KEY', align:'center'},
                    {field: 'name', title: '流程模型名称', align:'center', visible:false},
                    {field: 'description', title: '流程模型描述', align:'center',templet: function(params){
                        var dd = JSON.parse(params.description).description;
                        if (dd != "" && dd != undefined && dd != null) {
                            return dd;
                        }else{
                            return "";
                        }
                    }},
                    {field: 'creatTime', title: '创建时间', align:'center'},
                    {field: 'lastEditTime', title: '最后修改时间', align:'center'}
                ]]
                ,page: true
                ,height:$("body").height() - $(".toolbar").outerHeight(true) -70
                ,loading:true
                ,text: {
                    none: '暂无相关数据' //默认：无数据。注：该属性为 layui 2.2.5 开始新增
                }
                ,even: true
            });

            /*查询*/
            $("#search").click(function () {
                reloadTable();
            });
            function reloadTable() {
                var table = layui.table;
                table.reload("modelTable", {
                    where: {
                        name: $('#modelName').val()
                    }
                });
            }
            /*新增*/
            $("#add").click(function(){
                window.open(Hussar.ctxPath+"/model/modelCreate");
            });
            /*导入*/
            $("#import").click(function(){
                $("#importFlag").val("import");
                importForm();
            });
            /*导入保存*/
            $("#importSave").click(function () {
               importSave();
            });
            /*批量导入*/
            $("#batchImport").click(function(){
                $("#importFlag").val("batchImport");
                importForm();
            });

            /*导出*/
            $("#export").click(function(){
                exportForm();
            });
            /*修改*/
            $('#edit').click(function(){
                editForm();
            });

            /*部署*/
            $('#deploy').click(function(){
                deployForm();
            });
            /*重置*/
            $("#reset").click(function () {
                $('#modelName').val('');
            });
            /*导入*/
            function importForm() {
                var that = this;
                layerView = layer.open({
                	type: 1,
                    title : "导入模型",
                    shadeClose: false,
                    shade: true,
                    maxmin: false, //开启最大化最小化按钮
                    area: ['440px', '160px'],
        			content : $("#importEvent"),
        			success : function() {
        				$('#importForm')[0].reset();
        			}
        		});
            }
            /*导出*/
            function exportForm() {
                var ids = [];
                var table = layui.table;
                var checkStatus = table.checkStatus("modelTable");
                var data = checkStatus.data;
                if(data.length == 0){
                    Hussar.info("请选择要导出的记录");
                }else{
                    for(var i=0;i<data.length;i++){    //循环筛选出id
                        ids.push(data[i].modelId);
                    }
                    var modelId = ids.join(',');
                    var url = Hussar.ctxPath+"/model/export?modelId="+modelId;
                    window.location.href = url;
                }
            }
            /*模型编辑*/
            function editForm() {
                //获取列表选择的记录
                var ids = [];
                var table = layui.table;
                var checkStatus = table.checkStatus("modelTable");
                var data = checkStatus.data;
                if(data.length<=0){
                    Hussar.info("请选择一条修改的记录");
                }else if(data.length > 1){
                    Hussar.info("请选择一条修改的记录");
                }else{
                    var modelId = data[0].modelId;
                    window.open(Hussar.ctxPath+"/model/modelEdit?modelId="+modelId);
                }
            }

            /*模型部署*/
            function deployForm() {
                //获取列表选择的记录
                var ids = [];
                var table = layui.table;
                var checkStatus = table.checkStatus("modelTable");
                var data = checkStatus.data;
                if(data.length<=0){
                    Hussar.info("请选择一条部署的记录");
                    return false;
                }else if(data.length > 1){
                    Hussar.info("请选择一条部署的记录");
                    return false;
                }else{
                    var modelId = data[0].modelId;
                    var url = Hussar.ctxPath+"/model/modelDeploy?modelId="+modelId;
                    $.ajax({
                        type: "post",
                        url: url,
                        success: function (data) {
                            var jsObject = JSON.parse(data);
                            var result= jsObject.result;
                            var flags = JSON.parse(result);
                            var re = flags.flag;
                            if(re=="true"){
                                Hussar.success("部署成功");
                                reloadTable();
                            }
                            if(re=="false"){
                                Hussar.error("部署失败");
                                layer.close(infoWin);
                            }
                        },
                        error: function () {
                        	 Hussar.error("部署失败");
                        }
                    });
                }
            }

            /*删除*/
            $('#delete').click(function(){
                var ids = [];
                var table = layui.table;
                var checkStatus = table.checkStatus("modelTable");
                var data = checkStatus.data;
                for(var i=0;i<data.length;i++){    //循环筛选出id
                    ids.push(data[i].modelId);
                }

                if(data.length == 0){
                    Hussar.info("请选择要删除的记录");
                }else{
                    var eId = ids.join(',');
                    var operation =function(){
                        var ajax = new $ax(Hussar.ctxPath+"/model/modelDelete",
                            function(data) {
                                var jsObject = JSON.parse(data);
                                var result= jsObject.result;
                                var flags = JSON.parse(result);
                                var re = flags.flag;
                                if(re=="true"){
                                    Hussar.success("删除成功");
                                    reloadTable();
                                }
                                if(re=="false"){
                                    Hussar.error("删除失败");
                                }
                            }, function(data) {
                                Hussar.error("删除失败！");
                            });
                        ajax.set("modelId", eId);
                        ajax.start();
                    };
                    Hussar.confirm("确定要删除吗 ?", operation);
                }
            });
            /*导入保存*/
            function importSave() {
                var that = this;
                if($("#importFileInput").val()==""){
                    Hussar.info("流程模型文件不能为空");
                    return;
                }
                var url;
                if ($("#importFlag").val() == "batchImport") {
                    url = Hussar.ctxPath+"/model/batchImport";
                }
                if($("#importFlag").val() == "import"){
                    url = Hussar.ctxPath+"/model/modelImport";
                }
                $("#importForm").ajaxSubmit({
                    url:url,
                    type:"post",
                    success:function (data) {
                        var jsObject = JSON.parse(data);
                        var result= jsObject.result;
                        var flags = JSON.parse(result);
                        var re = flags.flag;
                        if(re=="true"){
                            layer.closeAll();
                            Hussar.success("导入成功");
                            layer.close(layer.index);
                            reloadTable();
                        }
                        if(re=="false"){
                        	 Hussar.error("导入失败");
                        }
                    },
                    error:function(){
                    }
                })
            }
});

