/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.rest.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.bpm.common.utils.ServiceResult;
import com.jxdinfo.hussar.bpm.common.utils.StringUtils;
import com.jxdinfo.hussar.bpm.extend.ExtendBpmnJsonConverter;
import com.jxdinfo.hussar.bpm.model.model.ModelBuild;
import com.jxdinfo.hussar.bpm.rest.service.ProcessModelService;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.converter.util.InputStreamProvider;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Process;
import org.activiti.editor.language.json.converter.BpmnJsonConverter;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.util.io.InputStreamSource;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ModelQuery;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.explorer.util.XmlUtil;
import org.activiti.image.impl.DefaultProcessDiagramCanvas;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ProcessModelServiceImpl
implements ProcessModelService {
    @Autowired
    private RepositoryService repositoryService;

    @Override
    public String createModel() {
        try {
            String model_key = UUID.randomUUID().toString();
            ObjectMapper objectMapper = new ObjectMapper();
            ObjectNode editorNode = objectMapper.createObjectNode();
            editorNode.put("id", "canvas");
            editorNode.put("resourceId", "canvas");
            ObjectNode stencilSetNode = objectMapper.createObjectNode();
            stencilSetNode.put("namespace", "http://b3mn.org/stencilset/bpmn2.0#");
            editorNode.put("stencilset", (JsonNode)stencilSetNode);
            ObjectNode stencilSetNode2 = objectMapper.createObjectNode();
            String date = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
            String processId = "key-" + date;
            stencilSetNode2.put("process_id", processId);
            stencilSetNode2.put("process_namespace", "http://www.jxdinfo.com/");
            editorNode.put("properties", (JsonNode)stencilSetNode2);
            Model modelData = this.repositoryService.newModel();
            ObjectNode modelObjectNode = objectMapper.createObjectNode();
            modelObjectNode.put("revision", 1);
            modelData.setMetaInfo(modelObjectNode.toString());
            modelData.setKey(StringUtils.defaultString((String)model_key));
            this.repositoryService.saveModel(modelData);
            this.repositoryService.addModelEditorSource(modelData.getId(), editorNode.toString().getBytes("utf-8"));
            HashMap<String, String> mapStr = new HashMap<String, String>();
            mapStr.put("modelId", modelData.getId());
            return ServiceResult.getResult("1", "", JSON.toJSONString(mapStr));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return ServiceResult.getResult("0", "", "");
        }
    }

    @Override
    public String deployModel(String modelId) {
        HashMap<String, String> mapStr = new HashMap<String, String>();
        try {
            Model modelData = this.repositoryService.getModel(modelId);
            byte[] bytes = this.repositoryService.getModelEditorSource(modelData.getId());
            if (bytes == null) {
                mapStr.put("flag", "false");
                return ServiceResult.getResult("1", "\u6a21\u578b\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8bbe\u8ba1\u6d41\u7a0b\u5e76\u6210\u529f\u4fdd\u5b58\uff0c\u518d\u8fdb\u884c\u53d1\u5e03\u3002", JSON.toJSONString(mapStr));
            }
            JsonNode editNode = new ObjectMapper().readTree(bytes);
            BpmnJsonConverter jsonConverter = new BpmnJsonConverter();
            ExtendBpmnJsonConverter child = new ExtendBpmnJsonConverter();
            Map toBpmnMap = child.updateConvertersToBpmnMap();
            Map toJsonMap = child.updateConvertersToJsonMap();
            BpmnModel bpmnModel = jsonConverter.convertToBpmnModel(editNode);
            byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(bpmnModel);
            String processName = modelData.getName() + ".bpmn20.xml";
            Deployment deployment = this.repositoryService.createDeployment().name(modelData.getName()).addString(processName, new String(bpmnBytes, "UTF-8")).deploy();
            modelData.setDeploymentId(deployment.getId());
            this.repositoryService.saveModel(modelData);
            mapStr.put("flag", "true");
            return ServiceResult.getResult("1", "", JSON.toJSONString(mapStr));
        }
        catch (IOException e) {
            e.printStackTrace();
            mapStr.put("flag", "false");
            return ServiceResult.getResult("0", "", JSON.toJSONString(mapStr));
        }
    }

    @Override
    public String validateModel(String modelId) {
        return null;
    }

    @Override
    public Map<String, Object> queryModelList(String modelName, Integer page, Integer limit) {
        try {
            Long listCount = this.repositoryService.createModelQuery().modelNameLike("%" + modelName + "%").count();
            List list = ((ModelQuery)this.repositoryService.createModelQuery().modelNameLike("%" + modelName + "%").orderByLastUpdateTime().desc()).listPage((page - 1) * limit, limit.intValue());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            ArrayList<ModelBuild> myList = new ArrayList<ModelBuild>();
            if (list != null) {
                BpmnJsonConverter jsonConverter = new BpmnJsonConverter();
                for (int i = 0; i < list.size(); ++i) {
                    ModelBuild modelBuild = new ModelBuild();
                    modelBuild.setModelId(((Model)list.get(i)).getId());
                    byte[] arg0 = this.repositoryService.getModelEditorSource(((Model)list.get(i)).getId());
                    String temp = new String(arg0, "utf-8").replace("undefined", "");
                    JsonNode editorNode = new ObjectMapper().readTree(temp.getBytes("utf-8"));
                    BpmnModel bpmnModel = jsonConverter.convertToBpmnModel(editorNode);
                    if (bpmnModel.getProcesses().size() > 0) {
                        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(((Process)bpmnModel.getProcesses().get(0)).getId()).latestVersion().singleResult();
                        modelBuild.setModelKey(((Process)bpmnModel.getProcesses().get(0)).getId());
                        if (processDefinition == null) {
                            modelBuild.setProcessDefinitionId("");
                        } else {
                            modelBuild.setProcessDefinitionId(processDefinition.getId());
                        }
                    } else {
                        modelBuild.setModelKey("");
                    }
                    modelBuild.setName(((Model)list.get(i)).getName());
                    modelBuild.setDescription(((Model)list.get(i)).getMetaInfo());
                    modelBuild.setCreatTime(sdf.format(((Model)list.get(i)).getCreateTime()));
                    modelBuild.setLastEditTime(sdf.format(((Model)list.get(i)).getLastUpdateTime()));
                    myList.add(modelBuild);
                }
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("count", listCount);
            map.put("code", 0);
            map.put("msg", "success");
            map.put("data", myList);
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String queryModelActivitiInfo(String modelId) {
        try {
            ArrayList activityInfos = new ArrayList();
            ProcessDefinitionEntity processModel = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getModel(modelId);
            List activitiList = processModel.getActivities();
            InputStream xmlIs = this.repositoryService.getResourceAsStream(processModel.getDeploymentId(), processModel.getResourceName());
            BpmnModel bm = new BpmnXMLConverter().convertToBpmnModel((InputStreamProvider)new InputStreamSource(xmlIs), false, true);
            Class<?> clazz = Class.forName("org.activiti.image.impl.DefaultProcessDiagramGenerator");
            Method method = clazz.getDeclaredMethod("initProcessDiagramCanvas", BpmnModel.class, String.class, String.class, String.class, String.class, ClassLoader.class);
            method.setAccessible(true);
            DefaultProcessDiagramCanvas pdc = (DefaultProcessDiagramCanvas)method.invoke(clazz.newInstance(), bm, "png", "\u5b8b\u4f53", "\u5b8b\u4f53", "\u5b8b\u4f53", null);
            clazz = Class.forName("org.activiti.image.impl.DefaultProcessDiagramCanvas");
            Field minXField = clazz.getDeclaredField("minX");
            Field minYField = clazz.getDeclaredField("minY");
            minXField.setAccessible(true);
            minYField.setAccessible(true);
            int minX = minXField.getInt(pdc);
            int minY = minYField.getInt(pdc);
            minX = minX > 0 ? minX - 5 : 0;
            minY = minY > 0 ? minY - 5 : 0;
            for (ActivityImpl activity : activitiList) {
                HashMap<String, Object> activityInfo = new HashMap<String, Object>();
                activityInfo.put("width", activity.getWidth());
                activityInfo.put("height", activity.getHeight());
                activityInfo.put("x", activity.getX() + 10);
                activityInfo.put("y", activity.getY() + 10);
                activityInfo.put("actId", activity.getId());
                activityInfo.put("name", activity.getProperty("name"));
                activityInfos.add(activityInfo);
            }
            HashMap<String, String> mapStr = new HashMap<String, String>();
            mapStr.put("data", JSONArray.toJSONString(activityInfos));
            return ServiceResult.getResult("1", "", JSON.toJSONString(mapStr));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ServiceResult.getResult("0", "", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String importModel(MultipartFile model_file) {
        HashMap<String, String> mapStr = new HashMap<String, String>();
        InputStreamReader in = null;
        try {
            XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
            in = new InputStreamReader((InputStream)new ByteArrayInputStream(model_file.getBytes()), "UTF-8");
            XMLStreamReader xtr = xif.createXMLStreamReader(in);
            BpmnModel bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
            String modelName = ((Process)bpmnModel.getProcesses().get(0)).getName();
            String modelKey = UUID.randomUUID().toString();
            Model modelData = this.repositoryService.newModel();
            ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
            modelObjectNode.put("name", modelName);
            modelObjectNode.put("revision", 1);
            modelData.setMetaInfo(modelObjectNode.toString());
            modelData.setName(modelName);
            modelData.setKey(StringUtils.defaultString((String)modelKey));
            this.repositoryService.saveModel(modelData);
            BpmnJsonConverter jsonConverter = new BpmnJsonConverter();
            ObjectNode editorNode = jsonConverter.convertToJson(bpmnModel);
            this.repositoryService.addModelEditorSource(modelData.getId(), editorNode.toString().getBytes("utf-8"));
            in.close();
            mapStr.put("flag", "true");
            mapStr.put("modelName", modelName);
            mapStr.put("modelKey", modelKey);
            String string = ServiceResult.getResult("1", "", JSON.toJSONString(mapStr));
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        mapStr.put("flag", "false");
        return ServiceResult.getResult("0", "", JSON.toJSONString(mapStr));
    }

    @Override
    public String deleteModel(String modelId) {
        HashMap<String, String> mapStr = new HashMap<String, String>();
        try {
            this.repositoryService.deleteModel(modelId);
            mapStr.put("flag", "true");
            return ServiceResult.getResult("1", "", JSON.toJSONString(mapStr));
        }
        catch (Exception e) {
            e.printStackTrace();
            mapStr.put("flag", "false");
            return ServiceResult.getResult("0", "", JSON.toJSONString(mapStr));
        }
    }

    @Override
    public String batchImportModel(FileInputStream in) {
        HashMap<String, String> mapStr = new HashMap<String, String>();
        try {
            XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
            XMLStreamReader xtr = xif.createXMLStreamReader(in);
            BpmnModel bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
            String modelName = ((Process)bpmnModel.getProcesses().get(0)).getName();
            String modelKey = UUID.randomUUID().toString();
            Model modelData = this.repositoryService.newModel();
            ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
            modelObjectNode.put("name", modelName);
            modelObjectNode.put("revision", 1);
            modelData.setMetaInfo(modelObjectNode.toString());
            modelData.setName(modelName);
            modelData.setKey(StringUtils.defaultString((String)modelKey));
            this.repositoryService.saveModel(modelData);
            BpmnJsonConverter jsonConverter = new BpmnJsonConverter();
            ObjectNode editorNode = jsonConverter.convertToJson(bpmnModel);
            this.repositoryService.addModelEditorSource(modelData.getId(), editorNode.toString().getBytes("utf-8"));
            mapStr.put("flag", "true");
            mapStr.put("modelName", modelName);
            mapStr.put("modelKey", modelKey);
            return ServiceResult.getResult("1", "", JSON.toJSONString(mapStr));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        mapStr.put("flag", "false");
        return ServiceResult.getResult("0", "", JSON.toJSONString(mapStr));
    }

    @Override
    public String exportModel(String modelId) {
        try {
            Model modelData = this.repositoryService.getModel(modelId);
            BpmnJsonConverter jsonConverter = new BpmnJsonConverter();
            byte[] arg0 = this.repositoryService.getModelEditorSource(modelData.getId());
            JsonNode editorNode = new ObjectMapper().readTree(arg0);
            BpmnModel bpmnModel = jsonConverter.convertToBpmnModel(editorNode);
            BpmnXMLConverter xmlConverter = new BpmnXMLConverter();
            byte[] bpmnBytes = xmlConverter.convertToXML(bpmnModel);
            String modelMark = ((Process)bpmnModel.getProcesses().get(0)).getId();
            String filename = modelData.getName() + "_" + modelMark + ".bpmn20.xml";
            String isoString = new String(bpmnBytes, "UTF-8");
            HashMap<String, String> mapStr = new HashMap<String, String>();
            mapStr.put("filename", filename);
            mapStr.put("bpmnBytes", isoString);
            return ServiceResult.getResult("1", "", JSON.toJSONString(mapStr));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ServiceResult.getResult("0", "", "");
        }
    }
}

