/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.rest.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.bpm.common.utils.BpmConstant;
import com.jxdinfo.hussar.bpm.common.utils.ServiceResult;
import com.jxdinfo.hussar.bpm.rest.service.TaskWebService;
import com.jxdinfo.hussar.bpm.rest.util.ActivitiJumpCommand;
import com.jxdinfo.hussar.bpm.rest.util.CommonJumpTaskCmd;
import com.jxdinfo.hussar.bpm.rest.util.MultiInstanceJumpTaskCmd;
import com.jxdinfo.hussar.bpm.rest.util.ParallelJumpTaskCmd;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.converter.util.InputStreamProvider;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricIdentityLink;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.TaskServiceImpl;
import org.activiti.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.activiti.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.ValueExpression;
import org.activiti.engine.impl.juel.ExpressionFactoryImpl;
import org.activiti.engine.impl.juel.SimpleContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.ReadOnlyProcessDefinition;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.impl.util.io.InputStreamSource;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskWebServiceImpl
implements TaskWebService {
    private static Logger LOGGER = LoggerFactory.getLogger(TaskWebServiceImpl.class);
    @Autowired
    private TaskService taskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    private String userTask = "userTask";
    private String subProcess = "subProcess";
    private String startAct = "startEvent";
    private String endAct = "endEvent";
    private String starter = "starter";

    @Override
    public String queryToDoTaskList(String userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskCandidateOrAssigned(userId).includeProcessVariables()).includeTaskLocalVariables()).orderByTaskCreateTime()).desc()).list();
            List<Map<String, Object>> list = this.tasksToMap(tasks);
            map.put("data", JSONArray.toJSONString(list));
            map.put("count", tasks.size());
            return ServiceResult.getResult("1", "success", JSON.toJSONString(map));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5f85\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String queryToDoTaskListByProcess(String userId, String processDefinitionKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskCandidateOrAssigned(userId).processDefinitionKey(processDefinitionKey)).includeProcessVariables()).includeTaskLocalVariables()).orderByTaskCreateTime()).desc()).list();
            List<Map<String, Object>> list = this.tasksToMap(tasks);
            map.put("data", JSONArray.toJSONString(list));
            map.put("count", tasks.size());
            return ServiceResult.getResult("1", "success", JSON.toJSONString(map));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5f85\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String queryToDoTaskList(String userId, Integer page, Integer rows) {
        Long countTasks = 0L;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            countTasks = this.taskService.createTaskQuery().taskCandidateOrAssigned(userId).count();
            List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskCandidateOrAssigned(userId).includeProcessVariables()).includeTaskLocalVariables()).orderByTaskCreateTime()).desc()).listPage((page - 1) * rows, rows.intValue());
            List<Map<String, Object>> list = this.tasksToMap(tasks);
            map.put("data", JSONArray.toJSONString(list));
            map.put("count", countTasks);
            return ServiceResult.getResult("1", "success", JSON.toJSONString(map));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5f85\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String queryToDoByDefinitionKey(String processDefinitionKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey(processDefinitionKey)).includeProcessVariables()).includeTaskLocalVariables()).orderByTaskCreateTime()).desc()).list();
            List<Map<String, Object>> list = this.tasksToMap(tasks);
            map.put("data", JSONArray.toJSONString(list));
            map.put("count", tasks.size());
            return ServiceResult.getResult("1", "success", JSON.toJSONString(map));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5f85\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String queryToDoTaskListByPageAndProcess(String userId, String processDefinitionKey, Integer page, Integer rows) {
        Long countTasks = 0L;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            countTasks = ((TaskQuery)this.taskService.createTaskQuery().taskCandidateOrAssigned(userId).processDefinitionKey(processDefinitionKey)).count();
            List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskCandidateOrAssigned(userId).processDefinitionKey(processDefinitionKey)).includeProcessVariables()).includeTaskLocalVariables()).orderByTaskCreateTime()).desc()).listPage((page - 1) * rows, rows.intValue());
            List<Map<String, Object>> list = this.tasksToMap(tasks);
            map.put("data", JSONArray.toJSONString(list));
            map.put("count", countTasks);
            return ServiceResult.getResult("1", "success", JSON.toJSONString(map));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5f85\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String queryToDoTaskListByDefinitionKey(String userId, String processDefinitionKey, String definitionKey, Integer page, Integer rows) {
        Long countTasks = 0L;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            countTasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskCandidateOrAssigned(userId).processDefinitionKey(processDefinitionKey)).taskDefinitionKey(definitionKey)).count();
            List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskCandidateOrAssigned(userId).processDefinitionKey(processDefinitionKey)).taskDefinitionKey(definitionKey)).includeProcessVariables()).includeTaskLocalVariables()).orderByTaskCreateTime()).desc()).listPage((page - 1) * rows, rows.intValue());
            List<Map<String, Object>> list = this.tasksToMap(tasks);
            map.put("data", JSONArray.toJSONString(list));
            map.put("count", countTasks);
            return ServiceResult.getResult("1", "success", JSON.toJSONString(map));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5f85\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String queryFinishedTaskList(String userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskAssignee(userId)).orderByHistoricTaskInstanceEndTime().includeProcessVariables()).finished().desc()).list();
            List<Map<String, Object>> list = this.hisTasksToMap(hisTaskList);
            map.put("data", JSONArray.toJSONString(list));
            map.put("count", hisTaskList.size());
            return ServiceResult.getResult("1", "success", JSON.toJSONString(map));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5df2\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String queryFinishedTaskListByProcess(String userId, String processDefinitionKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processDefinitionKey(processDefinitionKey)).taskAssignee(userId)).includeProcessVariables()).orderByHistoricTaskInstanceEndTime().finished().desc()).list();
            List<Map<String, Object>> list = this.hisTasksToMap(hisTaskList);
            map.put("data", JSONArray.toJSONString(list));
            map.put("count", hisTaskList.size());
            return ServiceResult.getResult("1", "success", JSON.toJSONString(map));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5df2\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String queryFinishedTaskList(String userId, Integer page, Integer rows) {
        Long counthisList = 0L;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            counthisList = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskAssignee(userId)).finished().count();
            List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskAssignee(userId)).includeProcessVariables()).orderByHistoricTaskInstanceEndTime().finished().desc()).listPage((page - 1) * rows, rows.intValue());
            List<Map<String, Object>> list = this.hisTasksToMap(hisTaskList);
            map.put("data", JSONArray.toJSONString(list));
            map.put("count", counthisList);
            return ServiceResult.getResult("1", "success", JSON.toJSONString(map));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5df2\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String queryFinishedTaskListByPageAndProcess(String userId, String processDefinitionKey, Integer page, Integer rows) {
        Long counthisList = 0L;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            counthisList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskAssignee(userId)).processDefinitionKey(processDefinitionKey)).finished().count();
            List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processDefinitionKey(processDefinitionKey)).taskAssignee(userId)).includeProcessVariables()).finished().orderByHistoricTaskInstanceEndTime().desc()).listPage((page - 1) * rows, rows.intValue());
            List<Map<String, Object>> list = this.hisTasksToMap(hisTaskList);
            map.put("data", JSONArray.toJSONString(list));
            map.put("count", counthisList);
            return ServiceResult.getResult("1", "success", JSON.toJSONString(map));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5df2\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String queryFinishedTaskListByDefinitionKey(String userId, String processDefinitionKey, String definitionKey, Integer page, Integer rows) {
        Long counthisList = 0L;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            counthisList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskAssignee(userId)).processDefinitionKey(processDefinitionKey)).taskDefinitionKey(definitionKey)).finished().count();
            List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskAssignee(userId)).processDefinitionKey(processDefinitionKey)).taskDefinitionKey(definitionKey)).includeProcessVariables()).finished().orderByHistoricTaskInstanceEndTime().desc()).listPage((page - 1) * rows, rows.intValue());
            List<Map<String, Object>> list = this.hisTasksToMap(hisTaskList);
            map.put("data", JSONArray.toJSONString(list));
            map.put("count", counthisList);
            return ServiceResult.getResult("1", "success", JSON.toJSONString(map));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5df2\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String claimTask(String taskId, String userId) {
        try {
            this.taskService.claim(taskId, userId);
            return ServiceResult.getResult("1", "success", "");
        }
        catch (Exception e) {
            LOGGER.error("\u7b7e\u6536\u4efb\u52a1\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String completeTask(String taskId) {
        try {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            ArrayList list = new ArrayList();
            String processInstanceId = task.getProcessInstanceId();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("taskSourceFlag", BpmConstant.COMPLETE);
            if (task.getDelegationState() == null) {
                this.taskService.complete(taskId, map);
            } else {
                this.taskService.resolveTask(taskId);
                this.taskService.complete(taskId, map);
            }
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
            if (tasks != null && tasks.size() > 0) {
                for (Task t : tasks) {
                    HashMap<String, Object> resultMap = new HashMap<String, Object>();
                    resultMap.put("taskId", t.getId());
                    resultMap.put("definitionKey", t.getTaskDefinitionKey());
                    resultMap.put("definitionName", t.getName());
                    resultMap.put("userId", this.getAssigneeByTaskId(t.getId()));
                    list.add(resultMap);
                }
            }
            return ServiceResult.getResult("1", "success", JSON.toJSONString(list));
        }
        catch (Exception e) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String completeTask(String taskId, String userId) {
        try {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            ArrayList list = new ArrayList();
            String processInstanceId = task.getProcessInstanceId();
            this.claimTask(taskId, userId);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("taskSourceFlag", BpmConstant.COMPLETE);
            if (task.getDelegationState() == null) {
                this.taskService.complete(taskId, map);
            } else {
                this.taskService.resolveTask(taskId);
                this.taskService.complete(taskId, map);
            }
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
            if (tasks != null && tasks.size() > 0) {
                for (Task t : tasks) {
                    HashMap<String, Object> resultMap = new HashMap<String, Object>();
                    resultMap.put("taskId", t.getId());
                    resultMap.put("definitionKey", t.getTaskDefinitionKey());
                    resultMap.put("definitionName", t.getName());
                    resultMap.put("userId", this.getAssigneeByTaskId(t.getId()));
                    list.add(resultMap);
                }
            }
            return ServiceResult.getResult("1", "success", JSON.toJSONString(list));
        }
        catch (Exception e) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String completeTask(String taskId, Map<String, Object> map) {
        try {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            if (map == null) {
                map = new HashMap<String, Object>();
            }
            map.put("taskSourceFlag", BpmConstant.COMPLETE);
            ArrayList list = new ArrayList();
            String processInstanceId = task.getProcessInstanceId();
            if (task.getDelegationState() == null) {
                this.taskService.complete(taskId, map);
            } else {
                this.taskService.resolveTask(taskId, map);
                this.taskService.complete(taskId, map);
            }
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
            if (tasks != null && tasks.size() > 0) {
                for (Task t : tasks) {
                    HashMap<String, Object> resultMap = new HashMap<String, Object>();
                    resultMap.put("taskId", t.getId());
                    resultMap.put("definitionKey", t.getTaskDefinitionKey());
                    resultMap.put("definitionName", t.getName());
                    resultMap.put("userId", this.getAssigneeByTaskId(t.getId()));
                    list.add(resultMap);
                }
            }
            return ServiceResult.getResult("1", "success", JSON.toJSONString(list));
        }
        catch (Exception e) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String completeTask(String taskId, String userId, Map<String, Object> map) {
        try {
            this.taskService.claim(taskId, userId);
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            if (map == null) {
                map = new HashMap<String, Object>();
            }
            map.put("taskSourceFlag", BpmConstant.COMPLETE);
            ArrayList list = new ArrayList();
            String processInstanceId = task.getProcessInstanceId();
            if (task.getDelegationState() == null) {
                this.taskService.complete(taskId, map);
            } else {
                this.taskService.resolveTask(taskId, map);
                this.taskService.complete(taskId, map);
            }
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
            if (tasks != null && tasks.size() > 0) {
                for (Task t : tasks) {
                    HashMap<String, Object> resultMap = new HashMap<String, Object>();
                    resultMap.put("taskId", t.getId());
                    resultMap.put("definitionKey", t.getTaskDefinitionKey());
                    resultMap.put("definitionName", t.getName());
                    resultMap.put("userId", this.getAssigneeByTaskId(t.getId()));
                    list.add(resultMap);
                }
            }
            return ServiceResult.getResult("1", "success", JSON.toJSONString(list));
        }
        catch (Exception e) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String completeTask(String taskId, String userId, Map<String, String> assigneeMap, Map<String, Object> map) {
        try {
            List tasks;
            List taskNow;
            this.taskService.claim(taskId, userId);
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            if (map == null) {
                map = new HashMap<String, Object>();
            }
            map.put("taskSourceFlag", BpmConstant.COMPLETE);
            String processInstanceId = task.getProcessInstanceId();
            ArrayList list = new ArrayList();
            if (task.getDelegationState() == null) {
                this.taskService.complete(taskId, map);
            } else {
                this.taskService.resolveTask(taskId, map);
                this.taskService.complete(taskId, map);
            }
            if (assigneeMap != null && (taskNow = ((TaskQuery)this.processEngine.getTaskService().createTaskQuery().processInstanceId(processInstanceId)).active().list()) != null && taskNow.size() > 0) {
                for (Task t : taskNow) {
                    String tId = task.getId();
                    String nodeId = task.getTaskDefinitionKey();
                    String assignee = assigneeMap.get(nodeId);
                    if (!StringUtils.isNotEmpty((CharSequence)assignee)) continue;
                    Set<String> userSet = this.getAssigneeByTaskId(tId);
                    for (String user : userSet) {
                        this.taskService.deleteCandidateUser(tId, user);
                    }
                    List<String> assigneeList = Arrays.asList(assignee.split(","));
                    for (String id : assigneeList) {
                        this.taskService.addCandidateUser(tId, id);
                    }
                }
            }
            if ((tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list()) != null && tasks.size() > 0) {
                for (Task t : tasks) {
                    HashMap<String, Object> resultMap = new HashMap<String, Object>();
                    resultMap.put("taskId", t.getId());
                    resultMap.put("definitionKey", t.getTaskDefinitionKey());
                    resultMap.put("definitionName", t.getName());
                    resultMap.put("userId", this.getAssigneeByTaskId(t.getId()));
                    list.add(resultMap);
                }
            }
            return ServiceResult.getResult("1", "success", JSON.toJSONString(list));
        }
        catch (Exception e) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String completeTask(String taskId, String userId, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        ArrayList list = new ArrayList();
        try {
            List tasks;
            List taskNow;
            this.taskService.claim(taskId, userId);
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            if (map == null) {
                map = new HashMap<String, Object>();
            }
            map.put("taskSourceFlag", BpmConstant.COMPLETE);
            String processInstanceId = task.getProcessInstanceId();
            if (StringUtils.isNotEmpty((CharSequence)comment)) {
                this.taskService.addComment(taskId, null, "complete", comment);
            }
            if (task.getDelegationState() == null) {
                this.taskService.complete(taskId, map);
            } else {
                this.taskService.resolveTask(taskId, map);
                this.taskService.complete(taskId, map);
            }
            if (assigneeMap != null && (taskNow = ((TaskQuery)this.processEngine.getTaskService().createTaskQuery().processInstanceId(processInstanceId)).active().list()) != null && taskNow.size() > 0) {
                for (Task t : taskNow) {
                    String tId = task.getId();
                    String nodeId = task.getTaskDefinitionKey();
                    String assignee = assigneeMap.get(nodeId);
                    if (!StringUtils.isNotEmpty((CharSequence)assignee)) continue;
                    Set<String> userSet = this.getAssigneeByTaskId(tId);
                    for (String user : userSet) {
                        this.taskService.deleteCandidateUser(tId, user);
                    }
                    List<String> assigneeList = Arrays.asList(assignee.split(","));
                    for (String id : assigneeList) {
                        this.taskService.addCandidateUser(tId, id);
                    }
                }
            }
            if ((tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list()) != null && tasks.size() > 0) {
                for (Task t : tasks) {
                    HashMap<String, Object> resultMap = new HashMap<String, Object>();
                    resultMap.put("taskId", t.getId());
                    resultMap.put("definitionKey", t.getTaskDefinitionKey());
                    resultMap.put("definitionName", t.getName());
                    resultMap.put("userId", this.getAssigneeByTaskId(t.getId()));
                    list.add(resultMap);
                }
            }
            return ServiceResult.getResult("1", "success", JSON.toJSONString(list));
        }
        catch (Exception e) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String completeTask(String taskId, String userId, String comment, Map<String, Object> map) {
        try {
            this.taskService.claim(taskId, userId);
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            if (map == null) {
                map = new HashMap<String, Object>();
            }
            map.put("taskSourceFlag", BpmConstant.COMPLETE);
            ArrayList list = new ArrayList();
            String processInstanceId = task.getProcessInstanceId();
            if (StringUtils.isNotEmpty((CharSequence)comment)) {
                this.taskService.addComment(taskId, null, "complete", comment);
            }
            if (task.getDelegationState() == null) {
                this.taskService.complete(taskId, map);
            } else {
                this.taskService.resolveTask(taskId, map);
                this.taskService.complete(taskId, map);
            }
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
            if (tasks != null && tasks.size() > 0) {
                for (Task t : tasks) {
                    HashMap<String, Object> resultMap = new HashMap<String, Object>();
                    resultMap.put("taskId", t.getId());
                    resultMap.put("definitionKey", t.getTaskDefinitionKey());
                    resultMap.put("definitionName", t.getName());
                    resultMap.put("userId", this.getAssigneeByTaskId(t.getId()));
                    list.add(resultMap);
                }
            }
            return ServiceResult.getResult("1", "success", JSON.toJSONString(list));
        }
        catch (Exception e) {
            LOGGER.error("\u4efb\u52a1\u529e\u7406\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String unClaimTask(String taskId) {
        try {
            this.taskService.unclaim(taskId);
            return ServiceResult.getResult("1", "success", "");
        }
        catch (Exception e) {
            LOGGER.error("\u53d6\u6d88\u7b7e\u6536\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    private List<PvmTransition> getPvmTransition(ActivityImpl currActivity, List<PvmTransition> pt) {
        String activityType = "";
        List incomingTransitions = currActivity.getIncomingTransitions();
        for (PvmTransition pv : incomingTransitions) {
            ActivityImpl ai = (ActivityImpl)pv.getSource();
            Map map = ai.getProperties();
            String string = activityType = map.get("type") == null ? "" : map.get("type").toString();
            if (activityType.contains("Gateway")) {
                pt = this.getPvmTransition(ai, pt);
                continue;
            }
            pt.add(pv);
        }
        return pt;
    }

    @Override
    public String rejectToPreTask(String taskId, String comment, Map<String, Object> map) {
        Boolean isFirst = false;
        ArrayList list = new ArrayList();
        String starterUserId = "";
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String backActivityId = this.getLastActivityId(taskId);
        if (backActivityId.equals(this.getFristActivityId(taskId))) {
            starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
            isFirst = true;
        }
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        map.put("taskSourceFlag", BpmConstant.REJECT);
        this.rejectTask("", taskId, backActivityId, comment, map);
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(task.getProcessInstanceId())).active().list();
        if (tasks != null && tasks.size() > 0) {
            for (Task t : tasks) {
                List identityLinkList = this.taskService.getIdentityLinksForTask(t.getId());
                if (isFirst.booleanValue() && t.getAssignee() == null && StringUtils.isNotEmpty((CharSequence)starterUserId) && (identityLinkList == null || identityLinkList.size() == 0)) {
                    this.taskService.setAssignee(t.getId(), starterUserId);
                }
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                resultMap.put("taskId", t.getId());
                resultMap.put("definitionKey", t.getTaskDefinitionKey());
                resultMap.put("definitionName", t.getName());
                resultMap.put("userId", this.getAssigneeByTaskId(t.getId()));
                list.add(resultMap);
            }
        }
        return ServiceResult.getResult("1", "success", JSON.toJSONString(list));
    }

    @Override
    public String rejectToPreTask(String taskId, String userId, String comment, Map<String, Object> map) {
        Boolean isFirst = false;
        ArrayList list = new ArrayList();
        String starterUserId = "";
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String backActivityId = this.getLastActivityId(taskId);
        if (backActivityId.equals(this.getFristActivityId(taskId))) {
            starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
            isFirst = true;
        }
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        map.put("taskSourceFlag", BpmConstant.REJECT);
        this.rejectTask(userId, taskId, backActivityId, comment, map);
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(task.getProcessInstanceId())).active().list();
        if (tasks != null && tasks.size() > 0) {
            for (Task t : tasks) {
                List identityLinkList = this.taskService.getIdentityLinksForTask(t.getId());
                if (isFirst.booleanValue() && t.getAssignee() == null && StringUtils.isNotEmpty((CharSequence)starterUserId) && (identityLinkList == null || identityLinkList.size() == 0)) {
                    this.taskService.setAssignee(t.getId(), starterUserId);
                }
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                resultMap.put("taskId", t.getId());
                resultMap.put("definitionKey", t.getTaskDefinitionKey());
                resultMap.put("definitionName", t.getName());
                resultMap.put("userId", this.getAssigneeByTaskId(t.getId()));
                list.add(resultMap);
            }
        }
        return ServiceResult.getResult("1", "success", JSON.toJSONString(list));
    }

    @Override
    public String rejectToFristTask(String taskId, String comment, Map<String, Object> map) {
        String starterUserId = "";
        ArrayList list = new ArrayList();
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String firstTaskId = this.getFristActivityId(taskId);
        starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        map.put("taskSourceFlag", BpmConstant.REJECT);
        this.rejectTask("", taskId, firstTaskId, comment, map);
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(task.getProcessInstanceId())).active().list();
        if (tasks != null && tasks.size() > 0) {
            for (Task t : tasks) {
                List identityLinkList = this.taskService.getIdentityLinksForTask(t.getId());
                if (t.getAssignee() == null && StringUtils.isNotEmpty((CharSequence)starterUserId) && (identityLinkList == null || identityLinkList.size() == 0)) {
                    this.taskService.setAssignee(t.getId(), starterUserId);
                }
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                resultMap.put("taskId", t.getId());
                resultMap.put("definitionKey", t.getTaskDefinitionKey());
                resultMap.put("definitionName", t.getName());
                resultMap.put("userId", this.getAssigneeByTaskId(t.getId()));
                list.add(resultMap);
            }
        }
        return ServiceResult.getResult("1", "success", JSON.toJSONString(list));
    }

    @Override
    public String rejectToFristTask(String taskId, String userId, String comment, Map<String, Object> map) {
        this.claimTask(taskId, userId);
        ArrayList list = new ArrayList();
        String starterUserId = "";
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String firstTaskId = this.getFristActivityId(taskId);
        starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        map.put("taskSourceFlag", BpmConstant.REJECT);
        this.rejectTask(userId, taskId, firstTaskId, comment, map);
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(task.getProcessInstanceId())).active().list();
        if (tasks != null && tasks.size() > 0) {
            for (Task t : tasks) {
                List identityLinkList = this.taskService.getIdentityLinksForTask(t.getId());
                if (t.getAssignee() == null && StringUtils.isNotEmpty((CharSequence)starterUserId) && (identityLinkList == null || identityLinkList.size() == 0)) {
                    this.taskService.setAssignee(t.getId(), starterUserId);
                }
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                resultMap.put("taskId", t.getId());
                resultMap.put("definitionKey", t.getTaskDefinitionKey());
                resultMap.put("definitionName", t.getName());
                resultMap.put("userId", this.getAssigneeByTaskId(t.getId()));
                list.add(resultMap);
            }
        }
        return ServiceResult.getResult("1", "success", JSON.toJSONString(list));
    }

    public void rejectTask(String userId, String taskId, String backActivityId, String comment, Map<String, Object> map) {
        int backType = this.backType(taskId);
        if (StringUtils.isNotEmpty((CharSequence)comment)) {
            this.taskService.addComment(taskId, null, "complete", comment);
        }
        switch (backType) {
            case 1: {
                this.commonReject(userId, taskId, backActivityId, map);
                break;
            }
            case 2: {
                this.multiInstanceReject(userId, taskId, backActivityId, map);
                break;
            }
            case 3: {
                this.parallelReject(userId, taskId, backActivityId, map);
                break;
            }
            default: {
                this.commonReject(userId, taskId, backActivityId, map);
            }
        }
    }

    private void parallelReject(String userId, String taskId, String backActivityId, Map<String, Object> map) {
        if (StringUtils.isNotEmpty((CharSequence)userId)) {
            this.claimTask(taskId, userId);
        }
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String processDefinition = task.getProcessDefinitionId();
        ReadOnlyProcessDefinition processDefinitionEntity = (ReadOnlyProcessDefinition)this.repositoryService.getProcessDefinition(processDefinition);
        ActivityImpl destinationActivity = (ActivityImpl)processDefinitionEntity.findActivity(backActivityId);
        String executionId = task.getExecutionId();
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId(task.getTaskDefinitionKey()).singleResult();
        String parentId = execution.getParentId();
        ActivityImpl currentActivity = (ActivityImpl)processDefinitionEntity.findActivity(task.getTaskDefinitionKey());
        this.processEngine.getManagementService().executeCommand((Command)new ParallelJumpTaskCmd(userId, executionId, parentId, destinationActivity, map, currentActivity));
    }

    private void commonReject(String userId, String taskId, String backActivityId, Map<String, Object> map) {
        if (StringUtils.isNotEmpty((CharSequence)userId)) {
            this.claimTask(taskId, userId);
        }
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String processDefinition = task.getProcessDefinitionId();
        ReadOnlyProcessDefinition processDefinitionEntity = (ReadOnlyProcessDefinition)this.repositoryService.getProcessDefinition(processDefinition);
        ActivityImpl destinationActivity = (ActivityImpl)processDefinitionEntity.findActivity(backActivityId);
        String executionId = task.getExecutionId();
        String parentId = task.getExecutionId();
        ActivityImpl currentActivity = (ActivityImpl)processDefinitionEntity.findActivity(task.getTaskDefinitionKey());
        this.processEngine.getManagementService().executeCommand((Command)new CommonJumpTaskCmd(executionId, parentId, destinationActivity, map, currentActivity));
    }

    private void multiInstanceReject(String userId, String taskId, String backActivityId, Map<String, Object> map) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String processDefinition = task.getProcessDefinitionId();
        ReadOnlyProcessDefinition processDefinitionEntity = (ReadOnlyProcessDefinition)this.repositoryService.getProcessDefinition(processDefinition);
        ActivityImpl destinationActivity = (ActivityImpl)processDefinitionEntity.findActivity(backActivityId);
        String executionId = task.getExecutionId();
        List execution = this.runtimeService.createExecutionQuery().activityId(task.getTaskDefinitionKey()).list();
        String parentId = ((Execution)execution.get(0)).getParentId();
        ActivityImpl currentActivity = (ActivityImpl)processDefinitionEntity.findActivity(task.getTaskDefinitionKey());
        this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceJumpTaskCmd(userId, executionId, parentId, destinationActivity, map, currentActivity));
    }

    private String getLastActivityId(String taskId) {
        ArrayList<PvmTransition> pt;
        String backActivityId = "";
        HashMap map = new HashMap();
        HistoricTaskInstance currTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
        List list = ((HistoricActivityInstanceQuery)this.processEngine.getHistoryService().createHistoricActivityInstanceQuery().processInstanceId(currTask.getProcessInstanceId()).orderByHistoricActivityInstanceEndTime().activityType(this.userTask).finished().desc()).list();
        ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(currTask.getProcessDefinitionId());
        ActivityImpl currActivity = definition.findActivity(currTask.getTaskDefinitionKey());
        List<PvmTransition> incomingTransitions = this.getPvmTransition(currActivity, pt = new ArrayList<PvmTransition>());
        if (incomingTransitions != null && incomingTransitions.size() > 0) {
            block0: for (int i = 0; i < incomingTransitions.size(); ++i) {
                String id = incomingTransitions.get(i).getSource().getId();
                for (HistoricActivityInstance his : list) {
                    if (!id.equals(his.getActivityId())) continue;
                    backActivityId = id;
                    continue block0;
                }
            }
        }
        return backActivityId;
    }

    public String getFristActivityId(String taskId) {
        String allNodeInfo = this.queryHistoryActByTaskId(taskId);
        JSONObject object = JSONObject.parseObject((String)allNodeInfo);
        String resultStr = object.get((Object)"result") == null ? "" : object.get((Object)"result").toString();
        JSONArray jsonArray = JSONArray.parseArray((String)JSONObject.parseObject((String)resultStr).get((Object)"data").toString());
        JSONObject jsonObject = new JSONObject();
        if (jsonArray != null && jsonArray.size() > 0) {
            jsonObject = jsonArray.getJSONObject(jsonArray.size() - 1);
        }
        String fristActivityId = jsonObject.getString("nodeId") == null ? "" : jsonObject.getString("nodeId").toString();
        return fristActivityId;
    }

    @Override
    public String delegateTask(String taskId, String userId) {
        try {
            this.taskService.delegateTask(taskId, userId);
            return ServiceResult.getResult("1", "success", "");
        }
        catch (Exception e) {
            LOGGER.error("\u4efb\u52a1\u59d4\u6258\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String freeJump(String taskId, String activitiId) {
        try {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            if (task != null) {
                String excId = task.getExecutionId();
                TaskServiceImpl taskServiceImpl = (TaskServiceImpl)this.taskService;
                taskServiceImpl.getCommandExecutor().execute((Command)new ActivitiJumpCommand(excId, activitiId));
            }
            return ServiceResult.getResult("1", "success", "");
        }
        catch (Exception e) {
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String getCurrNodeInfoByTaskId(String taskId) {
        try {
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).list();
            String re = JSONArray.toJSONString(this.tasksToMap(tasks));
            return ServiceResult.getResult("1", "success", re);
        }
        catch (Exception e) {
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String lastUserTask(String taskId) {
        boolean flag = false;
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        try {
            if (task != null) {
                String excId = task.getExecutionId();
                ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(excId).singleResult();
                String activitiId = execution.getActivityId();
                ProcessDefinitionEntity def = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
                ActivityImpl activity = def.findActivity(activitiId);
                List outTransitions = activity.getOutgoingTransitions();
                for (PvmTransition pt : outTransitions) {
                    PvmActivity pa = pt.getDestination();
                    if (pa.getParent() != null) {
                        if (pa.getParent().getProperty("type") != null) {
                            List subOutTransitions;
                            String parentType = String.valueOf(pa.getParent().getProperty("type"));
                            if (!this.subProcess.equals(parentType) || (subOutTransitions = ((ActivityImpl)pa.getParent()).getOutgoingTransitions()).size() <= 0) continue;
                            for (PvmTransition tr : subOutTransitions) {
                                PvmActivity p = tr.getDestination();
                                if (!"endEvent".equals(p.getProperty("type"))) continue;
                                flag = true;
                            }
                            continue;
                        }
                        if (!"endEvent".equals(pa.getProperty("type"))) continue;
                        flag = true;
                        continue;
                    }
                    if (!"endEvent".equals(pa.getProperty("type"))) continue;
                    flag = true;
                }
            }
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put("flag", flag);
            return ServiceResult.getResult("1", "success", JSON.toJSONString(map));
        }
        catch (Exception e) {
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String queryNextActivitiListByTaskId(String taskId) {
        JSONArray list = new JSONArray();
        JSONObject json = new JSONObject();
        JSONObject curJson = new JSONObject();
        try {
            if (StringUtils.isNotBlank((CharSequence)taskId)) {
                String formKeyExpression;
                Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
                String excId = task.getExecutionId();
                ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(excId).singleResult();
                String activitiId = execution.getActivityId();
                ProcessDefinitionEntity def = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
                ActivityImpl activity = def.findActivity(activitiId);
                TaskDefinition curtask = (TaskDefinition)activity.getProperty("taskDefinition");
                Expression curProp = curtask.getFormKeyExpression();
                String curUserProp = "";
                if (curProp != null && StringUtils.isNotBlank((CharSequence)(formKeyExpression = curProp.getExpressionText()))) {
                    String[] keys = formKeyExpression.split(",");
                    for (int i = 0; i < keys.length; ++i) {
                        String key = keys[i];
                        curUserProp = curUserProp + key.substring(key.indexOf("[") + 1, key.indexOf("]")) + ",";
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)curUserProp)) {
                    if (curUserProp.contains("6")) {
                        curJson.put("firstUser", (Object)this.getStartPersionId(excId, def));
                    }
                    curUserProp = curUserProp.substring(0, curUserProp.length() - 1);
                }
                curJson.put("nextUserProp", (Object)curUserProp);
                List outTransitions = activity.getOutgoingTransitions();
                for (PvmTransition pt : outTransitions) {
                    String formKeyExpression2;
                    PvmActivity pa = pt.getDestination();
                    String actype = String.valueOf(pa.getProperty("type"));
                    if (!this.userTask.equals(actype)) {
                        List<JSONObject> jsonlist = this.userActivityImpl(pa, "");
                        list.addAll(jsonlist);
                        continue;
                    }
                    JSONObject jsonStr = new JSONObject();
                    jsonStr.put("nodeType", (Object)actype);
                    jsonStr.put("nodeId", (Object)pa.getId());
                    jsonStr.put("gateway", (Object)"");
                    jsonStr.put("nodeName", (Object)String.valueOf(pa.getProperty("name")));
                    jsonStr.put("condition", (Object)"");
                    TaskDefinition t = (TaskDefinition)pa.getProperty("taskDefinition");
                    Expression duedate = t.getDueDateExpression();
                    if (duedate != null) {
                        jsonStr.put("duedate", (Object)duedate.getExpressionText());
                    } else {
                        jsonStr.put("duedate", (Object)"");
                    }
                    String users = "";
                    users = t.getCandidateUserIdExpressions().toString();
                    if (StringUtils.isNotBlank((CharSequence)users)) {
                        json.put("users", (Object)users);
                    }
                    jsonStr.put("users", (Object)users);
                    Expression nextProp = t.getFormKeyExpression();
                    String nextUserProp = "";
                    if (nextProp != null && StringUtils.isNotBlank((CharSequence)(formKeyExpression2 = nextProp.getExpressionText()))) {
                        String[] keys = formKeyExpression2.split(",");
                        for (int j = 0; j < keys.length; ++j) {
                            String key = keys[j];
                            nextUserProp = nextUserProp + key.substring(key.indexOf("[") + 1, key.indexOf("]")) + ",";
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)nextUserProp)) {
                        if (nextUserProp.contains("6")) {
                            jsonStr.put("firstUser", (Object)this.getStartPersionId(excId, def));
                        }
                        nextUserProp = nextUserProp.substring(0, nextUserProp.length() - 1);
                    }
                    jsonStr.put("nextUserProp", (Object)nextUserProp);
                    list.add((Object)jsonStr);
                }
            }
            json.put("array", (Object)list);
            json.put("current", (Object)curJson);
            return ServiceResult.getResult("0", "success", JSON.toJSONString((Object)json));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u83b7\u53d6\u5f53\u524d\u8282\u70b9\u4e0b\u4e00\u4eba\u5de5\u73af\u8282\u51fa\u9519" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    private String getStartPersionId(String excId, ProcessDefinitionEntity def) {
        String startUser = "";
        HistoricActivityInstance hisBean = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityType(this.startAct).processInstanceId(excId).singleResult();
        startUser = hisBean.getAssignee();
        if (startUser == null || "".equals(startUser)) {
            String actId = hisBean.getActivityId();
            ActivityImpl activity = def.findActivity(actId);
            PvmTransition outTransitions = (PvmTransition)activity.getOutgoingTransitions().get(0);
            PvmActivity p = outTransitions.getDestination();
            String firstActId = p.getId();
            hisBean = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId(firstActId).processInstanceId(excId).singleResult();
            startUser = hisBean.getAssignee();
        }
        return startUser;
    }

    private List<JSONObject> userActivityImpl(PvmActivity pa, String conditionText) {
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        String actype = String.valueOf(pa.getProperty("type"));
        if (!this.userTask.equals(actype)) {
            if (this.subProcess.equals(actype)) {
                List subProcessActivitis = pa.getActivities();
                for (ActivityImpl act : subProcessActivitis) {
                    if (!this.startAct.equals(act.getProperty("type"))) continue;
                    List outTransitions = act.getOutgoingTransitions();
                    if (outTransitions.size() > 0) {
                        for (PvmTransition tr : outTransitions) {
                            StringBuffer condition = new StringBuffer("");
                            if (!"".equals(conditionText)) {
                                condition.append(conditionText);
                            }
                            if (tr.getProperty("conditionText") != null) {
                                if (condition.length() > 0) {
                                    condition.append(";");
                                }
                                condition.append(tr.getProperty("conditionText"));
                            }
                            PvmActivity ac = tr.getDestination();
                            List<JSONObject> temp = this.userActivityImpl(ac, condition.toString());
                            list.addAll(temp);
                        }
                    }
                    break;
                }
            } else if (this.endAct.equals(actype)) {
                if (pa.getParent() != null) {
                    if (pa.getParent().getProperty("type") != null) {
                        List outTransitions;
                        String parentType = String.valueOf(pa.getParent().getProperty("type"));
                        if (this.subProcess.equals(parentType) && (outTransitions = ((ActivityImpl)pa.getParent()).getOutgoingTransitions()).size() > 0) {
                            outTransitions = (List)((Object)outTransitions.iterator());
                            while (((Iterator)((Object)outTransitions)).hasNext()) {
                                Object tr = ((Iterator)((Object)outTransitions)).next();
                                StringBuffer condition = new StringBuffer("");
                                if (!"".equals(conditionText)) {
                                    condition.append(conditionText);
                                }
                                if (((PvmTransition)tr).getProperty("conditionText") != null) {
                                    if (condition.length() > 0) {
                                        condition.append(";");
                                    }
                                    condition.append(((PvmTransition)tr).getProperty("conditionText"));
                                }
                                PvmActivity ac = ((PvmTransition)tr).getDestination();
                                List<JSONObject> temp = this.userActivityImpl(ac, condition.toString());
                                list.addAll(temp);
                            }
                        }
                    } else if ("ParallelGateway".equals(actype)) {
                        JSONObject json = new JSONObject();
                        json.put("nodeType", (Object)actype);
                        json.put("nodeId", (Object)pa.getId());
                        json.put("nodeName", (Object)String.valueOf(pa.getProperty("name")));
                        json.put("condition", (Object)conditionText);
                        list.add(json);
                    } else {
                        JSONObject json = new JSONObject();
                        json.put("nodeType", (Object)actype);
                        json.put("nodeId", (Object)pa.getId());
                        json.put("nodeName", (Object)(pa.getProperty("name") == null ? "\u7ed3\u675f" : String.valueOf(pa.getProperty("name"))));
                        json.put("condition", (Object)conditionText);
                        list.add(json);
                    }
                }
            } else {
                List outTransitions = pa.getOutgoingTransitions();
                if (outTransitions.size() > 0) {
                    for (PvmTransition pv : outTransitions) {
                        StringBuffer condition = new StringBuffer("");
                        if (StringUtils.isNotBlank((CharSequence)conditionText)) {
                            condition.append(conditionText);
                        }
                        if (pv.getProperty("conditionText") != null) {
                            String judge = pv.getProperty("conditionText").toString();
                            if ((judge = judge.substring(judge.indexOf("==") + 2, judge.length() - 1)).equals(conditionText)) continue;
                            if (condition.length() > 0) {
                                condition.append(";");
                            }
                            condition.append(pv.getProperty("conditionText"));
                        }
                        PvmActivity ac = pv.getDestination();
                        List<JSONObject> temp = this.userActivityImpl(ac, condition.toString());
                        list.addAll(temp);
                    }
                }
            }
        } else {
            String formKeyExpression;
            TaskDefinition t;
            Expression duedate;
            String parentType;
            JSONObject json = new JSONObject();
            json.put("nodeType", (Object)actype);
            json.put("nodeId", (Object)pa.getId());
            json.put("nodeName", (Object)String.valueOf(pa.getProperty("name")));
            json.put("condition", (Object)conditionText);
            List incoming = pa.getIncomingTransitions();
            if (pa.getParent() != null && pa.getParent().getProperty("type") != null && this.subProcess.equals(parentType = String.valueOf(pa.getParent().getProperty("type")))) {
                incoming = ((ActivityImpl)pa.getParent()).getIncomingTransitions();
            }
            if (incoming != null && !incoming.isEmpty()) {
                String type = String.valueOf(((PvmTransition)incoming.get(0)).getSource().getProperty("type"));
                if (StringUtils.isNotBlank((CharSequence)conditionText)) {
                    for (PvmTransition inc : incoming) {
                        Object condi = inc.getProperty("conditionText");
                        if (condi == null || !String.valueOf(condi).equalsIgnoreCase(conditionText)) continue;
                        type = String.valueOf(inc.getSource().getProperty("type"));
                        break;
                    }
                }
                if ("ParallelGateway".equalsIgnoreCase(type)) {
                    json.put("gateway", (Object)"parallel");
                } else if ("ExclusiveGateway".equalsIgnoreCase(type)) {
                    json.put("gateway", (Object)"exclusive");
                } else if ("InclusiveGateway".equalsIgnoreCase(type)) {
                    json.put("gateway", (Object)"inclusive");
                } else {
                    json.put("gateway", (Object)"");
                }
            }
            if ((duedate = (t = (TaskDefinition)pa.getProperty("taskDefinition")).getDueDateExpression()) != null) {
                json.put("duedate", (Object)duedate.getExpressionText());
            } else {
                json.put("duedate", (Object)"");
            }
            String users = "";
            users = t.getCandidateUserIdExpressions().toString();
            if (StringUtils.isNotBlank((CharSequence)users)) {
                json.put("users", (Object)users);
            }
            Expression nextProp = t.getFormKeyExpression();
            String nextUserProp = "";
            if (nextProp != null && StringUtils.isNotBlank((CharSequence)(formKeyExpression = nextProp.getExpressionText()))) {
                String[] keys = formKeyExpression.split(",");
                for (int i = 0; i < keys.length; ++i) {
                    String key = keys[i];
                    nextUserProp = nextUserProp + key.substring(key.indexOf("[") + 1, key.indexOf("]")) + ",";
                }
            }
            if (StringUtils.isNotBlank((CharSequence)nextUserProp)) {
                nextUserProp = nextUserProp.substring(0, nextUserProp.length() - 1);
            }
            json.put("nextUserProp", (Object)nextUserProp);
            list.add(json);
        }
        return list;
    }

    @Override
    public String queryAssigneeByTaskId(String taskId) {
        Set<String> users = null;
        try {
            users = this.getAssigneeByTaskId(taskId);
            return ServiceResult.getResult("1", "success", JSON.toJSONString(users));
        }
        catch (Exception e) {
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String queryNextAssigneeByTaskId(String taskId, Map<String, String> formData) {
        try {
            List sf;
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            BpmnModel bm = this.getBpmnModel(task.getProcessDefinitionId());
            ArrayList<String> nextNodeList = new ArrayList<String>();
            UserTask userTask = (UserTask)((Process)bm.getProcesses().get(0)).getFlowElement(task.getTaskDefinitionKey());
            List sequenceFlows = userTask.getOutgoingFlows();
            String seqTarRef = ((SequenceFlow)sequenceFlows.get(0)).getTargetRef();
            if (((Process)bm.getProcesses().get(0)).getFlowElement(seqTarRef) instanceof ExclusiveGateway) {
                if (formData == null) {
                    return ServiceResult.getResult("0", "error", "\u53c2\u6570\u53d8\u91cf\u548c\u53c2\u6570\u503c\u4e0d\u80fd\u4e3a\u7a7a!");
                }
                ExclusiveGateway exclusiveGateway = (ExclusiveGateway)((Process)bm.getProcesses().get(0)).getFlowElement(seqTarRef);
                sf = exclusiveGateway.getOutgoingFlows();
                for (SequenceFlow s : sf) {
                    String ce = s.getConditionExpression();
                    if (!this.getResultByELAndFormData(ce, formData)) continue;
                    nextNodeList.add(s.getTargetRef());
                    break;
                }
            }
            if (((Process)bm.getProcesses().get(0)).getFlowElement(seqTarRef) instanceof ParallelGateway) {
                ParallelGateway parallelGateway = (ParallelGateway)((Process)bm.getProcesses().get(0)).getFlowElement(seqTarRef);
                sf = parallelGateway.getOutgoingFlows();
                for (SequenceFlow s : sf) {
                    nextNodeList.add(s.getTargetRef());
                }
            }
            if (((Process)bm.getProcesses().get(0)).getFlowElement(seqTarRef) instanceof UserTask) {
                UserTask u = (UserTask)((Process)bm.getProcesses().get(0)).getFlowElement(seqTarRef);
                nextNodeList.add(u.getId());
            }
            List<Object> list = this.getCandidateUserList(task, bm, nextNodeList);
            return ServiceResult.getResult("1", "success", JSON.toJSONString(list));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u8282\u70b9\u53c2\u4e0e\u8005\u51fa\u9519\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    private BpmnModel getBpmnModel(String processDefinitionId) {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processDefinitionId);
        InputStream xmlIs = this.repositoryService.getResourceAsStream(processDefinition.getDeploymentId(), processDefinition.getResourceName());
        BpmnModel bm = new BpmnXMLConverter().convertToBpmnModel((InputStreamProvider)new InputStreamSource(xmlIs), false, true);
        return bm;
    }

    private boolean getResultByELAndFormData(String el, Map formData) {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = new SimpleContext();
        for (Object k : formData.keySet()) {
            if (formData.get(k) == null) continue;
            context.setVariable(k.toString(), factory.createValueExpression(formData.get(k), formData.get(k).getClass()));
        }
        ValueExpression e = factory.createValueExpression((ELContext)context, el, Boolean.TYPE);
        return (Boolean)e.getValue((ELContext)context);
    }

    private List<Object> getCandidateUserList(Task task, BpmnModel bm, List<String> nextNodeList) {
        String userId = "";
        List<Object> userList = new ArrayList();
        List<String> deptsList = null;
        List<String> rolesList = null;
        ArrayList<Object> finList = new ArrayList<Object>();
        if (nextNodeList != null && nextNodeList.size() > 0) {
            for (String nodeId : nextNodeList) {
                Map extensionElements;
                Boolean currentdept;
                UserTask userTask = (UserTask)((Process)bm.getProcesses().get(0)).getFlowElement(nodeId);
                Map extensionAttribute = userTask.getAttributes();
                List deptAttribute = (List)extensionAttribute.get("candidateDepts");
                List roleAttribute = (List)extensionAttribute.get("candidateRoles");
                if (deptAttribute != null && deptAttribute.size() > 0) {
                    String candidateDepts = ((ExtensionAttribute)deptAttribute.get(0)).getValue();
                    deptsList = Arrays.asList(candidateDepts.split(","));
                }
                if (roleAttribute != null && roleAttribute.size() > 0) {
                    String candidateRoles = ((ExtensionAttribute)roleAttribute.get(0)).getValue();
                    rolesList = Arrays.asList(candidateRoles.split(","));
                }
                if ((currentdept = Boolean.valueOf(Boolean.parseBoolean(String.valueOf((extensionElements = ((Process)bm.getProcesses().get(0)).getFlowElement(nodeId).getExtensionElements()).get("currentdept"))))).booleanValue()) {
                    userId = this.getTaskStarterUserId(task.getProcessInstanceId());
                    deptsList = this.iAssigneeChooseService.getFlowStarterDept(userId);
                }
                userList = deptsList == null && rolesList == null ? new ArrayList() : this.iAssigneeChooseService.getUserList(deptsList, rolesList);
                List candidateList = userTask.getCandidateUsers();
                if (candidateList != null && candidateList.size() > 0) {
                    userList.addAll(candidateList);
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("nodeId", nodeId);
                map.put("nodeName", userTask.getName());
                map.put("list", userList);
                finList.add(map);
            }
        }
        return finList;
    }

    private Set<String> getAssigneeByTaskId(String taskId) {
        HashSet<String> users = new HashSet<String>();
        List identityLinkList = this.taskService.getIdentityLinksForTask(taskId);
        if (identityLinkList != null && identityLinkList.size() > 0) {
            for (IdentityLink identityLink : identityLinkList) {
                users.add(identityLink.getUserId());
            }
        }
        return users;
    }

    @Override
    public String queryHistoryActByTaskId(String taskId) {
        ArrayList hisList = new ArrayList();
        HashMap<String, Object> mapResult = new HashMap<String, Object>();
        try {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            if (task != null) {
                String processInstanceId = task.getProcessInstanceId();
                List list = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().activityType(this.userTask).processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().desc()).list();
                if (list != null && list.size() > 0) {
                    for (HistoricActivityInstance historyIns : list) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        String tId = historyIns.getTaskId();
                        if (tId.equals(taskId)) continue;
                        map.put("nodeId", historyIns.getActivityId());
                        map.put("nodeName", historyIns.getActivityName());
                        map.put("taskId", tId);
                        map.put("endTime", historyIns.getEndTime() == null ? null : Long.valueOf(historyIns.getEndTime().getTime()));
                        hisList.add(map);
                    }
                }
            }
            mapResult.put("data", JSONArray.toJSONString(hisList));
            mapResult.put("count", hisList.size());
            return ServiceResult.getResult("1", "success", JSON.toJSONString(mapResult));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5386\u53f2\u73af\u8282\u4fe1\u606f\u63a5\u53e3\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    public List<Map<String, Object>> tasksToMap(List<Task> tasks) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (tasks != null && tasks.size() > 0) {
            for (int i = 0; i < tasks.size(); ++i) {
                HashMap<String, Object> taskMap = new HashMap<String, Object>();
                Task task = tasks.get(i);
                Map variables = task.getProcessVariables();
                ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
                taskMap.put("taskId", task.getId());
                taskMap.put("name", task.getName());
                taskMap.put("assignee", task.getAssignee());
                taskMap.put("definitionId", task.getProcessDefinitionId());
                taskMap.put("definitionName", task.getName());
                taskMap.put("definitionKey", task.getTaskDefinitionKey());
                taskMap.put("processInsId", task.getProcessInstanceId());
                taskMap.put("createTime", task.getCreateTime());
                taskMap.put("bussinessId", pi.getBusinessKey());
                taskMap.put("variables", variables);
                taskMap.put("taskSourceFlag", variables.get("taskSourceFlag"));
                taskMap.put("formKey", task.getFormKey());
                list.add(taskMap);
            }
        }
        return list;
    }

    public List<Map<String, Object>> hisTasksToMap(List<HistoricTaskInstance> hs) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (hs != null && hs.size() > 0) {
            for (HistoricTaskInstance hsi : hs) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(hsi.getProcessInstanceId()).singleResult();
                Map variables = hsi.getProcessVariables();
                map.put("taskId", hsi.getId());
                map.put("name", hsi.getName());
                map.put("assignee", hsi.getAssignee());
                map.put("definitionId", hsi.getProcessDefinitionId());
                map.put("definitionName", hsi.getName());
                map.put("definitionKey", hsi.getTaskDefinitionKey());
                map.put("processInsId", hsi.getProcessInstanceId());
                map.put("claimTime", hsi.getClaimTime());
                map.put("startTime", hsi.getStartTime());
                map.put("bussinessId", hpi.getBusinessKey());
                map.put("variables", variables);
                map.put("taskSourceFlag", variables.get("taskSourceFlag"));
                map.put("endTime", hsi.getEndTime());
                map.put("formKey", hsi.getFormKey());
                list.add(map);
            }
        }
        return list;
    }

    @Override
    public String queryTaskIdByBusinessKey(String businessId) {
        try {
            List task = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(businessId)).list();
            String re = "";
            ArrayList<String> list = new ArrayList<String>();
            if (task != null) {
                for (int i = 0; i < task.size(); ++i) {
                    list.add(((Task)task.get(i)).getId());
                }
            }
            return ServiceResult.getResult("1", "success", JSONArray.toJSONString(list));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5f85\u529e\u5217\u8868\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String withdrawState(String historicTaskId) {
        String result = "false";
        try {
            HistoricTaskInstance currTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(historicTaskId)).singleResult();
            ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(currTask.getProcessInstanceId()).singleResult();
            if (instance == null) {
                LOGGER.error("\u51fa\u9519\u5566\uff01\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f");
                return ServiceResult.getResult("0", "\u51fa\u9519\u5566\uff01\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f", "");
            }
            ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(currTask.getProcessDefinitionId());
            if (definition == null) {
                return ServiceResult.getResult("0", "\u51fa\u9519\u5566\uff01\u6d41\u7a0b\u5b9a\u4e49\u672a\u627e\u5230", "");
            }
            ActivityImpl currActivity = definition.findActivity(currTask.getTaskDefinitionKey());
            List nextTransitionList = currActivity.getOutgoingTransitions();
            for (PvmTransition nextTransition : nextTransitionList) {
                List nextTransitionLists;
                PvmActivity nextActivity = nextTransition.getDestination();
                if ("parallelGateway".equals(nextActivity.getProperty("type"))) {
                    nextTransitionLists = nextActivity.getOutgoingTransitions();
                    boolean flag = false;
                    for (PvmTransition nextTransitions : nextTransitionLists) {
                        PvmActivity nextActivitys = nextTransitions.getDestination();
                        List hisList = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(instance.getId()).activityId(nextActivitys.getId()).unfinished().list();
                        if (hisList == null || hisList.size() <= 0) continue;
                        flag = true;
                    }
                    if (!flag) continue;
                    result = "true";
                    continue;
                }
                if ("exclusiveGateway".equals(nextActivity.getProperty("type"))) {
                    nextTransitionLists = nextActivity.getOutgoingTransitions();
                    for (PvmTransition nextTransitions : nextTransitionLists) {
                        PvmActivity nextActivitys = nextTransitions.getDestination();
                        List hisList = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(instance.getId()).activityId(nextActivitys.getId()).unfinished().list();
                        if (hisList == null || hisList.size() <= 0) continue;
                        result = "true";
                    }
                    continue;
                }
                List hisList = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(instance.getId()).activityId(nextActivity.getId()).unfinished().list();
                if (hisList != null && hisList.size() > 0) {
                    result = "true";
                    continue;
                }
                result = "false";
            }
            return ServiceResult.getResult("1", "success", result);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u80fd\u5426\u9a73\u56de\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), result);
        }
    }

    @Override
    public String revokeTask(String bussinessId, String userId, String comment, Map<String, Object> map) {
        ArrayList list = new ArrayList();
        List taskList = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(bussinessId)).list();
        if (taskList != null && taskList.size() > 0) {
            Task task = (Task)taskList.get(0);
            String taskId = task.getId();
            task.setAssignee(userId);
            Boolean isFirst = false;
            String starterUserId = "";
            String backActivityId = this.getLastActivityId(taskId);
            if (backActivityId.equals(this.getFristActivityId(taskId))) {
                starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
                isFirst = true;
            }
            if (map == null) {
                map = new HashMap<String, Object>();
            }
            map.put("taskSourceFlag", BpmConstant.REVOKE);
            this.rejectTask(userId, taskId, backActivityId, comment, map);
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(task.getProcessInstanceId())).active().list();
            if (tasks != null && tasks.size() > 0) {
                for (Task t : tasks) {
                    List identityLinkList = this.taskService.getIdentityLinksForTask(t.getId());
                    if (isFirst.booleanValue() && t.getAssignee() == null && StringUtils.isNotEmpty((CharSequence)starterUserId) && (identityLinkList == null || identityLinkList.size() == 0)) {
                        this.taskService.setAssignee(t.getId(), starterUserId);
                    }
                    HashMap<String, Object> resultMap = new HashMap<String, Object>();
                    resultMap.put("taskId", t.getId());
                    resultMap.put("definitionKey", t.getTaskDefinitionKey());
                    resultMap.put("definitionName", t.getName());
                    resultMap.put("userId", this.getAssigneeByTaskId(t.getId()));
                    list.add(resultMap);
                }
            }
        }
        return ServiceResult.getResult("1", "success", JSON.toJSONString(list));
    }

    public void backProcess(String taskId, String activityId, Map<String, Object> variables) throws Exception {
        List taskNowList;
        ProcessDefinitionEntity def;
        ActivityImpl activity;
        List out;
        PvmTransition pv;
        PvmActivity destination;
        String type;
        if (StringUtils.isEmpty((CharSequence)activityId)) {
            LOGGER.error("\u9a73\u56de\u76ee\u6807\u8282\u70b9ID\u4e3a\u7a7a!");
        }
        boolean isFirst = false;
        String userId = "";
        Task tasks = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (activityId.equals(this.getFristActivityId(taskId))) {
            List identityLink = this.processEngine.getHistoryService().getHistoricIdentityLinksForProcessInstance(tasks.getProcessInstanceId());
            for (HistoricIdentityLink il : identityLink) {
                if (!this.starter.equals(il.getType())) continue;
                userId = il.getUserId() == null ? "" : il.getUserId().toString();
                break;
            }
            isFirst = true;
        }
        if ("exclusiveGateway".equals(type = (destination = (pv = (PvmTransition)(out = (activity = (def = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(tasks.getProcessDefinitionId())).findActivity(activityId)).getOutgoingTransitions()).get(0)).getDestination()).getProperty("type").toString())) {
            this.commitProcess(taskId, variables, activityId);
        } else if ("parallelGateway".equals(type)) {
            this.commitProcess(taskId, variables, activityId);
            List outGate = destination.getOutgoingTransitions();
            ArrayList executionIdList = new ArrayList();
            for (Object pvOut : outGate) {
                PvmActivity outDestination = pvOut.getDestination();
                List hisList = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(tasks.getProcessInstanceId()).activityId(outDestination.getId()).list();
                HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)hisList.get(0);
                if (historicActivityInstance.getExecutionId().equals(tasks.getExecutionId())) continue;
                executionIdList.add(historicActivityInstance.getExecutionId());
            }
            List taskList = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(tasks.getProcessInstanceId())).list();
            for (Task task : taskList) {
                if (executionIdList.indexOf(task.getExecutionId()) == -1) continue;
                TaskEntity currentTaskEntity = (TaskEntity)((TaskQuery)this.taskService.createTaskQuery().taskId(task.getId())).singleResult();
                currentTaskEntity.setExecutionId(null);
                this.taskService.saveTask((Task)currentTaskEntity);
                this.taskService.deleteTask(task.getId(), true);
            }
        } else {
            this.commitProcess(taskId, variables, activityId);
        }
        List<Task> taskList = this.findTaskList(this.findProcessInstanceByTaskId(taskId).getId());
        for (Task task : taskList) {
            this.commitProcess(task.getId(), variables, activityId);
        }
        if (isFirst && (taskNowList = ((TaskQuery)this.processEngine.getTaskService().createTaskQuery().processInstanceId(tasks.getProcessInstanceId())).active().list()) != null && taskNowList.size() > 1) {
            for (Task taskNow : taskNowList) {
                if (taskNow.getAssignee() != null || !taskNow.getTaskDefinitionKey().equals(activityId)) continue;
                this.taskService.setAssignee(taskNow.getId(), userId);
                break;
            }
        }
    }

    private TaskEntity findTaskById(String taskId) {
        TaskEntity task = (TaskEntity)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        return task;
    }

    private void commitProcess(String taskId, Map<String, Object> variables, String activityId) {
        if (variables == null) {
            variables = new HashMap<String, Object>();
        }
        if (StringUtils.isEmpty((CharSequence)activityId)) {
            this.taskService.complete(taskId, variables);
        } else {
            this.turnTransition(taskId, activityId, variables);
        }
    }

    private void turnTransition(String taskId, String activityId, Map<String, Object> variables) {
        List taskList;
        boolean isFirst = false;
        String userId = "";
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (activityId.equals(this.getFristActivityId(taskId))) {
            List identityLink = this.processEngine.getHistoryService().getHistoricIdentityLinksForProcessInstance(task.getProcessInstanceId());
            for (HistoricIdentityLink il : identityLink) {
                if (!this.starter.equals(il.getType())) continue;
                userId = il.getUserId() == null ? "" : il.getUserId().toString();
                break;
            }
            isFirst = true;
        }
        ActivityImpl currActivity = this.findActivitiImpl(taskId, null);
        List<PvmTransition> oriPvmTransitionList = this.clearTransition(currActivity);
        TransitionImpl newTransition = currActivity.createOutgoingTransition();
        ActivityImpl pointActivity = this.findActivitiImpl(taskId, activityId);
        newTransition.setDestination(pointActivity);
        this.taskService.complete(taskId, variables);
        pointActivity.getIncomingTransitions().remove(newTransition);
        this.restoreTransition(currActivity, oriPvmTransitionList);
        if (isFirst && (taskList = ((TaskQuery)this.processEngine.getTaskService().createTaskQuery().processInstanceId(task.getProcessInstanceId())).active().list()) != null && taskList.size() > 0) {
            for (Task taskNow : taskList) {
                if (taskNow.getAssignee() != null || !taskNow.getTaskDefinitionKey().equals(activityId)) continue;
                this.taskService.setAssignee(taskNow.getId(), userId);
                break;
            }
        }
    }

    private ActivityImpl findActivitiImpl(String taskId, String activityId) {
        ProcessDefinitionEntity processDefinition = this.findProcessDefinitionEntityByTaskId(taskId);
        if (StringUtils.isEmpty((CharSequence)activityId)) {
            activityId = this.findTaskById(taskId).getTaskDefinitionKey();
        }
        if ("END".equals(activityId.toUpperCase())) {
            for (ActivityImpl activityImpl : processDefinition.getActivities()) {
                List pvmTransitionList = activityImpl.getOutgoingTransitions();
                if (!pvmTransitionList.isEmpty()) continue;
                return activityImpl;
            }
        }
        ActivityImpl activityImpl = processDefinition.findActivity(activityId);
        return activityImpl;
    }

    private List<PvmTransition> clearTransition(ActivityImpl activityImpl) {
        ArrayList<PvmTransition> oriPvmTransitionList = new ArrayList<PvmTransition>();
        List pvmTransitionList = activityImpl.getOutgoingTransitions();
        for (PvmTransition pvmTransition : pvmTransitionList) {
            oriPvmTransitionList.add(pvmTransition);
        }
        pvmTransitionList.clear();
        return oriPvmTransitionList;
    }

    private ProcessDefinitionEntity findProcessDefinitionEntityByTaskId(String taskId) {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(this.findTaskById(taskId).getProcessDefinitionId());
        if (processDefinition == null) {
            LOGGER.error("\u6d41\u7a0b\u5b9a\u4e49\u672a\u627e\u5230!");
        }
        return processDefinition;
    }

    private void restoreTransition(ActivityImpl activityImpl, List<PvmTransition> oriPvmTransitionList) {
        List pvmTransitionList = activityImpl.getOutgoingTransitions();
        pvmTransitionList.clear();
        for (PvmTransition pvmTransition : oriPvmTransitionList) {
            pvmTransitionList.add(pvmTransition);
        }
    }

    private ProcessInstance findProcessInstanceByTaskId(String taskId) throws Exception {
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(this.findTaskById(taskId).getProcessInstanceId()).singleResult();
        if (processInstance == null) {
            throw new Exception("\u6d41\u7a0b\u5b9e\u4f8b\u672a\u627e\u5230!");
        }
        return processInstance;
    }

    private List<Task> findTaskList(String processInstanceId) {
        List list = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
        return list.stream().filter(task -> task.getCreateTime() == task.getCreateTime()).collect(Collectors.toList());
    }

    private int backType(String taskId) {
        int num = 1;
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).active().singleResult();
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        if (instance == null) {
            LOGGER.error("\u51fa\u9519\u5566\uff01\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f");
            return 0;
        }
        ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
        if (definition == null) {
            LOGGER.error("\u51fa\u9519\u5566\uff01\u6d41\u7a0b\u5b9a\u4e49\u672a\u627e\u5230");
            return 0;
        }
        ActivityImpl currActivity = definition.findActivity(task.getTaskDefinitionKey());
        ActivityBehavior activityBehavior = currActivity.getActivityBehavior();
        if (activityBehavior instanceof ParallelMultiInstanceBehavior || activityBehavior instanceof SequentialMultiInstanceBehavior) {
            num = 2;
            return num;
        }
        List incomingTransitions = currActivity.getIncomingTransitions();
        for (PvmTransition pvmTransition : incomingTransitions) {
            PvmActivity pvmActivity = pvmTransition.getSource();
            if ("parallelGateway".equals(pvmActivity.getProperty("type"))) {
                num = 3;
                continue;
            }
            num = 1;
        }
        return num;
    }

    private String getTaskStarterUserId(String processInstanceId) {
        String starterUserId = "";
        HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (hpi != null) {
            starterUserId = hpi.getStartUserId();
        }
        return starterUserId;
    }

    private String backTask(String taskId, String baskActivitiId) {
        List<Task> taskList = null;
        ArrayList<String> taskIdList = new ArrayList<String>();
        String str = "";
        String processInstanceId = "";
        try {
            taskList = this.findTaskList(this.findProcessInstanceByTaskId(taskId).getId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (taskList != null && taskList.size() > 0) {
            for (Task task : taskList) {
                taskIdList.add(task.getId());
            }
            for (Task task : taskList) {
                processInstanceId = task.getProcessInstanceId();
                str = this.roolBack(task.getId(), baskActivitiId, taskIdList);
            }
            List taskNow = ((TaskQuery)this.processEngine.getTaskService().createTaskQuery().processInstanceId(processInstanceId)).active().list();
            TreeSet taskSet = new TreeSet((o1, o2) -> o1.getName().compareTo(o2.getName()));
            taskSet.addAll(taskNow);
            ArrayList s = new ArrayList(taskSet);
            for (Task t : taskNow) {
                if (s.contains(t)) continue;
                this.taskService.setAssignee(t.getId(), "");
            }
        }
        return str;
    }

    public String roolBack(String taskId, String backActivityId, List<String> taskIdList) {
        boolean isFirst = false;
        String userId = "";
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String taskDefKey = task.getTaskDefinitionKey();
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
        List activitilist = processDefinition.getActivities();
        ActivityImpl currActiviti = null;
        ActivityImpl destActiviti = null;
        int sign = 0;
        for (Object activityImpl : activitilist) {
            if (taskDefKey.equals(activityImpl.getId())) {
                currActiviti = activityImpl;
                ++sign;
            }
            if (backActivityId.equals(activityImpl.getId())) {
                destActiviti = activityImpl;
                ++sign;
            }
            if (sign != 2) continue;
            break;
        }
        if (backActivityId.equals(this.getFristActivityId(taskId))) {
            userId = this.getTaskStarterUserId(task.getProcessInstanceId());
            isFirst = true;
        }
        ArrayList<PvmTransition> hisPvmTransitionList = new ArrayList<PvmTransition>(0);
        for (PvmTransition pvmTransition : currActiviti.getOutgoingTransitions()) {
            hisPvmTransitionList.add(pvmTransition);
        }
        currActiviti.getOutgoingTransitions().clear();
        TransitionImpl newTransitionImpl = currActiviti.createOutgoingTransition();
        newTransitionImpl.setDestination(destActiviti);
        this.taskService.complete(task.getId());
        destActiviti.getIncomingTransitions().remove(newTransitionImpl);
        currActiviti.getOutgoingTransitions().clear();
        currActiviti.getOutgoingTransitions().addAll(hisPvmTransitionList);
        if (isFirst) {
            List taskNow = ((TaskQuery)this.processEngine.getTaskService().createTaskQuery().processInstanceId(task.getProcessInstanceId())).active().list();
            for (Task task1 : taskNow) {
                if (task1.getAssignee() != null || taskIdList.contains(task1.getId())) continue;
                this.taskService.setAssignee(task1.getId(), userId);
            }
        }
        return ServiceResult.getResult("1", "success", "");
    }

    @Override
    public String resolveTask(String taskId) {
        try {
            HistoricTaskInstance currTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
            ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(currTask.getProcessInstanceId()).singleResult();
            if (instance == null) {
                LOGGER.error("\u51fa\u9519\u5566\uff01\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f");
                return "ERROR";
            }
            Map variables = instance.getProcessVariables();
            ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(currTask.getProcessDefinitionId());
            if (definition == null) {
                LOGGER.error("\u51fa\u9519\u5566\uff01\u6d41\u7a0b\u5b9a\u4e49\u672a\u627e\u5230");
                return "ERROR";
            }
            ActivityImpl currActivity = definition.findActivity(currTask.getTaskDefinitionKey());
            List nextTransitionList = currActivity.getIncomingTransitions();
            ArrayList<PvmTransition> oriPvmTransitionList = new ArrayList<PvmTransition>();
            List pvmTransitionList = currActivity.getOutgoingTransitions();
            for (Object pvmTransition : pvmTransitionList) {
                oriPvmTransitionList.add((PvmTransition)pvmTransition);
            }
            pvmTransitionList.clear();
            ArrayList<TransitionImpl> newTransitions = new ArrayList<TransitionImpl>();
            for (PvmTransition nextTransition : nextTransitionList) {
                PvmActivity nextActivity = nextTransition.getSource();
                String isGateways = "";
                if (nextActivity.getProperty("type") != null) {
                    isGateways = nextActivity.getProperty("type").toString();
                }
                if (isGateways.length() > 7 || "Gataway".equals(isGateways.substring(isGateways.length() - 7))) {
                    List nextTransitionLists = nextActivity.getIncomingTransitions();
                    for (PvmTransition nextTransitions : nextTransitionLists) {
                        PvmActivity nextActivitys = nextTransitions.getSource();
                        ActivityImpl nextActivityImpl = definition.findActivity(nextActivitys.getId());
                        TransitionImpl newTransition = currActivity.createOutgoingTransition();
                        newTransition.setDestination(nextActivityImpl);
                        nextActivityImpl.getIncomingTransitions().remove(newTransition);
                        newTransitions.add(newTransition);
                    }
                    continue;
                }
                ActivityImpl nextActivityImpl = definition.findActivity(nextActivity.getId());
                TransitionImpl newTransition = currActivity.createOutgoingTransition();
                newTransition.setDestination(nextActivityImpl);
                nextActivityImpl.getIncomingTransitions().remove(newTransition);
                newTransitions.add(newTransition);
            }
            List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(instance.getId())).taskDefinitionKey(currTask.getTaskDefinitionKey())).list();
            for (Task task : tasks) {
                this.taskService.claim(task.getId(), task.getAssignee());
                this.taskService.complete(task.getId(), variables);
                this.historyService.deleteHistoricTaskInstance(task.getId());
            }
            for (TransitionImpl transitionImpl : newTransitions) {
                currActivity.getOutgoingTransitions().remove(transitionImpl);
            }
            for (PvmTransition pvmTransition : oriPvmTransitionList) {
                pvmTransitionList.add(pvmTransition);
            }
            return ServiceResult.getResult("1", "success", "");
        }
        catch (Exception e) {
            LOGGER.error("\u4efb\u52a1\u9a73\u56de\u51fa\u932f\uff1a" + e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    public String queryGatewayCondition(String gatewayId, String processInstanceId) {
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).singleResult();
        return this.runtimeService.getVariable(execution.getId(), gatewayId).toString();
    }

    public boolean isCondition(String key, String el, String value) {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = new SimpleContext();
        context.setVariable(key, factory.createValueExpression((Object)value, String.class));
        ValueExpression e = factory.createValueExpression((ELContext)context, el, Boolean.TYPE);
        return (Boolean)e.getValue((ELContext)context);
    }

    private ProcessDefinitionEntity getProcessDefinition(String processDefId) {
        return (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processDefId);
    }
}

