/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.rest.controller;

import com.jxdinfo.hussar.bpm.rest.service.TaskWebService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TaskController {
    @Resource
    private TaskWebService taskWebService;

    @RequestMapping(value={"/queryToDoTaskList"})
    public String queryToDoTaskList(String userId) {
        return this.taskWebService.queryToDoTaskList(userId);
    }

    @RequestMapping(value={"/queryToDoTaskListByProcess"})
    public String queryToDoTaskListByProcess(String userId, String processDefinitionKey) {
        return this.taskWebService.queryToDoTaskListByProcess(userId, processDefinitionKey);
    }

    @RequestMapping(value={"/queryToDoTaskListByPage"})
    public String queryToDoTaskList(String userId, Integer page, Integer rows) {
        return this.taskWebService.queryToDoTaskList(userId, page, rows);
    }

    @RequestMapping(value={"/queryToDoByDefinitionKey"})
    public String queryToDoByDefinitionKey(String processDefinitionKey) {
        return this.taskWebService.queryToDoByDefinitionKey(processDefinitionKey);
    }

    @RequestMapping(value={"/queryToDoTaskListByPageAndProcess"})
    public String queryToDoTaskListByPageAndProcess(String userId, String processDefinitionKey, Integer page, Integer rows) {
        return this.taskWebService.queryToDoTaskListByPageAndProcess(userId, processDefinitionKey, page, rows);
    }

    @RequestMapping(value={"/queryToDoTaskListByDefinitionKey"})
    public String queryToDoTaskListByDefinitionKey(String userId, String processDefinitionKey, String definitionKey, Integer page, Integer rows) {
        return this.taskWebService.queryToDoTaskListByDefinitionKey(userId, processDefinitionKey, definitionKey, page, rows);
    }

    @RequestMapping(value={"/queryFinishedTaskList"})
    public String queryFinishedTaskList(String userId) {
        return this.taskWebService.queryFinishedTaskList(userId);
    }

    @RequestMapping(value={"/queryFinishedTaskListByProcess"})
    public String queryFinishedTaskListByProcess(String userId, String processDefinitionKey) {
        return this.taskWebService.queryFinishedTaskListByProcess(userId, processDefinitionKey);
    }

    @RequestMapping(value={"/queryFinishedTaskListByPage"})
    public String queryFinishedTaskList(String userId, Integer page, Integer rows) {
        return this.taskWebService.queryFinishedTaskList(userId, page, rows);
    }

    @RequestMapping(value={"/queryFinishedTaskListByPageAndProcess"})
    public String queryFinishedTaskListByPageAndProcess(String userId, String processDefinitionKey, Integer page, Integer rows) {
        return this.taskWebService.queryFinishedTaskListByPageAndProcess(userId, processDefinitionKey, page, rows);
    }

    @RequestMapping(value={"/queryFinishedTaskListByDefinitionKey"})
    public String queryFinishedTaskListByDefinitionKey(String userId, String processDefinitionKey, String definitionKey, Integer page, Integer rows) {
        return this.taskWebService.queryFinishedTaskListByDefinitionKey(userId, processDefinitionKey, definitionKey, page, rows);
    }

    @RequestMapping(value={"/claimTask"})
    public String claimTask(String taskId, String userId) {
        return this.taskWebService.claimTask(taskId, userId);
    }

    @RequestMapping(value={"/completeTask"})
    public String completeTask(String taskId) {
        return this.taskWebService.completeTask(taskId);
    }

    @RequestMapping(value={"/completeTaskByUser"})
    public String completeTask(String taskId, String userId) {
        return this.taskWebService.completeTask(taskId, userId);
    }

    @RequestMapping(value={"/completeTaskByMap"})
    public String completeTask(String taskId, Map<String, Object> map) {
        return this.taskWebService.completeTask(taskId, map);
    }

    @RequestMapping(value={"/completeTaskByUserAndMap"})
    public String completeTask(String taskId, String userId, Map<String, Object> map) {
        return this.taskWebService.completeTask(taskId, userId, map);
    }

    @RequestMapping(value={"/completeTaskByAssignee"})
    public String completeTask(String taskId, String userId, Map<String, String> assigneeMap, Map<String, Object> map) {
        return this.taskWebService.completeTask(taskId, userId, assigneeMap, map);
    }

    @RequestMapping(value={"/completeTaskByAssigneeAndComment"})
    public String completeTaskByComment(String taskId, String userId, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        return this.taskWebService.completeTask(taskId, userId, assigneeMap, comment, map);
    }

    @RequestMapping(value={"/completeTaskByComment"})
    public String completeTask(String taskId, String userId, String comment, Map<String, Object> map) {
        return this.taskWebService.completeTask(taskId, userId, comment, map);
    }

    @RequestMapping(value={"/unClaimTask"})
    public String unClaimTask(String taskId) {
        return this.taskWebService.unClaimTask(taskId);
    }

    @RequestMapping(value={"/rejectToPreTask"})
    public String rejectToPreTask(String taskId, String comment, Map<String, Object> map) {
        return this.taskWebService.rejectToPreTask(taskId, comment, map);
    }

    @RequestMapping(value={"/rejectToPreTaskByUser"})
    public String rejectToPreTask(String taskId, String userId, String comment, Map<String, Object> map) {
        return this.taskWebService.rejectToPreTask(taskId, userId, comment, map);
    }

    @RequestMapping(value={"/rejectToFristTask"})
    public String rejectToFristTask(String taskId, String comment, Map<String, Object> map) {
        return this.taskWebService.rejectToFristTask(taskId, comment, map);
    }

    @RequestMapping(value={"/rejectToFristTaskByUser"})
    public String rejectToFristTask(String taskId, String userId, String comment, Map<String, Object> map) {
        return this.taskWebService.rejectToFristTask(taskId, userId, comment, map);
    }

    @RequestMapping(value={"/resolveTask"})
    public String resolveTask(String taskId) {
        return this.taskWebService.resolveTask(taskId);
    }

    @RequestMapping(value={"/delegateTask"})
    public String delegateTask(String taskId, String userId) {
        return this.taskWebService.delegateTask(taskId, userId);
    }

    @RequestMapping(value={"/freeJump"})
    public String freeJump(String taskId, String activitiId) {
        return this.taskWebService.freeJump(taskId, activitiId);
    }

    @RequestMapping(value={"/getCurrNodeInfoByTaskId"})
    public String getCurrNodeInfoByTaskId(String taskId) {
        return this.taskWebService.getCurrNodeInfoByTaskId(taskId);
    }

    @RequestMapping(value={"/lastUserTask"})
    public String lastUserTask(String taskId) {
        return this.taskWebService.lastUserTask(taskId);
    }

    @RequestMapping(value={"/queryNextActivitiListByTaskId"})
    public String queryNextActivitiListByTaskId(String taskId) {
        return this.taskWebService.queryNextActivitiListByTaskId(taskId);
    }

    @RequestMapping(value={"/queryAssigneeByTaskId"})
    public String queryAssigneeByTaskId(String taskId) {
        return this.taskWebService.queryAssigneeByTaskId(taskId);
    }

    @RequestMapping(value={"/queryNextAssigneeByTaskId"})
    public String queryNextAssigneeByTaskId(String taskId, Map<String, String> formData) {
        return this.taskWebService.queryNextAssigneeByTaskId(taskId, formData);
    }

    @RequestMapping(value={"/queryHistoryActByTaskId"})
    public String queryHistoryActByTaskId(String taskId) {
        return this.taskWebService.queryHistoryActByTaskId(taskId);
    }

    @RequestMapping(value={"/queryTaskIdByBusinessKey"})
    public String queryTaskIdByBusinessKey(String businessId) {
        return this.taskWebService.queryTaskIdByBusinessKey(businessId);
    }

    @RequestMapping(value={"/withdrawState"})
    public String withdrawState(String historicTaskId) {
        return this.taskWebService.withdrawState(historicTaskId);
    }

    @RequestMapping(value={"/revokeTask"})
    public String revokeTask(String bussinessId, String userId, String comment, Map<String, Object> map) {
        return this.taskWebService.revokeTask(bussinessId, userId, comment, map);
    }

    @RequestMapping(value={"/httpClientGetJson"})
    public String httpClientGetJson(HttpServletRequest request) {
        String taskId = request.getParameter("taskId") == null ? "" : request.getParameter("taskId").toString();
        JSONObject map = new HashMap();
        JSONObject response = null;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
            String line = null;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            map = response = JSONObject.fromObject((Object)sb.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.completeTask(taskId, (Map<String, Object>)map);
    }
}

