/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.processinst.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bpm.processinst.service.ProcessInstService;
import com.jxdinfo.hussar.bpm.rest.service.ProcessInstanceService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/processInst"})
public class ProcessInstController
extends BaseController {
    @Autowired
    private ProcessInstService processInstService;
    @Autowired
    private ProcessInstanceService processInstanceService;

    @RequestMapping(value={"/goViewRun"})
    @RequiresPermissions(value={"processInst:goViewRun"})
    @BussinessLog(key="/processInst/goViewRun", type="04", value="\u8fd0\u884c\u4e2d\u5b9e\u4f8b\u6d41\u7a0b\u9875\u9762")
    public ModelAndView goViewRun() {
        ModelAndView mv = new ModelAndView("/bpm/processinst/running/runningProcess.html");
        return mv;
    }

    @RequestMapping(value={"/goViewSup"})
    @RequiresPermissions(value={"processInst:goViewSup"})
    @BussinessLog(key="/processInst/goViewSup", type="04", value="\u6302\u8d77\u7684\u5b9e\u4f8b\u6d41\u7a0b\u9875\u9762")
    public ModelAndView goViewSup() {
        ModelAndView mv = new ModelAndView("/bpm/processinst/suspend/suspendProcess.html");
        return mv;
    }

    @RequestMapping(value={"/goViewFinished"})
    @RequiresPermissions(value={"processInst:goViewFinished"})
    @BussinessLog(key="/processInst/goViewFinished", type="04", value="\u5b8c\u6210\u7684\u5b9e\u4f8b\u6d41\u7a0b\u9875\u9762")
    public ModelAndView goViewFinished() {
        ModelAndView mv = new ModelAndView("/bpm/processinst/finished/finishedProcess.html");
        return mv;
    }

    @RequestMapping(value={"/getRunningProcessList"})
    public Map<String, Object> getRunningProcessList(@RequestParam(required=false) String processDefName, @RequestParam(required=false) String processInstCode, @RequestParam(required=false) String businessKey, @RequestParam(required=false) String startTime, @RequestParam(required=false) String startTimeEnd, @RequestParam(required=false) Integer page, @RequestParam(required=false) Integer limit) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processDefName", processDefName);
        map.put("processInstCode", processInstCode);
        map.put("businessKey", businessKey);
        map.put("startTime", startTime);
        map.put("startTimeEnd", startTimeEnd);
        map.put("page", page);
        map.put("limit", limit);
        Map<String, Object> result = this.processInstService.getRunningProcessList(map);
        return result;
    }

    @RequestMapping(value={"/getSuspendProcessList"})
    public Map<String, Object> getSuspendProcessList(@RequestParam(required=false) String processDefName, @RequestParam(required=false) String processInstCode, @RequestParam(required=false) String businessKey, @RequestParam(required=false) String startTime, @RequestParam(required=false) String startTimeEnd, @RequestParam(required=false) Integer page, @RequestParam(required=false) Integer limit) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processDefName", processDefName);
        map.put("processInstCode", processInstCode);
        map.put("businessKey", businessKey);
        map.put("startTime", startTime);
        map.put("startTimeEnd", startTimeEnd);
        map.put("page", page);
        map.put("limit", limit);
        Map<String, Object> result = this.processInstService.getSuspendProcessList(map);
        return result;
    }

    @RequestMapping(value={"/getFinishedProcessList"})
    public Map<String, Object> getFinishedProcessList(@RequestParam(required=false) String processDefName, @RequestParam(required=false) String processInstCode, @RequestParam(required=false) String businessKey, @RequestParam(required=false) String endTime, @RequestParam(required=false) String endTimeEnd, @RequestParam(required=false) Integer page, @RequestParam(required=false) Integer limit) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processDefName", processDefName);
        map.put("processInstCode", processInstCode);
        map.put("businessKey", businessKey);
        map.put("endTime", endTime);
        map.put("endTimeEnd", endTimeEnd);
        map.put("page", page);
        map.put("limit", limit);
        Map<String, Object> result = this.processInstService.getFinishedProcessList(map);
        return result;
    }

    @RequestMapping(value={"/deleteProcessById"})
    @RequiresPermissions(value={"processInst:deleteProcessById"})
    @BussinessLog(key="/processInst/deleteProcessById", type="2", value="\u5220\u9664\u8fd0\u884c\u4e2d\u548c\u6302\u8d77\u7684\u6d41\u7a0b\u5b9e\u4f8b")
    public String deleteProcessById(@RequestParam(value="instId") String instId) {
        String delete = "";
        String[] processInstanceId = instId.split(",");
        for (int i = 0; i < processInstanceId.length; ++i) {
            delete = this.processInstService.deleteProcessInstance(processInstanceId[i]);
        }
        return delete;
    }

    @RequestMapping(value={"/deleteFinishedProcessById"})
    @RequiresPermissions(value={"processInst:deleteFinishedProcessById"})
    @BussinessLog(key="/processInst/deleteFinishedProcessById", type="11", value="\u5220\u9664\u5b8c\u6210\u7684\u6d41\u7a0b\u5b9e\u4f8b")
    public String deleteFinishedProcessById(@RequestParam(value="instId") String instId) {
        String delete = "";
        String[] processInstanceId = instId.split(",");
        for (int i = 0; i < processInstanceId.length; ++i) {
            delete = this.processInstService.deleteFinishedProcessInstance(processInstanceId[i]);
        }
        return delete;
    }

    @RequestMapping(value={"/suspendProcessById"})
    @RequiresPermissions(value={"processInst:suspendProcessById"})
    @BussinessLog(key="/processInst/suspendProcessById", type="10", value="\u6302\u8d77\u6d41\u7a0b\u5b9e\u4f8b")
    public String suspendProcessById(@RequestParam(value="instId") String instId) {
        String suspend = "";
        String[] processInstanceId = instId.split(",");
        for (int i = 0; i < processInstanceId.length; ++i) {
            suspend = this.processInstService.suspendProcessInstanceById(processInstanceId[i]);
        }
        return suspend;
    }

    @RequestMapping(value={"/activateProcessById"})
    @RequiresPermissions(value={"processInst:activateProcessById"})
    @BussinessLog(key="/processInst/activateProcessById", type="11", value="\u6fc0\u6d3b\u6d41\u7a0b\u5b9e\u4f8b")
    public String activateProcessById(@RequestParam(value="instId") String instId) {
        String activate = "";
        String[] processInstanceId = instId.split(",");
        for (int i = 0; i < processInstanceId.length; ++i) {
            activate = this.processInstService.activateProcessById(processInstanceId[i]);
        }
        return activate;
    }

    @RequestMapping(value={"/getLocalProcessTrace"})
    @ResponseBody
    public JSONArray getLocalProcessTrace(String processInstanceId, HttpServletResponse response) {
        try {
            String trace = this.processInstanceService.getProcessTrace(processInstanceId);
            JSONObject object = JSONObject.parseObject((String)trace);
            String resultStr = object.get((Object)"result") == null ? "" : object.get((Object)"result").toString();
            JSONArray jsonArray = JSONArray.parseArray((String)resultStr);
            return jsonArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

