/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.processcount;

import com.jxdinfo.hussar.bpm.processinst.service.ProcessInstService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/processCount"})
public class ProcessCountController
extends BaseController {
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private ProcessInstService processInstService;
    @Value(value="${spring.datasource.driverClassName}")
    private String driverClassName;

    @RequestMapping(value={"/getPic"})
    public List getProcessDefinitions() {
        ArrayList<Serializable> result = new ArrayList<Serializable>();
        try {
            int definition = (int)this.repositoryService.createProcessDefinitionQuery().latestVersion().count();
            int model = (int)this.repositoryService.createModelQuery().latestVersion().count();
            int wait = (int)this.taskService.createTaskQuery().count();
            int instance = (int)this.runtimeService.createProcessInstanceQuery().count();
            int finished = (int)this.historyService.createHistoricProcessInstanceQuery().finished().count();
            int suspend = (int)this.runtimeService.createProcessInstanceQuery().suspended().count();
            int active = (int)this.runtimeService.createProcessInstanceQuery().active().count();
            List list = new ArrayList();
            list = this.driverClassName.indexOf("mysql") != -1 ? this.processInstService.getFinishAmount("mysql") : this.processInstService.getFinishAmount("oracle");
            HashMap map = new HashMap();
            for (int i = 0; i < list.size(); ++i) {
                HashMap mapResult = (HashMap)list.get(i);
                map.put(((String)mapResult.get("TIME")).trim(), mapResult.get("AMOUNT"));
            }
            result.add(Integer.valueOf(definition));
            result.add(Integer.valueOf(model));
            result.add(Integer.valueOf(wait));
            result.add(Integer.valueOf(instance));
            result.add(Integer.valueOf(finished));
            result.add(Integer.valueOf(suspend));
            result.add(Integer.valueOf(active));
            result.add(map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @RequestMapping(value={"/instanceCount"})
    @RequiresPermissions(value={"processCount:instanceCount"})
    @BussinessLog(key="/processCount/instanceCount", type="04", value="\u6d41\u7a0b\u5b9e\u4f8b\u9875\u9762")
    public ModelAndView instanceCount() {
        ModelAndView mv = new ModelAndView("/bpm/processcount/instancecount.html");
        return mv;
    }

    @RequestMapping(value={"/processPandect"})
    @RequiresPermissions(value={"processCount:processPandect"})
    @BussinessLog(key="/processCount/processPandect", type="04", value="\u6d41\u7a0b\u603b\u89c8\u9875\u9762")
    public ModelAndView processPandect() {
        ModelAndView mv = new ModelAndView("/bpm/processcount/processpandect.html");
        return mv;
    }

    @RequestMapping(value={"/finishedProcess"})
    @RequiresPermissions(value={"processCount:finishedProcess"})
    @BussinessLog(key="/processCount/finishedProcess", type="04", value="\u5df2\u5b8c\u6210\u6d41\u7a0b\u9875\u9762")
    public ModelAndView finishedProcess() {
        ModelAndView mv = new ModelAndView("/bpm/processcount/finishedprocess.html");
        return mv;
    }
}

