/**
 * Created by lenovo on 2018/2/28.
 */
var RunProcess = {};
        //初始化表格
        layui.use(['jquery','layer','Hussar','jstree','HussarAjax','table','laydate'], function(){
        	var Hussar = layui.Hussar;
        	var $ = layui.jquery;
        	var layer=layui.layer;
        	var $ax=layui.HussarAjax;
        	var table = layui.table;
        	var laydate = layui.laydate;
        	var ts = laydate.render({
        	   	elem: '#startTime',
                type : 'datetime',
                done: function (value,date) {	
               	 if (value !== '') {
               		 te.config.min.year = date.year;
        	        	 te.config.min.month = date.month - 1;
        	        	 te.config.min.date = date.date;
        	        	 te.config.min.hours = date.hours;
        	        	 te.config.min.minutes = date.minutes;
        	        	 te.config.min.seconds = date.seconds;
               	 } else {
               		 te.config.min.year = '';
        	        	 te.config.min.month = '';
        	        	 te.config.min.date = '';
        	        	 te.config.min.hours = '';
        	        	 te.config.min.minutes = '';
        	        	 te.config.min.seconds = '';
               	 }
               	 	        	 
                }
        	});
        	var te = laydate.render({
        	   	 elem: '#startTimeEnd',
        	     type : 'datetime',              
        	     done: function (value,date) {			    	 
        	    	 if (value !== '') {
        	    		 ts.config.max.year = date.year;
        	        	 ts.config.max.month = date.month - 1;
        	        	 ts.config.max.date = date.date;
        	        	 ts.config.max.hours = date.hours;
        	        	 ts.config.max.minutes = date.minutes;
        	        	 ts.config.max.seconds = date.seconds;
        	    	 } else {
        	    		 ts.config.max.year = '2099';
        	        	 ts.config.max.month = '11';
        	        	 ts.config.max.date = '31';
        	        	 ts.config.max.hours = '0';
        	        	 ts.config.max.minutes = '0';
        	        	 ts.config.max.seconds = '0';
        	    	 }
        	    	 	 
        	     }
        	});
            table.render({
                elem: '#runningProcessTable',
                url:Hussar.ctxPath+'/processInst/getRunningProcessList',
                cols: [[
                    {type:'checkbox'},
                    {type:'numbers', title: '序号'},
                    {field: 'processDefinitionName', title: '流程定义名称', align:'center'},
                    {field: 'processInstanceId', title: '流程实例编码', align:'center',event: 'openPic', style:'cursor: pointer;color:#00a4ff',width:300},
                    {field: 'processDefinitionId', title: '流程定义编码', align:'center', visible:false},
                    {field: 'businessKey', title: '业务主键', align:'center'},
                    {field: 'startTime', title: '流程启动时间', align:'center',templet:function (params) {
                        if (params.startTime == null || params.startTime== "") {
                            return "";
                        }else if(params.startTime.length==30){
                            var str=params.startTime;
                            return str.slice(0,9) + " " + str.slice(10,12)+":"+ str.slice(13,15)+":"+ str.slice(17,19);
                        } else{
                            return new Date(params.startTime).format("yyyy-MM-dd hh:mm:ss");
                        }
                    }},
                    {field: 'endTime', title: '流程结束时间', align:'center',templet:function (params) {
                        if (params.endTime == null || params.endTime== "") {
                            return "";
                        }else if(params.endTime.length==30){
                            var str=params.endTime;
                            return str.slice(0,9) + " " + str.slice(10,12)+":"+ str.slice(13,15)+":"+ str.slice(17,19);
                        } else {
                            return new Date(params.endTime).format("yyyy-MM-dd hh:mm:ss");
                        }
                    }},
                ]]
                ,page: true
                ,height:$("body").height() - $(".toolbar").outerHeight(true) -70
                ,loading:true
                ,text: {
                    none: '暂无相关数据'
                }
                ,even: true
            });
            table.on('tool(clickEvent)', function(obj){
                var data = obj.data;
                if(obj.event === 'openPic'){
                    layui.use('layer', function(){
                        var layer = layui.layer;
                        layer.open({
                            type: 1,
                            maxmin : true,
                            title:"流程实例图",
                            content: $('#picWindow'), //这里content是一个DOM，注意：最好该元素要存放在body最外层，否则可能被其它的相对元素所影响
                            area: ["866px", "400px"],
                            success: function(){
                                $('#pictureName').html(data.processName)
                            },
                            end: function () {
                                $('#picWindow').hide();
                            }
                        });
                    });
                    var flowImageAndRect = $('#flowImageAndRect');
                    flowImageAndRect.empty();
                    // 加载流程图片
                    loadProcessImage(data.processInstanceId);
                    setTimeout(function(){
                        loadProcessTrace(data.processInstanceId);
                    },200);
                }
            });
            /*查询*/
            $("#search").click(function () {
                reloadTable();
            });
            function reloadTable() {
                var table = layui.table;
                table.reload("runningProcessTable", {
                    page : {
                        curr : 1
                        // 重新从第 1 页开始
                    },
                    where: {
                        processDefName: $('#processDefName').val(),
                        processInstCode: $('#processInstCode').val(),
                        businessKey: $('#businessKey').val(),
                        startTime: $('#startTime').val(),
                        startTimeEnd: $('#startTimeEnd').val()
                    }
                });
            }
            /*重置*/
            $("#reset").click(function () {
                //流程定义名称
                $('#processDefName').val('');
                //流程实例编码
                $('#processInstCode').val('');
                //业务主键
                $('#businessKey').val('');
                //流程结束时间
                $('#startTime').val('');
                //至
                $('#startTimeEnd').val('');
                //重新加载表格
                reloadTable();
            });
            /*删除*/
            $('#delete').click(function(){
                var that = this;
                var ids = [];
                var table = layui.table;
                var checkStatus = table.checkStatus("runningProcessTable");
                var data = checkStatus.data;
                for(var i=0;i<data.length;i++){    //循环筛选出id
                    ids.push(data[i].processInstanceId);
                }

                if(data.length == 0){
                    Hussar.info("请选择要删除的记录");
                }else{
                    layer.confirm('确认删除吗?', {icon: 3, title:'提示'}, function(index) {
                        var eId = ids.join(',');
                        var url =  Hussar.ctxPath+"/processInst/deleteProcessById?instId="+eId;
                        $.ajax({
                            type: "post",
                            url: url,
                            success: function (data) {
                                var jsObject = JSON.parse(data);
                                var result= jsObject.result;
                                var flags = JSON.parse(result);
                                var re = flags.flag;
                                if(re=="true"){
                                    Hussar.success("删除成功");
                                    reloadTable();
                                }
                                if(re=="false"){
                                    Hussar.error("删除失败");
                                }
                            },
                            error: function () {
                                Hussar.error("删除失败");
                            }
                        });
                        layer.close(index);
                    });
                }
            });
            /*挂起*/
            $('#suspend').click(function(){
                var that = this;
                var ids = [];
                var table = layui.table;
                var checkStatus = table.checkStatus("runningProcessTable");
                var data = checkStatus.data;
                for(var i=0;i<data.length;i++){    //循环筛选出id
                    ids.push(data[i].processInstanceId);
                }

                if(data.length == 0){
                    Hussar.info("请选择要挂起的记录");
                }else{
                    layer.confirm('确认挂起吗?', {icon: 3, title:'提示'}, function(index) {
                        var eId = ids.join(',');
                        var url =  Hussar.ctxPath+"/processInst/suspendProcessById?instId="+eId;
                        $.ajax({
                            type: "post",
                            url: url,
                            success: function (data) {
                                var jsObject = JSON.parse(data);
                                var result= jsObject.result;
                                var flags = JSON.parse(result);
                                var re = flags.flag;
                                if(re=="true"){
                                    Hussar.success("挂起成功");
                                    reloadTable();
                                }
                                if(re=="false"){
                                    Hussar.error("挂起失败");
                                }
                            },
                            error: function () {
                                Hussar.error("挂起失败");
                            }
                        });
                        layer.close(index);
                    });
                }
            });
            /**
             * 加载图片
             */
            function loadProcessImage(id){
                var imageUrl = Hussar.ctxPath+"/queryProcessInstancePicture?processInstanceId="+id+"";
                // 加载图片
                $('<img />',{
                    "src" : imageUrl,
                    "alt" : '',
                    "class":"imgLeft",
                }).appendTo($('#flowImageAndRect'));
            }

            /**
             * 加载流程中各节点的信息
             * @param id : 流程定义的id
             */
            function loadProcessTrace(instanceId) {
                var traceUrl = Hussar.ctxPath+"/processInst/getLocalProcessTrace?processInstanceId="+instanceId+"";
                var html = "";
                $.ajax({
                    type: "get",
                    url: traceUrl,
                    traditional: true,
                    success: function (infos) {
                        $.each(infos, function (i, v) {
                            // 矩形的div
                            var $div = $('<div/>', {
                                'class': 'activity-attr',
                                'onmouseover' : 'RunProcess.over("'+v.actId+'")',
                                'onmouseout' : 'RunProcess.out("'+v.actId+'")',
                            }).css({
                                position: 'absolute',
                                left: v.x,
                                top: v.y,
                                width: v.width,
                                height: v.height,
                                opacity: 0,
                                zIndex: 100,
                            }).attr({'actId': v.actId, 'name': v.name});
                            html += $div.prop("outerHTML");
                        });

                        $.each(infos, function (i, v) {
                            // 矩形的div
                            var userInfo= v.userInfo;
                            var timeInfo=v.timeInfo;
                            var info="";
                            for(var key in userInfo) {
                                var userName=userInfo[key];
                                if(userInfo[key]==null||userInfo[key]==undefined||userInfo[key]=="null"){
                                    userName="";
                                }
                                info=info+'<tr>\n' +
                                    '    <td ><span id="numZJ">'+userName+'</span></td>\n' +
                                    '    <td ><span id="numZJ">'+new Date(parseInt(timeInfo[key])).format("yyyy-MM-dd hh:mm:ss")+'</span></td>\n' +
                                    '</tr>\n'
                            }
                            var $div = $('<div id="'+v.actId+'" class="hideDiv"><table class="activityTable">\n' +
                                '    <tbody>\n' +'<tr>\n' +
                                '    <td ><span>处理人</span></td>\n' +
                                '    <td ><span>处理时间</span></td>\n' +
                                '</tr>\n'+
                                info+
                                '    </tbody>\n' +
                                '</table></div>', {
                                'class': ''
                            }).css({
                                position: 'absolute',
                                left: v.x+v.width+3,
                                top: v.y,
                                width: 300,
                                height: v.height ,
                                opacity: 999,
                                zIndex: 10000000,
                            }).attr({'actId': v.actId, 'name': v.name});
                            html += $div.prop("outerHTML");
                        });
                        $('<div />', {'id': 'processRect'}).html(html).appendTo($('#flowImageAndRect'));
                    }
                })
            }
            /*鼠标悬停*/
            RunProcess.over=function(id){
                $('#'+id).show();
            }
            /*鼠标移出*/
            RunProcess.out=function(id){
                $('#'+id).hide();
            }
            Date.prototype.format = function(fmt) {
                var o = {
                    "M+" : this.getMonth()+1,                 //月份
                    "d+" : this.getDate(),                    //日
                    "h+" : this.getHours(),                   //小时
                    "m+" : this.getMinutes(),                 //分
                    "s+" : this.getSeconds(),                 //秒
                    "q+" : Math.floor((this.getMonth()+3)/3), //季度
                    "S"  : this.getMilliseconds()             //毫秒
                };
                if(/(y+)/.test(fmt)) {
                    fmt=fmt.replace(RegExp.$1, (this.getFullYear()+"").substr(4 - RegExp.$1.length));
                }
                for(var k in o) {
                    if(new RegExp("("+ k +")").test(fmt)){
                        fmt = fmt.replace(RegExp.$1, (RegExp.$1.length==1) ? (o[k]) : (("00"+ o[k]).substr((""+ o[k]).length)));
                    }
                }
                return fmt;
            }
        });
        