/*
 * Activiti Modeler component part of the Activiti project
 * Copyright 2005-2014 Alfresco Software, Ltd. All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
'use strict';

angular.module('activitiModeler')
    .controller('ToolbarController', ['$scope', '$http', '$modal', '$q', '$rootScope', '$translate', '$location', function ($scope, $http, $modal, $q, $rootScope, $translate, $location) {

    	$scope.editorFactory.promise.then(function () {
    		$scope.secondItems = KISBPM.TOOLBAR_CONFIG.secondItems;
    	});
        
        $scope.firstItems = KISBPM.TOOLBAR_CONFIG.firstItems;

        // Call configurable click handler (From http://stackoverflow.com/questions/359788/how-to-execute-a-javascript-function-when-i-have-its-name-as-a-string)
        var executeFunctionByName = function(functionName, context /*, args */) {
            var args = Array.prototype.slice.call(arguments).splice(2);
            var namespaces = functionName.split(".");
            var func = namespaces.pop();
            for(var i = 0; i < namespaces.length; i++) {
                context = context[namespaces[i]];
            }
            return context[func].apply(this, args);
        };

        // Click handler for toolbar buttons
        $scope.toolbarButtonClicked = function(buttonIndex) {

            // Default behaviour
            var buttonClicked = $scope.secondItems[buttonIndex];
            var services = { '$scope' : $scope, '$rootScope' : $rootScope, '$http' : $http, '$modal' : $modal, '$q' : $q, '$translate' : $translate};
            executeFunctionByName(buttonClicked.action, window, services);

            // Other events
            var event = {
                type : KISBPM.eventBus.EVENT_TYPE_TOOLBAR_BUTTON_CLICKED,
                toolbarItem : buttonClicked
            };
            KISBPM.eventBus.dispatch(event.type, event);
        };
        
        // Click handler for secondary toolbar buttons
        $scope.toolbarFirstButtonClicked = function(buttonIndex) {
            var buttonClicked = $scope.firstItems[buttonIndex];
            var services = { '$scope' : $scope, '$http' : $http, '$modal' : $modal, '$q' : $q, '$translate' : $translate, '$location': $location};
            executeFunctionByName(buttonClicked.action, window, services);
        };
        
        /* Key bindings */
        Mousetrap.bind(['command+z', 'ctrl+z'], function(e) {
        	var services = { '$scope' : $scope, '$rootScope' : $rootScope, '$http' : $http, '$modal' : $modal, '$q' : $q, '$translate' : $translate};
        	KISBPM.TOOLBAR.ACTIONS.undo(services);
            return false;
        });
        
        Mousetrap.bind(['command+y', 'ctrl+y'], function(e) {
        	var services = { '$scope' : $scope, '$rootScope' : $rootScope, '$http' : $http, '$modal' : $modal, '$q' : $q, '$translate' : $translate};
        	KISBPM.TOOLBAR.ACTIONS.redo(services);
            return false;
        });
        
        Mousetrap.bind(['command+c', 'ctrl+c'], function(e) {
        	var services = { '$scope' : $scope, '$rootScope' : $rootScope, '$http' : $http, '$modal' : $modal, '$q' : $q, '$translate' : $translate};
        	KISBPM.TOOLBAR.ACTIONS.copy(services);
            return false;
        });
        
        Mousetrap.bind(['command+v', 'ctrl+v'], function(e) {
        	var services = { '$scope' : $scope, '$rootScope' : $rootScope, '$http' : $http, '$modal' : $modal, '$q' : $q, '$translate' : $translate};
        	KISBPM.TOOLBAR.ACTIONS.paste(services);
            return false;
        });
        
        Mousetrap.bind(['del'], function(e) {
        	var services = { '$scope' : $scope, '$rootScope' : $rootScope, '$http' : $http, '$modal' : $modal, '$q' : $q, '$translate' : $translate};
        	KISBPM.TOOLBAR.ACTIONS.deleteItem(services);
            return false;
        });

        /* Undo logic */

        $scope.undoStack = [];
        $scope.redoStack = [];

        $scope.editorFactory.promise.then(function() {

            // Catch all command that are executed and store them on the respective stacks
            $scope.editor.registerOnEvent(ORYX.CONFIG.EVENT_EXECUTE_COMMANDS, function( evt ){

                // If the event has commands
                if( !evt.commands ){ return; }

                $scope.undoStack.push( evt.commands );
                $scope.redoStack = [];
                
                for(var i = 0; i < $scope.secondItems.length; i++)
        		{
                    var item = $scope.secondItems[i];
                    if (item.action === 'KISBPM.TOOLBAR.ACTIONS.undo')
                    {
                    	item.enabled = true;
                    }
                    else if (item.action === 'KISBPM.TOOLBAR.ACTIONS.redo')
                    {
                    	item.enabled = false;
                    }
        		}

                // Update
                $scope.editor.getCanvas().update();
                $scope.editor.updateSelection();

            });

        });
        
        // Handle enable/disable toolbar buttons 
        $scope.editorFactory.promise.then(function() {
        	$scope.editor.registerOnEvent(ORYX.CONFIG.EVENT_SELECTION_CHANGED, function( evt ){
        		var elements = evt.elements;
        		
        		for(var i = 0; i < $scope.secondItems.length; i++)
        		{
                    var item = $scope.secondItems[i];
                    if (item.enabledAction && item.enabledAction === 'element')
                    {
                    	var minLength = 1;
                    	if(item.minSelectionCount) {
                    		minLength = item.minSelectionCount;
                    	}
                    	if (elements.length >= minLength && !item.enabled) {
                    		$scope.safeApply(function () {
                    			item.enabled = true;
                            });
                    	}
                    	else if (elements.length == 0 && item.enabled) {
                    		$scope.safeApply(function () {
                    			item.enabled = false;
                            });
                    	}
                    }
                }
        	});
        	
        });

        // localStorage.removeItem('tipFlag');
        // 设置localStorage 如果用户第一次进入页面就显示引导用户步骤
        if(window.localStorage){
            var tipFlag = localStorage.getItem("tipFlag"); //获取tip的值

            if(tipFlag == null){

                jQuery(".guide-box").fadeIn();

                localStorage.setItem("tipFlag","visited"); //设置a为"visited" 关键代码 设置
            }
        }

        jQuery('.konwButton').click(function() {
            jQuery(".guide-box").fadeOut();
        });
        jQuery(".btn-key").off("click").click(function(){
            jQuery(".guide-box").fadeToggle();
        });
        // 禁止全局缩放
        var scrollFunc=function(e){
            var e = e || window.event;
            if(e.wheelDelta && e.ctrlKey){//IE/Opera/Chrome
                e.returnValue=false;
                e.preventDefault();
            }else if(e.detail && e.ctrlKey){//Firefox
                e.returnValue=false;
                e.preventDefault();
            }
        }
        /*注册事件*/
        if(document.addEventListener){
            document.addEventListener('DOMMouseScroll',scrollFunc,false);
        }
        //W3C
        window.onmousewheel=document.onmousewheel=scrollFunc;//IE/Opera/Chrome/Safari

        window.setTimeout(function(){
            var services = { '$scope' : $scope, '$rootScope' : $rootScope, '$http' : $http, '$modal' : $modal, '$q' : $q, '$translate' : $translate};
            // canvas局部缩放
            var matchArr = navigator.userAgent.match(/MSIE (\d)/i);
            var isIE = matchArr ? matchArr[1]:undefined;
            var isFF = /FireFox/i.test(navigator.userAgent);
            
            var canvas = document.getElementById("ORYX_Editor");

            if(isIE < 9) { //传统浏览器使用MouseWheel事件
                document.attachEvent("onmousewheel",mousewheelEvent);
            }else if(!isFF){ //除火狐外的现代浏览器也使用MouseWheel事件
                document.addEventListener("mousewheel",mousewheelEvent);
            }else{ //火狐使用DOMMouseScroll事件
                document.addEventListener("DOMMouseScroll",mousewheelEvent);
            }

            function mousewheelEvent(e){
                var e = e || window.event;

                if(e.ctrlKey) {
                    e.preventDefault();
                    e.stopPropagation();
                   var delta= (e.wheelDelta / 120) ||( -e.detail / 3);
                    if(delta>0){
                        KISBPM.TOOLBAR.ACTIONS.zoomIn(services);
                    }else{
                        KISBPM.TOOLBAR.ACTIONS.zoomOut(services);
                    }
                    //阻止浏览器默认方法
                    return false;
                }
            }


            document.onkeydown =function(e){
                var  e = e || window.event;

                if (e.shiftKey){
                    canvas.classList.add("grab");
                }
                if(e.ctrlKey && e.keyCode == 187) {

                    KISBPM.TOOLBAR.ACTIONS.zoomIn(services);
                    //阻止浏览器默认方法
                    e.returnValue=false;
                    e.preventDefault();
                }
                if(e.ctrlKey && e.keyCode == 189) {

                    KISBPM.TOOLBAR.ACTIONS.zoomOut(services);
                    //阻止浏览器默认方法
                    e.returnValue=false;
                    e.preventDefault();
                }

            }
            document.onkeyup =function(){
                canvas.classList.remove("grab");
            }

            var canvasSection = document.getElementById("canvasSection");
            var offsetX = 0;
            var offsetY = 0;
            //点击某物体时，用drag对象即可，move和up是全局区域，也就是整个文档通用，应该使用document对象而不是drag对象(否则，采用drag对象时物体只能往右方或下方移动)
            canvas.onmousedown = function(e) {
                var e = e || window.event;
                if(e.shiftKey){
                    var e = e || window.event; //兼容ie浏览器
                    var orignalX = e.clientX; //点击时的位置相对于浏览器最左边的距离
                    var orignalY = e.clientY;

                    // console.log("鼠标按下的位置:("+orignalX+","+orignalY+")");
                    /*低版本ie bug:物体被拖出浏览器可是窗口外部时，还会出现滚动条，
                        解决方法是采用ie浏览器独有的2个方法setCapture()\releaseCapture(),这两个方法，
                        可以让鼠标滑动到浏览器外部也可以捕获到事件，而我们的bug就是当鼠标移出浏览器的时候，
                        限制超过的功能就失效了。用这个方法，即可解决这个问题。注：这两个方法用于onmousedown和onmouseup中*/
                    if(typeof canvas.setCapture!='undefined'){
                        canvas.setCapture();
                    }

                    document.onmousemove = function(e) {
                        var e = e || window.event; //兼容ie浏览器
                        //移动时物体的偏移距离累加，解决拖动时出现晃动的现象
                        offsetX +=  (e.clientX - orignalX);
                        offsetY += (e.clientY - orignalY);

                        // console.log("鼠标移动的位置:("+e.clientX+","+e.clientY+")");
                        // console.log("偏移位置:("+offsetX+","+offsetY+")");
                        canvas.style.transform = "translate("+offsetX+ "px,"+offsetY+"px)";
                        orignalX = e.clientX;
                        orignalY = e.clientY;

                    };
                    document.onmouseup = function(e) { //当鼠标弹起来的时候不再移动

                        this.onmousemove = null;
                        this.onmouseup = null; //预防鼠标弹起来后还会循环（即预防鼠标放上去的时候还会移动）

                        //修复低版本ie bug
                        if(typeof canvas.releaseCapture!='undefined'){
                            canvas.releaseCapture();
                        }
                    };
                }else{
                    canvas.classList.remove("grab");
                }
            };

        },1500)

    }]);