/*
 * Activiti Modeler component part of the Activiti project
 * Copyright 2005-2014 Alfresco Software, Ltd. All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * Assignment
 */
var app = angular.module('myApp',[]);
var KisBpmAssignmentCtrl = ['$scope', '$modal', function ($scope, $modal) {

    // Config for the modal window
    var opts = {
        template: 'bpm/editor-app/configuration/properties/assignment-popup.html?version=' + Date.now(),
        scope: $scope
    };

    // Open the dialog
    $modal(opts);
    $scope.tab =1;
    $scope.selectTab = function (setTab) {
        this.tab = setTab;
    }
    $scope.isSelected = function (checkTab) {
      return  this.tab === checkTab;
    }
}];

var KisBpmAssignmentPopupCtrl = ['$scope', '$http', function ($scope, $http) {
    var countUser = 0;
    var countRole = 0;
    var countDept = 0;
    var arrUsers = [];
    var arrRoles = [];
    var arrDepts = [];
    $scope.setting = {
        check: {
            enable: true
        },
        data: {
            simpleData: {
                enable: true
            }
        },
        callback: {
            onCheck: function (event, treeId, treeNode) {//点击菜单时进行的处理
                var treeName = "userTree";
                var zTree = jQuery.fn.zTree.getZTreeObj("userTree");
                var checkNodes = zTree.getCheckedNodes(true);
                var users = [];
                if (checkNodes.length > 0) {
                    for (var i = 0; i < checkNodes.length; i++) {
                        if (!checkNodes[i].isParent) {
                            var obj = {
                                name: checkNodes[i].name,
                                type: checkNodes[i].type,
                                id: checkNodes[i].id,
                                treeName:treeName
                            };
                            users.push(obj);
                        }
                    }
                }
                $scope.users = users;
                $scope.$apply()
                return true;
            }
        }
    };

    $scope.settingRole = {
        check: {
            enable: true
        },
        data: {
            simpleData: {
                enable: true
            }
        },
        callback: {
            onCheck: function (event, treeId, treeNode) {//点击菜单时进行的处理
                var treeName = "roleTree";
                var zTree = jQuery.fn.zTree.getZTreeObj("roleTree");
                var checkNodes = zTree.getCheckedNodes(true);
                var roles = [];
                if (checkNodes.length > 0) {
                    for (var i = 0; i < checkNodes.length; i++) {
                        if (!checkNodes[i].isParent) {
                            var obj = {
                                name: checkNodes[i].name,
                                type: checkNodes[i].type,
                                id: checkNodes[i].id,
                                treeName:treeName
                            };
                            roles.push(obj);
                        }
                    }
                }
               $scope.roles = roles;
                $scope.$apply();
                return true;
            }
        }
    };

    $scope.settingDept = {
        check: {
            enable: true
        },
        data: {
            simpleData: {
                enable: true
            }
        },
        callback: {
            onCheck: function (event, treeId, treeNode) {//点击菜单时进行的处理
                var treeName = "deptTree";
                var zTree = jQuery.fn.zTree.getZTreeObj("deptTree");
                var checkNodes = zTree.getCheckedNodes(true);
                var depts = [];
                if (checkNodes.length > 0) {
                    for (var i = 0; i < checkNodes.length; i++) {
                        if (!checkNodes[i].isParent) {
                            var obj = {
                                name: checkNodes[i].name,
                                type: checkNodes[i].type,
                                id: checkNodes[i].id,
                                treeName:treeName
                            };
                            depts.push(obj);
                        }
                    }
                }
                $scope.depts = depts;
                $scope.$apply();
                return true;
            }
        }
    };
    $scope.initUserTree = function () {

        $http({
            method: 'POST',
            url: ACTIVITI.CONFIG.baseRoot + "/assigneeChoose/userJson",
            params: {}
        }).success(function (data, status, headers, config) {
            var personId = $scope.assignment.assignee;
            if(personId != "" && personId != undefined && personId != null){
                $scope.joinPerson = personId;
            }
            jQuery.noConflict();
            jQuery.fn.zTree.init(jQuery("#userTree"), $scope.setting, data);//进行初始化树形菜单
            var zTree = jQuery.fn.zTree.getZTreeObj("userTree");
            zTree.expandAll(false);
            var treeName = "userTree";
            //对已选择的值进行反选操作
            var ids = $scope.assignment.assignee;
            var candidateUsers = $scope.assignment.candidateUsers;
            var users = [];
            for (var i = 0; i < candidateUsers.length; i++) {
                if (candidateUsers[i].value != ''&&candidateUsers[i].type == 'userTree') {
                    var n = zTree.getNodeByParam("id", candidateUsers[i].value, null);
                    if(n!= null && n!=""&& n!=undefined&&n!="null"){
                        var obj = {
                            name: n.name,
                            type: n.type,
                            id: n.id,
                            treeName:treeName
                        };
                        users.push(obj);
                        zTree.checkNode(zTree.getNodeByParam("id", candidateUsers[i].value, null), true, true, false);
                    }
                }
            }
            $scope.users = users;
        }).error(function (data, status, headers, config) {
            alert("error");
        });
        $scope.initRoleTree();
    }
    $scope.initRoleTree = function () {
        $http({
            method: 'POST',
            url:ACTIVITI.CONFIG.baseRoot + "/assigneeChoose/roleJson",
            params: {}
        }).success(function (data, status, headers, config) {
            jQuery.noConflict();
            jQuery.fn.zTree.init(jQuery("#roleTree"), $scope.settingRole, data);//进行初始化树形菜单
            var zTree = jQuery.fn.zTree.getZTreeObj("roleTree");
            zTree.expandAll(false);
            var treeName = "roleTree";
            //对已选择的值进行反选操作
            var ids = $scope.assignment.assignee;
            var candidateRoles = $scope.assignment.candidateRoles;
            var roles = [];
            if (candidateRoles != undefined){
                for (var i = 0; i < candidateRoles.length; i++) {
                    if (candidateRoles[i].value != ''&&candidateRoles[i].type == 'roleTree') {
                        var n = zTree.getNodeByParam("id", candidateRoles[i].value, null);
                        if(n!= null && n!=""&& n!=undefined&&n!="null"){
                            var obj = {
                                name: n.name,
                                type: n.type,
                                id: n.id,
                                treeName:treeName
                            };
                            roles.push(obj);
                            zTree.checkNode(zTree.getNodeByParam("id", candidateRoles[i].value, null), true, true, false);
                        }
                    }
                }
            }
            $scope.roles = roles;
        }).error(function (data, status, headers, config) {
            alert("error");
        });
       $scope.initDeptTree();
    }
    $scope.initDeptTree = function () {
        $http({
            method: 'POST',
            url: ACTIVITI.CONFIG.baseRoot + "/assigneeChoose/deptJson",
            params: {}
        }).success(function (data, status, headers, config) {
            jQuery.noConflict();
            jQuery.fn.zTree.init(jQuery("#deptTree"), $scope.settingDept, data);//进行初始化树形菜单
            var zTree = jQuery.fn.zTree.getZTreeObj("deptTree");
            zTree.expandAll(false);
            var treeName = "deptTree";

            //对已选择的值进行反选操作
            var candidateDepts = $scope.assignment.candidateDepts;
            var depts = [];
            if(candidateDepts != undefined ){
                for (var i = 0; i < candidateDepts.length; i++) {
                    if (candidateDepts[i].value != ''&&candidateDepts[i].type == 'deptTree') {
                        var n = zTree.getNodeByParam("id", candidateDepts[i].value, null);
                        if(n!= null && n!=""&& n!=undefined&&n!="null"){
                            var obj = {
                                name: n.name,
                                type: n.type,
                                id: n.id,
                                treeName:treeName
                            };
                            depts.push(obj);
                            zTree.checkNode(zTree.getNodeByParam("id", candidateDepts[i].value, null), true, true, false);
                        }
                    }
                }
            }
            $scope.depts = depts;
        }).error(function (data, status, headers, config) {
            alert("error");
        });
    }
    //初始化tree
    $scope.initUserTree();

    //用户列表删除操作
    $scope.unCheck = function (nodeId,treeName) {
        var zTree = jQuery.fn.zTree.getZTreeObj(treeName);
        zTree.checkNode(zTree.getNodeByParam("id", nodeId, null), false, true, false);
        var users;
        if(treeName == "roleTree"){
            users= $scope.roles;
        }else if(treeName == "deptTree"){
            users= $scope.depts;
        }else{
            users= $scope.users;
        }
        for (var i = 0; i < users.length; i++) {
            if(users[i].id == nodeId){
                users.splice(i,1);
            }
        }
        var userids = [];
        for(var i = 0; i < users.length; i++){
            userids[i] = users[i].id
        }
        if(treeName == "roleTree"){
            $scope.roles = users;
        }else if(treeName == "deptTree"){
            $scope.depts = users;
        }else{
            $scope.users = users;
        }
        $scope.assignment.candidateUsers = userids.join(",")
    }

    // Put json representing assignment on scope
    if ($scope.property.value !== undefined && $scope.property.value !== null
        && $scope.property.value.assignment !== undefined
        && $scope.property.value.assignment !== null) {
        $scope.assignment = $scope.property.value.assignment;
    } else {
        $scope.assignment = {};
    }

    if ($scope.assignment.candidateUsers == undefined || $scope.assignment.candidateUsers.length == 0) {
        $scope.assignment.candidateUsers = [{value: ''}];
    }
    if ($scope.assignment.candidateRoles == undefined || $scope.assignment.candidateRoles.length == 0) {
        $scope.assignment.candidateRoles = [{value: ''}];
    }
    if ($scope.assignment.candidateDepts == undefined || $scope.assignment.candidateDepts.length == 0) {
        $scope.assignment.candidateDepts = [{value: ''}];
    }

    // Click handler for + button after enum value
    var userValueIndex = 1;
    $scope.addCandidateUserValue = function (index) {
        $scope.assignment.candidateUsers.splice(index + 1, 0, {value: 'value ' + userValueIndex++});
    };

    // Click handler for - button after enum value
    $scope.removeCandidateUserValue = function (index) {
        $scope.assignment.candidateUsers.splice(index, 1);
    };

    if ($scope.assignment.candidateGroups == undefined || $scope.assignment.candidateGroups.length == 0) {
        $scope.assignment.candidateGroups = [{value: ''}];
    }

    var groupValueIndex = 1;
    $scope.addCandidateGroupValue = function (index) {
        $scope.assignment.candidateGroups.splice(index + 1, 0, {value: 'value ' + groupValueIndex++});
    };

    // Click handler for - button after enum value
    $scope.removeCandidateGroupValue = function (index) {
        $scope.assignment.candidateGroups.splice(index, 1);
    };

    var roleValueIndex = 1;
    $scope.addCandidateRoleValue = function (index) {
        $scope.assignment.candidateRoles.splice(index + 1, 0, {value: 'value ' + roleValueIndex++});
    };

    // Click handler for - button after enum value
    $scope.removeCandidateRoleValue = function (index) {
        $scope.assignment.candidateRoles.splice(index, 1);
    };

    var deptValueIndex = 1;
    $scope.addCandidateDeptValue = function (index) {
        $scope.assignment.candidateDepts.splice(index + 1, 0, {value: 'value ' + deptValueIndex++});
    };

    // Click handler for - button after enum value
    $scope.removeCandidateDeptValue = function (index) {
        $scope.assignment.candidateDepts.splice(index, 1);
    };

    $scope.save = function () {
        //获取变量
        var joinPerson = $scope.joinPerson;
        //判断是否为空，如果不为空则使用的是变量的形式。
        if(joinPerson != "" && joinPerson != undefined && joinPerson != null){
            $scope.assignment.assignee = joinPerson;
            $scope.assignment.candidateUsers = [{value: ''}];
            $scope.assignment.candidateRoles = [{value: ''}];
            $scope.assignment.candidateDepts = [{value: ''}];
            $scope.property.value = {};
            handleAssignmentInput($scope);
            $scope.property.value.assignment = $scope.assignment;
            $scope.updatePropertyInModel($scope.property);
            $scope.close();
        }else{
            var userTree = jQuery.fn.zTree.getZTreeObj("userTree");
            var userCheckNodes = userTree.getCheckedNodes(true);
            if (userCheckNodes.length > 0) {
                for (var i = 0; i < userCheckNodes.length; i++) {
                    if (!userCheckNodes[i].isParent) {
                        arrUsers[countUser] = {value: userCheckNodes[i].id ,type:"userTree"} ;
                        countUser++;
                    }
                }
            }
            var roleTree = jQuery.fn.zTree.getZTreeObj("roleTree");
            var roleCheckNodes = roleTree.getCheckedNodes(true);
            if (roleCheckNodes.length > 0) {
                for (var i = 0; i < roleCheckNodes.length; i++) {
                    if (!roleCheckNodes[i].isParent) {
                        arrRoles[countRole] = {value: roleCheckNodes[i].id,type:"roleTree"} ;
                        countRole++;
                    }
                }
            }
            //var joinPerson =jQuery("#joinPerson").val();

            var deptTree = jQuery.fn.zTree.getZTreeObj("deptTree");
            var deptCheckNodes = deptTree.getCheckedNodes(true);
            if (deptCheckNodes.length > 0) {
                for (var i = 0; i < deptCheckNodes.length; i++) {
                    if (!deptCheckNodes[i].isParent) {``
                        arrDepts[countDept] = {value: deptCheckNodes[i].id ,type:"deptTree"} ;
                        countDept++;
                    }
                }
            }
            $scope.assignment.assignee = "";
            $scope.assignment.candidateUsers = arrUsers;
            $scope.assignment.candidateRoles = arrRoles;
            $scope.assignment.candidateDepts = arrDepts;
            $scope.property.value = {};
            handleAssignmentInput($scope);
            $scope.property.value.assignment = $scope.assignment;
            $scope.updatePropertyInModel($scope.property);
            $scope.close();
        }

    };

    // Close button handler
    $scope.close = function () {
        handleAssignmentInput($scope);
        $scope.property.mode = 'read';
        $scope.$hide();
    };

    var handleAssignmentInput = function ($scope) {
        if ($scope.assignment.candidateUsers) {
            var emptyUsers = true;
            var toRemoveIndexes = [];
            for (var i = 0; i < $scope.assignment.candidateUsers.length; i++) {
                if ($scope.assignment.candidateUsers[i].value != '') {
                    emptyUsers = false;
                }
                else {
                    toRemoveIndexes[toRemoveIndexes.length] = i;
                }
            }

            for (var i = 0; i < toRemoveIndexes.length; i++) {
                $scope.assignment.candidateUsers.splice(toRemoveIndexes[i], 1);
            }

            if (emptyUsers) {
                $scope.assignment.candidateUsers = undefined;
            }
        }

        if ($scope.assignment.candidateGroups) {
            var emptyGroups = true;
            var toRemoveIndexes = [];
            for (var i = 0; i < $scope.assignment.candidateGroups.length; i++) {
                if ($scope.assignment.candidateGroups[i].value != '') {
                    emptyGroups = false;
                }
                else {
                    toRemoveIndexes[toRemoveIndexes.length] = i;
                }
            }

            for (var i = 0; i < toRemoveIndexes.length; i++) {
                $scope.assignment.candidateGroups.splice(toRemoveIndexes[i], 1);
            }

            if (emptyGroups) {
                $scope.assignment.candidateGroups = undefined;
            }
        }
        if ($scope.assignment.candidateRoles) {
            var emptyRoles = true;
            var toRemoveIndexes = [];
            for (var i = 0; i < $scope.assignment.candidateRoles.length; i++) {
                if ($scope.assignment.candidateRoles[i].value != '') {
                    emptyRoles = false;
                }
                else {
                    toRemoveIndexes[toRemoveIndexes.length] = i;
                }
            }

            for (var i = 0; i < toRemoveIndexes.length; i++) {
                $scope.assignment.candidateRoles.splice(toRemoveIndexes[i], 1);
            }

            if (emptyRoles) {
                $scope.assignment.candidateRoles = undefined;
            }
        }
        if ($scope.assignment.candidateDepts) {
            var emptyDepts = true;
            var toRemoveIndexes = [];
            for (var i = 0; i < $scope.assignment.candidateDepts.length; i++) {
                if ($scope.assignment.candidateDepts[i].value != '') {
                    emptyDepts = false;
                }
                else {
                    toRemoveIndexes[toRemoveIndexes.length] = i;
                }
            }

            for (var i = 0; i < toRemoveIndexes.length; i++) {
                $scope.assignment.candidateDepts.splice(toRemoveIndexes[i], 1);
            }

            if (emptyDepts) {
                $scope.assignment.candidateDepts = undefined;
            }
        }
    };
}];
function wtConfigInfo($scope, $http) {
    //接受子控制器发送的消息
    // $scope.$on("menu",function(event,params){
    //     $http.get("/leave/userJson").success(function(data){
    //         //发送消息给子控制器
    //         $scope.$broadcast("menuData",data);
    //     });
    // });
}function wtConfigInfo1($scope, $http) {
    //接受子控制器发送的消息
    // $scope.$on("menu",function(event,params){
    //     $http.get("/leave/userJson").success(function(data){
    //         //发送消息给子控制器
    //         $scope.$broadcast("menuData",data);
    //     });
    // });
}function wtConfigInfo2($scope, $http) {
    $scope.joinPerson;
    //接受子控制器发送的消息
    // $scope.$on("menu",function(event,params){
    //     $http.get("/leave/userJson").success(function(data){
    //         //发送消息给子控制器
    //         $scope.$broadcast("menuData",data);
    //     });
    // });
}

