/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.taskmonitor.controller;

import com.jxdinfo.hussar.bpm.taskmonitor.service.TaskMonitorService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/taskMonitor"})
public class TaskMonitorController {
    @Autowired
    private TaskMonitorService taskMonitorService;

    @RequestMapping(value={"/processRunning"})
    @RequiresPermissions(value={"taskMonitor:processRunning"})
    @BussinessLog(key="/taskMonitor/processRunning", type="04", value="\u529e\u7406\u4e2d\u4efb\u52a1\u9875\u9762")
    public ModelAndView processRunning() {
        ModelAndView mv = new ModelAndView("/bpm/taskmonitor/processRunning.html");
        return mv;
    }

    @RequestMapping(value={"/processFinished"})
    @RequiresPermissions(value={"taskMonitor:processFinished"})
    @BussinessLog(key="/taskMonitor/processFinished", type="04", value="\u5df2\u5b8c\u6210\u4efb\u52a1\u9875\u9762")
    public ModelAndView processFinished() {
        ModelAndView mv = new ModelAndView("/bpm/taskmonitor/processFinished.html");
        return mv;
    }

    @RequestMapping(value={"/queryProcessRunning"})
    public Map<String, Object> queryProcessRunning(@RequestParam(required=false) String processDefinitionName, @RequestParam(required=false) Integer page, @RequestParam(required=false) Integer limit) {
        try {
            processDefinitionName = URLDecoder.decode(URLDecoder.decode(processDefinitionName, "UTF-8"), "UTF-8");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("processDefinitionName", processDefinitionName);
            map.put("page", page);
            map.put("limit", limit);
            Map<String, Object> result = this.taskMonitorService.queryProcessRunning(map);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @RequestMapping(value={"/queryProcessFinished"})
    public Map<String, Object> queryProcessFinished(@RequestParam(required=false) String processDefinitionName, @RequestParam(required=false) Integer page, @RequestParam(required=false) Integer limit) {
        try {
            processDefinitionName = URLDecoder.decode(URLDecoder.decode(processDefinitionName, "UTF-8"), "UTF-8");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("processDefinitionName", processDefinitionName);
            map.put("page", page);
            map.put("limit", limit);
            Map<String, Object> result = this.taskMonitorService.queryProcessFinished(map);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

