/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.rest.util;

import com.jxdinfo.hussar.bpm.common.utils.StringUtils;
import java.util.List;
import java.util.Map;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmProcessElement;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.task.Task;

public class ParallelJumpTaskCmd
implements Command<Void> {
    protected String userId;
    protected String executionId;
    protected String parentId;
    protected ActivityImpl desActivity;
    protected Map<String, Object> paramvar;
    protected ActivityImpl currentActivity;

    public Void execute(CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
        ExecutionEntity executionEntity = executionEntityManager.findExecutionById(this.executionId);
        String id = null;
        if (executionEntity.getParent() != null) {
            if ((executionEntity = executionEntity.getParent()).getParent() != null) {
                executionEntity = executionEntity.getParent();
                id = executionEntity.getId();
            } else {
                id = executionEntity.getId();
            }
        }
        executionEntity.setVariables(this.paramvar);
        executionEntity.setEventSource((PvmProcessElement)this.currentActivity);
        executionEntity.setActivity(this.currentActivity);
        for (TaskEntity taskEntity : Context.getCommandContext().getTaskEntityManager().findTasksByExecutionId(this.executionId)) {
            taskEntity.fireEvent("complete");
            Context.getCommandContext().getTaskEntityManager().deleteTask(taskEntity, "ParallelJumpTaskCmd-Completed", false);
        }
        List list = executionEntityManager.findChildExecutionsByParentExecutionId(this.parentId);
        for (ExecutionEntity ee : list) {
            ee.remove();
            List tasks = ee.getTasks();
            if (tasks != null && tasks.size() > 0 && StringUtils.isNotEmpty((CharSequence)this.userId)) {
                for (Task task : tasks) {
                    task.setAssignee(this.userId);
                }
            }
            Context.getCommandContext().getHistoryManager().recordActivityEnd(ee);
        }
        executionEntity.executeActivity((PvmActivity)this.desActivity);
        return null;
    }

    public ParallelJumpTaskCmd(String userId, String executionId, String parentId, ActivityImpl desActivity, Map<String, Object> paramvar, ActivityImpl currentActivity) {
        this.userId = userId;
        this.executionId = executionId;
        this.desActivity = desActivity;
        this.paramvar = paramvar;
        this.currentActivity = currentActivity;
        this.parentId = parentId;
    }
}

