/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.rest.controller;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.bpm.rest.service.ProcessInstanceService;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProcessInstanceController {
    @Resource
    private ProcessInstanceService processInstanceService;

    @RequestMapping(value={"/startProcessInstanceByIdVariables"})
    public String startProcessInstanceById(String processDefinitionId, String userId, String businessKey, String variablesMap) {
        Map maps = (Map)JSON.parse((String)variablesMap);
        return this.processInstanceService.startProcessInstanceById(processDefinitionId, userId, businessKey, maps);
    }

    @RequestMapping(value={"/startProcessInstanceByKeyVariables"})
    public String startProcessInstanceByKey(String processDefinitionKey, String userId, String businessKey, String variablesMap) {
        Map maps = (Map)JSON.parse((String)variablesMap);
        return this.processInstanceService.startProcessInstanceByKey(processDefinitionKey, userId, businessKey, maps);
    }

    @RequestMapping(value={"/startProcessInstanceById"})
    public String startProcessInstanceById(String processDefinitionId, String userId, String businessKey) {
        return this.processInstanceService.startProcessInstanceById(processDefinitionId, userId, businessKey);
    }

    @RequestMapping(value={"/startProcessInstanceByKey"})
    public String startProcessInstanceByKey(String processDefinitionKey, String userId, String businessKey) {
        return this.processInstanceService.startProcessInstanceByKey(processDefinitionKey, userId, businessKey);
    }

    @RequestMapping(value={"/queryProcessInstanceList"})
    public String queryProcessInstanceList(int page, int rows) {
        return this.processInstanceService.queryProcessInstanceList(page, rows);
    }

    @RequestMapping(value={"/queryProcessInstanceByKey"})
    public String queryProcessInstanceByKey(String processDefinitionKey, String businessKey, int page, int rows) {
        return this.processInstanceService.queryProcessInstanceByKey(processDefinitionKey, businessKey, page, rows);
    }

    @RequestMapping(value={"/updateProcessInstanceState"})
    public String updateProcessInstanceState(String operation, String processInstanceId) {
        return this.processInstanceService.updateProcessInstanceState(operation, processInstanceId);
    }

    @RequestMapping(value={"/deleteProcessInstance"})
    public String deleteProcessInstance(String processInstanceId, String reason) {
        return this.processInstanceService.deleteProcessInstance(processInstanceId, reason);
    }

    @RequestMapping(value={"/backFlowProcessInstance"})
    public String backFlowProcessInstance(String currentTaskId, String destinationTaskId) {
        return this.processInstanceService.backFlowProcessInstance(currentTaskId, destinationTaskId);
    }

    @RequestMapping(value={"/endProcessInstance"})
    public String endProcessInstance(String taskId) {
        return this.processInstanceService.endProcessInstance(taskId);
    }

    @RequestMapping(value={"/queryFinishedProcessInstance"})
    public String queryFinishedProcessInstance(String processDefinitionId, String businessKey, int page, int rows) {
        return this.processInstanceService.queryFinishedProcessInstance(processDefinitionId, businessKey, page, rows);
    }

    @RequestMapping(value={"/queryProcessInstanceCompleteState"})
    public String queryProcessInstanceCompleteState(String processInstanceId) {
        return this.processInstanceService.queryProcessInstanceCompleteState(processInstanceId);
    }

    @RequestMapping(value={"/queryProcessInstancePicture"})
    public void queryProcessInstancePicture(String processInstanceId, HttpServletResponse response) {
        this.processInstanceService.queryProcessInstancePicture(processInstanceId, response);
    }

    @RequestMapping(value={"/getProcessTrace"})
    public String getProcessTrace(String processInstanceId) {
        return this.processInstanceService.getProcessTrace(processInstanceId);
    }

    @RequestMapping(value={"/queryProcessDefinitionByInstanceId"})
    public String queryProcessDefinitionByInstanceId(String processInstanceId) {
        return this.processInstanceService.queryProcessDefinitionByInstanceId(processInstanceId);
    }

    @RequestMapping(value={"/deleteAssigneeUsers"})
    public String deleteAssigneeUsers(String taskId, String users) {
        return this.processInstanceService.deleteAssigneeUsers(taskId, users);
    }

    @RequestMapping(value={"/addAssigneeUsers"})
    public String addAssigneeUsers(String taskId, String users) {
        return this.processInstanceService.addAssigneeUsers(taskId, users);
    }

    @RequestMapping(value={"/queryVariable"})
    public String queryVariable(String processInstId) {
        return this.processInstanceService.queryVariable(processInstId);
    }

    @RequestMapping(value={"/editVariable"})
    public String editVariable(String taskId, String map) {
        HashMap maps = (HashMap)JSON.parse((String)map);
        return this.processInstanceService.editVariable(taskId, maps);
    }
}

