/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.processimage.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"bpmMainController"})
public class BpmMainController {
    private String endNodeType = "EndNoneEvent";
    private String userTaskNodeType = "UserTask";
    private String subNodeType = "SubProcess";
    private String exclusiveNodeType = "ExclusiveGateway";
    private String startNodeType = "StartNoneEvent";
    private static String id;

    @RequestMapping(value={"/checkModelJson"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public void checkModelJson(@RequestBody MultiValueMap<String, String> values, HttpServletResponse response) throws IOException {
        JSONObject json = new JSONObject();
        StringBuffer errorMes = new StringBuffer("");
        JSONObject modelJson = JSONObject.fromObject((Object)values.getFirst((Object)"json_xml"));
        JSONArray shapes = modelJson.getJSONArray("childShapes");
        int state = 1;
        int count = 0;
        Map<String, List<String>> result = this.validateJSONArray(shapes);
        if (result.get("unconect") != null && result.get("unconect").size() > 0) {
            state = 0;
            errorMes.append("(" + ++count + ") \u5b58\u5728\u672a\u8fde\u63a5\u7684\u56fe\u5f62;\r\n");
        }
        if (result.get("repeat") != null && result.get("repeat").size() > 0) {
            state = 0;
            errorMes.append("(" + ++count + ") \u5b58\u5728\u6307\u5b9a\u8282\u70b9\u529e\u7406\u4eba\u548c\u53c2\u4e0e\u8005\u91cd\u590d\u7684\u73af\u8282\uff0c\u4ed6\u4eec\u4e3a\uff1a");
            for (int i = 0; i < result.get("repeat").size(); ++i) {
                errorMes.append(result.get("repeat").get(i));
                if (i == result.get("repeat").size() - 1) continue;
                errorMes.append(",");
            }
            errorMes.append(";\r\n");
        }
        if (result.get("unconfigure") != null && result.get("unconfigure").size() > 0) {
            state = 0;
            errorMes.append("(" + ++count + ") \u5b58\u5728\u7f51\u5173\u672a\u914d\u7f6e\u5206\u652f\u6761\u4ef6;\r\n");
        }
        if (result.get("unname") != null && result.get("unname").size() > 0) {
            state = 0;
            errorMes.append("(" + ++count + ") \u5b58\u5728\u672a\u547d\u540d\u7684\u4eba\u5de5\u73af\u8282;\r\n");
        }
        if (result.get("start") == null || result.get("start").size() != 1) {
            state = 0;
            errorMes.append("(" + ++count + ") \u4e3b\u6d41\u7a0b\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a\u8d77\u59cb\u8282\u70b9;\r\n");
        }
        if (result.get("end") == null || result.get("end").size() < 1) {
            state = 0;
            errorMes.append("(" + ++count + ") \u4e3b\u6d41\u7a0b\u5e94\u81f3\u5c11\u542b\u6709\u4e00\u4e2a\u7ed3\u675f\u8282\u70b9;\r\n");
        }
        json.put((Object)"state", (Object)state);
        if (state == 1) {
            json.put((Object)"mes", (Object)"\u6d41\u7a0b\u6821\u9a8c\u901a\u8fc7");
        } else if (state == 0) {
            json.put((Object)"mes", (Object)errorMes.toString());
        }
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        response.getWriter().write(json.toString());
        response.flushBuffer();
    }

    public Map<String, List<String>> validateJSONArray(JSONArray arr) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        ArrayList<String> unConnectedShapes = new ArrayList<String>();
        ArrayList<String> unAssignedShapes = new ArrayList<String>();
        ArrayList<String> unConfiguredConditionShapes = new ArrayList<String>();
        ArrayList<String> unNamedShapses = new ArrayList<String>();
        ArrayList<String> startNodeShapes = new ArrayList<String>();
        ArrayList<String> repeatShapes = new ArrayList<String>();
        ArrayList<String> endNodeShapes = new ArrayList<String>();
        if (arr != null && arr.size() > 0) {
            for (int i = 0; i < arr.size(); ++i) {
                JSONObject shape = arr.getJSONObject(i);
                String resourceId = shape.getString("resourceId");
                JSONObject stencil = shape.getJSONObject("stencil");
                JSONObject properties = shape.getJSONObject("properties");
                String shapeType = stencil.getString("id");
                JSONArray nextShapes = shape.getJSONArray("outgoing");
                if (!(nextShapes != null && nextShapes.size() >= 1 || this.endNodeType.equals(shapeType))) {
                    unConnectedShapes.add(resourceId);
                    map.put("unconect", unConnectedShapes);
                }
                if (this.userTaskNodeType.equals(shapeType)) {
                    Object partner = properties.get("usertaskassignment");
                    String assignmentnode = properties.getString("assignmentnode");
                    String nodeName = properties.getString("name");
                    if (nodeName == null || "".equals(nodeName)) {
                        unNamedShapses.add(resourceId);
                    }
                    if (partner == null || "".equals(partner)) {
                        unAssignedShapes.add(nodeName);
                    }
                    if (!"".equals(partner) && !"".equals(assignmentnode)) {
                        repeatShapes.add(nodeName);
                    }
                    map.put("unname", unNamedShapses);
                    map.put("unassign", unAssignedShapes);
                    map.put("repeat", repeatShapes);
                    continue;
                }
                if (this.exclusiveNodeType.equals(shapeType)) {
                    JSONArray outGoings = shape.getJSONArray("outgoing");
                    if (outGoings != null && outGoings.size() > 1) {
                        for (int j = 0; j < outGoings.size(); ++j) {
                            JSONObject outGoing = outGoings.getJSONObject(j);
                            String val = outGoing.getString("resourceId");
                            JSONObject findResult = this.findJSONObject(arr, "resourceId", val);
                            String condition = findResult.getJSONObject("properties").getString("conditionsequenceflow");
                            if (!"".equals(condition)) continue;
                            unConfiguredConditionShapes.add(resourceId);
                        }
                    }
                    map.put("unconfigure", unConfiguredConditionShapes);
                    continue;
                }
                if (this.startNodeType.equals(shapeType)) {
                    startNodeShapes.add(resourceId);
                    map.put("start", startNodeShapes);
                    continue;
                }
                if (this.endNodeType.equals(shapeType)) {
                    endNodeShapes.add(resourceId);
                    map.put("end", endNodeShapes);
                    continue;
                }
                if (!this.subNodeType.equals(shapeType)) continue;
                JSONArray subChilds = shape.getJSONArray("childShapes");
                Map<String, List<String>> subMap = this.validateJSONArray(subChilds);
                List<Object> unConnectSub = subMap.get("unconect") == null ? new ArrayList() : subMap.get("unconect");
                List<Object> unNameSub = subMap.get("unname") == null ? new ArrayList() : subMap.get("unname");
                List<Object> unAssignSub = subMap.get("unassign") == null ? new ArrayList() : subMap.get("unassign");
                List<Object> unConfigureSub = subMap.get("unconfigure") == null ? new ArrayList() : subMap.get("unconfigure");
                unConnectedShapes.addAll(unConnectSub);
                unAssignedShapes.addAll(unAssignSub);
                unConfiguredConditionShapes.addAll(unConfigureSub);
                unNamedShapses.addAll(unNameSub);
                map.put("unconect", unConnectedShapes);
                map.put("unassign", unAssignedShapes);
                map.put("unconfigure", unConfiguredConditionShapes);
                map.put("unname", unNamedShapses);
            }
        }
        return map;
    }

    public JSONObject findJSONObject(JSONArray arr, String key, String value) {
        JSONObject returnJson = new JSONObject();
        if (arr != null && arr.size() > 0) {
            for (int i = 0; i < arr.size(); ++i) {
                JSONObject json = arr.getJSONObject(i);
                String val = json.getString(key);
                if (!val.equals(value)) continue;
                returnJson.putAll((Map)json);
                break;
            }
        }
        return returnJson;
    }
}

