/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.model.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.bpm.common.utils.StringUtils;
import com.jxdinfo.hussar.bpm.model.model.ModelBuild;
import com.jxdinfo.hussar.bpm.model.service.IModelService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.editor.language.json.converter.BpmnJsonConverter;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ModelQuery;
import org.activiti.explorer.util.XmlUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ModelServiceImpl
implements IModelService {
    @Autowired
    private RepositoryService repositoryService;

    @Override
    public HashMap<String, Object> ModelQuery(String name, String pageSize, String pageIndex) {
        List list = ((ModelQuery)this.repositoryService.createModelQuery().modelNameLike("%" + name + "%").orderByLastUpdateTime().desc()).listPage(Integer.parseInt(pageIndex) * Integer.parseInt(pageSize), Integer.parseInt(pageSize));
        long rows = ((ModelQuery)this.repositoryService.createModelQuery().modelNameLike("%" + name + "%").orderByLastUpdateTime().desc()).count();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<ModelBuild> myList = new ArrayList<ModelBuild>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                ModelBuild modelBuild = new ModelBuild();
                modelBuild.setModelId(((Model)list.get(i)).getId());
                modelBuild.setName(((Model)list.get(i)).getName());
                modelBuild.setDescription(((Model)list.get(i)).getMetaInfo());
                modelBuild.setCreatTime(sdf.format(((Model)list.get(i)).getCreateTime()));
                modelBuild.setLastEditTime(sdf.format(((Model)list.get(i)).getLastUpdateTime()));
                myList.add(i, modelBuild);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("total", rows);
        map.put("data", myList);
        return map;
    }

    @Override
    public String deleteModel(String modelId) {
        this.repositoryService.deleteModel(modelId);
        return "delete";
    }

    @Override
    public String ModelCreat(String name, String key, String description) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            ObjectNode editorNode = objectMapper.createObjectNode();
            editorNode.put("id", "canvas");
            editorNode.put("resourceId", "canvas");
            ObjectNode stencilSetNode = objectMapper.createObjectNode();
            stencilSetNode.put("namespace", "http://b3mn.org/stencilset/bpmn2.0#");
            editorNode.put("stencilset", (JsonNode)stencilSetNode);
            Model modelData = this.repositoryService.newModel();
            ObjectNode modelObjectNode = objectMapper.createObjectNode();
            modelObjectNode.put("name", name);
            modelObjectNode.put("revision", 1);
            description = StringUtils.defaultString((String)description);
            modelObjectNode.put("description", description);
            modelData.setMetaInfo(modelObjectNode.toString());
            modelData.setName(name);
            modelData.setKey(StringUtils.defaultString((String)key));
            this.repositoryService.saveModel(modelData);
            this.repositoryService.addModelEditorSource(modelData.getId(), editorNode.toString().getBytes("utf-8"));
            return modelData.getId();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String ModelDeploy(String modelName, String uid) {
        try {
            Model modelData = this.repositoryService.getModel(uid);
            ObjectNode modelNode = (ObjectNode)new ObjectMapper().readTree(this.repositoryService.getModelEditorSource(modelData.getId()));
            byte[] bpmnBytes = null;
            BpmnModel model = new BpmnJsonConverter().convertToBpmnModel((JsonNode)modelNode);
            bpmnBytes = new BpmnXMLConverter().convertToXML(model);
            this.repositoryService.createDeployment().name(modelName).addString(modelName + ".bpmn20.xml", new String(bpmnBytes, "UTF-8")).deploy();
            return "deploy";
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String ModelImport(String modelName, String key, String description, String deploy, MultipartFile file) {
        try {
            XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
            InputStreamReader in = new InputStreamReader((InputStream)new ByteArrayInputStream(file.getBytes()), "UTF-8");
            XMLStreamReader xtr = xif.createXMLStreamReader(in);
            BpmnModel bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
            Model modelData = this.repositoryService.newModel();
            ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
            modelObjectNode.put("name", modelName);
            modelObjectNode.put("revision", 1);
            description = StringUtils.defaultString((String)description);
            modelObjectNode.put("description", description);
            modelData.setMetaInfo(modelObjectNode.toString());
            modelData.setName(modelName);
            modelData.setKey(StringUtils.defaultString((String)key));
            this.repositoryService.saveModel(modelData);
            BpmnJsonConverter jsonConverter = new BpmnJsonConverter();
            ObjectNode editorNode = jsonConverter.convertToJson(bpmnModel);
            this.repositoryService.addModelEditorSource(modelData.getId(), editorNode.toString().getBytes("utf-8"));
            if ("1".equals(deploy)) {
                this.repositoryService.createDeployment().name(modelName).addString(modelName + ".bpmn20.xml", new String(file.getBytes(), "UTF-8")).deploy();
            }
            return "import";
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        return null;
    }
}

