var ProcessPicInfo={};
layui.use(['jquery','Hussar','HussarAjax'], function(){
    var Hussar = layui.Hussar;
    var $ = layui.jquery;
    var $ax=layui.HussarAjax;

    var flowImageAndRect = $('#flowImageAndRect');
    flowImageAndRect.empty();
    // 加载流程图片
    loadProcessImage(definitionId);
    //加载各节点信息
    setTimeout(function(){
       loadProcessTrace(definitionId);
    },200);

    /**
     * 加载图片
     */
    function loadProcessImage(id){
        var imageUrl = Hussar.ctxPath+"/queryProcessInstancePicture?processInstanceId="+encodeURI(encodeURI(id))+"";
        // 加载图片
        $('<img />',{
            "src" : imageUrl,
            "alt" : '',
            "class":"imgLeft",
        }).appendTo($('#flowImageAndRect'));
    }
    /**
     * 加载流程中各节点的信息
     * @param id : 流程定义的id
     */
    function loadProcessTrace(instanceId) {
        var traceUrl = Hussar.ctxPath+"/processInst/getLocalProcessTrace?processInstanceId="+instanceId+"";
        var html = "";
        $.ajax({
            type: "get",
            url: traceUrl,
            traditional: true,
            success: function (infos) {
                $.each(infos, function (i, v) {
                    // 矩形的div
                    var $div = $('<div/>', {
                        'class': 'activity-attr',
                        'onmouseover' : 'ProcessPicInfo.over("'+v.actId+'")',
                        'onmouseout' : 'ProcessPicInfo.out("'+v.actId+'")',
                    }).css({
                        position: 'absolute',
                        left: v.x,
                        top: v.y,
                        width: v.width,
                        height: v.height,
                        opacity: 0,
                        zIndex: 100,
                    }).attr({'actId': v.actId, 'name': v.name});
                    html += $div.prop("outerHTML");
                });

                $.each(infos, function (i, v) {
                    // 矩形的div
                    var userInfo= v.userInfo;
                    var timeInfo=v.timeInfo;
                    var commentInfo=v.commentInfo;
                    var info="";
                    debugger;
                    for(var key in userInfo) {
                        var userName=userInfo[key];
                        if(userInfo[key]==null||userInfo[key]==undefined||userInfo[key]=="null"){
                            userName="";
                        }
                        info=info+'<tr>\n' +
                            '<td style="width: 80px;border-right: 1px solid #ddd;border-bottom: 1px solid #ddd" ><span >'+ userName+'</span></td>\n' +
                            '<td style="width: 120px;border-right: 1px solid #ddd;border-bottom: 1px solid #ddd"><span ">'+ new Date(parseInt(timeInfo[key])).format("yyyy-MM-dd hh:mm:ss")+'</span></td>\n' +
                            '<td style="width: 250px;text-align: left;border-bottom: 1px solid #ddd" ><span ">'+ commentInfo[key]+'</span></td>\n' +
                            '</tr>'
                    }
                    var $div = $('<div id="'+v.actId+'" class="hideDiv"><table class="activityTable">\n' +
                        '    <tbody>\n'
                        +'<tr>\n' +
                        '    <td style="width: 80px;border-right: 1px solid #ddd;border-bottom: 1px solid #ddd"><span>处理人</span></td>\n' +
                        '    <td style="width: 120px;border-right: 1px solid #ddd;border-bottom: 1px solid #ddd"><span>处理时间</span></td>\n' +
                        '    <td style="width: 250px;border-bottom: 1px solid #ddd"><span>处理意见</span></td>\n' +
                        '</tr>\n'
                        + info+
                        '    </tbody>\n' +
                        '</table></div>', {
                        'class': ''
                    }).css({
                        position: 'absolute',
                        left: v.x+v.width+3,
                        top: v.y,
                        width: 450,
                        height: v.height ,
                        opacity: 999,
                        zIndex: 10000000,
                    }).attr({'actId': v.actId, 'name': v.name});
                    html += $div.prop("outerHTML");
                });
                $('<div />', {'id': 'processRect'}).html(html).appendTo($('#flowImageAndRect'));
            }
        })
    }
    /*鼠标悬停*/
    ProcessPicInfo.over=function(id){
        $('#'+id).show();
    }
    /*鼠标移出*/
    ProcessPicInfo.out=function(id){
        $('#'+id).hide();
    }
    Date.prototype.format = function(fmt) {
        var o = {
            "M+" : this.getMonth()+1,                 //月份
            "d+" : this.getDate(),                    //日
            "h+" : this.getHours(),                   //小时
            "m+" : this.getMinutes(),                 //分
            "s+" : this.getSeconds(),                 //秒
            "q+" : Math.floor((this.getMonth()+3)/3), //季度
            "S"  : this.getMilliseconds()             //毫秒
        };
        if(/(y+)/.test(fmt)) {
            fmt=fmt.replace(RegExp.$1, (this.getFullYear()+"").substr(4 - RegExp.$1.length));
        }
        for(var k in o) {
            if(new RegExp("("+ k +")").test(fmt)){
                fmt = fmt.replace(RegExp.$1, (RegExp.$1.length==1) ? (o[k]) : (("00"+ o[k]).substr((""+ o[k]).length)));
            }
        }
        return fmt;
    }
});
