/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.taskmonitor.service.impl;

import com.jxdinfo.hussar.bpm.taskmonitor.service.TaskMonitorService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskMonitorServiceImpl
implements TaskMonitorService {
    @Autowired
    private TaskService taskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RepositoryService repositoryService;

    @Override
    public Map<String, Object> queryProcessRunning(HashMap map) {
        String definitionName = map.get("processDefinitionName") == null ? "" : map.get("processDefinitionName").toString();
        Integer page = Integer.parseInt(map.get("page").toString());
        Integer limit = Integer.parseInt(map.get("limit").toString());
        List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processDefinitionNameLike("%" + definitionName + "%")).orderByTaskCreateTime()).desc()).listPage((page - 1) * limit, limit.intValue());
        long count = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionNameLike("%" + definitionName + "%")).count();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("msg", "success");
        dataMap.put("data", this.tasksToMap(tasks));
        dataMap.put("count", count);
        dataMap.put("code", 0);
        return dataMap;
    }

    @Override
    public Map<String, Object> queryProcessFinished(HashMap map) {
        String definitionName = map.get("processDefinitionName") == null ? "" : map.get("processDefinitionName").toString();
        Integer page = Integer.parseInt(map.get("page").toString());
        Integer limit = Integer.parseInt(map.get("limit").toString());
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processDefinitionNameLike("%" + definitionName + "%")).finished().orderByHistoricTaskInstanceEndTime().desc()).listPage((page - 1) * limit, limit.intValue());
        long count = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processDefinitionNameLike("%" + definitionName + "%")).finished().count();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("msg", "success");
        dataMap.put("data", this.hisTasksToMap(hisTaskList));
        dataMap.put("count", count);
        dataMap.put("code", 0);
        return dataMap;
    }

    public List<Map<String, Object>> hisTasksToMap(List<HistoricTaskInstance> hs) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < hs.size(); ++i) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("taskId", hs.get(i).getId());
            map.put("name", hs.get(i).getName());
            map.put("assignee", hs.get(i).getAssignee());
            map.put("processDefinitionId", hs.get(i).getProcessDefinitionId());
            map.put("definitionKey", hs.get(i).getTaskDefinitionKey());
            map.put("processInstanceId", hs.get(i).getProcessInstanceId());
            map.put("claimTime", hs.get(i).getClaimTime());
            map.put("startTime", hs.get(i).getStartTime());
            map.put("endTime", hs.get(i).getEndTime());
            ProcessDefinition ProcessDefinition2 = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(hs.get(i).getProcessDefinitionId()).singleResult();
            map.put("processDefinitionName", ProcessDefinition2.getName());
            list.add(map);
        }
        return list;
    }

    public List<Map<String, Object>> tasksToMap(List<Task> tasks) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < tasks.size(); ++i) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("taskId", tasks.get(i).getId());
            map.put("name", tasks.get(i).getName());
            map.put("assignee", tasks.get(i).getAssignee());
            map.put("processDefinitionId", tasks.get(i).getProcessDefinitionId());
            map.put("definitionKey", tasks.get(i).getTaskDefinitionKey());
            map.put("processInstanceId", tasks.get(i).getProcessInstanceId());
            map.put("createTime", tasks.get(i).getCreateTime());
            map.put("processVariables", tasks.get(i).getProcessVariables());
            ProcessDefinition ProcessDefinition2 = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(tasks.get(i).getProcessDefinitionId()).singleResult();
            map.put("processDefinitionName", ProcessDefinition2.getName());
            list.add(map);
        }
        return list;
    }
}

