// 初始化页面
layui.use(['jquery', 'layer', 'Hussar', 'jstree', 'HussarAjax', 'table','HussarBpm'], function () {
    var Hussar = layui.Hussar;
    var $ = layui.jquery;
    var $ax = layui.HussarAjax;
    var table = layui.table;
    var allId = [];
    var info = [];

    $(function(){
        chart();
    });

    function chart() {
        $.ajax({
            type: "post",
            url: Hussar.ctxPath + "/processCount/getAllTackCout",
            success: function (data) {
                if (data.length > 0) {
                    var nameData = [];
                    var numData = [];
                    var keyData = [];
                    for (var i = 0; i < data.length; i++) {
                        nameData.push(data[i].PROCESSNAME)
                        numData.push(data[i].COUNTNUM)
                        var obj = {};
                        obj.value = data[i].COUNTNUM;
                        obj.id = data[i].PROCESSKEY;
                        keyData.push(obj);
                    }
                    var allTask = echarts.init(document.getElementById('allTask'));
                    var allTaskOption = {
                        tooltip: {
                            trigger: 'axis',
                            formatter: "{b} : {c} "
                        },
                        calculable: false,
                        xAxis: [
                            {
                                data: nameData
                            }
                        ],
                        yAxis: [
                            {
                                type: 'value',
                                min: 0,
                                minInterval: 1
                            }
                        ],
                        series: [
                            {
                                type: 'bar',
                                data: keyData
                            }]
                    };
                    allTask.setOption(allTaskOption);
                    //监听点击事件
                    allTask.on('click', function (params) {
                        var key = params.data.id;
                        // 节点信息
                        $.ajax({
                            type: "post",
                            url: Hussar.ctxPath + "/processCount/loadNodeCount",
                            data : {definitionKey:key},
                            success: function (data) {
                                for (var i = 0;i < data.length;i++){
                                    allId[data[i].actId] = data[i].num;
                                }
                                $(".tableBox").hide();
                                // 加载流程图片
                                loadProcessImage(key);
                            }
                        });
                    })
                }
            }
        });
    }

    function loadProcessImage(key) {
        layui.use(['jquery', 'Hussar', 'HussarAjax'], function () {
            var Hussar = layui.Hussar;
            var $ = layui.jquery;
            var $ax = layui.HussarAjax;
            $(function () {
                //1.获取canvas元素
                var cnv = document.getElementById("canvas");
                cnv.width = $(window).width() - 50;
                cnv.height = $(window).height() - 50;
                //获取上下文环境对象
                var cxt = cnv.getContext("2d");
                var canvasDiv= document.getElementById("canvasDiv");
                createImg(cxt);

                function createImg(cxt) {
                    $.ajax({
                        type: "POST",
                        url: Hussar.ctxPath+"/processDiagram/getProcessInfoByDefKey",
                        dataType: "json",
                        data: {
                            processDefinitonKey: key
                        },
                        success: function (data) {
                            info = data;
                            window.tools.createImg(cnv,data,allId);
                        }
                    });
                }
                cnv.addEventListener("click",function () {
                    mouseclick(window.tools.get_canvasMouse(event,cnv),info)
                });

            });
        });

    }
    var flag = 0;
    function mouseclick(mouse,data) {
        var sub_top = $("#canvas").css("marginTop").replace('px', '');
        var sub_Left = $("#canvas").css("marginLeft").replace('px', '');
        for(var i = 0;i< data.length;i++){
            var item = data[i];
            if(mouse.x> item.x &&  mouse.x<(item.x + item.width ) && mouse.y> item.y && mouse.y <(item.y + item.height + 10)){
                flag = 1;
                var inner="";
                if(item.state != "sequenceFlow"){
                    $(".tableBox").show();
                    nodeTaskList(data[i].id)
                }
                $(".pop-win").html(inner).css({"top":(item.y + item.height)*1 + 20 + parseInt(sub_top),"left": item.x *1 + parseInt(sub_Left) + (item.width*1 - 236 )/2}).show()
            }else {
                flag = 0;
            }
        }
        if(flag===0){
            $(".pop-win").hide()
        }
    }

    function nodeTaskList(key) {
        table.render({
            elem: '#nodetask',
            url: Hussar.ctxPath + "/processCount/nodeTaskList",
            cols: [[
                {type: 'numbers', title: '序号'},
                {field: 'processName', title: '流程定义名称', align: 'center'},
                {field: 'nodeName', title: '节点名称', align: 'center'},
                {field: 'taskId', title: '任务ID', align: 'center'},
                {field: 'businessKey', title: '业务ID', align: 'center'},
                {field: 'userName', title: '任务接收人', align: 'center'},
                {
                    field: 'createTime', title: '任务开始时间', align: 'center', templet: function (params) {
                        if (params.createTime == null || params.createTime === "") {
                            return "";
                        } else {
                            return new Date(params.createTime).format("yyyy-MM-dd hh:mm:ss");
                        }
                    }
                }
            ]],
            where: {
                definitionKey: key,
                userId: $('#userId').val()
            }
            , page: true
            , height: $("body").height() - $(".toolbar").outerHeight(true) - 170
            , loading: true
            , text: {
                none: '暂无相关数据' //默认：无数据。注：该属性为 layui 2.2.5 开始新增
            }
            , even: true
        });
    }

    Date.prototype.format = function (fmt) {
        var o = {
            "M+": this.getMonth() + 1,                 //月份
            "d+": this.getDate(),                    //日
            "h+": this.getHours(),                   //小时
            "m+": this.getMinutes(),                 //分
            "s+": this.getSeconds(),                 //秒
            "q+": Math.floor((this.getMonth() + 3) / 3), //季度
            "S": this.getMilliseconds()             //毫秒
        };
        if (/(y+)/.test(fmt)) {
            fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
        }
        for (var k in o) {
            if (new RegExp("(" + k + ")").test(fmt)) {
                fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
            }
        }
        return fmt;
    }
});
