/**
 * Created by xb on 2018/4/3.
 */
var ProcessRun = {};
layui.use(['jquery','layer','Hussar','jstree','HussarAjax','table'], function(){
	var Hussar = layui.Hussar;
	var $ = layui.jquery;
	var layer=layui.layer;
	var $ax=layui.HussarAjax;
	var table = layui.table;
            table.render({
                elem: '#processDefinitionTable',
                url: Hussar.ctxPath+"/taskMonitor/queryProcessRunning",
                cols: [[
                    {type:'checkbox'},
                    {type:'numbers', title: '序号'},
                    {field: 'name', title: '任务名称', align:'center',},
                    {field: 'taskId', title: '任务编码', align:'center',event: 'openPic', style:'cursor: pointer;color:#00a4ff'},
                    //{field: 'processInstanceId', title: '流程实例编码', align:'center',event: 'openPic', style:'cursor: pointer;color:#2dcab7'},
                    {field: 'processDefinitionName', title: '流程定义名称', align:'center'},
                    //{field: 'processDefinitionId', title: '流程定义编码', align:'center'},
                    {field: 'createTime', title: '任务开始时间', align:'center',templet:function (params) {
                        if (params.createTime == null || params.createTime== "") {
                            return "";
                        } else {
                            var jsonDate = new Date(parseInt(params.createTime)).format("yyyy-MM-dd hh:mm:ss");
                            return jsonDate;
                        }}
                    }
                ]],
                where: {
                    processDefinitionName: encodeURI(encodeURI($('#processDefinitionName').val())),
                }
                ,page: true
                ,height:$("body").height() - $(".toolbar").outerHeight(true) -70
                ,loading:true
                ,text: {
                    none: '暂无相关数据' //默认：无数据。注：该属性为 layui 2.2.5 开始新增
                }
                ,even: true
            });
            table.on('tool(clickEvent)', function(obj){
                var data = obj.data;
                if(obj.event === 'openPic'){
                    layui.use('layer', function(){
                        var layer = layui.layer;
                        layer.open({
                            type: 1,
                            maxmin : true,
                            title:"流程实例图",
                            content: $('#picWindow'), //这里content是一个DOM，注意：最好该元素要存放在body最外层，否则可能被其它的相对元素所影响
                            area: ["866px", "400px"],
                            success: function(){
                            },
                            end: function () {
                                $('#picWindow').hide();
                            }
                        });
                    });
                    var flowImageAndRect = $('#flowImageAndRect');
                    flowImageAndRect.empty();
                    // 加载流程图片
                    loadProcessImage(data.processInstanceId);
                    setTimeout(function(){
                        loadProcessTrace(data.processInstanceId);
                    },200);
                }
            });
            /*查询*/
            $("#search").click(function searcha() {
                reloadTable();
            });

            /*删除*/
            $("#deleteBtn").click(function(){
                var ids = [];
                var table = layui.table;
                var checkStatus = table.checkStatus("processDefinitionTable");
                var data = checkStatus.data;
                for(var i=0;i<data.length;i++){    //循环筛选出id
                    ids.push(data[i].deploymentId);
                }
                if(data.length == 0){
                    Hussar.info("请选择要删除的记录");
                }else{
                    layer.confirm('确认删除吗?', {icon: 3, title:'提示'}, function(index){
                        var eId = ids.join(',');
                        $.ajax({
                            type: "post",
                            url: Hussar.ctxPath+"/ProcessDefinitionsController/deleteData?deploymentId="+eId+"",
                            success: function(data){
                                if(data == "success"){
                                    reloadTable();
                                    Hussar.success("删除成功");
                                }else{
                                    Hussar.error("删除失败");
                                }
                            },
                            error: function () {
                                Hussar.error("删除失败");
                            }
                        });
                        layer.close(index);
                    });
                }
            });


            /*重置*/
            $("#reset").click(function () {
                //流程定义名称
                $('#processDefinitionName').val('');
                //重新加载表格
                reloadTable();
            });

            /**
             * 加载图片
             */
            function loadProcessImage(id){
                var imageUrl = Hussar.ctxPath+"/queryProcessInstancePicture?processInstanceId="+id+"";
                // 加载图片
                $('<img />',{
                    "src" : imageUrl,
                    "alt" : '',
                    "class":"imgLeft",
                }).appendTo($('#flowImageAndRect'));
            }
            /**
             * 加载流程中各节点的信息
             * @param id : 流程定义的id
             */
            function loadProcessTrace(instanceId) {
                var traceUrl = Hussar.ctxPath+"/processInst/getLocalProcessTrace?processInstanceId="+instanceId+"";
                var html = "";
                $.ajax({
                    type: "get",
                    url: traceUrl,
                    traditional: true,
                    success: function (infos) {
                        $.each(infos, function (i, v) {
                            // 矩形的div
                            var $div = $('<div/>', {
                                'class': 'activity-attr',
                                'onmouseover' : 'ProcessRun.over("'+v.actId+'")',
                                'onmouseout' : 'ProcessRun.out("'+v.actId+'")',
                            }).css({
                                position: 'absolute',
                                left: v.x,
                                top: v.y,
                                width: v.width,
                                height: v.height,
                                opacity: 0,
                                zIndex: 100,
                            }).attr({'actId': v.actId, 'name': v.name});
                            html += $div.prop("outerHTML");
                        });

                        $.each(infos, function (i, v) {
                            // 矩形的div
                            var userInfo= v.userInfo;
                            var timeInfo=v.timeInfo;
                            var info="";
                            for(var key in userInfo) {
                                var userName=userInfo[key];
                                if(userInfo[key]==null||userInfo[key]==undefined||userInfo[key]=="null"){
                                    userName="";
                                }
                                info=info+'<tr>\n' +
                                    '    <td ><span id="numZJ">'+userName+'</span></td>\n' +
                                    '    <td ><span id="numZJ">'+new Date(parseInt(timeInfo[key])).format("yyyy-MM-dd hh:mm:ss")+'</span></td>\n' +
                                    '</tr>\n'
                            }
                            var $div = $('<div id="'+v.actId+'" class="hideDiv"><table class="activityTable">\n' +
                                '    <tbody>\n' +'<tr>\n' +
                                '    <td ><span>处理人</span></td>\n' +
                                '    <td ><span>处理时间</span></td>\n' +
                                '</tr>\n'+
                                info+
                                '    </tbody>\n' +
                                '</table></div>', {
                                'class': ''
                            }).css({
                                position: 'absolute',
                                left: v.x+v.width+3,
                                top: v.y,
                                width: 300,
                                height: v.height ,
                                opacity: 999,
                                zIndex: 10000000,
                            }).attr({'actId': v.actId, 'name': v.name});
                            html += $div.prop("outerHTML");
                        });
                        $('<div />', {'id': 'processRect'}).html(html).appendTo($('#flowImageAndRect'));
                    }
                })
            }
            /*鼠标悬停*/
            ProcessRun.over=function(id){
                $('#'+id).show();
            }
            /*鼠标移出*/
            ProcessRun.out=function(id){
                $('#'+id).hide();
            }

            function reloadTable() {
                var table = layui.table;
                table.reload("processDefinitionTable", {
                    where: {
                        processDefinitionName: encodeURI(encodeURI($('#processDefinitionName').val())),
                    }
                });
            }
            Date.prototype.format = function(fmt) {
                var o = {
                    "M+" : this.getMonth()+1,                 //月份
                    "d+" : this.getDate(),                    //日
                    "h+" : this.getHours(),                   //小时
                    "m+" : this.getMinutes(),                 //分
                    "s+" : this.getSeconds(),                 //秒
                    "q+" : Math.floor((this.getMonth()+3)/3), //季度
                    "S"  : this.getMilliseconds()             //毫秒
                };
                if(/(y+)/.test(fmt)) {
                    fmt=fmt.replace(RegExp.$1, (this.getFullYear()+"").substr(4 - RegExp.$1.length));
                }
                for(var k in o) {
                    if(new RegExp("("+ k +")").test(fmt)){
                        fmt = fmt.replace(RegExp.$1, (RegExp.$1.length==1) ? (o[k]) : (("00"+ o[k]).substr((""+ o[k]).length)));
                    }
                }
                return fmt;
            }
        });
