layui.use(['jquery', 'layer', 'Hussar', 'HussarAjax', "form", "table", "laydate"], function () {
    var Hussar = layui.Hussar;
    var $ = layui.jquery;
    var $ax = layui.HussarAjax;
    var form = layui.form;
    var laydate = layui.laydate;
    var table = layui.table;
    var table1;
    var UrgeTask = {
        seItem: null,
        type: null
    };

    /**
     * 初始化按钮事件
     */
    UrgeTask.initButtonEvent = function () {
        //重置
        $("#reset").click(function () {
            UrgeTask.reset();
        });
        //查询
        $("#search").click(function () {
            UrgeTask.search();
        });
    };
    /**
     * 查询
     */
    UrgeTask.search = function () {
        UrgeTask.initTable()
    }
    /**
     * 重置
     */
    UrgeTask.reset = function () {
        $('#procName').val("");
        $('#sendUserName').val("");
        $('#startTime').val("");
        $('#endTime').val("");
    }
    /**
     * 初始化列表
     */
    UrgeTask.initTable = function () {
        layui.use('table', function () {
            var procName = $("#procName").val();
            var sendUserName = $("#sendUserName").val();
            var startTime = $("#startTime").val();
            var endTime = $("#endTime").val();
            var table = layui.table;
            var str = [{type: 'checkbox', width: 40},
                {title: '序号', type: 'numbers', align: 'center'},
                {
                    field: 'procName',
                    title: '流程名称',
                    align: 'center',
                    event: 'openPic',
                    style: 'cursor: pointer;color:#00a4ff'
                },
                {field: 'taskName', title: '节点名称', align: 'center', sort: false, templet: function(params){
                        if (params.formKey == null || params.formKey === "") {
                            return '<span>' + params.taskName + '</span>'
                        }else{
                            return '<a  style="color: #00a4ff" href=' + Hussar.ctxPath + params.formKey +
                                '?taskId='+ params.taskId + '&flowKey='+ params.procDefKey + '&businessId='+
                                params.businessId + '&nodeId='+ params.taskDefKey + '>' + params.taskName + '</a>'
                        }
                    }},
                {field: 'sendUserName', title: '发送人', align: 'center', sort: false},
                {field: 'sendTime', title: '催办时间', align: 'center', sort: false},
            ];
            table.render({
                elem: '#UrgeTask',
                height: $("body").height() - $(".layui-form").outerHeight(true) - 26,
                url: Hussar.ctxPath + '/sysActUrgeTask/list',
                cols: [str],
                page: true,
                id: 'UrgeTask',
                even: true,
                limit: 10,
                where: {
                    procName: procName,
                    sendUserName: sendUserName,
                    startTime: startTime,
                    endTime: endTime
                }
            });
            table1 = table;
        });
    };
    table.on('tool(UrgeTask)', function (obj) {
        var data = obj.data;
        if (obj.event === 'openPic') {
            layui.use(['layer', 'HussarBpm'], function () {
                var bpm = layui.HussarBpm;
                bpm.processpicTab(data.procInstId, '流程图', function () {

                });
            });
        }
    });
    /**
     * 初始化时间控件
     */
    UrgeTask.initLaydate = function () {
        var ts = laydate.render({
            elem: '#startTime',
            type: 'datetime',
            done: function (value, date) {
                if (value !== '') {
                    te.config.min.year = date.year;
                    te.config.min.month = date.month - 1;
                    te.config.min.date = date.date;
                    te.config.min.hours = date.hours;
                    te.config.min.minutes = date.minutes;
                    te.config.min.seconds = date.seconds;
                } else {
                    te.config.min.year = '';
                    te.config.min.month = '';
                    te.config.min.date = '';
                    te.config.min.hours = '';
                    te.config.min.minutes = '';
                    te.config.min.seconds = '';
                }

            }
        });
        var te = laydate.render({
            elem: '#endTime',
            type: 'datetime',
            done: function (value, date) {
                if (value !== '') {
                    ts.config.max.year = date.year;
                    ts.config.max.month = date.month - 1;
                    ts.config.max.date = date.date;
                    ts.config.max.hours = date.hours;
                    ts.config.max.minutes = date.minutes;
                    ts.config.max.seconds = date.seconds;
                } else {
                    ts.config.max.year = '2099';
                    ts.config.max.month = '11';
                    ts.config.max.date = '31';
                    ts.config.max.hours = '0';
                    ts.config.max.minutes = '0';
                    ts.config.max.seconds = '0';
                }

            }
        });
    }
    /**
     * 初始化
     */
    $(function () {
        UrgeTask.initLaydate();
        UrgeTask.initTable();
        UrgeTask.initButtonEvent();
    });
});
