layui.use(['jquery', 'Hussar', 'HussarAjax'], function () {
    var Hussar = layui.Hussar;
    var $ = layui.jquery;
    $(function () {
        //1.获取canvas元素
        var cnv = document.getElementById("canvas");
        cnv.width = $(window).width() + 400;
        cnv.height = $(window).height() + 400;
        //获取上下文环境对象
        var cxt = cnv.getContext("2d");
        createImg(cxt);
        // 节点信息
        var dataPop = [];
        $.ajax({
            type: "POST",
            url: Hussar.ctxPath + "/processDiagram/getProcessCompleteInfo",
            dataType: "json",
            data: {
                processInstanceId: definitionId
            },
            success: function (data) {
                dataPop = data
            }
        });

        // 绘制图片
        function createImg(cxt) {
            $.ajax({
                type: "POST",
                url: Hussar.ctxPath + "/processDiagram/getProcessInfo",
                dataType: "json",
                data: {
                    processInstanceId: definitionId
                },
                success: function (data) {
                    window.tools.createImg(cnv, data, null);
                }
            });
        }

        // 监听
        cnv.addEventListener("mousemove", function () {
            rectCheckMouse(tools.get_canvasMouse(event, cnv), dataPop)
        });

        var flag = 0;

        // 监听触发
        function rectCheckMouse(mouse, data) {
            var sub_top = $("#canvas").css("marginTop").replace('px', '');
            var sub_Left = $("#canvas").css("marginLeft").replace('px', '');
            for (var i = 0; i < data.length; i++) {
                var item = data[i];
                if (mouse.x > item.x && mouse.x < (item.x + item.width) && mouse.y > item.y && mouse.y < (item.y + item.height + 10)) {
                    flag = 1;
                    var inner = "";
                    if (item.state === "finish") {
                        inner += "<div class='ul-info'>"
                        for (var n = 0; n < item.completeInfo.length; n++) {
                            inner += "<ul>" +
                                "<li>开始时间：<span>" + item.completeInfo[n].startTime + "</span></li>" +
                                " <li>结束时间：<span>" + item.completeInfo[n].endTime + "</span></li>" +
                                "<li>处&nbsp;&nbsp;理&nbsp;&nbsp;人：<span>" + item.completeInfo[n].assignee + "</span></li>" +
                                "<li>" +
                                "办理意见：<span>" + item.completeInfo[n].comments + "</span>" +
                                "</li>" +
                                "</ul>"
                        }
                        inner += "</div>"
                    } else if (item.state === "now") {
                        var type = item.completeType;
                        var operating = '驳回节点';
                        if (type == 'revoke') {
                            operating = '撤回节点'
                        }
                        if (type == 'reject') {
                            operating = '驳回节点'
                        }
                        inner += "<div class='ul-info'>"
                        if (item.rejectFrom == ''||item.rejectFrom ==undefined) {
                            inner += "<ul>" +
                                "<li>创建时间：<span>" + item.startTime + "</span></li>" +
                                "<li>接&nbsp;&nbsp;收&nbsp;&nbsp;人：<span>" + item.assignee + "</span></li>" +
                                "</ul>";
                        } else {
                            inner += "<ul>" +
                                "<li>创建时间：<span>" + item.startTime + "</span></li>" +
                                "<li>" + operating + "：<span>" + item.rejectFrom + "</span></li>" +
                                "<li>接&nbsp;&nbsp;收&nbsp;&nbsp;人：<span>" + item.assignee + "</span></li>" +
                                "</ul>";
                        }
                        var complete = item.completeInfo;
                        if (complete != undefined) {
                            for (var n = 0; n < item.completeInfo.length; n++) {
                                inner += "<ul>" +
                                    "<li>开始时间：<span>" + item.completeInfo[n].startTime + "</span></li>" +
                                    " <li>结束时间：<span>" + item.completeInfo[n].endTime + "</span></li>" +
                                    "<li>处&nbsp;&nbsp;理&nbsp;&nbsp;人：<span>" + item.completeInfo[n].assignee + "</span></li>" +
                                    "<li>" +
                                    "办理意见：<span>" + item.completeInfo[n].comments + "</span>" +
                                    "</li>" +
                                    "</ul>"
                            }
                        }
                        inner += "</div>"
                    }
                    var top = (item.y + item.height) + 10 + parseInt(sub_top) + cnv.offsetTop -
                        document.body.scrollTop - document.documentElement.scrollTop;
                    var left = item.x + parseInt(sub_Left) + (item.width - 260) / 2 + cnv.offsetLeft -
                        document.body.scrollLeft - document.documentElement.scrollLeft;
                    $(".pop-win").html(inner).css({
                        "top": top < 0 ? 5 : top,
                        "left": left < 0 ? 5 : left
                    }).show();
                    break;
                } else {
                    flag = 0;
                }
            }
            if (flag === 0) {
                $(".pop-win").hide()
            }
        }
    });
});
