/**
 * 初始化详情对话框
 */
var TEntrustInfoDlg = {
    tEntrustInfoData : {},
    index : ""
};

layui.use(['layer', 'Hussar', 'HussarAjax','form', 'laydate'], function(){
	var layer = layui.layer
        ,Hussar = layui.Hussar
	    ,$ = layui.jquery
	    ,laydate = layui.laydate
	    ,$ax = layui.HussarAjax
        ,form = layui.form;

/**
 * 清除数据
 */
TEntrustInfoDlg.clearData = function() {
    this.tEntrustInfoData = {};
};

/**
 * 设置对话框中的数据
 *
 * @param key 数据的名称
 * @param val 数据的具体值
 */
TEntrustInfoDlg.set = function(key, val) {
    this.tEntrustInfoData[key] = (typeof val == "undefined") ? $("#" + key).val() : val;
    return this;
};

/**
 * 设置对话框中的数据
 *
 * @param key 数据的名称
 * @param val 数据的具体值
 */
TEntrustInfoDlg.get = function(key) {
    return $("#" + key).val();
};

/**
 * 关闭此对话框
 */
TEntrustInfoDlg.close = function() {
    parent.layui.layer.close(window.parent.TEntrust.layerIndex);
};

TEntrustInfoDlg.closeChild = function(data) {
    $("#people").val(data.id);
    $("#peoplename").val(data.name);
    layer.close(TEntrustInfoDlg.index);
};

    /**
 * 收集数据
 */
TEntrustInfoDlg.collectData = function() {
    this
    .set('id')
    .set('people')
    .set('starttime')
    .set('endtime')
    .set('enpeople')
    .set('peoplename');
    this.tEntrustInfoData['state'] = $("[name='state']:checked").val();
    this.tEntrustInfoData['processname'] = $("dd[class='layui-this']").html();
    this.tEntrustInfoData['processid'] = $("#processid").val();
};

form.verify({
    limit:function(value){
        if (value < $("#starttime").val()){
            return "结束日期不可小于开始日期!";
        }
    }
});

/**
 * 提交添加
 */
form.on('submit(save)',function(){

    TEntrustInfoDlg.clearData();
    TEntrustInfoDlg.collectData();

    //提交信息
    var ajax = new $ax(Hussar.ctxPath + "/tEntrust/add", function(data){
        if (data.code == 200){
            window.parent.layui.Hussar.success("添加成功!");
            window.parent.TEntrust.reloadTable();
            TEntrustInfoDlg.close();
        }else {
            Hussar.error(data.message);
        }

    },function(data){
        Hussar.error("添加失败!" + data.responseJSON.message + "!");
    });
    ajax.set(TEntrustInfoDlg.tEntrustInfoData);
    ajax.start();
});

/**
 * 提交修改
 */
form.on('submit(edit)',function(){
    TEntrustInfoDlg.clearData();
    TEntrustInfoDlg.collectData();

    //提交信息
    var ajax = new $ax(Hussar.ctxPath + "/tEntrust/update", function(data){
        if (data.code == 200){
            window.parent.layui.Hussar.success("修改成功!");
            window.parent.TEntrust.reloadTable();
            TEntrustInfoDlg.close();
        }else {
            Hussar.error(data.message);
        }
    },function(data){
        Hussar.error("修改失败!" + data.responseJSON.message + "!");
    });
    ajax.set(TEntrustInfoDlg.tEntrustInfoData);
    ajax.start();
});

/**
 * 初始化时间控件
 */
TEntrustInfoDlg.initLaydate = function() {
    var dateDom = $(".dateType");
    $.each($(".dateType"), function (i,dom) {
        laydate.render({
            elem: dom,
            type : 'datetime'
        });
    });
};

$("#peoplename").click(function(){
    TEntrustInfoDlg.index = layer.open({
        type:2,
        title: '被委托人',
        area: ['300px', '400px'], //宽高
        fix: false, //不固定
        maxmin: false,
        content: Hussar.ctxPath + '/tEntrust/choose'
    })
});

$(function() {
    TEntrustInfoDlg.initLaydate();   //初始化时间控件
});

});