/**
 * 管理初始化
 */
var TEntrust = {
    id: "TEntrustTable",	//表格id
    seItem: null,		//选中的条目
    table: null,
    layerIndex: -1,
    pageSize:20,
    pageNumber:1
};
layui.use(['layer','bootstrap_table_edit','Hussar', 'HussarAjax','table'], function(){
	var layer = layui.layer
	    ,table = layui.table
        ,Hussar = layui.Hussar
	    ,$ = layui.jquery
	    ,$ax = layui.HussarAjax;

/**
 * 初始化表格的列
 */
TEntrust.initColumn = function () {
    return [[
        {type: 'checkbox'},
        {type: 'numbers', title: '序号'},
            {title: '主键id', field: 'id', align: 'center',hide:true},
            {title: '委托流程', field: 'processname', align: 'center'},
            {title: '委托流程id', field: 'processid', align: 'center',hide:true},
            {title: '委托人', field: 'enpeople', align: 'center',hide:true},
            {title: '被委托人', field: 'peoplename', align: 'center'},
            {title: '被委托人id', field: 'people', align: 'center',hide:true},
            {title: '状态', field: 'state', align: 'center',templet: function (value) {
                if ("1" == value.state){
                    return "启用";
                }else {
                    return "禁用";
                }
            }},
            {title: '开始时间', field: 'starttime', align: 'center'},
            {title: '结束时间', field: 'endtime', align: 'center'}
    ]];
};

TEntrust.reloadTable = function(){
    table.reload('idTest');
};

/**
 * 检查是否选中
 */
TEntrust.check = function () {
    var selected = table.checkStatus('idTest');
    if(selected.data.length != 1){
        Hussar.info("请先选中列表中的一条数据！");
        return false;
    }else {
        TEntrust.seItem = selected.data[0];
        return true;
    }
};

/**
 * 点击添加
 */
TEntrust.openAddTEntrust = function () {
    var index = layer.open({
        type: 2,
        title: '新增委托配置',
        area: ['720px', '500px'], //宽高
        fix: false, //不固定
        maxmin: false,
        content: Hussar.ctxPath + '/tEntrust/tEntrust_add'
    });
    this.layerIndex = index;
};

/**
 * 点击修改
 */
TEntrust.openTEntrustDetail = function () {
    if (this.check()) {
        var index = layer.open({
            type: 2,
            title: '修改委托配置',
            area: ['720px', '500px'], //宽高
            fix: false, //不固定
            maxmin: false,
            content: Hussar.ctxPath + '/tEntrust/tEntrust_update/' + TEntrust.seItem.id});
        this.layerIndex = index;
    }
};

/**
 *  修改是否禁用
*/
TEntrust.changeState = function () {
    var selected = table.checkStatus('idTest');
    if (selected.data.length > 0){
        Hussar.confirm("是否要变更为启用/禁用？",function(){
            var ajax = new $ax(Hussar.ctxPath + "/tEntrust/editState",function(data){
                if (data.code == 200){
                    Hussar.success("启用/禁用成功！");
                }else {
                    Hussar.error("启用/禁用失败！");
                }
            }, function (data) {
                Hussar.error("变更失败!" + data.responseJSON.message + "!");
            });
            ajax.set("tEntrusts",JSON.stringify(selected.data));
            ajax.start();
            table.reload('idTest')
        },function(){

        })
    }
};

/**
 * 获取多选行
 */
TEntrust.select = function (){
    var selected = table.checkStatus('idTest');
    var ids = [];
    for (var id in selected.data){
        ids.push(selected.data[id].id);
    }
    return ids;
};

/**
 * 删除
 */
TEntrust.delete = function () {
    var ids = TEntrust.select();
    if (ids.length > 0) {
        Hussar.confirm("确定要删除吗？",function(){
            var ajax = new $ax(Hussar.ctxPath + "/tEntrust/delete", function (data) {
                Hussar.success("删除成功!");
                table.reload('idTest');
            }, function (data) {
                Hussar.error("删除失败!" + data.responseJSON.message + "!");
            });
            ajax.set("tEntrustId",JSON.stringify(ids));
            ajax.start();
        },function(){

        })
    }else {
        Hussar.info("请选择至少一条数据！");
    }
};

/**
 * 查询列表
 */
TEntrust.search = function () {
    table.reload('idTest', {
        where:{
            condition:$("#condition").val()
        }
    });
};

$(function () {
    var defaultColunms = TEntrust.initColumn();

    table.render({
        elem: "#TEntrustTable",
        page: true,
        cols: defaultColunms,
        height:$("body").height() - $(".layui-form").outerHeight(true) - 26,
        url:'/tEntrust/list',
        id: 'idTest'
    });
})

});