/**
 * Created by myname on 2019/2/12.
 */
layui.use(['jquery', 'layer', 'Hussar', 'jstree', 'HussarAjax', 'element'], function () {
    var Hussar = layui.Hussar;
    var $ = layui.jquery;
    var jstree = layui.jstree;
    var OrgTreeDemo = {};
    var UserMgr = {};
    var dataTree = {};

    /*初始化人员树*/
    OrgTreeDemo.initUserTree = function (data) {
        var $tree = $("#showUserTree");
        $tree.jstree({
            core: {
                data:{
                    "url"  :Hussar.ctxPath + "/user/userTree",
                    "data" : function (node) {
                        return { "parentId" : node.id };
                    }
                },
                "multiple": false
            },
            plugins: ['types', 'search'],
            types: {
                "1": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/com.png"},
                "2": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/dept.png"},
                "3": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/station.png"},
                "9": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/empl.png"},
                "USER": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/user.png"}
            },
            search: UserMgr.search(),
            sort: function (a, b) {
                return this.get_node(a).original.struOrder > this.get_node(b).original.struOrder ? 1 : -1;
            }
        });
        $tree.bind('activate_node.jstree', function (obj, e) {
            if (e.node.type == "USER") {
                dataTree.name = e.node.text;
                dataTree.id = e.node.id;
                window.parent.TEntrustInfoDlg.closeChild(dataTree);
            }
        });
    };

    /**
     * 所有树的模糊查询
     */
    UserMgr.search = function () {
        var to = false;
        //用户树查询
        $("#userTreeSearch").keyup(function () {
            if (to) {
                clearTimeout(to);
            }
            to = setTimeout(function () {
                var v = $("#userTreeSearch").val();
                var temp = $("#showUserTree").is(":hidden");
                if (temp == true) {
                    $("#showUserTree").show();
                }
                $("#showUserTree").jstree(true).search(v);
                //添加索引
                if (v != '') {
                    var n = $(".jstree-search").length, con_html;
                    if (n > 0) {
                        con_html = "<em>" + n + "</em>个匹配项";
                    } else {
                        con_html = "无匹配项";
                    }
                    $("#userTreeSearchResult").html(con_html);
                    //定位到符合查询结果的树节点上
                    var searchResult = $("#showUserTree").jstree('search', v);
                    $(searchResult).find('.jstree-search').focus();
                } else {
                    $("#userTreeSearchResult").html("");
                }
            }, 250);
        });
    };

    $(function(){
        OrgTreeDemo.initUserTree();
    })
});