layui.use(['jquery', 'layer', 'Hussar', 'HussarAjax', "form", "table", "laydate"], function () {

    var Hussar = layui.Hussar;
    var $ = layui.jquery;
    var layer = layui.layer;
    var $ax = layui.HussarAjax;
    var form = layui.form;
    var table = layui.table;
    var laydate = layui.laydate;
    var table1;
    var FlowTodo = {
        seItem: null,
        type: null
    };

    /**
     * 初始化按钮事件
     */
    FlowTodo.initButtonEvent = function () {
        $("#btnClose").click(function () {
            FlowTodo.closeIndex();
            layer.closeAll();
        });
        //重置
        $("#reset").click(function () {
            FlowTodo.reset();
        });
        //查询
        $("#search").click(function () {
            FlowTodo.search();
        });
    };
    /**
     * 查询
     */
    FlowTodo.search = function () {
        FlowTodo.initTable()
    }
    /**
     * 重置
     */
    FlowTodo.reset = function () {
        $('#flowType').val("");
        $('#message').val("");
        $('#startTime').val("");
        $('#endTime').val("");
    }
    /**
     * 初始化列表
     */
    FlowTodo.initTable = function () {
        layui.use('table', function () {
            var flowType = $("#flowType option:selected").val();
            var message = $("#message").val();
            var startTime = $("#startTime").val();
            var endTime = $("#endTime").val();
            var table = layui.table;
            var str = [{type: 'checkbox', width: 40},
                {title: '序号', type: 'numbers', align: 'center'},
                {field: 'definitionName', title: '流程名称', align: 'center', event: 'openPic', style: 'cursor: pointer;color:#00a4ff'},
                {
                    field: 'name', title: '节点名称', align: 'center', sort: false, templet: function (params) {
                        if (params.formKey == null || params.formKey === "") {
                            return '<span>' + params.name + '</span>'
                        } else {
                            return '<a  style="color: #00a4ff" href=' + Hussar.ctxPath + params.formKey +
                                '?taskId='+ params.taskId + '&flowKey='+ params.definitionKey + '&businessId='+
                                params.businessId + '&nodeId='+ params.taskDefinitionKey + '>' + params.name + '</a>'
                        }
                    }
                },
                {field: 'sendUserName', title: '发送人', align: 'center', sort: false},
                {field: 'createTime', title: '创建时间', align: 'center', sort: false},
                {field: 'message', title: '任务内容', align: 'center', sort: false},
            ]
            table.render({
                elem: '#FlowTodo',
                height: $("body").height() - $(".layui-form").outerHeight(true) - 26,
                url: Hussar.ctxPath + '/flowEvents/todoList',
                cols: [str],
                page: true,
                id: 'FlowTodo',
                even: true,
                limit: 10,
                where: {
                    flowType: flowType,
                    message: message,
                    startTime: startTime,
                    endTime: endTime
                }
            });
            table1 = table;
        });
    };
    table.on('tool(FlowTodo)', function (obj) {
        var data = obj.data;
        if (obj.event === 'openPic') {
            layui.use(['layer', 'HussarBpm'], function () {
                var bpm = layui.HussarBpm;
                bpm.processpicTab(data.processInsId, '流程图', function () {

                });
            });
        }
    });
    /**
     * 获取流程下拉框
     */
    FlowTodo.queryOption = function () {
        var ajax = new $ax(Hussar.ctxPath + "/flowEvents/flowType",
            function (json) {
                $("#flowType").html("");
                $("#flowType").append("<option value=''>" + "请选择" + "</option>");
                for (var i = 0; i < json.length; i++) {
                    $("#flowType").append("<option value='" + json[i].id + "'>" + json[i].name + "</option>");
                }
                form.render();
            }, function (data) {
                Hussar.error("获取审核类型失败！");
            });
        ajax.start();
    };
    /**
     * 初始化时间控件
     */
    FlowTodo.initLaydate = function () {
        var ts = laydate.render({
            elem: '#startTime',
            type: 'datetime',
            done: function (value, date) {
                if (value !== '') {
                    te.config.min.year = date.year;
                    te.config.min.month = date.month - 1;
                    te.config.min.date = date.date;
                    te.config.min.hours = date.hours;
                    te.config.min.minutes = date.minutes;
                    te.config.min.seconds = date.seconds;
                } else {
                    te.config.min.year = '';
                    te.config.min.month = '';
                    te.config.min.date = '';
                    te.config.min.hours = '';
                    te.config.min.minutes = '';
                    te.config.min.seconds = '';
                }

            }
        });
        var te = laydate.render({
            elem: '#endTime',
            type: 'datetime',
            done: function (value, date) {
                if (value !== '') {
                    ts.config.max.year = date.year;
                    ts.config.max.month = date.month - 1;
                    ts.config.max.date = date.date;
                    ts.config.max.hours = date.hours;
                    ts.config.max.minutes = date.minutes;
                    ts.config.max.seconds = date.seconds;
                } else {
                    ts.config.max.year = '2099';
                    ts.config.max.month = '11';
                    ts.config.max.date = '31';
                    ts.config.max.hours = '0';
                    ts.config.max.minutes = '0';
                    ts.config.max.seconds = '0';
                }

            }
        });
    }
    /**
     * 初始化
     */
    $(function () {
        FlowTodo.initLaydate();
        FlowTodo.queryOption();
        FlowTodo.initTable();
        FlowTodo.initButtonEvent();
    });
});
