﻿//定义工具函数集
window.tools = {};
//获取鼠标当前位置
window.tools.getMouse = function (element) {
    var mouse = { x: 0, y: 0 };
    element.addEventListener("mousemove", function (e) {
        var x, y;
        var e = e || window.event;
        if (e.pageX || e.pageY) {
            x = e.pageX;
            y = e.pageY;
        }
        else {
            x = e.clientX + document.body.scrollLeft + document.documentElement.scrollLeft;
            y = e.clientY + document.body.scrollTop + document.documentElement.scrollTop;
        }
        x -= element.offsetLeft;
        y -= element.offsetTop;

        mouse.x = x;
        mouse.y = y;
    }, false);
    return mouse;
}
//获取随机颜色值
window.tools.getRandomColor=function(){
    return '#' +
    (function (color) {
        return (color += '0123456789abcdef'[Math.floor(Math.random() * 16)])
        && (color.length == 6) ? color : arguments.callee(color);
    })('');
}
//外接矩形判定法（碰撞检测）
window.tools.checkRect = function (rectA, rectB) {
    return !(rectA.x + rectA.width < rectB.x ||
             rectB.x + rectB.width < rectA.x ||
             rectA.y + rectA.height < rectB.y ||
             rectB.y + rectB.height < rectA.y);
}

//外接圆判定法（碰撞检测）
window.tools.checkCircle = function (circleB, circleA) {
    var dx = circleB.x - circleA.x;
    var dy = circleB.y - circleA.y;
    var distance = Math.sqrt(dx * dx + dy * dy);
    if (distance < (circleA.radius + circleB.radius)) {
        return true;
    }
    else {
        return false;
    }
}

//获取键盘控制方向
window.tools.getKey = function () {
    var key = {};
    window.addEventListener("keydown", function (e) {
        if (e.keyCode == 38 || e.keyCode == 87) {
            key.direction = "up";
        } else if (e.keyCode == 39 || e.keyCode == 68) {
            key.direction = "right";
        } else if (e.keyCode == 40 || e.keyCode == 83) {
            key.direction = "down";
        } else if (e.keyCode == 37 || e.keyCode == 65) {
            key.direction = "left";
        } else {
            key.direction = "";
        }
    }, false);
    return key;
}

//动画循环，兼容各大浏览器
window.requestAnimationFrame = (
    window.webkitRequestAnimationFrame ||
    window.mozRequestAnimationFrame ||
    window.msRequestAnimationFrame ||
    window.oRequestAnimationFrame ||
    function (callback) {
        return window.setTimeout(callback, 1000 / 60);
    }
);

/*--------以下为流程图中绘制流程图中各要素方法-------*/

// 绘制流程图
window.tools.createImg = function(cnv,data,allId) {
    var cxt = cnv.getContext("2d");
    /*动态改变canvas的高宽*/
    var height = [];
    var width = [];
    for (var i = 0;i < data.length;i++){
        if (data[i].type != 'sequenceFlow'){
            height.push(data[i].y+data[i].height);
            width.push(data[i].x+data[i].width);
        }else {
            width = width.concat(data[i].xPoints);
            height = height.concat(data[i].yPoints);
        }
    }
    if(allId != null){
        cnv.width = Math.max.apply(null, width) +120;
        cnv.height =Math.max.apply(null, height) +50;
    }else if(Math.max.apply(null, height) > 500 ){
        cnv.width = Math.max.apply(null, width) +120;
        cnv.height =Math.max.apply(null, height) +300;
    }else {
        cnv.width = Math.max.apply(null, width) +120;
        cnv.height =Math.max.apply(null, height) +250;
    }

    for (var i = 0; i < data.length; i++) {
        var item = data[i];
        //获取type startEvent 开始 sequenceFlow路径  userTask节点 endEvent 结束
        var nodeType = item.type;
        var nodeName = item.name;
        var nodeState = item.state;
        if (nodeType === "startEvent") {
            cxt.beginPath();
            var x = item.x;
            var y = item.y;
            var r = item.width / 2;
            cxt.arc(x + r , y+ r , r, 0, 360 * Math.PI / 180, true);
            cxt.closePath();
            cxt.lineWidth = 2;
            cxt.strokeStyle = '#3cb1ff';//
            cxt.stroke();
            cxt.fillStyle = "#eef0f2";
            cxt.fill();
            createPolygon(cxt, 3, x+ r , y + r, 8, '#3cb1ff');
            cxt.font = "12px 微软雅黑";
            cxt.fillStyle = "#666";
            cxt.textAlign = 'center';
            cxt.fillText(nodeName, x + r , y + item.width  + 15);
        }else if (nodeType === "startTimerEvent"){
            var width = item.width;
            var height = item.height;
            var x = item.x;
            var y = item.y;
            cxt.lineWidth=1;
            var state = item.state;
            var itemName = item.name;
            var node = new Node(width, height, 4, x, y, typeof(state) == 'undefined' ? 'finish': state, itemName,item.id);
            node.createStartTimerEvent(cxt);
        }
        else if (nodeType === "sequenceFlow") {
            // 循环遍历线的节点，画出线的轨迹
            var x = item.xPoints;
            var y = item.yPoints;
            cxt.beginPath();
            cxt.moveTo(x[0], y[0]);
            var max = x.length;
            for (var j = 1;j< max;j++){
                cxt.lineTo(x[j], y[j]);
            }
            cxt.lineWidth = 1;
            var color;
            if (nodeState === "finish" || nodeState === "now") {
                color = '#3cb1ff';//
            } else {
                color = '#b9bbbf';//
            }
            cxt.strokeStyle = color;
            cxt.stroke();
            // 线上添加文字
            textRote(cxt,nodeName,x[0],y[0],x[1],y[1]);
            // 根据最后两点确定箭头的方向
            // 需要参数，最后两个点
            createP(cxt,x[max-1],y[max-1],x[max-2],y[max-2],color);
        }
        else if (nodeType === "exclusiveGateway") {//互斥网关
            var x = item.x;
            var y = item.y;
            var r = item.width / 2;
            var h = item.height / 2;
            cxt.beginPath();
            cxt.moveTo(x , y + r );
            cxt.lineTo(x + r, y);
            cxt.lineTo(x + item.width, y + h);
            cxt.lineTo(x + r, y + item.height);
            cxt.closePath();
            if(nodeState === "finish" || nodeState === "now"){
                cxt.strokeStyle = '#3cb1ff';
                cxt.stroke();
                cxt.fillStyle = '#e5f7fd';//#3cb1ff
                cxt.fill();
            }else{
                cxt.strokeStyle = '#b9bbbf';
                cxt.stroke();
                cxt.fillStyle = '#eef0f2';//#3cb1ff
                cxt.fill();
            }
            cxt.beginPath();
            cxt.moveTo(x + r/2, y + r/2);
            cxt.lineTo(x + item.width - r/2, y +  3*r/2);
            cxt.moveTo(x + r/2, y + 3*r/2);
            cxt.lineTo(x + item.width - r/2, y +  r/2);
            cxt.lineWidth=2;
            cxt.stroke();
            cxt.fillStyle = '#e5f7fd';//#3cb1ff
            cxt.font = "12px 微软雅黑";
            cxt.fillStyle = "#666";
            cxt.textAlign = 'center';
            cxt.fillText(item.name, x + r, y + item.height + 15 );
        }
        else if (nodeType === "inclusiveGateway") {//包容网关
            var x = item.x;
            var y = item.y;
            var r = item.width / 2;
            var h = item.height / 2;
            cxt.beginPath();
            cxt.moveTo(x , y + r );
            cxt.lineTo(x + r, y);
            cxt.lineTo(x + item.width, y + h);
            cxt.lineTo(x + r, y + item.height);
            cxt.closePath();
            if(nodeState === "finish" || nodeState === "now"){
                cxt.strokeStyle = '#3cb1ff';
                cxt.stroke();
                cxt.fillStyle = '#e5f7fd';//#3cb1ff
                cxt.fill();
            }else{
                cxt.strokeStyle = '#b9bbbf';
                cxt.stroke();
                cxt.fillStyle = '#eef0f2';//#3cb1ff
                cxt.fill();
            }
            //菱形内部圆
            cxt.beginPath();
            cxt.arc(x +r,y  + h ,11,0,360*Math.PI/180,true);
            cxt.closePath();
            cxt.lineWidth=2;
            cxt.strokeStyle = '#b9bbbf';//#3cb1ff
            cxt.stroke();
            cxt.font = "12px 微软雅黑";
            cxt.fillStyle = "#666";
            cxt.textAlign = 'center';
            cxt.fillText(item.name, x + r, y + item.height + 15 );
        }
        else if (nodeType === "parallelGateway") {  //并行网关
            var x = item.x;
            var y = item.y;
            var r = item.width / 2;
            var h = item.height / 2;
            cxt.beginPath();
            cxt.moveTo(x , y + r );
            cxt.lineTo(x + r, y);
            cxt.lineTo(x + item.width, y + h);
            cxt.lineTo(x + r, y + item.height);
            cxt.closePath();
            if(nodeState === "finish" || nodeState === "now"){
                cxt.strokeStyle = '#3cb1ff';
                cxt.stroke();
                cxt.fillStyle = '#e5f7fd';//#3cb1ff
                cxt.fill();
            }else{
                cxt.strokeStyle = '#b9bbbf';
                cxt.stroke();
                cxt.fillStyle = '#eef0f2';//#3cb1ff
                cxt.fill();
            }
            //内部加号
            cxt.beginPath();
            cxt.moveTo(x , y + h );
            cxt.lineTo(x + item.width, y + h );
            cxt.moveTo(x + r, y  );
            cxt.lineTo(x + r,  y + item.height );
            cxt.lineWidth=2;
            cxt.stroke();
            cxt.fillStyle = '#e5f7fd';//#3cb1ff
            cxt.font = "12px 微软雅黑";
            cxt.fillStyle = "#666";
            cxt.textAlign = 'center';
            cxt.fillText(item.name, x + r, y+ item.height + 15 );
        }
        else if (nodeType === "userTask") {
            var width = item.width;
            var height = item.height;
            var x = item.x;
            var y = item.y;
            cxt.lineWidth=1;
            var state = item.state;
            var itemName = item.name;
            var node = new Node(width, height, 4, x, y, typeof(state) == 'undefined' ? 'finish': state, itemName,item.id);
            node.createNode(cxt,allId);
        }
        else if (nodeType === "endEvent") {
            //开始绘制图形--END
            var x = item.x;
            var y = item.y;
            var r = item.width / 2;
            var h = item.height / 2;
            cxt.beginPath();
            cxt.arc(x + r, y + r, r, 0, 360 * Math.PI / 180, true);
            cxt.closePath();
            cxt.lineWidth = 2;
            if(nodeState === "finish" || nodeState === "now"){
                cxt.strokeStyle = '#3cb1ff';
                cxt.stroke();
            }else {
                cxt.strokeStyle = '#b9bbbf';
                cxt.stroke();
            }
            cxt.fillStyle = "#eef0f2";
            cxt.fill();
            cxt.fillStyle = "#f66f4f";
            cxt.fillRect(x - 6 + r , y + r - 6 , 12, 11);
            cxt.font = "12px 微软雅黑";
            cxt.fillStyle = "#666";
            cxt.textAlign = 'center';
            cxt.fillText(item.name, x + r , y + item.width + 15);
        }// 子流程
        else if (nodeType === "subProcess"){
            var width = item.width;
            var height = item.height;
            var x = item.x;
            var y = item.y;
            cxt.lineWidth=1;
            var state = item.state;
            var itemName = item.name;
            var node = new Node(width, height, 4, x, y, typeof(state) == 'undefined' ? 'finish': state, itemName,item.id);
            node.createSubProcess(cxt);
        }// 边界定时事件
        else if (nodeType === "boundaryEvent"){
            var width = item.width;
            var height = item.height;
            var x = item.x;
            var y = item.y;
            cxt.lineWidth=1;
            var state = item.state;
            var itemName = item.name;
            var node = new Node(width, height, 4, x, y, typeof(state) == 'undefined' ? 'finish': state, itemName,item.id);
            node.createBoundaryEvent(cxt);
        } else if (nodeType === "callActivity") {
            var width = item.width;
            var height = item.height;
            var x = item.x;
            var y = item.y;
            cxt.lineWidth=2;
            var state = item.state;
            var itemName = item.name;
            var node = new Node(width, height, 4, x, y, typeof(state) == 'undefined' ? 'finish': state, itemName,item.id);
            node.createNode(cxt,allId);
        }

    }
};

// 绘制正三角方法
function createPolygon(cxt, n, dx, dy, size, color) {
    cxt.beginPath();
    var degree = (2 * Math.PI) / n;
    for (var i = 0; i < n; i++) {
        var x = Math.cos(i * degree);
        var y = Math.sin(i * degree);
        cxt.lineTo(x * size + dx, y * size + dy);
    }
    cxt.closePath();
    cxt.fillStyle = color;//#3cb1ff
    cxt.fill();
}

// 绘制箭头
function createP(cxt,x1,y1,x2,y2,color){
    // 保存旋转画布
    cxt.save();
    cxt.translate(x1, y1);
    // 分为8种情况
    var de = (y1-y2)/(x1-x2);
    // 1.向左直线
    if (y1 == y2 && x1 < x2){
        cxt.rotate(1.5*Math.PI);
    }// 2. 向右直线
    else if (y1 == y2 && x1 > x2) {
        cxt.rotate(Math.PI/2);
    }// 3.右倾向上直线
    else if (x1 > x2 && y1 < y2){
        cxt.rotate(Math.PI/2-Math.atan(-de));
    }// 4.右倾向下直线
    else if (x1 > x2 && y1 > y2){
        cxt.rotate(Math.PI/2+Math.atan(de));
    }// 5.左倾向上直线
    else if (x1 < x2 && y1 < y2){
        cxt.rotate(1.5*Math.PI+Math.atan(de));
    }// 6.左倾向下直线
    else if (x1 < x2 && y1 > y2){
        cxt.rotate(1.5*Math.PI-Math.atan(-de));
    }// 7. 向下直线
    else if(x1 == x2 && y1 > y2){
        cxt.rotate(Math.PI);
    }
    // 先绘制一个顶点正上的正三角形,边长为lineto中的数字
    cxt.beginPath();
    cxt.moveTo(0,0);
    cxt.lineTo(-6,+6);
    cxt.lineTo(+6,+6);
    cxt.closePath();
    cxt.fillStyle = color;
    cxt.fill();
    // 恢复
    cxt.restore();
}

// 文字旋转
function textRote(cxt,text,x,y,c,z){
    // 文字根据斜率旋转
    cxt.save();
    var deg = Math.atan((z-y)/(c-x));
    var con = text;
    if(deg>1.5){
        x = x + 10
    }else if(deg<-1.5){
        x = x - 10
    }else {
        y =  y - 10
    }
    cxt.translate((x+c)/2, (y+z)/2);
    cxt.rotate(deg);
    cxt.font = "12px 微软雅黑";
    cxt.fillStyle = "#666";
    cxt.fillText(text, 0, 0);
    cxt.restore();
}

// 鼠标位置
window.tools.get_canvasMouse = function(ev,obj){
    var mouse = {x:'',y:''};
    mouse.x = ev.clientX-obj.offsetLeft+ document.body.scrollLeft + document.documentElement.scrollLeft;
    mouse.y = ev.clientY-obj.offsetTop +document.body.scrollTop + document.documentElement.scrollTop;
    return mouse;
}
