//
function Node(width,height,radius,offsetX,offsetY,state,txt,id)
{
    this.width = width||100;

    this.height = height||80;

    this.x = offsetX || 0;

    this.y = offsetY || 0;

    this.radius = radius || 12;

    this.type = state;

    this.html = txt;

    this.id = id;
}
function draw_anim(context, x,y, iObj) {
    context.clearRect(x,y,21,31);
    if (iObj.source != null){
        context.drawImage(iObj.source, iObj.current * iObj.width, 0,
            iObj.width, iObj.height, x, y, iObj.width, iObj.height);
    }
    iObj.current = (iObj.current + 1) % iObj.total_frames;
}
Node.prototype = {
    //绘制节点
    createNode: function (cxt,allId) {
        //真实比例换算成设计稿比例
        var width = this.width;
        var height = this.height;
        var scale = width/69;
        //落差
        var offsetX = this.x;
        var offsetY = this.y;
        //根据类型获取颜色 fillColor strokeColor
        var type = this.type,fillColor,strokeColor;
        //type==0 已进行 type==3 被退回节点都是蓝色
        if(type==="finish"){
            fillColor = '#e5f6fd';
            strokeColor = '#3cb1ff';
        }
        //type==1 当前节点 type==2 挂起节点都i是橙色
        else if(type==="suspend"){
            fillColor = '#ffffe7';
            strokeColor = '#f9cb7d';
        }
        //type eef0f2 b9bbbf
        else if(type === "reject"){
            fillColor = '#F9DBCF';
            strokeColor = '#FB885F';
        }
        else if(type === 'revoke'){
            fillColor = '#FFF1D9';
            strokeColor = '#FFD68E';
        }
        else if(type === "now"||type==="complete"){
            fillColor = '#e3ffed';
            strokeColor = '#10c050';
        }else if(type === "next"){
            fillColor = '#eef0f2';
            strokeColor = '#b9bbbf';
        }else if (type === "subProcess"){
            fillColor = '#eef0f2';
            strokeColor = '#b9bbbf';
        }
        //绘制圆角矩形
        var r = this.radius;
        var txt=this.html;
        cxt.beginPath();
        cxt.moveTo(offsetX + r,offsetY);
        cxt.lineTo(offsetX + width -r,offsetY);
        cxt.arcTo(offsetX + width , offsetY,offsetX + width , offsetY + r,r);
        cxt.lineTo(offsetX + width, offsetY + height - r);
        cxt.arcTo(offsetX + width , offsetY + height,offsetX + width -r , offsetY + height,r);
        cxt.lineTo(offsetX + r, offsetY + height);
        cxt.arcTo(offsetX   , offsetY+height ,offsetX   , offsetY+ height- r ,r);
        cxt.lineTo(offsetX , offsetY + r);
        cxt.arcTo(offsetX   , offsetY ,offsetX + r , offsetY ,r);
        cxt.closePath();
        cxt.fillStyle = fillColor;
        cxt.strokeStyle = strokeColor;
        cxt.fill();
        cxt.stroke();
        cxt.font = "12px 微软雅黑";
        cxt.fillStyle = "#666";
        cxt.textAlign='center';
        if(txt.length<10){
            cxt.fillText(txt,offsetX + width/2,offsetY + height+20);
        }else{
            var txt1=txt.substring(0,9);
            var txt2=txt.substring(9,txt.length);
            cxt.fillText(txt1,offsetX + width/2,offsetY + height+20);
            cxt.fillText(txt2,offsetX + width/2,offsetY + height+35);
        }

        //绘制人员图像
    /*    cxt.beginPath();
        cxt.arc(offsetX + width/2,offsetY + height *.35,4*scale,0,360*Math.PI/180,true);
        cxt.closePath();
        cxt.lineWidth=2;
        cxt.strokeStyle = strokeColor;
        cxt.stroke();
        cxt.beginPath();
        cxt.arc(offsetX + width/2,offsetY + height*.75  ,10*scale,0,180*Math.PI/180,true);
        cxt.strokeStyle = strokeColor;
        cxt.stroke();*/
        //
        var imgx = offsetX + width/2 -7;
        var imgy = offsetY + height/2 -16;
        var image = new Image();
        var path = layui.Hussar.ctxPath;
        var img_obj = {
            'source': null,
            'current': 0,
            'total_frames': 5,
            'width': 21,
            'height': 31
        };
        if(type==="now" || type==="complete"){
            img_obj.source = image;
            image.src= path + "/static/bpm/jxdbpm/processpic/img/user_now1.png";
            draw_anim(cxt, imgx, imgy, img_obj);
            setInterval(function () {
                draw_anim(cxt, imgx, imgy, img_obj);
            }, 100);
        }//绿色
        else {
            if(type==="finish") {
                image.src = path + "/static/bpm/jxdbpm/processpic/img/finish.png"
            }
            else if(type==="reject"){
                image.src= path + "/static/bpm/jxdbpm/processpic/img/reject.png"
            }
            else if( type === 'revoke'){
                image.src= path + "/static/bpm/jxdbpm/processpic/img/revoke.png"
            }
            else if(type==="suspend"){
                image.src= path + "/static/bpm/jxdbpm/processpic/img/suspend.png"
            }//黄色
            else {
                image.src= path + "/static/bpm/jxdbpm/processpic/img/other.png"
            }//灰色
            image.onload = function () {
                cxt.drawImage(image,imgx,imgy)
            }
        }

        // 右上角圆形徽章，或者其他细节
        if (allId != null){
            cxt.beginPath();
            cxt.arc(offsetX + width *.85,offsetY+13*scale,8*scale,0,360*Math.PI/180,true);
            cxt.closePath();
            cxt.stroke();
            //填充
            cxt.fillStyle='#62bca0';
            cxt.fill();
            // 右上角的徽章信息
            var text = allId[this.id];
            cxt.font = '12px';
            cxt.fillStyle = '#ffffff';
            cxt.fillText(text,offsetX + width *.85,offsetY+13*scale+4)
        }else {

            //绘制各种类型细节
            if(type === "finish"){
                // 已进行右上角对号
                cxt.beginPath();
                cxt.moveTo(offsetX + width*.78,offsetY+15*scale );
                cxt.lineTo(offsetX + width*.84,offsetY + 18*scale);
                cxt.lineTo(offsetX + width *.9,offsetY+12*scale);
                cxt.lineWidth=2;
                cxt.strokeStyle = strokeColor;
                cxt.stroke();
            }
            else if(type === "now" || type === "complete"){
                // 当前-进行
                cxt.beginPath();
                var dx = offsetX + width*.8;
                var dy = offsetY + 15*scale;
                //createPolygon(cxt ,3,x,y,5,strokeStyle);
                var degree = (2*Math.PI)/3;
                for(var i = 0 ;i<3;i++){
                    var x = Math.cos(i*degree);
                    var y = Math.sin(i*degree);
                    cxt.lineTo(x * 4*scale + dx,y*4*scale +dy);
                }
                cxt.closePath();
                cxt.fillStyle = strokeColor;//#3cb1ff
                cxt.fill();

            }
            else if(type === "suspend"){
                // 挂起暂停
                cxt.beginPath();
                cxt.arc(x,y,5,45*Math.PI/180,315*Math.PI/180);
                cxt.moveTo(offsetX + width*.8,offsetY+12*scale );
                cxt.lineTo(offsetX + width *.8 ,offsetY + 20*scale);
                cxt.moveTo(offsetX + width*.82,offsetY+12*scale );
                cxt.lineTo(offsetX + width *.82 ,offsetY + 20*scale);
                cxt.lineWidth=2;
                cxt.strokeStyle = strokeColor;
                cxt.stroke();
            }
            else if(type === "reject"){
                // 退回右上角关闭
                cxt.beginPath();
                cxt.moveTo(offsetX + width*.8 ,offsetY + 12*scale);
                cxt.lineTo(offsetX + width*.9 ,offsetY + 12*scale);
                cxt.lineWidth=2;
                cxt.strokeStyle = strokeColor;
                cxt.stroke();
                cxt.beginPath();
                cxt.moveTo(offsetX + width*.82 ,offsetY + 8*scale);
                cxt.lineTo(offsetX + width*.75 ,offsetY + 12*scale);
                cxt.lineTo(offsetX + width*.82 ,offsetY + 16*scale);
                cxt.lineTo(offsetX + width*.82 ,offsetY + 8*scale);
                cxt.closePath();
                cxt.fillStyle = strokeColor;
                cxt.fill();
            }else if(type === "revoke"){
                // 退回右上角关闭
                cxt.beginPath();
                cxt.moveTo(offsetX + width*.75 ,offsetY + 20*scale);
                cxt.lineTo(offsetX + width*.9 ,offsetY + 20*scale);
                cxt.lineTo(offsetX + width*.9 ,offsetY + 12*scale);
                cxt.lineTo(offsetX + width*.82 ,offsetY + 12*scale);
                cxt.lineWidth=2;
                cxt.strokeStyle = strokeColor;
                cxt.stroke();
                cxt.beginPath();
                cxt.moveTo(offsetX + width*.82 ,offsetY + 8*scale);
                cxt.lineTo(offsetX + width*.75 ,offsetY + 12*scale);
                cxt.lineTo(offsetX + width*.82 ,offsetY + 16*scale);
                cxt.lineTo(offsetX + width*.82 ,offsetY + 8*scale);
                cxt.closePath();
                cxt.fillStyle = strokeColor;
                cxt.fill();
            }

        }
    },
    checkMouse:function(mouse)
    {
        var dx = this.width/2;
        var dy = this.height/2;
        var distance = Math.sqrt(dx * dx + dy * dy);
        if (distance < this.radius) {
            return true;
        } else {
            return false;
        }
    },
    // 绘制子流程节点
    createSubProcess:function(cxt){
        //真实比例换算成设计稿比例
        var width = this.width;
        var height = this.height;
        var scale = width/69;
        //落差
        var offsetX = this.x;
        var offsetY = this.y;
        //根据类型获取颜色 fillColor strokeColor
        var type = this.type,fillColor,strokeColor;
        //type==0 已进行 type==3 被退回节点都是蓝色
        if(type==="finish"||type==="reject"||type==="revoke"){
            fillColor = '#e5f7fd';
            strokeColor = '#3cb1ff';
        }
        //type==1 当前节点 type==2 挂起节点都i是橙色
        else if(type==="now"||type==="suspend" || type==="complete"){
            fillColor = '#ffffe7';
            strokeColor = '#f9cb7d';
        }
        //type eef0f2 b9bbbf
        else if(type === "next"){
            fillColor = '#eef0f2';
            strokeColor = '#b9bbbf';
        }else if (type = "subProcess"){
            fillColor = '#eef0f2';
            strokeColor = '#b9bbbf';
        }
        //绘制圆角矩形
        var r = this.radius;
        var txt=this.html;
        cxt.beginPath();
        cxt.moveTo(offsetX + r,offsetY);
        cxt.lineTo(offsetX + width -r,offsetY);
        cxt.arcTo(offsetX + width , offsetY,offsetX + width , offsetY + r,r);
        cxt.lineTo(offsetX + width, offsetY + height - r);
        cxt.arcTo(offsetX + width , offsetY + height,offsetX + width -r , offsetY + height,r);
        cxt.lineTo(offsetX + r, offsetY + height);
        cxt.arcTo(offsetX   , offsetY+height ,offsetX   , offsetY+ height- r ,r);
        cxt.lineTo(offsetX , offsetY + r);
        cxt.arcTo(offsetX   , offsetY ,offsetX + r , offsetY ,r);
        cxt.closePath();
        cxt.fillStyle = "white";
        cxt.strokeStyle = strokeColor;
        cxt.fill();
        cxt.stroke();
        cxt.font = "12px 微软雅黑";
        cxt.fillStyle = "#666";
        cxt.textAlign='center';
        if(txt.length<10){
            cxt.fillText(txt,offsetX + width/2,offsetY + height+20);
        }else{
            var txt1=txt.substring(0,9);
            var txt2=txt.substring(9,txt.length);
            cxt.fillText(txt1,offsetX + width/2,offsetY + height+20);
            cxt.fillText(txt2,offsetX + width/2,offsetY + height+35);
        }

    },
    // 绘制边界定时节点
    createBoundaryEvent:function(cxt){
        //真实比例换算成设计稿比例
        var width = this.width;
        var height = this.height;
        //落差
        var offsetX = this.x;
        var offsetY = this.y;
        //根据类型获取颜色 fillColor strokeColor
        var type = this.type,fillColor,strokeColor;
        //type==0 已进行 type==3 被退回节点都是蓝色
        if(type==="finish"||type==="reject" || type === 'revoke'){
            fillColor = '#e5f7fd';
            strokeColor = '#3cb1ff';
        }
        //type==1 当前节点 type==2 挂起节点都i是橙色
        else if(type==="now"||type==="suspend"||type==="complete"){
            fillColor = '#ffffe7';
            strokeColor = '#f9cb7d';
        }
        //type eef0f2 b9bbbf
        else if(type === "next"){
            fillColor = '#eef0f2';
            strokeColor = '#b9bbbf';
        }else if (type == "subProcess"){
            fillColor = '#eef0f2';
            strokeColor = '#b9bbbf';
        }else {
            fillColor = '#eef0f2';
            strokeColor = '#b9bbbf';
        }
        //绘制三个同心圆
        var r = height/2;
        var txt=this.html;
        cxt.beginPath();
        cxt.arc(offsetX + r,offsetY + r,r,0,360*Math.PI/180,true);
        cxt.closePath();
        cxt.fillStyle = "white";
        cxt.strokeStyle = strokeColor;
        cxt.fill();
        cxt.stroke();
        cxt.beginPath();
        cxt.arc(offsetX + r,offsetY + r,r*4/5,0,360*Math.PI/180,true);
        cxt.closePath();
        cxt.fillStyle = "white";
        cxt.strokeStyle = strokeColor;
        cxt.fill();
        cxt.stroke();
        cxt.beginPath();
        cxt.arc(offsetX + r,offsetY + r,r*3/5,0,360*Math.PI/180,true);
        cxt.closePath();
        cxt.fillStyle = "white";
        cxt.strokeStyle = strokeColor;
        cxt.fill();
        cxt.stroke();
        cxt.beginPath();
        cxt.arc(offsetX + r,offsetY + r,r*1/10,0,360*Math.PI/180,true);
        cxt.closePath();
        cxt.fillStyle = fillColor;
        cxt.strokeStyle = strokeColor;
        cxt.fill();
        cxt.stroke();
        // 时刻点
        cxt.beginPath();
        cxt.moveTo(offsetX +r,offsetY +.4*r);
        cxt.lineTo(offsetX +r,offsetY +.4*r+3);
        cxt.closePath();
        cxt.strokeStyle = strokeColor;
        cxt.stroke();

        cxt.beginPath();
        cxt.moveTo(offsetX +.4*r,offsetY +r);
        cxt.lineTo(offsetX +.4*r+3,offsetY +r);
        cxt.closePath();
        cxt.strokeStyle = strokeColor;
        cxt.stroke();

        cxt.beginPath();
        cxt.moveTo(offsetX +r,offsetY +1.6*r);
        cxt.lineTo(offsetX +r,offsetY +1.6*r-3);
        cxt.closePath();
        cxt.strokeStyle = strokeColor;
        cxt.stroke();

        cxt.beginPath();
        cxt.moveTo(offsetX +1.6*r,offsetY +r);
        cxt.lineTo(offsetX +1.6*r-3,offsetY +r);
        cxt.closePath();
        cxt.strokeStyle = strokeColor;
        cxt.stroke();
        // 分针和时针
        cxt.beginPath();
        cxt.moveTo(offsetX +r,offsetY +r);
        cxt.lineTo(offsetX +r,offsetY +r-5);
        cxt.closePath();
        cxt.strokeStyle = strokeColor;
        cxt.stroke();

        cxt.beginPath();
        cxt.moveTo(offsetX +r,offsetY +r);
        cxt.lineTo(offsetX +r+3,offsetY +r);
        cxt.closePath();
        cxt.strokeStyle = strokeColor;
        cxt.stroke();
        cxt.font = "12px 微软雅黑";
        cxt.fillStyle = "#666";
        cxt.textAlign='center';
        if(txt.length<10){
            cxt.fillText(txt,offsetX + width/2,offsetY + height+20);
        }else{
            var txt1=txt.substring(0,9);
            var txt2=txt.substring(9,txt.length);
            cxt.fillText(txt1,offsetX + width/2,offsetY + height+20);
            cxt.fillText(txt2,offsetX + width/2,offsetY + height+35);
        }
    },
    // 绘制定时开始节点
    createStartTimerEvent:function(cxt){
            //真实比例换算成设计稿比例
            var width = this.width;
            var height = this.height;
            //落差
            var offsetX = this.x;
            var offsetY = this.y;
            //根据类型获取颜色 fillColor strokeColor
            var type = this.type,fillColor,strokeColor;
            //type==0 已进行 type==3 被退回节点都是蓝色
            if(type==="finish"||type==="reject"||type==="revoke"){
                fillColor = '#e5f7fd';
                strokeColor = '#3cb1ff';
            }
            //type==1 当前节点 type==2 挂起节点都i是橙色
            else if(type==="now"||type==="suspend"||type==="complete"){
                fillColor = '#ffffe7';
                strokeColor = '#f9cb7d';
            }
            //type eef0f2 b9bbbf
            else if(type === "next"){
                fillColor = '#eef0f2';
                strokeColor = '#b9bbbf';
            }else if (type = "subProcess"){
                fillColor = '#eef0f2';
                strokeColor = '#b9bbbf';
            }else {
                fillColor = '#eef0f2';
                strokeColor = '#b9bbbf';
            }
            //绘制两个同心圆
            var r = height/2;
            var txt=this.html;
            cxt.beginPath();
            cxt.arc(offsetX + r,offsetY + r,r,0,360*Math.PI/180,true);
            cxt.closePath();
            cxt.fillStyle = "white";
            cxt.strokeStyle = strokeColor;
            cxt.fill();
            cxt.stroke();
            cxt.beginPath();
            cxt.arc(offsetX + r,offsetY + r,r*2/3,0,360*Math.PI/180,true);
            cxt.closePath();
            cxt.fillStyle = "white";
            cxt.strokeStyle = strokeColor;
            cxt.fill();
            cxt.stroke();
            cxt.beginPath();
            cxt.arc(offsetX + r,offsetY + r,r*1/10,0,360*Math.PI/180,true);
            cxt.closePath();
            cxt.fillStyle = fillColor;
            cxt.strokeStyle = strokeColor;
            cxt.fill();
            cxt.stroke();
            // 时刻点
            cxt.beginPath();
            cxt.moveTo(offsetX +r,offsetY +.4*r);
            cxt.lineTo(offsetX +r,offsetY +.4*r+3);
            cxt.closePath();
            cxt.strokeStyle = strokeColor;
            cxt.stroke();

            cxt.beginPath();
            cxt.moveTo(offsetX +.4*r,offsetY +r);
            cxt.lineTo(offsetX +.4*r+3,offsetY +r);
            cxt.closePath();
            cxt.strokeStyle = strokeColor;
            cxt.stroke();

            cxt.beginPath();
            cxt.moveTo(offsetX +r,offsetY +1.6*r);
            cxt.lineTo(offsetX +r,offsetY +1.6*r-3);
            cxt.closePath();
            cxt.strokeStyle = strokeColor;
            cxt.stroke();

            cxt.beginPath();
            cxt.moveTo(offsetX +1.6*r,offsetY +r);
            cxt.lineTo(offsetX +1.6*r-3,offsetY +r);
            cxt.closePath();
            cxt.strokeStyle = strokeColor;
            cxt.stroke();
            // 分针和时针
            cxt.beginPath();
            cxt.moveTo(offsetX +r,offsetY +r);
            cxt.lineTo(offsetX +r,offsetY +r-5);
            cxt.closePath();
            cxt.strokeStyle = strokeColor;
            cxt.stroke();

            cxt.beginPath();
            cxt.moveTo(offsetX +r,offsetY +r);
            cxt.lineTo(offsetX +r+3,offsetY +r);
            cxt.closePath();
            cxt.strokeStyle = strokeColor;
            cxt.stroke();
            cxt.font = "12px 微软雅黑";
            cxt.fillStyle = "#666";
            cxt.textAlign='center';
            if(txt.length<10){
                cxt.fillText(txt,offsetX + width/2,offsetY + height+20);
            }else{
                var txt1=txt.substring(0,9);
                var txt2=txt.substring(9,txt.length);
                cxt.fillText(txt1,offsetX + width/2,offsetY + height+20);
                cxt.fillText(txt2,offsetX + width/2,offsetY + height+35);
            }
        }

};